/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.tar;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.archive.FsArchiveEntry;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.util.Pool;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import org.apache.tools.tar.TarEntry;

@DefaultAnnotation(value={NonNull.class})
public class TarArchiveEntry
extends TarEntry
implements FsArchiveEntry,
Pool.Releasable<IOException> {
    @CheckForNull
    private IOPool.Entry<?> temp;

    public TarArchiveEntry(String name) {
        super(name, true);
        super.setModTime(Long.MIN_VALUE);
        super.setSize(-1L);
        super.setUserName(System.getProperty("user.name", ""));
    }

    public TarArchiveEntry(String name, TarEntry template) {
        super(name, true);
        super.setMode(template.getMode());
        super.setModTime(template.getModTime());
        super.setSize(template.getSize());
        super.setUserId(template.getUserId());
        super.setUserName(template.getUserName());
        super.setGroupId(template.getGroupId());
        super.setGroupName(template.getGroupName());
    }

    @Nullable
    IOPool.Entry<?> getTemp() {
        return this.temp;
    }

    void setTemp(@CheckForNull IOPool.Entry<?> temp) {
        this.temp = temp;
    }

    public void release() throws IOException {
        if (null != this.temp) {
            this.temp.release();
            this.temp = null;
        }
    }

    public Entry.Type getType() {
        return this.isDirectory() ? Entry.Type.DIRECTORY : Entry.Type.FILE;
    }

    public long getSize(Entry.Size type) {
        switch (type) {
            case DATA: 
            case STORAGE: {
                return this.getSize();
            }
        }
        return -1L;
    }

    public boolean setSize(Entry.Size type, long size) {
        if (Entry.Size.DATA != type) {
            return false;
        }
        this.setSize(size);
        return true;
    }

    public long getTime(Entry.Access type) {
        if (Entry.Access.WRITE != type) {
            return -1L;
        }
        long time = this.getModTime().getTime();
        return 0L <= time ? time : -1L;
    }

    public boolean setTime(Entry.Access type, long time) {
        if (Entry.Access.WRITE != type) {
            return false;
        }
        this.setModTime(time);
        return true;
    }

    public boolean equals(Object that) {
        return super.equals(that);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        StringBuilder s = new StringBuilder(((Object)((Object)this)).getClass().getName()).append("[name=").append(this.getName()).append(",type=").append(this.getType());
        for (Entry.Size type : ALL_SIZE_SET) {
            s.append(",size(").append(type).append(")=").append(this.getSize(type));
        }
        for (Entry.Size type : ALL_ACCESS_SET) {
            s.append(",time(").append(type).append(")=").append(this.getTime((Entry.Access)type));
        }
        return s.append("]").toString();
    }
}

