/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.tar;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.archive.tar.TarDriver;
import de.schlichtherle.truezip.fs.archive.tar.TarInputShop;
import de.schlichtherle.truezip.fs.archive.tar.TarOutputShop;
import de.schlichtherle.truezip.socket.IOPoolProvider;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.Immutable;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.apache.tools.bzip2.CBZip2OutputStream;

@Immutable
public class TarBZip2Driver
extends TarDriver {
    public static final int BUFFER_SIZE = 4096;

    public TarBZip2Driver(IOPoolProvider provider) {
        super(provider);
    }

    public int getBufferSize() {
        return 4096;
    }

    public int getLevel() {
        return 9;
    }

    @Override
    public OutputSocket<?> getOutputSocket(FsController<?> controller, FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        return controller.getOutputSocket(name, options.set((Enum)FsOutputOption.STORE), template);
    }

    @Override
    protected TarInputShop newTarInputShop(FsModel model, InputStream in) throws IOException {
        if (in.read() != 66 || in.read() != 90) {
            throw new IOException("Not a BZIP2 compressed input stream!");
        }
        byte[] magic = new byte[2];
        InputStream vin = TarInputShop.readAhead(in, magic);
        if (magic[0] != 104 || magic[1] < 49 || 57 < magic[1]) {
            throw new IOException("Not a BZIP2 compressed input stream!");
        }
        return new TarInputShop(this, (InputStream)new CBZip2InputStream((InputStream)new BufferedInputStream(vin, this.getBufferSize())));
    }

    @Override
    protected TarOutputShop newTarOutputShop(FsModel model, OutputStream out, TarInputShop source) throws IOException {
        out.write(new byte[]{66, 90});
        return super.newTarOutputShop(model, (OutputStream)new CBZip2OutputStream((OutputStream)new BufferedOutputStream(out, this.getBufferSize()), this.getLevel()), source);
    }
}

