/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.tar;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.archive.FsCharsetArchiveDriver;
import de.schlichtherle.truezip.fs.archive.FsMultiplexedArchiveOutputShop;
import de.schlichtherle.truezip.fs.archive.tar.TarArchiveEntry;
import de.schlichtherle.truezip.fs.archive.tar.TarInputShop;
import de.schlichtherle.truezip.fs.archive.tar.TarOutputShop;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.IOPoolProvider;
import de.schlichtherle.truezip.socket.InputShop;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import net.jcip.annotations.Immutable;

@Immutable
@DefaultAnnotation(value={NonNull.class})
public class TarDriver
extends FsCharsetArchiveDriver<TarArchiveEntry> {
    public static final Charset TAR_CHARSET = Charset.forName("US-ASCII");
    private final IOPoolProvider provider;

    public TarDriver(IOPoolProvider provider) {
        super(TAR_CHARSET);
        if (null == provider) {
            throw new NullPointerException();
        }
        this.provider = provider;
    }

    protected final IOPool<?> getPool() {
        return this.provider.get();
    }

    public InputSocket<?> getInputSocket(FsController<?> controller, FsEntryName name, BitField<FsInputOption> options) {
        return controller.getInputSocket(name, options.clear((Enum)FsInputOption.CACHE));
    }

    public OutputSocket<?> getOutputSocket(FsController<?> controller, FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        return controller.getOutputSocket(name, options.set((Enum)FsOutputOption.COMPRESS), template);
    }

    public TarArchiveEntry newEntry(String name, Entry.Type type, Entry template, BitField<FsOutputOption> mknod) throws CharConversionException {
        TarArchiveEntry entry;
        this.assertEncodable(name);
        name = TarDriver.toZipOrTarEntryName((String)name, (Entry.Type)type);
        if (template instanceof TarArchiveEntry) {
            entry = this.newEntry(name, (TarArchiveEntry)template);
        } else {
            entry = this.newEntry(name);
            if (null != template) {
                entry.setModTime(template.getTime(Entry.Access.WRITE));
                entry.setSize(template.getSize(Entry.Size.DATA));
            }
        }
        return entry;
    }

    public TarArchiveEntry newEntry(String name) {
        return new TarArchiveEntry(name);
    }

    public TarArchiveEntry newEntry(String name, TarArchiveEntry template) {
        return new TarArchiveEntry(name, template);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TarInputShop newInputShop(FsModel model, InputSocket<?> input) throws IOException {
        InputStream in = TarDriver.newInputStream((FsModel)model, input);
        try {
            TarInputShop tarInputShop = this.newTarInputShop(model, in);
            return tarInputShop;
        }
        finally {
            in.close();
        }
    }

    protected TarInputShop newTarInputShop(FsModel model, InputStream in) throws IOException {
        return new TarInputShop(this, in);
    }

    public OutputShop<TarArchiveEntry> newOutputShop(FsModel model, OutputSocket<?> output, InputShop<TarArchiveEntry> source) throws IOException {
        OutputStream out = TarDriver.newOutputStream((FsModel)model, output);
        try {
            return new FsMultiplexedArchiveOutputShop((OutputShop)this.newTarOutputShop(model, out, (TarInputShop)source), this.getPool());
        }
        catch (IOException ex) {
            try {
                out.close();
            }
            catch (IOException ex2) {
                throw (IOException)ex2.initCause(ex);
            }
            throw ex;
        }
    }

    protected TarOutputShop newTarOutputShop(FsModel model, OutputStream out, TarInputShop source) throws IOException {
        return new TarOutputShop(this, out);
    }
}

