/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.tar;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.archive.tar.TarDriver;
import de.schlichtherle.truezip.fs.archive.tar.TarInputShop;
import de.schlichtherle.truezip.fs.archive.tar.TarOutputShop;
import de.schlichtherle.truezip.socket.IOPoolProvider;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import net.jcip.annotations.Immutable;

@Immutable
public class TarGZipDriver
extends TarDriver {
    public static final int BUFFER_SIZE = 4096;

    public TarGZipDriver(IOPoolProvider provider) {
        super(provider);
    }

    public int getBufferSize() {
        return 4096;
    }

    public final int getLevel() {
        return 9;
    }

    @Override
    public OutputSocket<?> getOutputSocket(FsController<?> controller, FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        return controller.getOutputSocket(name, options.set((Enum)FsOutputOption.STORE), template);
    }

    @Override
    protected TarInputShop newTarInputShop(FsModel model, InputStream in) throws IOException {
        return new TarInputShop(this, new GZIPInputStream(in, this.getBufferSize()));
    }

    @Override
    protected TarOutputShop newTarOutputShop(FsModel model, OutputStream out, TarInputShop source) throws IOException {
        return super.newTarOutputShop(model, new GZIPOutputStream(out, this.getBufferSize(), this.getLevel()), source);
    }

    private static class GZIPOutputStream
    extends java.util.zip.GZIPOutputStream {
        GZIPOutputStream(OutputStream out, int size, int level) throws IOException {
            super(out, size);
            this.def.setLevel(level);
        }
    }
}

