/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.tar;

import de.schlichtherle.truezip.fs.archive.tar.TarArchiveEntry;
import de.schlichtherle.truezip.fs.archive.tar.TarDriver;
import de.schlichtherle.truezip.io.Streams;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.InputShop;
import de.schlichtherle.truezip.socket.InputSocket;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.apache.tools.tar.TarUtils;

@DefaultAnnotation(value={NonNull.class})
public class TarInputShop
implements InputShop<TarArchiveEntry> {
    private static final byte[] NULL_RECORD = new byte[512];
    private static final int CHECKSUM_OFFSET = 148;
    private final Map<String, TarArchiveEntry> entries = new LinkedHashMap<String, TarArchiveEntry>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TarInputShop(TarDriver driver, InputStream in) throws IOException {
        TarInputStream tin = TarInputShop.newValidatedTarInputStream(in);
        IOPool<?> pool = driver.getPool();
        try {
            TarEntry tinEntry;
            while (null != (tinEntry = tin.getNextEntry())) {
                String name = TarInputShop.getName(tinEntry);
                TarArchiveEntry entry = this.entries.get(name);
                if (null != entry) {
                    entry.release();
                }
                entry = new TarArchiveEntry(name, tinEntry);
                if (!tinEntry.isDirectory()) {
                    IOPool.Entry temp = (IOPool.Entry)pool.allocate();
                    entry.setTemp(temp);
                    try {
                        OutputStream out = temp.getOutputSocket().newOutputStream();
                        try {
                            Streams.cat((InputStream)tin, (OutputStream)out);
                        }
                        finally {
                            out.close();
                        }
                    }
                    catch (IOException ex) {
                        temp.release();
                        throw ex;
                    }
                }
                this.entries.put(name, entry);
            }
        }
        catch (IOException ex) {
            this.close0();
            throw ex;
        }
    }

    private static String getName(TarEntry entry) {
        String name = entry.getName();
        return entry.isDirectory() && !name.endsWith("/") ? name + '/' : name;
    }

    private static TarInputStream newValidatedTarInputStream(InputStream in) throws IOException {
        byte[] buf = new byte[512];
        InputStream vin = TarInputShop.readAhead(in, buf);
        if (!Arrays.equals(buf, NULL_RECORD)) {
            long expected = TarUtils.parseOctal((byte[])buf, (int)148, (int)8);
            for (int i = 0; i < 8; ++i) {
                buf[148 + i] = 32;
            }
            long is = TarUtils.computeCheckSum((byte[])buf);
            if (expected != is) {
                throw new IOException("Illegal initial record in TAR file: Expected checksum " + expected + ", is " + is + "!");
            }
        }
        return new TarInputStream(vin, 10240, 512);
    }

    static InputStream readAhead(InputStream in, byte[] buf) throws IOException {
        if (in.markSupported()) {
            in.mark(buf.length);
            TarInputShop.readFully(in, buf);
            in.reset();
            return in;
        }
        PushbackInputStream pin = new PushbackInputStream(in, buf.length);
        TarInputShop.readFully(pin, buf);
        pin.unread(buf);
        return pin;
    }

    private static void readFully(InputStream in, byte[] buf) throws IOException {
        int r;
        int l = buf.length;
        int n = 0;
        do {
            if (0 < (r = in.read(buf, n, l - n))) continue;
            throw new EOFException();
        } while ((n += r) < l);
    }

    public final int getSize() {
        return this.entries.size();
    }

    public final Iterator<TarArchiveEntry> iterator() {
        return this.entries.values().iterator();
    }

    public final TarArchiveEntry getEntry(String name) {
        return this.entries.get(name);
    }

    public InputSocket<TarArchiveEntry> getInputSocket(final String name) {
        if (null == name) {
            throw new NullPointerException();
        }
        class Input
        extends InputSocket<TarArchiveEntry> {
            Input() {
            }

            public TarArchiveEntry getLocalTarget() throws IOException {
                TarArchiveEntry entry = TarInputShop.this.getEntry(name);
                if (null == entry) {
                    throw new FileNotFoundException(name + " (entry not found)");
                }
                if (entry.isDirectory()) {
                    throw new FileNotFoundException(name + " (cannot read directories)");
                }
                return entry;
            }

            public ReadOnlyFile newReadOnlyFile() throws IOException {
                return this.getLocalTarget().getTemp().getInputSocket().newReadOnlyFile();
            }

            public InputStream newInputStream() throws IOException {
                return this.getLocalTarget().getTemp().getInputSocket().newInputStream();
            }
        }
        return new Input();
    }

    public void close() throws IOException {
        this.close0();
    }

    private void close0() throws IOException {
        Collection<TarArchiveEntry> values = this.entries.values();
        Iterator<TarArchiveEntry> i = values.iterator();
        while (i.hasNext()) {
            i.next().release();
            i.remove();
        }
    }
}

