/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.tar;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.archive.tar.TarArchiveEntry;
import de.schlichtherle.truezip.fs.archive.tar.TarDriver;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.io.OutputBusyException;
import de.schlichtherle.truezip.io.Streams;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.socket.OutputSocket;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.tools.tar.TarOutputStream;

@DefaultAnnotation(value={NonNull.class})
public class TarOutputShop
extends TarOutputStream
implements OutputShop<TarArchiveEntry> {
    private final Map<String, TarArchiveEntry> entries = new LinkedHashMap<String, TarArchiveEntry>();
    private final IOPool<?> pool;
    private boolean busy;

    public TarOutputShop(TarDriver driver, OutputStream out) {
        super(out);
        super.setLongFileMode(2);
        this.pool = driver.getPool();
    }

    public int getSize() {
        return this.entries.size();
    }

    public Iterator<TarArchiveEntry> iterator() {
        return this.entries.values().iterator();
    }

    public TarArchiveEntry getEntry(String name) {
        return this.entries.get(name);
    }

    public OutputSocket<TarArchiveEntry> getOutputSocket(final TarArchiveEntry entry) {
        if (null == entry) {
            throw new NullPointerException();
        }
        class Output
        extends OutputSocket<TarArchiveEntry> {
            Output() {
            }

            public TarArchiveEntry getLocalTarget() {
                return entry;
            }

            public OutputStream newOutputStream() throws IOException {
                long size;
                if (TarOutputShop.this.isBusy()) {
                    throw new OutputBusyException(entry.getName());
                }
                if (entry.isDirectory()) {
                    entry.setSize(0L);
                    return new EntryOutputStream(entry);
                }
                Entry peer = this.getPeerTarget();
                if (null != peer && -1L != (size = peer.getSize(Entry.Size.DATA))) {
                    entry.setSize(size);
                    return new EntryOutputStream(entry);
                }
                return new TempEntryOutputStream((IOPool.Entry)TarOutputShop.this.pool.allocate(), entry);
            }
        }
        return new Output();
    }

    private boolean isBusy() {
        return this.busy;
    }

    private class TempEntryOutputStream
    extends DecoratingOutputStream {
        private final IOPool.Entry<?> temp;
        private final TarArchiveEntry entry;
        private boolean closed;

        TempEntryOutputStream(IOPool.Entry<?> temp, TarArchiveEntry entry) throws IOException {
            super(temp.getOutputSocket().newOutputStream());
            this.temp = temp;
            this.entry = entry;
            TarOutputShop.this.entries.put(entry.getName(), entry);
            TarOutputShop.this.busy = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            TarOutputShop.this.busy = false;
            try {
                super.close();
            }
            finally {
                this.entry.setSize(this.temp.getSize(Entry.Size.DATA));
                this.store();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void store() throws IOException {
            try {
                InputStream in = this.temp.getInputSocket().newInputStream();
                try {
                    TarOutputShop.this.putNextEntry(this.entry);
                    try {
                        Streams.cat((InputStream)in, (OutputStream)((Object)TarOutputShop.this));
                    }
                    finally {
                        TarOutputShop.this.closeEntry();
                    }
                }
                finally {
                    in.close();
                }
            }
            finally {
                this.temp.release();
            }
        }
    }

    private class EntryOutputStream
    extends DecoratingOutputStream {
        private boolean closed;

        EntryOutputStream(TarArchiveEntry entry) throws IOException {
            super((OutputStream)((Object)TarOutputShop.this));
            TarOutputShop.this.putNextEntry(entry);
            TarOutputShop.this.entries.put(entry.getName(), entry);
            TarOutputShop.this.busy = true;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            TarOutputShop.this.busy = false;
            TarOutputShop.this.closeEntry();
        }
    }
}

