/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.inst.jmx;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsManager;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.inst.InstrumentingCompositeDriver;
import de.schlichtherle.truezip.fs.inst.InstrumentingController;
import de.schlichtherle.truezip.fs.inst.InstrumentingDirector;
import de.schlichtherle.truezip.fs.inst.InstrumentingIOPool;
import de.schlichtherle.truezip.fs.inst.InstrumentingManager;
import de.schlichtherle.truezip.fs.inst.jmx.JmxApplicationController;
import de.schlichtherle.truezip.fs.inst.jmx.JmxController;
import de.schlichtherle.truezip.fs.inst.jmx.JmxIOPool;
import de.schlichtherle.truezip.fs.inst.jmx.JmxIOStatistics;
import de.schlichtherle.truezip.fs.inst.jmx.JmxIOStatisticsMXBean;
import de.schlichtherle.truezip.fs.inst.jmx.JmxIOStatisticsView;
import de.schlichtherle.truezip.fs.inst.jmx.JmxInputSocket;
import de.schlichtherle.truezip.fs.inst.jmx.JmxKernelController;
import de.schlichtherle.truezip.fs.inst.jmx.JmxManager;
import de.schlichtherle.truezip.fs.inst.jmx.JmxModel;
import de.schlichtherle.truezip.fs.inst.jmx.JmxNio2InputSocket;
import de.schlichtherle.truezip.fs.inst.jmx.JmxNio2OutputSocket;
import de.schlichtherle.truezip.fs.inst.jmx.JmxOutputSocket;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.JSE7;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.lang.management.ManagementFactory;
import javax.annotation.concurrent.ThreadSafe;
import javax.management.InstanceNotFoundException;
import javax.management.JMX;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

@ThreadSafe
public class JmxDirector
extends InstrumentingDirector<JmxDirector> {
    private static final String APPLICATION_IO_STATISTICS = "ApplicationIOStatistics";
    private static final String KERNEL_IO_STATISTICS = "KernelIOStatistics";
    private static final String TEMP_IO_STATISTICS = "TempIOStatistics";
    private static final MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
    public static final JmxDirector SINGLETON = JSE7.AVAILABLE ? new JmxNio2Director() : new JmxDirector();
    private volatile JmxIOStatistics application;
    private volatile JmxIOStatistics kernel;
    private volatile JmxIOStatistics temp;

    private JmxDirector() {
    }

    JmxIOStatistics getApplicationIOStatistics() {
        JmxIOStatistics stats = this.application;
        assert (null != stats);
        return stats;
    }

    void setApplicationIOStatistics(JmxIOStatistics stats) {
        assert (null != stats);
        this.application = stats;
        JmxIOStatisticsView.register(stats, APPLICATION_IO_STATISTICS);
    }

    JmxIOStatistics getKernelIOStatistics() {
        JmxIOStatistics stats = this.kernel;
        assert (null != stats);
        return stats;
    }

    void setKernelIOStatistics(JmxIOStatistics stats) {
        assert (null != stats);
        this.kernel = stats;
        JmxIOStatisticsView.register(stats, KERNEL_IO_STATISTICS);
    }

    JmxIOStatistics getTempIOStatistics() {
        JmxIOStatistics stats = this.temp;
        assert (null != stats);
        return stats;
    }

    void setTempIOStatistics(JmxIOStatistics stats) {
        assert (null != stats);
        this.temp = stats;
        JmxIOStatisticsView.register(stats, TEMP_IO_STATISTICS);
    }

    void clearStatistics() {
        for (Object[] params : new Object[][]{{APPLICATION_IO_STATISTICS, this.application}, {KERNEL_IO_STATISTICS, this.kernel}, {TEMP_IO_STATISTICS, this.temp}}) {
            ObjectName pattern;
            try {
                pattern = new ObjectName(FsManager.class.getName() + ":type=" + params[0] + ",name=*");
            }
            catch (MalformedObjectNameException ex) {
                throw new AssertionError();
            }
            for (ObjectName found : mbs.queryNames(pattern, null)) {
                JmxIOStatisticsMXBean proxy = JMX.newMXBeanProxy(mbs, found, JmxIOStatisticsMXBean.class);
                if (((JmxIOStatistics)params[1]).getTimeCreatedMillis() == proxy.getTimeCreatedMillis()) continue;
                try {
                    mbs.unregisterMBean(found);
                }
                catch (InstanceNotFoundException ex) {
                    throw new AssertionError();
                }
                catch (MBeanRegistrationException ex) {
                    throw new AssertionError((Object)ex);
                }
            }
        }
    }

    @Override
    public <E extends IOPool.Entry<E>> IOPool<E> instrument(IOPool<E> pool) {
        return new JmxIOPool<E>(pool, this);
    }

    @Override
    public FsManager instrument(FsManager manager) {
        return new JmxManager(manager, this);
    }

    @Override
    public FsModel instrument(FsModel model, InstrumentingCompositeDriver context) {
        return new JmxModel(model, this);
    }

    @Override
    public FsController<?> instrument(FsController<?> controller, InstrumentingManager context) {
        return new JmxApplicationController(controller, this);
    }

    @Override
    public FsController<?> instrument(FsController<?> controller, InstrumentingCompositeDriver context) {
        return new JmxKernelController(controller, this);
    }

    @Override
    public <E extends IOPool.Entry<E>> InputSocket<E> instrument(InputSocket<E> input, InstrumentingIOPool.Buffer context) {
        return new JmxInputSocket<E>(input, this, this.temp);
    }

    @Override
    @SuppressWarnings(value={"BC_UNCONFIRMED_CAST"})
    public <E extends Entry> InputSocket<E> instrument(InputSocket<E> input, InstrumentingController<JmxDirector> context) {
        return new JmxInputSocket<E>(input, this, ((JmxController)context).getIOStatistics());
    }

    @Override
    public <E extends IOPool.Entry<E>> OutputSocket<E> instrument(OutputSocket<E> output, InstrumentingIOPool.Buffer context) {
        return new JmxOutputSocket<E>(output, this, this.temp);
    }

    @Override
    @SuppressWarnings(value={"BC_UNCONFIRMED_CAST"})
    public <E extends Entry> OutputSocket<E> instrument(OutputSocket<E> output, InstrumentingController<JmxDirector> context) {
        return new JmxOutputSocket<E>(output, this, ((JmxController)context).getIOStatistics());
    }

    private static final class JmxNio2Director
    extends JmxDirector {
        private JmxNio2Director() {
        }

        @Override
        public <E extends IOPool.Entry<E>> InputSocket<E> instrument(InputSocket<E> input, InstrumentingIOPool.Buffer context) {
            return new JmxNio2InputSocket<E>(input, this, ((JmxDirector)this).temp);
        }

        @Override
        @SuppressWarnings(value={"BC_UNCONFIRMED_CAST"})
        public <E extends Entry> InputSocket<E> instrument(InputSocket<E> input, InstrumentingController<JmxDirector> context) {
            return new JmxNio2InputSocket<E>(input, this, ((JmxController)context).getIOStatistics());
        }

        @Override
        public <E extends IOPool.Entry<E>> OutputSocket<E> instrument(OutputSocket<E> output, InstrumentingIOPool.Buffer context) {
            return new JmxNio2OutputSocket<E>(output, this, ((JmxDirector)this).temp);
        }

        @Override
        @SuppressWarnings(value={"BC_UNCONFIRMED_CAST"})
        public <E extends Entry> OutputSocket<E> instrument(OutputSocket<E> output, InstrumentingController<JmxDirector> context) {
            return new JmxNio2OutputSocket<E>(output, this, ((JmxController)context).getIOStatistics());
        }
    }
}

