/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.file;

import de.schlichtherle.truezip.file.ThreadLocalMatcher;
import de.schlichtherle.truezip.fs.FsCompositeDriver;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDriver;
import de.schlichtherle.truezip.fs.FsDriverProvider;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsPath;
import de.schlichtherle.truezip.fs.FsScheme;
import de.schlichtherle.truezip.fs.sl.FsDriverLocator;
import de.schlichtherle.truezip.fs.spi.FsDriverService;
import de.schlichtherle.truezip.util.CanonicalStringSet;
import de.schlichtherle.truezip.util.SuffixSet;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.regex.Matcher;
import net.jcip.annotations.Immutable;

@Immutable
@DefaultAnnotation(value={NonNull.class})
public final class TArchiveDetector
implements FsCompositeDriver,
FsDriverProvider {
    public static final TArchiveDetector NULL = new TArchiveDetector("");
    public static final TArchiveDetector ALL = new TArchiveDetector(null);
    private final Map<FsScheme, FsDriver> drivers;
    private final String suffixes;
    private final ThreadLocalMatcher matcher;

    public TArchiveDetector(@CheckForNull String suffixes) {
        this((FsDriverProvider)FsDriverLocator.SINGLETON, suffixes);
    }

    public TArchiveDetector(FsDriverProvider provider, @CheckForNull String suffixes) {
        SuffixSet given;
        Map drivers = provider.get();
        SuffixSet known = TArchiveDetector.getSuffixes(provider);
        if (null != suffixes) {
            given = new SuffixSet(suffixes);
            if (given.retainAll((CanonicalStringSet)known)) {
                SuffixSet unknown = new SuffixSet(suffixes);
                unknown.removeAll((CanonicalStringSet)known);
                throw new IllegalArgumentException("\"" + unknown + "\" (no archive driver installed for these suffixes)");
            }
        } else {
            given = known;
        }
        this.drivers = drivers;
        this.suffixes = given.toString();
        this.matcher = new ThreadLocalMatcher(given.toPattern());
    }

    private static SuffixSet getSuffixes(FsDriverProvider provider) {
        SuffixSet set = new SuffixSet();
        for (Map.Entry entry : provider.get().entrySet()) {
            FsDriver driver = (FsDriver)entry.getValue();
            if (null == driver || !driver.isFederated()) continue;
            set.add(((FsScheme)entry.getKey()).toString());
        }
        return set;
    }

    public TArchiveDetector(String suffixes, @CheckForNull FsDriver driver) {
        this(NULL, suffixes, driver);
    }

    public TArchiveDetector(FsDriverProvider delegate, String suffixes, @CheckForNull FsDriver driver) {
        this(delegate, new Object[][]{{suffixes, driver}});
    }

    public TArchiveDetector(FsDriverProvider delegate, Object[][] config) {
        this(delegate, FsDriverService.newMap((Object[][])config));
    }

    public TArchiveDetector(FsDriverProvider delegate, Map<FsScheme, FsDriver> config) {
        HashMap<FsScheme, FsDriver> drivers = new HashMap<FsScheme, FsDriver>(delegate.get());
        SuffixSet suffixes = TArchiveDetector.getSuffixes(delegate);
        for (Map.Entry<FsScheme, FsDriver> entry : config.entrySet()) {
            FsScheme scheme = entry.getKey();
            FsDriver driver = entry.getValue();
            if (null != driver) {
                suffixes.add(scheme.toString());
                drivers.put(scheme, driver);
                continue;
            }
            suffixes.remove((Object)scheme.toString());
            drivers.remove(scheme);
        }
        this.drivers = Collections.unmodifiableMap(drivers);
        this.suffixes = suffixes.toString();
        this.matcher = new ThreadLocalMatcher(suffixes.toPattern());
    }

    public Map<FsScheme, FsDriver> get() {
        return this.drivers;
    }

    @CheckForNull
    public FsScheme getScheme(String path) {
        Matcher m = this.matcher.reset(path);
        return m.matches() ? FsScheme.create((String)m.group(1).toLowerCase(Locale.ENGLISH)) : null;
    }

    @CheckForNull
    FsDriver getDriver(FsScheme scheme) {
        return this.drivers.get(scheme);
    }

    public FsController<?> newController(FsModel model, @CheckForNull FsController<?> parent) {
        FsScheme detectedScheme;
        assert (null != model.getParent() ? model.getParent().equals((Object)parent.getModel()) : null == parent);
        FsMountPoint mountPoint = model.getMountPoint();
        FsScheme declaredScheme = mountPoint.getScheme();
        FsPath path = mountPoint.getPath();
        if (null != path && !declaredScheme.equals((Object)(detectedScheme = this.getScheme(path.getEntryName().getPath())))) {
            throw new IllegalArgumentException(mountPoint.toString() + " (declared/detected scheme mismatch)");
        }
        FsDriver driver = this.drivers.get(declaredScheme);
        if (null == driver) {
            throw new ServiceConfigurationError(declaredScheme + "(unknown file system scheme - check run time class path configuration)");
        }
        return driver.newController(model, parent);
    }

    public String toString() {
        return this.suffixes;
    }
}

