/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.file;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TBIO;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TFileOutputStream;
import de.schlichtherle.truezip.fs.FsCompositeDriver;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsFilteringManager;
import de.schlichtherle.truezip.fs.FsManager;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsPath;
import de.schlichtherle.truezip.fs.FsScheme;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.FsUriModifier;
import de.schlichtherle.truezip.fs.sl.FsManagerLocator;
import de.schlichtherle.truezip.io.Paths;
import de.schlichtherle.truezip.io.Streams;
import de.schlichtherle.truezip.util.BitField;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.ServiceConfigurationError;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import net.jcip.annotations.Immutable;

@DefaultAnnotation(value={NonNull.class})
@Immutable
@SuppressWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
public final class TFile
extends File {
    private static final long serialVersionUID = 3617072259051821745L;
    private static final String UNC_PREFIX = separator + separator;
    private static final Set<File> ROOTS = Collections.unmodifiableSet(new TreeSet<File>(Arrays.asList(TFile.listRoots())));
    static final FsManager manager = FsManagerLocator.SINGLETON.get();
    private static TArchiveDetector defaultDetector = TArchiveDetector.ALL;
    private static boolean lenient = true;
    private transient File delegate;
    private transient TArchiveDetector detector;
    @Nullable
    private transient TFile innerArchive;
    @Nullable
    private transient TFile enclArchive;
    @Nullable
    private transient FsEntryName enclEntryName;
    @Nullable
    private volatile transient FsController<?> controller;

    public TFile(File file) {
        this(file, defaultDetector);
    }

    public TFile(File file, @CheckForNull TArchiveDetector detector) {
        super(file.getPath());
        if (file instanceof TFile) {
            TFile tfile = (TFile)file;
            this.delegate = tfile.delegate;
            this.detector = tfile.detector;
            this.enclArchive = tfile.enclArchive;
            this.enclEntryName = tfile.enclEntryName;
            this.innerArchive = tfile.isArchive() ? this : tfile.innerArchive;
            this.controller = tfile.controller;
        } else {
            this.delegate = file;
            this.detector = null != detector ? detector : defaultDetector;
            this.scan(null);
        }
        assert (this.invariants());
    }

    public TFile(String path) {
        this(path, defaultDetector);
    }

    public TFile(String path, @CheckForNull TArchiveDetector detector) {
        super(path);
        this.delegate = new File(path);
        this.detector = null != detector ? detector : defaultDetector;
        this.scan(null);
        assert (this.invariants());
    }

    public TFile(String parent, String member) {
        this(parent, member, defaultDetector);
    }

    public TFile(String parent, String member, @CheckForNull TArchiveDetector detector) {
        super(parent, member);
        this.delegate = new File(parent, member);
        this.detector = null != detector ? detector : defaultDetector;
        this.scan(null);
        assert (this.invariants());
    }

    public TFile(File parent, String member) {
        this(parent, member, null);
    }

    public TFile(File parent, String member, @CheckForNull TArchiveDetector detector) {
        super(parent, member);
        this.delegate = new File(parent, member);
        if (parent instanceof TFile) {
            TFile tparent = (TFile)parent;
            this.detector = null != detector ? detector : tparent.detector;
            this.scan(tparent);
        } else {
            this.detector = null != detector ? detector : defaultDetector;
            this.scan(null);
        }
        assert (this.invariants());
    }

    public TFile(URI uri) {
        this(FsPath.create((URI)uri, (FsUriModifier)FsUriModifier.CANONICALIZE), defaultDetector);
    }

    public TFile(FsPath path) {
        this(path, defaultDetector);
    }

    private TFile(FsPath path, TArchiveDetector detector) {
        super(path.hierarchicalize().getUri());
        this.parse(path, detector);
    }

    private void parse(FsPath path, TArchiveDetector detector) {
        this.delegate = new File(super.getPath());
        this.detector = detector;
        FsMountPoint mountPoint = path.getMountPoint();
        FsPath mountPointPath = mountPoint.getPath();
        if (null == mountPointPath) {
            assert (!path.getUri().isOpaque());
            this.enclArchive = null;
            this.enclEntryName = null;
            this.innerArchive = null;
        } else {
            FsEntryName entryName = path.getEntryName();
            if (entryName.isRoot()) {
                assert (path.getUri().isOpaque());
                if (mountPointPath.getUri().isOpaque()) {
                    this.enclArchive = new TFile(mountPointPath.getMountPoint(), detector);
                    this.enclEntryName = mountPointPath.getEntryName();
                } else {
                    this.enclArchive = null;
                    this.enclEntryName = null;
                }
                this.innerArchive = this;
            } else {
                assert (path.getUri().isOpaque());
                this.enclArchive = new TFile(mountPoint, detector);
                this.enclEntryName = entryName;
                this.innerArchive = this.enclArchive;
            }
        }
        assert (this.invariants());
    }

    private TFile(FsMountPoint mountPoint, TArchiveDetector detector) {
        super(mountPoint.hierarchicalize().getUri());
        this.delegate = new File(super.getPath());
        this.detector = detector;
        FsPath mountPointPath = mountPoint.getPath();
        if (null == mountPointPath) {
            assert (!mountPoint.getUri().isOpaque());
            this.enclArchive = null;
            this.enclEntryName = null;
            this.innerArchive = null;
        } else {
            assert (mountPoint.getUri().isOpaque());
            if (mountPointPath.getUri().isOpaque()) {
                this.enclArchive = new TFile(mountPointPath.getMountPoint(), detector);
                this.enclEntryName = mountPointPath.getEntryName();
            } else {
                this.enclArchive = null;
                this.enclEntryName = null;
            }
            this.innerArchive = this;
        }
        assert (this.invariants());
    }

    private TFile(File delegate, @CheckForNull TFile innerArchive, TArchiveDetector detector) {
        super(delegate.getPath());
        this.delegate = delegate;
        String path = delegate.getPath();
        if (null != innerArchive) {
            int innerArchivePathLength = innerArchive.getPath().length();
            if (path.length() == innerArchivePathLength) {
                this.detector = innerArchive.detector;
                this.innerArchive = this;
                this.enclArchive = innerArchive.enclArchive;
                this.enclEntryName = innerArchive.enclEntryName;
            } else {
                this.detector = detector;
                this.innerArchive = this.enclArchive = innerArchive;
                try {
                    this.enclEntryName = new FsEntryName(new URI(null, null, path.substring(innerArchivePathLength + 1).replace(separatorChar, '/'), null), FsUriModifier.CANONICALIZE);
                }
                catch (URISyntaxException ex) {
                    throw new AssertionError((Object)ex);
                }
            }
        } else {
            this.detector = detector;
        }
        assert (this.invariants());
    }

    private void scan(@CheckForNull TFile ancestor) {
        String path = super.getPath();
        assert (ancestor == null || path.startsWith(ancestor.getPath()));
        assert (this.delegate.getPath().equals(path));
        assert (null != this.detector);
        StringBuilder enclEntryNameBuf = new StringBuilder(path.length());
        this.scan(ancestor, this.detector, 0, path, enclEntryNameBuf, new Paths.Splitter(separatorChar, false));
        try {
            this.enclEntryName = 0 >= enclEntryNameBuf.length() ? null : new FsEntryName(new URI(null, null, enclEntryNameBuf.toString(), null), FsUriModifier.CANONICALIZE);
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private void scan(@CheckForNull TFile ancestor, TArchiveDetector detector, int skip, String path, StringBuilder enclEntryNameBuf, Paths.Splitter splitter) {
        if (path == null) {
            assert (this.enclArchive == null);
            enclEntryNameBuf.setLength(0);
            return;
        }
        splitter.split(path);
        String parent = splitter.getParentPath();
        String member = splitter.getMemberName();
        if (member.length() != 0 && !".".equals(member)) {
            if ("..".equals(member)) {
                ++skip;
            } else if (skip > 0) {
                --skip;
            } else {
                boolean isArchive;
                if (ancestor != null) {
                    int ancestorPathLen;
                    int pathLen = path.length();
                    if (pathLen == (ancestorPathLen = ancestor.getPath().length())) {
                        this.enclArchive = ancestor.innerArchive;
                        if (!ancestor.isArchive()) {
                            if (ancestor.isEntry()) {
                                if (enclEntryNameBuf.length() > 0) {
                                    enclEntryNameBuf.insert(0, '/');
                                    enclEntryNameBuf.insert(0, ancestor.enclEntryName.getPath());
                                } else {
                                    assert (this.enclArchive == ancestor.enclArchive);
                                    enclEntryNameBuf.append(ancestor.enclEntryName.getPath());
                                }
                            } else {
                                assert (this.enclArchive == null);
                                enclEntryNameBuf.setLength(0);
                            }
                        } else if (enclEntryNameBuf.length() <= 0) {
                            assert (this.enclArchive == ancestor);
                            this.innerArchive = this;
                            this.enclArchive = ancestor.enclArchive;
                            if (ancestor.enclEntryName != null) {
                                enclEntryNameBuf.append(ancestor.enclEntryName.getPath());
                            }
                        }
                        if (this.innerArchive != this) {
                            this.innerArchive = this.enclArchive;
                        }
                        return;
                    }
                    if (pathLen < ancestorPathLen) {
                        detector = ancestor.detector;
                        ancestor = ancestor.enclArchive;
                    }
                }
                boolean bl = isArchive = detector.getScheme(path) != null;
                if (enclEntryNameBuf.length() > 0) {
                    if (isArchive) {
                        this.enclArchive = new TFile(path, detector);
                        if (this.innerArchive != this) {
                            this.innerArchive = this.enclArchive;
                        }
                        return;
                    }
                    enclEntryNameBuf.insert(0, '/');
                    enclEntryNameBuf.insert(0, member);
                } else {
                    if (isArchive) {
                        this.innerArchive = this;
                    }
                    enclEntryNameBuf.append(member);
                }
            }
        }
        this.scan(ancestor, detector, skip, parent, enclEntryNameBuf, splitter);
    }

    private Object writeReplace() throws ObjectStreamException {
        return this.getAbsoluteFile();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.toURI());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.parse(FsPath.create((URI)((URI)in.readObject()), (FsUriModifier)FsUriModifier.CANONICALIZE), defaultDetector);
    }

    private boolean invariants() {
        assert (null != this.delegate);
        assert (!(this.delegate instanceof TFile));
        assert (this.delegate.getPath().equals(super.getPath()));
        assert (null != this.detector);
        assert (this.innerArchive != null == (this.getInnerEntryName() != null));
        assert (this.enclArchive != null == (this.enclEntryName != null));
        assert (this != this.enclArchive);
        assert (this == this.innerArchive ^ (this.innerArchive == this.enclArchive && null == this.controller));
        assert (null == this.enclArchive || Paths.contains((String)this.enclArchive.getPath(), (String)this.delegate.getParentFile().getPath(), (char)separatorChar) && 0 < this.enclEntryName.toString().length());
        return true;
    }

    public static void sync(BitField<FsSyncOption> options) throws FsSyncException {
        manager.sync(options);
    }

    public static void sync(TFile archive, BitField<FsSyncOption> options) throws FsSyncException {
        if (!archive.isArchive()) {
            throw new IllegalArgumentException(archive.getPath() + " (not a federated file system)");
        }
        if (null != archive.getEnclArchive()) {
            throw new IllegalArgumentException(archive.getPath() + " (not a top level federated file system)");
        }
        new FsFilteringManager(manager, archive.getController().getModel().getMountPoint()).sync(options);
    }

    public static void umount() throws FsSyncException {
        TFile.sync((BitField<FsSyncOption>)FsManager.UMOUNT);
    }

    public static void umount(boolean closeStreams) throws FsSyncException {
        TFile.sync((BitField<FsSyncOption>)BitField.of((Enum)FsSyncOption.CLEAR_CACHE).set((Enum)FsSyncOption.FORCE_CLOSE_INPUT, closeStreams).set((Enum)FsSyncOption.FORCE_CLOSE_OUTPUT, closeStreams));
    }

    public static void umount(boolean waitForInputStreams, boolean closeInputStreams, boolean waitForOutputStreams, boolean closeOutputStreams) throws FsSyncException {
        TFile.sync((BitField<FsSyncOption>)BitField.of((Enum)FsSyncOption.CLEAR_CACHE).set((Enum)FsSyncOption.WAIT_CLOSE_INPUT, waitForInputStreams).set((Enum)FsSyncOption.FORCE_CLOSE_INPUT, closeInputStreams).set((Enum)FsSyncOption.WAIT_CLOSE_OUTPUT, waitForOutputStreams).set((Enum)FsSyncOption.FORCE_CLOSE_OUTPUT, closeOutputStreams));
    }

    public static void umount(TFile archive) throws FsSyncException {
        TFile.sync(archive, (BitField<FsSyncOption>)FsManager.UMOUNT);
    }

    public static void umount(TFile archive, boolean closeStreams) throws FsSyncException {
        TFile.sync(archive, (BitField<FsSyncOption>)BitField.of((Enum)FsSyncOption.CLEAR_CACHE).set((Enum)FsSyncOption.FORCE_CLOSE_INPUT, closeStreams).set((Enum)FsSyncOption.FORCE_CLOSE_OUTPUT, closeStreams));
    }

    public static void umount(TFile archive, boolean waitForInputStreams, boolean closeInputStreams, boolean waitForOutputStreams, boolean closeOutputStreams) throws FsSyncException {
        TFile.sync(archive, (BitField<FsSyncOption>)BitField.of((Enum)FsSyncOption.CLEAR_CACHE).set((Enum)FsSyncOption.WAIT_CLOSE_INPUT, waitForInputStreams).set((Enum)FsSyncOption.FORCE_CLOSE_INPUT, closeInputStreams).set((Enum)FsSyncOption.WAIT_CLOSE_OUTPUT, waitForOutputStreams).set((Enum)FsSyncOption.FORCE_CLOSE_OUTPUT, closeOutputStreams));
    }

    public static boolean isLenient() {
        return lenient;
    }

    public static void setLenient(boolean lenient) {
        TFile.lenient = lenient;
    }

    public static TArchiveDetector getDefaultArchiveDetector() {
        return defaultDetector;
    }

    public static void setDefaultArchiveDetector(TArchiveDetector detector) {
        if (null == detector) {
            throw new NullPointerException();
        }
        defaultDetector = detector;
    }

    @Nullable
    public TFile getNonArchivedParentFile() {
        TFile enclArchive = this.enclArchive;
        return null != enclArchive ? enclArchive.getNonArchivedParentFile() : this.getParentFile();
    }

    @Override
    @Nullable
    public String getParent() {
        return this.delegate.getParent();
    }

    @Override
    @Nullable
    public TFile getParentFile() {
        File parent = this.delegate.getParentFile();
        if (parent == null) {
            return null;
        }
        if (null != this.enclArchive && this.enclArchive.getPath().length() == parent.getPath().length()) {
            assert (this.enclArchive.getPath().equals(parent.getPath()));
            return this.enclArchive;
        }
        return new TFile(parent, this.enclArchive, this.detector);
    }

    @Override
    public TFile getAbsoluteFile() {
        String p = this.getAbsolutePath();
        return p.equals(this.getPath()) ? this : new TFile(p, this.detector);
    }

    @Override
    public String getAbsolutePath() {
        return this.delegate.getAbsolutePath();
    }

    public TFile getNormalizedAbsoluteFile() {
        String p = this.getNormalizedAbsolutePath();
        return p.equals(this.getPath()) ? this : new TFile(p, this.detector);
    }

    public String getNormalizedAbsolutePath() {
        return Paths.normalize((String)this.getAbsolutePath(), (char)separatorChar);
    }

    public TFile getNormalizedFile() {
        String p = this.getNormalizedPath();
        return p.equals(this.getPath()) ? this : new TFile(p, this.detector);
    }

    public String getNormalizedPath() {
        return Paths.normalize((String)this.getPath(), (char)separatorChar);
    }

    @Override
    public TFile getCanonicalFile() throws IOException {
        String p = this.getCanonicalPath();
        return p.equals(this.getPath()) ? this : new TFile(p, this.detector);
    }

    @Override
    public String getCanonicalPath() throws IOException {
        return this.delegate.getCanonicalPath();
    }

    public final TFile getCanOrAbsFile() {
        String p = this.getCanOrAbsPath();
        return p.equals(this.getPath()) ? this : new TFile(p, this.detector);
    }

    public String getCanOrAbsPath() {
        try {
            return this.getCanonicalPath();
        }
        catch (IOException ex) {
            return Paths.normalize((String)this.getAbsolutePath(), (char)separatorChar);
        }
    }

    public boolean isArchive() {
        return this == this.innerArchive;
    }

    public boolean isEntry() {
        return this.enclEntryName != null;
    }

    @CheckForNull
    public TFile getInnerArchive() {
        return this.innerArchive;
    }

    @Nullable
    public String getInnerEntryName() {
        return this == this.innerArchive ? FsEntryName.ROOT.getPath() : (null == this.enclEntryName ? null : this.enclEntryName.getPath());
    }

    @Nullable
    FsEntryName getInnerEntryName0() {
        return this == this.innerArchive ? FsEntryName.ROOT : this.enclEntryName;
    }

    @CheckForNull
    public TFile getEnclArchive() {
        return this.enclArchive;
    }

    @Nullable
    public String getEnclEntryName() {
        return null == this.enclEntryName ? null : this.enclEntryName.getPath();
    }

    @Nullable
    final FsEntryName getEnclEntryName0() {
        return this.enclEntryName;
    }

    public final TArchiveDetector getArchiveDetector() {
        return this.detector;
    }

    public File getFile() {
        return this.delegate;
    }

    @Nullable
    FsController<?> getController() {
        FsMountPoint mountPoint;
        if (this != this.innerArchive || null != this.controller) {
            return this.controller;
        }
        assert (this == this.innerArchive);
        String path = Paths.normalize((String)this.delegate.getPath(), (char)separatorChar);
        FsScheme scheme = this.detector.getScheme(path);
        if (null == scheme) {
            throw new ServiceConfigurationError("unknown file system scheme for path \"" + path + "\"! Check run-time class path configuration.");
        }
        try {
            mountPoint = new FsMountPoint(scheme, null == this.enclArchive ? new FsPath(this.delegate) : new FsPath(this.enclArchive.getController().getModel().getMountPoint(), this.enclEntryName));
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
        this.controller = manager.getController(mountPoint, (FsCompositeDriver)this.detector);
        return this.controller;
    }

    public boolean isParentOf(File file) {
        String a = this.getAbsolutePath();
        String b = file.getAbsoluteFile().getParent();
        return b != null ? Paths.contains((String)a, (String)b, (char)separatorChar) : false;
    }

    public boolean contains(File file) {
        return TFile.contains(this, file);
    }

    public static boolean contains(File a, File b) {
        return Paths.contains((String)a.getAbsolutePath(), (String)b.getAbsolutePath(), (char)separatorChar);
    }

    public boolean isFileSystemRoot() {
        TFile canOrAbsFile = this.getCanOrAbsFile();
        return ROOTS.contains(canOrAbsFile) || TFile.isUNC(canOrAbsFile.getPath());
    }

    public boolean isUNC() {
        return TFile.isUNC(this.getCanOrAbsPath());
    }

    private static boolean isUNC(String path) {
        return path.startsWith(UNC_PREFIX) && path.indexOf(separatorChar, 2) > 2;
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean equals(Object that) {
        return this.delegate.equals(that);
    }

    @Override
    public int compareTo(File other) {
        return this.delegate.compareTo(other);
    }

    public TFile getTopLevelArchive() {
        TFile enclArchive = this.enclArchive;
        return null != enclArchive ? enclArchive.getTopLevelArchive() : this.innerArchive;
    }

    @Override
    public String getPath() {
        return this.delegate.getPath();
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public boolean isAbsolute() {
        return this.delegate.isAbsolute();
    }

    @Override
    public boolean isHidden() {
        return this.delegate.isHidden();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    public FsPath toFsPath() {
        try {
            if (this == this.innerArchive) {
                FsScheme scheme = this.detector.getScheme(this.delegate.getPath());
                assert (null != scheme);
                if (null != this.enclArchive) {
                    return new FsPath(new FsMountPoint(scheme, new FsPath(new FsMountPoint(this.enclArchive.toURI(), FsUriModifier.CANONICALIZE), this.enclEntryName)), FsEntryName.ROOT);
                }
                return new FsPath(new FsMountPoint(scheme, new FsPath(this.delegate)), FsEntryName.ROOT);
            }
            if (null != this.enclArchive) {
                return new FsPath(new FsMountPoint(this.enclArchive.toURI(), FsUriModifier.CANONICALIZE), this.enclEntryName);
            }
            return new FsPath(this.delegate);
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    @Override
    public URI toURI() {
        try {
            if (this == this.innerArchive) {
                FsScheme scheme = this.detector.getScheme(this.delegate.getPath());
                assert (null != scheme);
                if (null != this.enclArchive) {
                    return new FsMountPoint(scheme, new FsPath(new FsMountPoint(this.enclArchive.toURI(), FsUriModifier.CANONICALIZE), this.enclEntryName)).getUri();
                }
                return new FsMountPoint(scheme, new FsPath(this.delegate)).getUri();
            }
            if (null != this.enclArchive) {
                return new FsPath(new FsMountPoint(this.enclArchive.toURI(), FsUriModifier.CANONICALIZE), this.enclEntryName).getUri();
            }
            return this.delegate.toURI();
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    @Override
    @Deprecated
    public URL toURL() throws MalformedURLException {
        return null != this.innerArchive ? this.toURI().toURL() : this.delegate.toURL();
    }

    @Override
    public boolean exists() {
        if (this.innerArchive != null) {
            try {
                return null != this.innerArchive.getController().getEntry(this.getInnerEntryName0());
            }
            catch (IOException ex) {
                return false;
            }
        }
        return this.delegate.exists();
    }

    @Override
    public boolean isFile() {
        if (null != this.innerArchive) {
            try {
                FsEntry entry = this.innerArchive.getController().getEntry(this.getInnerEntryName0());
                if (null == entry) {
                    return false;
                }
                Entry.Type type = entry.getType();
                return Entry.Type.FILE == type || Entry.Type.HYBRID == type;
            }
            catch (IOException ex) {
                return false;
            }
        }
        return this.delegate.isFile();
    }

    @Override
    public boolean isDirectory() {
        if (null != this.innerArchive) {
            try {
                FsEntry entry = this.innerArchive.getController().getEntry(this.getInnerEntryName0());
                if (null == entry) {
                    return false;
                }
                Entry.Type type = entry.getType();
                return Entry.Type.DIRECTORY == type || Entry.Type.HYBRID == type;
            }
            catch (IOException ex) {
                return false;
            }
        }
        return this.delegate.isDirectory();
    }

    @CheckForNull
    public Icon getOpenIcon() {
        if (this == this.innerArchive) {
            try {
                return this.getController().getOpenIcon();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @CheckForNull
    public Icon getClosedIcon() {
        if (this == this.innerArchive) {
            try {
                return this.getController().getClosedIcon();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public boolean canRead() {
        if (null != this.innerArchive) {
            try {
                return this.innerArchive.getController().isReadable(this.getInnerEntryName0());
            }
            catch (IOException ex) {
                return false;
            }
        }
        return this.delegate.canRead();
    }

    @Override
    public boolean canWrite() {
        if (null != this.innerArchive) {
            try {
                return this.innerArchive.getController().isWritable(this.getInnerEntryName0());
            }
            catch (IOException ex) {
                return false;
            }
        }
        return this.delegate.canWrite();
    }

    @Override
    public boolean setReadOnly() {
        if (null != this.innerArchive) {
            try {
                this.innerArchive.getController().setReadOnly(this.getInnerEntryName0());
                return true;
            }
            catch (IOException ex) {
                return false;
            }
        }
        return this.delegate.setReadOnly();
    }

    @Override
    public long length() {
        if (null != this.innerArchive) {
            FsEntry entry;
            try {
                entry = this.innerArchive.getController().getEntry(this.getInnerEntryName0());
            }
            catch (IOException ex) {
                return 0L;
            }
            if (null == entry || entry.getType() == Entry.Type.DIRECTORY) {
                return 0L;
            }
            long length = entry.getSize(Entry.Size.DATA);
            return length >= 0L ? length : 0L;
        }
        return this.delegate.length();
    }

    @Override
    public long lastModified() {
        if (null != this.innerArchive) {
            FsEntry entry;
            try {
                entry = this.innerArchive.getController().getEntry(this.getInnerEntryName0());
            }
            catch (IOException ex) {
                return 0L;
            }
            if (null == entry) {
                return 0L;
            }
            long time = entry.getTime(Entry.Access.WRITE);
            return 0L <= time ? time : 0L;
        }
        return this.delegate.lastModified();
    }

    @Override
    public boolean setLastModified(long time) {
        if (null != this.innerArchive) {
            try {
                this.innerArchive.getController().setTime(this.getInnerEntryName0(), BitField.of((Enum)Entry.Access.WRITE), time);
                return true;
            }
            catch (IOException ex) {
                return false;
            }
        }
        return this.delegate.setLastModified(time);
    }

    @Override
    @Nullable
    public String[] list() {
        if (null != this.innerArchive) {
            FsEntry entry;
            try {
                entry = this.innerArchive.getController().getEntry(this.getInnerEntryName0());
            }
            catch (IOException ex) {
                return null;
            }
            if (null == entry) {
                return null;
            }
            Set members = entry.getMembers();
            return null == members ? null : members.toArray(new String[members.size()]);
        }
        return this.delegate.list();
    }

    @Override
    @Nullable
    public String[] list(@CheckForNull FilenameFilter filter) {
        if (null != this.innerArchive) {
            FsEntry entry;
            try {
                entry = this.innerArchive.getController().getEntry(this.getInnerEntryName0());
            }
            catch (IOException ex) {
                return null;
            }
            if (null == entry) {
                return null;
            }
            Set members = entry.getMembers();
            if (null == members) {
                return null;
            }
            if (null == filter) {
                return members.toArray(new String[members.size()]);
            }
            ArrayList<String> filtered = new ArrayList<String>(members.size());
            for (String member : members) {
                if (!filter.accept(this, member)) continue;
                filtered.add(member);
            }
            return filtered.toArray(new String[filtered.size()]);
        }
        return this.delegate.list(filter);
    }

    @Nullable
    public TFile[] listFiles() {
        return this.listFiles((FilenameFilter)null, this.detector);
    }

    @Nullable
    public TFile[] listFiles(TArchiveDetector detector) {
        return this.listFiles((FilenameFilter)null, detector);
    }

    @Nullable
    public TFile[] listFiles(@CheckForNull FilenameFilter filenameFilter) {
        return this.listFiles(filenameFilter, this.detector);
    }

    @Nullable
    public TFile[] listFiles(@CheckForNull FilenameFilter filter, TArchiveDetector detector) {
        if (null != this.innerArchive) {
            FsEntry entry;
            try {
                entry = this.innerArchive.getController().getEntry(this.getInnerEntryName0());
            }
            catch (IOException ex) {
                return null;
            }
            if (null == entry) {
                return null;
            }
            Set members = entry.getMembers();
            if (null == members) {
                return null;
            }
            ArrayList<TFile> filtered = new ArrayList<TFile>(members.size());
            for (String member : members) {
                if (filter != null && !filter.accept(this, member)) continue;
                filtered.add(new TFile((File)this, member, detector));
            }
            return filtered.toArray(new TFile[filtered.size()]);
        }
        return TFile.convert(this.delegate.listFiles(filter), detector);
    }

    @Nullable
    private static TFile[] convert(File[] files, TArchiveDetector detector) {
        if (null == files) {
            return null;
        }
        TFile[] results = new TFile[files.length];
        int i = files.length;
        while (0 <= --i) {
            results[i] = new TFile(files[i], detector);
        }
        return results;
    }

    @Nullable
    public TFile[] listFiles(@CheckForNull FileFilter fileFilter) {
        return this.listFiles(fileFilter, this.detector);
    }

    @Nullable
    public TFile[] listFiles(@CheckForNull FileFilter filter, TArchiveDetector detector) {
        if (null != this.innerArchive) {
            FsEntry entry;
            try {
                entry = this.innerArchive.getController().getEntry(this.getInnerEntryName0());
            }
            catch (IOException ex) {
                return null;
            }
            if (null == entry) {
                return null;
            }
            Set members = entry.getMembers();
            if (null == members) {
                return null;
            }
            ArrayList<TFile> filtered = new ArrayList<TFile>(members.size());
            for (String member : members) {
                TFile file = new TFile((File)this, member, detector);
                if (filter != null && !filter.accept(file)) continue;
                filtered.add(file);
            }
            return filtered.toArray(new TFile[filtered.size()]);
        }
        return this.delegateListFiles(filter, detector);
    }

    @Nullable
    private TFile[] delegateListFiles(@CheckForNull FileFilter filter, TArchiveDetector detector) {
        ArrayList<TFile> filteredList = new ArrayList<TFile>();
        String[] members = this.delegate.list();
        if (members == null) {
            return null;
        }
        for (String member : members) {
            TFile file = new TFile((File)this, member, detector);
            if (filter != null && !filter.accept(file)) continue;
            filteredList.add(file);
        }
        TFile[] list = new TFile[filteredList.size()];
        filteredList.toArray(list);
        return list;
    }

    @Override
    public boolean createNewFile() throws IOException {
        if (null != this.innerArchive) {
            FsEntryName entryName;
            FsController<?> controller = this.innerArchive.getController();
            if (null != controller.getEntry(entryName = this.getInnerEntryName0())) {
                return false;
            }
            controller.mknod(entryName, Entry.Type.FILE, BitField.of((Enum)FsOutputOption.EXCLUSIVE).set((Enum)FsOutputOption.CREATE_PARENTS, TFile.isLenient()), null);
            return true;
        }
        return this.delegate.createNewFile();
    }

    @Override
    public boolean mkdirs() {
        if (null == this.innerArchive) {
            return this.delegate.mkdirs();
        }
        TFile parent = this.getParentFile();
        if (null != parent && !parent.exists()) {
            parent.mkdirs();
        }
        return this.mkdir();
    }

    @Override
    public boolean mkdir() {
        if (null != this.innerArchive) {
            try {
                this.innerArchive.getController().mknod(this.getInnerEntryName0(), Entry.Type.DIRECTORY, BitField.of((Enum)FsOutputOption.EXCLUSIVE).set((Enum)FsOutputOption.CREATE_PARENTS, TFile.isLenient()), null);
                return true;
            }
            catch (IOException ex) {
                return false;
            }
        }
        return this.delegate.mkdir();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TFile mkdir(boolean recursive) throws IOException {
        if (null != this.innerArchive) {
            TFile parent;
            if (recursive && null != (parent = this.getParentFile()) && !parent.exists()) {
                parent.mkdir(recursive);
            }
            FsController<?> controller = this.innerArchive.getController();
            FsEntryName innerEntryName = this.getInnerEntryName0();
            try {
                controller.mknod(innerEntryName, Entry.Type.DIRECTORY, BitField.of((Enum)FsOutputOption.EXCLUSIVE).set((Enum)FsOutputOption.CREATE_PARENTS, TFile.isLenient()), null);
                return this;
            }
            catch (IOException ex) {
                FsEntry entry = controller.getEntry(innerEntryName);
                if (null == entry) {
                    throw ex;
                }
                Entry.Type type = entry.getType();
                if (Entry.Type.DIRECTORY == type || Entry.Type.HYBRID == type) return this;
                throw ex;
            }
        } else {
            File dir = this.delegate;
            if ((!recursive ? dir.mkdir() : dir.mkdirs()) || dir.isDirectory()) return this;
            throw new IOException(dir + " (cannot create directory)");
        }
    }

    @Override
    @Deprecated
    public final boolean delete() {
        try {
            TFile.rm(this);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public TFile rm() throws IOException {
        TFile.rm(this);
        return this;
    }

    public static void rm(File node) throws IOException {
        if (node instanceof TFile) {
            TFile file = (TFile)node;
            if (null != file.innerArchive) {
                file.innerArchive.getController().unlink(file.getInnerEntryName0());
                return;
            }
            node = file.delegate;
        }
        if (!node.delete()) {
            throw new IOException(node + " (cannot delete)");
        }
    }

    public TFile rm_r() throws IOException {
        TBIO.rm_r(this, this.detector);
        return this;
    }

    public static void rm_r(File node) throws IOException {
        TBIO.rm_r(node, node instanceof TFile ? ((TFile)node).detector : TArchiveDetector.NULL);
    }

    @Override
    public void deleteOnExit() {
        if (this.innerArchive != null) {
            throw new UnsupportedOperationException();
        }
        this.delegate.deleteOnExit();
    }

    @Override
    @Deprecated
    public final boolean renameTo(File dst) {
        try {
            TFile.mv(this, dst, this.detector);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public TFile mv(File dst) throws IOException {
        TFile.mv(this, dst, this.detector);
        return this;
    }

    public static void mv(File src, File dst, TArchiveDetector detector) throws IOException {
        if (detector.toString().isEmpty()) {
            File dstDelegate;
            boolean dstArchived;
            File srcDelegate;
            boolean srcArchived;
            if (src instanceof TFile) {
                TFile srcFile = (TFile)src;
                srcArchived = null != srcFile.innerArchive;
                srcDelegate = srcFile.delegate;
            } else {
                srcArchived = false;
                srcDelegate = src;
            }
            if (dst instanceof TFile) {
                TFile dstFile = (TFile)dst;
                dstArchived = null != dstFile.innerArchive;
                dstDelegate = dstFile.delegate;
            } else {
                dstArchived = false;
                dstDelegate = src;
            }
            if (!srcArchived && !dstArchived) {
                if (srcDelegate.renameTo(dstDelegate)) {
                    return;
                }
                throw new IOException(src + " (cannot move to " + dst + ")");
            }
        }
        TBIO.mv(src, dst, detector);
    }

    public static void cp(InputStream in, OutputStream out) throws IOException {
        Streams.copy((InputStream)in, (OutputStream)out);
    }

    public static void cp(InputStream in, File dst) throws IOException {
        block2: {
            TFileOutputStream out = new TFileOutputStream(dst);
            try {
                TFile.cp(in, (OutputStream)((Object)out));
            }
            catch (IOException ex) {
                if (dst.delete()) break block2;
                throw new IOException(dst + " (cannot delete)", ex);
            }
        }
    }

    public static void cp(File src, OutputStream out) throws IOException {
        TFile.cp((InputStream)((Object)new TFileInputStream(src)), out);
    }

    public TFile cp(File dst) throws IOException {
        TBIO.cp(false, this, dst);
        return this;
    }

    public static void cp(File src, File dst) throws IOException {
        TBIO.cp(false, src, dst);
    }

    public TFile cp_p(File dst) throws IOException {
        TBIO.cp(true, this, dst);
        return this;
    }

    public static void cp_p(File src, File dst) throws IOException {
        TBIO.cp(true, src, dst);
    }

    public TFile cp_r(File dst) throws IOException {
        TBIO.cp_r(false, this, dst, this.detector, this.detector);
        return this;
    }

    public static void cp_r(File src, File dst, TArchiveDetector srcDetector, TArchiveDetector dstDetector) throws IOException {
        TBIO.cp_r(false, src, dst, srcDetector, dstDetector);
    }

    public TFile cp_rp(File dst) throws IOException {
        TBIO.cp_r(true, this, dst, this.detector, this.detector);
        return this;
    }

    public static void cp_rp(File src, File dst, TArchiveDetector srcDetector, TArchiveDetector dstDetector) throws IOException {
        TBIO.cp_r(true, src, dst, srcDetector, dstDetector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void input(InputStream in) throws IOException {
        TFileOutputStream out = new TFileOutputStream(this, false);
        try {
            try {
                Streams.cat((InputStream)in, (OutputStream)((Object)out));
            }
            finally {
                ((OutputStream)((Object)out)).close();
            }
        }
        catch (IOException ex) {
            this.delete();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void output(OutputStream out) throws IOException {
        TFileInputStream in = new TFileInputStream(this);
        try {
            Streams.cat((InputStream)((Object)in), (OutputStream)out);
        }
        finally {
            ((InputStream)((Object)in)).close();
        }
    }

    public static void cat(InputStream in, OutputStream out) throws IOException {
        Streams.cat((InputStream)in, (OutputStream)out);
    }
}

