/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.file;

import de.schlichtherle.truezip.fs.FsCompositeDriver;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDriver;
import de.schlichtherle.truezip.fs.FsDriverProvider;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsPath;
import de.schlichtherle.truezip.fs.FsScheme;
import de.schlichtherle.truezip.fs.sl.FsDriverLocator;
import de.schlichtherle.truezip.fs.spi.FsDriverService;
import de.schlichtherle.truezip.util.CanonicalStringSet;
import de.schlichtherle.truezip.util.SuffixSet;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;

@Immutable
@DefaultAnnotation(value={NonNull.class})
public final class TArchiveDetector
implements FsCompositeDriver,
FsDriverProvider {
    public static final TArchiveDetector NULL = new TArchiveDetector("");
    public static final TArchiveDetector ALL = new TArchiveDetector(null);
    private final Map<FsScheme, FsDriver> drivers;
    private final String suffixes;
    private final ThreadLocalMatcher matcher;

    public TArchiveDetector(@CheckForNull String suffixes) {
        this((FsDriverProvider)FsDriverLocator.SINGLETON, suffixes);
    }

    public TArchiveDetector(FsDriverProvider provider, @CheckForNull String suffixes) {
        HashMap<FsScheme, FsDriver> outDrivers;
        SuffixSet inSuffixes;
        HashMap<FsScheme, FsDriver> inDrivers = provider.get();
        if (null != suffixes) {
            inSuffixes = new SuffixSet(suffixes);
            outDrivers = new HashMap<FsScheme, FsDriver>(inDrivers.size() * 4 / 3 + 1);
        } else {
            inSuffixes = null;
            outDrivers = inDrivers;
        }
        SuffixSet outSuffixes = new SuffixSet();
        for (Map.Entry entry : inDrivers.entrySet()) {
            FsDriver driver = (FsDriver)entry.getValue();
            if (null == driver) continue;
            FsScheme scheme = (FsScheme)entry.getKey();
            boolean federated = driver.isFederated();
            if (null != inSuffixes) {
                boolean accepted = inSuffixes.contains((Object)scheme.toString());
                if (!federated || accepted) {
                    outDrivers.put(scheme, driver);
                }
                if (!federated || !accepted) continue;
                outSuffixes.add(scheme.toString());
                continue;
            }
            if (!federated) continue;
            outSuffixes.add(scheme.toString());
        }
        if (null != inSuffixes && inSuffixes.retainAll((CanonicalStringSet)outSuffixes)) {
            throw new IllegalArgumentException("\"" + inSuffixes + "\" (no archive driver installed for these suffixes)");
        }
        this.drivers = Collections.unmodifiableMap(outDrivers);
        this.suffixes = outSuffixes.toString();
        this.matcher = new ThreadLocalMatcher(outSuffixes.toPattern());
    }

    public TArchiveDetector(String suffixes, @CheckForNull FsDriver driver) {
        this(NULL, suffixes, driver);
    }

    public TArchiveDetector(FsDriverProvider delegate, String suffixes, @CheckForNull FsDriver driver) {
        this(delegate, new Object[][]{{suffixes, driver}});
    }

    public TArchiveDetector(FsDriverProvider delegate, Object[][] config) {
        this(delegate, FsDriverService.newMap((Object[][])config));
    }

    public TArchiveDetector(FsDriverProvider provider, Map<FsScheme, FsDriver> config) {
        Map inDrivers = provider.get();
        HashMap<FsScheme, FsDriver> outDrivers = new HashMap<FsScheme, FsDriver>(inDrivers.size() * 4 / 3 + 1);
        SuffixSet outSuffixes = new SuffixSet();
        for (Map.Entry entry : inDrivers.entrySet()) {
            FsDriver driver = (FsDriver)entry.getValue();
            if (null == driver) continue;
            FsScheme scheme = (FsScheme)entry.getKey();
            outDrivers.put(scheme, driver);
            if (!driver.isFederated()) continue;
            outSuffixes.add(scheme.toString());
        }
        for (Map.Entry<Object, Object> entry : config.entrySet()) {
            FsScheme scheme = (FsScheme)entry.getKey();
            FsDriver driver = (FsDriver)entry.getValue();
            if (null != driver) {
                outDrivers.put(scheme, driver);
                outSuffixes.add(scheme.toString());
                continue;
            }
            outDrivers.remove(scheme);
            outSuffixes.remove((Object)scheme.toString());
        }
        this.drivers = Collections.unmodifiableMap(outDrivers);
        this.suffixes = outSuffixes.toString();
        this.matcher = new ThreadLocalMatcher(outSuffixes.toPattern());
    }

    public Map<FsScheme, FsDriver> get() {
        return this.drivers;
    }

    @CheckForNull
    public FsScheme getScheme(String path) {
        Matcher m = this.matcher.reset(path);
        return m.matches() ? FsScheme.create((String)m.group(1).toLowerCase(Locale.ENGLISH)) : null;
    }

    public FsController<?> newController(FsModel model, @CheckForNull FsController<?> parent) {
        FsScheme detectedScheme;
        assert (null != model.getParent() ? model.getParent().equals((Object)parent.getModel()) : null == parent);
        FsMountPoint mountPoint = model.getMountPoint();
        FsScheme declaredScheme = mountPoint.getScheme();
        FsPath path = mountPoint.getPath();
        if (null != path && !declaredScheme.equals((Object)(detectedScheme = this.getScheme(path.getEntryName().getPath())))) {
            throw new IllegalArgumentException(mountPoint.toString() + " (declared/detected scheme mismatch)");
        }
        FsDriver driver = this.drivers.get(declaredScheme);
        if (null == driver) {
            throw new ServiceConfigurationError(declaredScheme + " (unknown file system scheme - check run time class path configuration)");
        }
        return driver.newController(model, parent);
    }

    public String toString() {
        return this.suffixes;
    }

    @ThreadSafe
    @DefaultAnnotation(value={NonNull.class})
    private static final class ThreadLocalMatcher
    extends ThreadLocal<Matcher> {
        private final Pattern pattern;

        ThreadLocalMatcher(Pattern pattern) {
            if (null == pattern) {
                throw new NullPointerException();
            }
            this.pattern = pattern;
        }

        @Override
        protected Matcher initialValue() {
            return this.pattern.matcher("");
        }

        Matcher reset(CharSequence input) {
            return ((Matcher)this.get()).reset(input);
        }
    }
}

