/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.file;

import de.schlichtherle.truezip.file.TBIO;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.io.DecoratingInputStream;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.util.BitField;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import net.jcip.annotations.Immutable;

@DefaultAnnotation(value={NonNull.class})
@Immutable
public final class TFileInputStream
extends DecoratingInputStream {
    private static final BitField<FsInputOption> DEFAULT_OPTIONS = BitField.noneOf(FsInputOption.class);

    public TFileInputStream(String path) throws FileNotFoundException {
        super(TFileInputStream.newInputStream(new TFile(path)));
    }

    public TFileInputStream(File file) throws FileNotFoundException {
        super(TFileInputStream.newInputStream(file));
    }

    private static InputStream newInputStream(File src) throws FileNotFoundException {
        InputSocket<?> input = TBIO.getInputSocket(src, DEFAULT_OPTIONS);
        try {
            return input.newInputStream();
        }
        catch (FileNotFoundException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw (FileNotFoundException)new FileNotFoundException(ex.toString()).initCause(ex);
        }
    }
}

