/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.file;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.fs.FsCompositeDriver;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsInputOptions;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsOutputOptions;
import de.schlichtherle.truezip.fs.FsPath;
import de.schlichtherle.truezip.io.Paths;
import de.schlichtherle.truezip.socket.IOSocket;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import net.jcip.annotations.Immutable;

@DefaultAnnotation(value={NonNull.class})
@Immutable
final class TBIO {
    private TBIO() {
    }

    public static void mv(File src, File dst, TArchiveDetector detector) throws IOException {
        if (dst.exists()) {
            throw new IOException(dst + " (destination exists already)");
        }
        TBIO.checkContains(src, dst);
        TBIO.mv0(src, dst, detector);
    }

    private static void mv0(File src, File dst, TArchiveDetector detector) throws IOException {
        if (src.isDirectory()) {
            boolean srcIsGhost;
            long srcLastModified = src.lastModified();
            boolean srcIsArchived = src instanceof TFile && null != ((TFile)src).getInnerArchive();
            boolean dstIsArchived = dst instanceof TFile && null != ((TFile)dst).getInnerArchive();
            boolean bl = srcIsGhost = srcIsArchived && 0L >= srcLastModified;
            if (!(srcIsGhost && dstIsArchived && TFile.isLenient() || dst.mkdir() || dst.isDirectory())) {
                throw new IOException(dst + " (not a directory)");
            }
            Object[] members = src.list();
            if (!srcIsArchived && dstIsArchived) {
                Arrays.sort(members);
            }
            for (Object member : members) {
                TBIO.mv0(new TFile(src, (String)member, detector), new TFile(dst, (String)member, detector), detector);
            }
            if (!srcIsGhost && !dst.setLastModified(srcLastModified)) {
                throw new IOException(dst + " (cannot set last modification time)");
            }
        } else if (src.isFile()) {
            if (dst.exists() && !dst.isFile()) {
                throw new IOException(dst + " (not a file)");
            }
            TBIO.cp0(true, src, dst);
        } else {
            if (src.exists()) {
                throw new IOException(src + " (cannot move special file)");
            }
            throw new IOException(src + " (missing file)");
        }
        if (!src.delete()) {
            throw new IOException(src + " (cannot delete)");
        }
    }

    public static void cp_r(boolean preserve, File src, File dst, TArchiveDetector srcDetector, TArchiveDetector dstDetector) throws IOException {
        TBIO.checkContains(src, dst);
        TBIO.cp_r0(preserve, src, dst, srcDetector, dstDetector);
    }

    private static void cp_r0(boolean preserve, File src, File dst, TArchiveDetector srcDetector, TArchiveDetector dstDetector) throws IOException {
        if (src.isDirectory()) {
            boolean srcIsGhost;
            long srcLastModified = src.lastModified();
            boolean srcArchived = src instanceof TFile && null != ((TFile)src).getInnerArchive();
            boolean dstArchived = dst instanceof TFile && null != ((TFile)dst).getInnerArchive();
            boolean bl = srcIsGhost = srcArchived && 0L >= srcLastModified;
            if (!(srcIsGhost && dstArchived && TFile.isLenient() || dst.mkdir() || dst.isDirectory())) {
                throw new IOException(dst + " (not a directory)");
            }
            Object[] members = src.list();
            if (!srcArchived && dstArchived) {
                Arrays.sort(members);
            }
            for (Object member : members) {
                TBIO.cp_r0(preserve, new TFile(src, (String)member, srcDetector), new TFile(dst, (String)member, dstDetector), srcDetector, dstDetector);
            }
            if (preserve && !srcIsGhost && !dst.setLastModified(srcLastModified)) {
                throw new IOException(dst + " (cannot set last modification time)");
            }
        } else if (src.isFile()) {
            if (dst.exists() && !dst.isFile()) {
                throw new IOException(dst + " (not a file)");
            }
            TBIO.cp0(preserve, src, dst);
        } else {
            if (src.exists()) {
                throw new IOException(src + " (cannot copy special file)");
            }
            throw new IOException(src + " (missing file)");
        }
    }

    public static void cp(boolean preserve, File src, File dst) throws IOException {
        TBIO.checkContains(src, dst);
        TBIO.cp0(preserve, src, dst);
    }

    private static void cp0(boolean preserve, File src, File dst) throws IOException {
        InputSocket<?> input = TBIO.getInputSocket(src, (BitField<FsInputOption>)FsInputOptions.NO_INPUT_OPTION);
        OutputSocket<?> output = TBIO.getOutputSocket(dst, (BitField<FsOutputOption>)FsOutputOptions.NO_OUTPUT_OPTION.set((Enum)FsOutputOption.CREATE_PARENTS, TFile.isLenient()), preserve ? (Entry)input.getLocalTarget() : null);
        IOSocket.copy(input, output);
    }

    public static void rm_r(File node, TArchiveDetector detector) throws IOException {
        if (node.isDirectory()) {
            for (String member : node.list()) {
                TBIO.rm_r(new TFile(node, member, detector), detector);
            }
        }
        if (!node.delete()) {
            throw new IOException(node + " (cannot delete)");
        }
    }

    private static void checkContains(File a, File b) throws IOException {
        if (Paths.contains((String)a.getAbsolutePath(), (String)b.getAbsolutePath(), (char)File.separatorChar)) {
            throw new IOException(b + " (contained in " + a + ")");
        }
    }

    static InputSocket<?> getInputSocket(File src, BitField<FsInputOption> options) {
        TFile file;
        TFile archive;
        if (src instanceof TFile && null != (archive = (file = (TFile)src).getInnerArchive())) {
            return archive.getController().getInputSocket(file.getInnerFsEntryName(), options);
        }
        FsPath path = new FsPath(src);
        return TFile.manager.getController(path.getMountPoint(), (FsCompositeDriver)TBIO.getDetector(src)).getInputSocket(path.getEntryName(), options);
    }

    private static TArchiveDetector getDetector(File file) {
        return file instanceof TFile ? ((TFile)file).getArchiveDetector() : TFile.getDefaultArchiveDetector();
    }

    static OutputSocket<?> getOutputSocket(File dst, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        TFile file;
        TFile archive;
        if (dst instanceof TFile && null != (archive = (file = (TFile)dst).getInnerArchive())) {
            return archive.getController().getOutputSocket(file.getInnerFsEntryName(), options, template);
        }
        FsPath path = new FsPath(dst);
        return TFile.manager.getController(path.getMountPoint(), (FsCompositeDriver)TBIO.getDetector(dst)).getOutputSocket(path.getEntryName(), options, template);
    }
}

