/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.file;

import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.fs.FsDriver;
import de.schlichtherle.truezip.fs.FsDriverProvider;
import de.schlichtherle.truezip.fs.FsScheme;
import de.schlichtherle.truezip.fs.archive.FsArchiveDriver;
import de.schlichtherle.truezip.fs.archive.mock.MockArchiveDriver;
import de.schlichtherle.truezip.util.SuffixSet;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Locale;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@DefaultAnnotation(value={NonNull.class})
public class TArchiveDetectorTest {
    private FsArchiveDriver<?> driver;
    private TArchiveDetector ALL;
    private TArchiveDetector NIL;
    private TArchiveDetector MOK;

    @Before
    public void setUp() {
        this.driver = new MockArchiveDriver();
        this.ALL = new TArchiveDetector("jar|zip", this.driver);
        this.NIL = new TArchiveDetector((FsDriverProvider)this.ALL, "");
        this.MOK = new TArchiveDetector((FsDriverProvider)this.NIL, "nil", this.driver);
    }

    @Test
    public void testIllegalConstructors() {
        for (TArchiveDetector delegate : new TArchiveDetector[]{this.NIL, this.ALL}) {
            try {
                new TArchiveDetector((FsDriverProvider)delegate, (Object[][])new Object[][]{{"foo", "java.lang.Object"}, {"bar", "java.io.FilterInputStream"}});
                Assert.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException expected) {
                // empty catch block
            }
        }
        this.testIllegalConstructors(NullPointerException.class, new Object[][]{{null, null}, {null, this.driver}, {null, null, null}, {null, null, this.driver}, {null, "xyz", null}, {null, "xyz", this.driver}, {this.NIL, null, null}, {this.NIL, null, this.driver}, {null, new Object[][]{{"xyz", MockArchiveDriver.class}}}, {this.NIL, null}, {this.NIL, new Object[][]{{null, null}}}, {this.NIL, new Object[][]{{null, ""}}}, {this.NIL, new Object[][]{{null, "xyz"}}}});
        this.testIllegalConstructors(IllegalArgumentException.class, new Object[][]{{"DRIVER"}, {"DEFAULT"}, {"NULL"}, {"ALL"}, {"unknownSuffix"}, {"", this.driver}, {".", this.driver}, {"|", this.driver}, {"|.", this.driver}, {"||", this.driver}, {"||.", this.driver}, {"|.|", this.driver}, {"|.|.", this.driver}, {this.NIL, "", this.driver}, {this.NIL, ".", this.driver}, {this.NIL, "|", this.driver}, {this.NIL, "|.", this.driver}, {this.NIL, "||", this.driver}, {this.NIL, "||.", this.driver}, {this.NIL, "|.|", this.driver}, {this.NIL, "|.|.", this.driver}, {this.NIL, new Object[][]{{"", this.driver}}}, {this.NIL, new Object[][]{{".", this.driver}}}, {this.NIL, new Object[][]{{"|", this.driver}}}, {this.NIL, new Object[][]{{"|.", this.driver}}}, {this.NIL, new Object[][]{{"||", this.driver}}}, {this.NIL, new Object[][]{{"||.", this.driver}}}, {this.NIL, new Object[][]{{"|.|", this.driver}}}, {this.NIL, new Object[][]{{"|.|.", this.driver}}}, {this.NIL, new Object[][]{{"anySuffix", ""}}}, {this.NIL, new Object[][]{{"anySuffix", "xyz"}}}, {this.NIL, new Object[][]{{MockArchiveDriver.class, this.driver}}}, {this.NIL, new Object[][]{{this.driver, this.driver}}}, {this.NIL, new Object[][]{{"anySuffix", new Object()}}}, {this.NIL, new Object[][]{{"anySuffix", Object.class}}}});
    }

    private void testIllegalConstructors(Class<? extends Throwable> expected, Object[][] list) {
        for (int i = 0; i < list.length; ++i) {
            Object[] args = list[i];
            Object arg0 = args[0];
            Object arg1 = null;
            Object arg2 = null;
            try {
                switch (args.length) {
                    case 1: {
                        new TArchiveDetector((String)arg0);
                        Assert.fail((String)("Index " + i));
                        break;
                    }
                    case 2: {
                        arg1 = args[1];
                        if (arg0 != null) {
                            if (arg1 != null) {
                                if (arg0 instanceof String) {
                                    new TArchiveDetector((String)arg0, (FsDriver)((FsArchiveDriver)arg1));
                                } else if (arg1 instanceof Object[][]) {
                                    new TArchiveDetector((FsDriverProvider)((TArchiveDetector)arg0), (Object[][])arg1);
                                } else {
                                    new TArchiveDetector((FsDriverProvider)((TArchiveDetector)arg0), (Map)arg1);
                                }
                                Assert.fail((String)("Index " + i));
                                break;
                            }
                            assert (arg0 != null);
                            assert (arg1 == null);
                            if (arg0 instanceof String) {
                                new TArchiveDetector((String)arg0, null);
                                Assert.fail((String)("Index " + i));
                                break;
                            }
                            try {
                                new TArchiveDetector((FsDriverProvider)((TArchiveDetector)arg0), (Object[][])null);
                                Assert.fail((String)("Index " + i));
                            }
                            catch (Throwable failure) {
                                Assert.assertTrue((boolean)expected.isAssignableFrom(failure.getClass()));
                            }
                            try {
                                new TArchiveDetector((FsDriverProvider)((TArchiveDetector)arg0), (Map)null);
                                Assert.fail((String)("Index " + i));
                            }
                            catch (Throwable failure) {
                                Assert.assertTrue((boolean)expected.isAssignableFrom(failure.getClass()));
                            }
                            break;
                        }
                        assert (arg0 == null);
                        if (arg1 != null) {
                            if (arg1 instanceof FsArchiveDriver) {
                                new TArchiveDetector(null, (FsDriver)((FsArchiveDriver)arg1));
                            } else if (arg1 instanceof Object[][]) {
                                new TArchiveDetector(null, (Object[][])arg1);
                            } else {
                                new TArchiveDetector(null, (Map)arg1);
                            }
                            Assert.fail((String)("Index " + i));
                            break;
                        }
                        assert (arg0 == null);
                        assert (arg1 == null);
                        try {
                            new TArchiveDetector((String)null, (FsDriver)((FsArchiveDriver)null));
                            Assert.fail((String)("Index " + i));
                        }
                        catch (Throwable failure) {
                            Assert.assertTrue((boolean)expected.isAssignableFrom(failure.getClass()));
                        }
                        try {
                            new TArchiveDetector((FsDriverProvider)((TArchiveDetector)null), (Object[][])null);
                            Assert.fail((String)("Index " + i));
                        }
                        catch (Throwable failure) {
                            Assert.assertTrue((boolean)expected.isAssignableFrom(failure.getClass()));
                        }
                        try {
                            new TArchiveDetector((FsDriverProvider)((TArchiveDetector)null), (Map)null);
                            Assert.fail((String)("Index " + i));
                        }
                        catch (Throwable failure) {
                            Assert.assertTrue((boolean)expected.isAssignableFrom(failure.getClass()));
                        }
                        break;
                    }
                    case 3: {
                        arg1 = args[1];
                        arg2 = args[2];
                        new TArchiveDetector((FsDriverProvider)((TArchiveDetector)arg0), (String)arg1, (FsDriver)((FsArchiveDriver)arg2));
                        Assert.fail((String)("Index " + i));
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                continue;
            }
            catch (Throwable ex) {
                Assert.assertTrue((boolean)expected.isAssignableFrom(ex.getClass()));
            }
        }
    }

    @Test
    public void testGetSuffixes() {
        this.assertSuffixes(new String[]{"zip", "zip", "zip", ".zip", "zip", "|zip", "zip", "zip|", "zip", "zip|zip", "zip", "zip|.zip", "zip", "zip||zip", "zip", "zip|zip|", "zip", ".zip|", "zip", ".zip|zip", "zip", ".zip|.zip", "zip", ".zip||zip", "zip", ".zip|zip|", "zip", "|zip|", "zip", "|zip|zip", "zip", "|zip|.zip", "zip", "|zip||zip", "zip", "|zip|zip|", "zip", "ZIP", "zip", ".ZIP", "zip", "|ZIP", "zip", "ZIP|", "zip", "ZIP|ZIP", "zip", "ZIP|.ZIP", "zip", "ZIP||ZIP", "zip", "ZIP|ZIP|", "zip", ".ZIP|", "zip", ".ZIP|ZIP", "zip", ".ZIP|.ZIP", "zip", ".ZIP||ZIP", "zip", ".ZIP|ZIP|", "zip", "|ZIP|", "zip", "|ZIP|ZIP", "zip", "|ZIP|.ZIP", "zip", "|ZIP||ZIP", "zip", "|ZIP|ZIP|", "jar|zip", "JAR|ZIP", "jar|zip", "ZIP|JAR", "jar|zip", "|ZIP|JAR", "jar|zip", "ZIP|JAR|", "jar|zip", "|ZIP|JAR|", "jar|zip", "||ZIP|JAR|", "jar|zip", "|ZIP||JAR|", "jar|zip", "|ZIP|JAR||", "jar|zip", ".JAR|.ZIP", "jar|zip", ".ZIP|.JAR", "jar|zip", "|.ZIP|.JAR", "jar|zip", ".ZIP|.JAR|", "jar|zip", "|.ZIP|.JAR|", "jar|zip", "||.ZIP|.JAR|", "jar|zip", "|.ZIP||.JAR|", "jar|zip", "|.ZIP|.JAR||"});
    }

    private void assertSuffixes(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String result = args[i++];
            String suffixes = args[i];
            TArchiveDetector detector = new TArchiveDetector(suffixes, this.driver);
            Assert.assertEquals((Object)result, (Object)detector.toString());
            detector = new TArchiveDetector((FsDriverProvider)this.NIL, suffixes, this.driver);
            Assert.assertEquals((Object)result, (Object)detector.toString());
            detector = new TArchiveDetector((FsDriverProvider)this.NIL, (Object[][])new Object[][]{{suffixes, this.driver}});
            Assert.assertEquals((Object)result, (Object)detector.toString());
        }
    }

    @Test
    public void testNullMapping() {
        for (TArchiveDetector delegate : new TArchiveDetector[]{this.NIL, this.ALL}) {
            TArchiveDetector detector = new TArchiveDetector((FsDriverProvider)delegate, "zip", null);
            Assert.assertFalse((boolean)new SuffixSet(detector.toString()).contains((Object)"zip"));
            detector = new TArchiveDetector((FsDriverProvider)delegate, ".ZIP", null);
            Assert.assertFalse((boolean)new SuffixSet(detector.toString()).contains((Object)"zip"));
        }
    }

    @Test
    public void testGetDriver() {
        this.assertScheme(new String[][]{{null, ""}, {null, "."}, {null, ".all"}, {null, ".default"}, {null, ".ear"}, {null, ".exe"}, {null, ".null"}, {null, ".z"}, {null, "test"}, {null, "test."}, {null, "test.all"}, {null, "test.default"}, {null, "test.null"}, {null, "test.z"}}, this.NIL, this.MOK, this.ALL);
        this.assertScheme(new String[][]{{null, ".jar"}, {null, ".zip"}, {null, "test.jar"}, {null, "test.zip"}}, this.NIL, this.MOK);
        this.assertScheme(new String[][]{{"jar", ".jar"}, {"jar", "test.jar"}, {"zip", ".zip"}, {"zip", "test.zip"}}, this.ALL);
    }

    private void assertScheme(String[][] tests, TArchiveDetector ... detectors) {
        for (TArchiveDetector detector : detectors) {
            try {
                detector.getScheme(null);
                Assert.fail((String)"Expected NullPointerException!");
            }
            catch (NullPointerException expected) {
                // empty catch block
            }
            for (String[] test : tests) {
                FsScheme scheme = test[0] == null ? null : FsScheme.create((String)test[0]);
                String path = test[1];
                this.assertScheme(detector, scheme, path);
                detector = new TArchiveDetector((FsDriverProvider)detector, new Object[0][0]);
                this.assertScheme(detector, scheme, path);
            }
        }
    }

    private void assertScheme(TArchiveDetector detector, @Nullable FsScheme scheme, String path) {
        String lpath = path.toLowerCase(Locale.ENGLISH);
        String upath = path.toUpperCase(Locale.ENGLISH);
        Assert.assertThat((Object)detector.getScheme(lpath), (Matcher)CoreMatchers.equalTo((Object)scheme));
        Assert.assertThat((Object)detector.getScheme(upath), (Matcher)CoreMatchers.equalTo((Object)scheme));
    }
}

