/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.file;

import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TConfig;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.fs.FsDriver;
import de.schlichtherle.truezip.fs.archive.mock.MockArchiveDriver;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class TConfigTest {
    @Test
    public void testDefaults() {
        TConfig config = TConfig.get();
        Assert.assertThat((Object)TConfig.get(), (Matcher)CoreMatchers.sameInstance((Object)config));
        TArchiveDetector detector = config.getArchiveDetector();
        Assert.assertThat((Object)detector, (Matcher)CoreMatchers.sameInstance((Object)TArchiveDetector.ALL));
        Assert.assertThat((Object)config.getArchiveDetector(), (Matcher)CoreMatchers.sameInstance((Object)detector));
        boolean lenient = config.isLenient();
        Assert.assertThat((Object)lenient, (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)config.isLenient(), (Matcher)CoreMatchers.sameInstance((Object)lenient));
    }

    @Test
    public void testPop() {
        try {
            TConfig.pop();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInheritance() throws InterruptedException {
        this.assertInheritance();
        TConfig config1 = TConfig.push();
        try {
            this.assertInheritance();
            TConfig config2 = TConfig.push();
            try {
                this.assertInheritance();
            }
            finally {
                config2.close();
            }
            this.assertInheritance();
        }
        finally {
            config1.close();
        }
    }

    private void assertInheritance() throws InterruptedException {
        class TestThread
        extends Thread {
            TConfig config;

            TestThread() {
            }

            @Override
            public void run() {
                this.config = TConfig.get();
                try {
                    TConfig.pop();
                    TConfig.pop();
                    Assert.fail();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
        TestThread t = new TestThread();
        t.start();
        t.join();
        Assert.assertThat((Object)t.config, (Matcher)CoreMatchers.sameInstance((Object)TConfig.get()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void runStandardUseCase() {
        TFile file1 = new TFile("file.mok");
        assert (!file1.isArchive());
        TConfig config = TConfig.push();
        try {
            config.setArchiveDetector(new TArchiveDetector("mok", (FsDriver)new MockArchiveDriver()));
            TFile file2 = new TFile("file.mok");
            assert (file2.isArchive());
        }
        finally {
            config.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAdvancedUsage() {
        TConfig config1 = TConfig.get();
        Assert.assertThat((Object)TConfig.get(), (Matcher)CoreMatchers.sameInstance((Object)config1));
        TArchiveDetector detector1 = config1.getArchiveDetector();
        Assert.assertThat((Object)config1.getArchiveDetector(), (Matcher)CoreMatchers.sameInstance((Object)detector1));
        TArchiveDetector detector2 = new TArchiveDetector("mok", (FsDriver)new MockArchiveDriver());
        TConfig config2 = TConfig.push();
        try {
            config2.setArchiveDetector(detector2);
            Assert.assertThat((Object)TConfig.get(), (Matcher)CoreMatchers.sameInstance((Object)config2));
            Assert.assertThat((Object)config2.getArchiveDetector(), (Matcher)CoreMatchers.sameInstance((Object)detector2));
            TArchiveDetector detector3 = new TArchiveDetector("mok", (FsDriver)new MockArchiveDriver());
            TConfig config3 = TConfig.push();
            try {
                config3.setArchiveDetector(detector3);
                Assert.assertThat((Object)TConfig.get(), (Matcher)CoreMatchers.sameInstance((Object)config3));
                Assert.assertThat((Object)config3.getArchiveDetector(), (Matcher)CoreMatchers.sameInstance((Object)detector3));
            }
            finally {
                config3.close();
            }
            Assert.assertThat((Object)TConfig.get(), (Matcher)CoreMatchers.sameInstance((Object)config2));
            Assert.assertThat((Object)config2.getArchiveDetector(), (Matcher)CoreMatchers.sameInstance((Object)detector2));
        }
        finally {
            config2.close();
        }
        Assert.assertThat((Object)TConfig.get(), (Matcher)CoreMatchers.sameInstance((Object)config1));
        Assert.assertThat((Object)config1.getArchiveDetector(), (Matcher)CoreMatchers.sameInstance((Object)detector1));
    }
}

