/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.file;

import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TestBase;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsPath;
import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TFileTest
extends TestBase {
    private static final Logger logger = Logger.getLogger(TFileTest.class.getName());
    private TFile archive;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.archive = new TFile("archive.mok");
    }

    @Override
    @After
    public void tearDown() {
        Assert.assertFalse((boolean)new File("archive.zip").exists());
    }

    @Test
    public void testValidPathConstructor() {
        for (String[] params : new String[][]{{"mok2:mok1:file:/foo.mok1!/bar.mok2!/META-INF/MANIFEST.MF", "/foo.mok1/bar.mok2/META-INF/MANIFEST.MF", "/foo.mok1/bar.mok2", "/foo.mok1/bar.mok2", "META-INF/MANIFEST.MF"}, {"mok2:mok1:file:/foo.mok1!/bar.mok2!/", "/foo.mok1/bar.mok2", "/foo.mok1/bar.mok2", "/foo.mok1", "bar.mok2"}, {"mok1:file:/foo.mok1!/META-INF/MANIFEST.MF", "/foo.mok1/META-INF/MANIFEST.MF", "/foo.mok1", "/foo.mok1", "META-INF/MANIFEST.MF"}, {"mok1:file:/foo.mok1!/", "/foo.mok1", "/foo.mok1", null, null}, {"mok2:file:/foo.mok2!/META-INF/MANIFEST.MF", "/foo.mok2/META-INF/MANIFEST.MF", "/foo.mok2", "/foo.mok2", "META-INF/MANIFEST.MF"}, {"mok2:file:/foo.mok2!/", "/foo.mok2", "/foo.mok2", null, null}, {"file:/foo", "/foo", null, null, null}, {"file:/", "/", null, null, null}}) {
            TFile file = new TFile(FsPath.create((URI)URI.create(params[0])));
            Assert.assertThat((Object)file.getPath(), (Matcher)CoreMatchers.equalTo((Object)params[1].replace('/', File.separatorChar)));
            if (null != params[2]) {
                Assert.assertThat((Object)file.getInnerArchive().getPath(), (Matcher)CoreMatchers.equalTo((Object)params[2].replace('/', File.separatorChar)));
            } else {
                Assert.assertThat((Object)file.getInnerArchive(), (Matcher)CoreMatchers.nullValue());
            }
            if (null != params[3]) {
                Assert.assertThat((Object)file.getEnclArchive().getPath(), (Matcher)CoreMatchers.equalTo((Object)params[3].replace('/', File.separatorChar)));
                Assert.assertThat((Object)file.getEnclEntryName(), (Matcher)CoreMatchers.equalTo((Object)params[4]));
            } else {
                Assert.assertThat((Object)file.getEnclArchive(), (Matcher)CoreMatchers.nullValue());
                Assert.assertThat((Object)file.getEnclEntryName(), (Matcher)CoreMatchers.nullValue());
            }
            Assert.assertThat((Object)new TFile(file.toFsPath()), (Matcher)CoreMatchers.equalTo((Object)file.getNormalizedAbsoluteFile()));
            Assert.assertThat((Object)new TFile(file.toURI()), (Matcher)CoreMatchers.equalTo((Object)file.getAbsoluteFile()));
        }
    }

    @Test
    public void testUriConstructor() throws Exception {
        String fs = File.separator;
        TFile file = new TFile(new URI("file", "/with a space", null));
        Assert.assertEquals((Object)"with a space", (Object)file.getName());
        Assert.assertNull((Object)file.getInnerArchive());
        Assert.assertNull((Object)file.getInnerEntryName());
        Assert.assertNull((Object)file.getEnclArchive());
        Assert.assertNull((Object)file.getEnclEntryName());
        file = new TFile(new URI("file", "/a .mok/b .mok/", null));
        Assert.assertNull((Object)file.getInnerArchive());
        Assert.assertNull((Object)file.getInnerEntryName());
        Assert.assertNull((Object)file.getEnclArchive());
        Assert.assertNull((Object)file.getEnclEntryName());
        file = new TFile(new URI("file", "/a .mok/b .mok", null));
        Assert.assertNull((Object)file.getInnerArchive());
        Assert.assertNull((Object)file.getInnerEntryName());
        Assert.assertNull((Object)file.getEnclArchive());
        Assert.assertNull((Object)file.getEnclEntryName());
        file = new TFile(new URI("mok", "file:/a .mok/b .mok!/", null));
        Assert.assertSame((Object)file, (Object)file.getInnerArchive());
        Assert.assertSame((Object)FsEntryName.ROOT, (Object)file.getInnerFsEntryName());
        Assert.assertNull((Object)file.getEnclArchive());
        Assert.assertNull((Object)file.getEnclEntryName());
        file = new TFile(new URI("mok", "file:/a .mok!/b .mok", null));
        Assert.assertSame((Object)file.getInnerArchive(), (Object)file.getEnclArchive());
        Assert.assertSame((Object)file.getInnerEntryName(), (Object)file.getEnclEntryName());
        Assert.assertEquals((Object)(fs + "a .mok"), (Object)file.getEnclArchive().getPath());
        Assert.assertEquals((Object)"b .mok", (Object)file.getEnclEntryName());
        try {
            file = new TFile(new URI("mok", "mok:file:/a .mok/b .mok!/", null));
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            file = new TFile(new URI("mok", "mok:file:/a .mok/b .mok!", null));
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            file = new TFile(new URI("mok", "mok:file:/a .mok!/b .mok/", null));
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            file = new TFile(new URI("mok", "mok:file:/a .mok!/b .mok", null));
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            file = new TFile(new URI("mok", "mok:mok:file:/a .mok/b .mok!/", null));
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            file = new TFile(new URI("mok", "mok:mok:file:/a .mok/b .mok!", null));
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            file = new TFile(new URI("mok", "mok:mok:file:/a .mok!/b .mok/", null));
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            file = new TFile(new URI("mok", "mok:mok:file:/a .mok!/b .mok", null));
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        file = new TFile(new URI("mok", "mok:file:/a .mok!/b .mok!/", null));
        Assert.assertSame((Object)file, (Object)file.getInnerArchive());
        Assert.assertSame((Object)FsEntryName.ROOT, (Object)file.getInnerFsEntryName());
        Assert.assertEquals((Object)(fs + "a .mok"), (Object)file.getEnclArchive().getPath());
        Assert.assertEquals((Object)"b .mok", (Object)file.getEnclEntryName());
        file = new TFile(new URI("mok", "file:/a .mok!/b .mok!/", null));
        Assert.assertSame((Object)file, (Object)file.getInnerArchive());
        Assert.assertSame((Object)FsEntryName.ROOT, (Object)file.getInnerFsEntryName());
        Assert.assertNull((Object)file.getEnclArchive());
        Assert.assertNull((Object)file.getEnclEntryName());
        try {
            file = new TFile(new URI("mok", "mok:mok:file:/a .mok!/b .mok!/../c .mok!/", null));
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            file = new TFile(new URI("mok", "mok:mok:file:/a .mok!/b .mok!/../c .mok!", null));
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            file = new TFile(new URI("mok", "file:/a .mok!/../b .mok/", null));
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            file = new TFile(new URI("mok", "file:/a .mok!/../b .mok", null));
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testParentConstructor() throws Exception {
        TFile file;
        int i;
        try {
            new TFile("x", (String)null);
            Assert.fail((String)"Expected NullPointerException!");
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            new TFile((File)new TFile("x"), (String)null);
            Assert.fail((String)"Expected NullPointerException!");
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        String fs = File.separator;
        TFile[] files = new TFile[]{new TFile((File)this.archive, ""), new TFile((File)this.archive, "."), new TFile((File)this.archive, "." + fs), new TFile((File)this.archive, "." + fs + "."), new TFile((File)this.archive, "." + fs + "." + fs), new TFile((File)this.archive, "." + fs + "." + fs + ".")};
        for (int i2 = 0; i2 < files.length; ++i2) {
            TFile file2 = files[i2];
            Assert.assertSame((Object)file2, (Object)file2.getInnerArchive());
            Assert.assertEquals((Object)"", (Object)file2.getInnerEntryName());
            Assert.assertNull((Object)file2.getEnclArchive());
            Assert.assertNull((Object)file2.getEnclEntryName());
        }
        String innerName = "inner.mok";
        TFile inner = new TFile((File)this.archive, "inner.mok");
        TFile[] files2 = new TFile[]{new TFile((File)inner, ""), new TFile((File)inner, "."), new TFile((File)inner, "." + fs), new TFile((File)inner, "." + fs + "."), new TFile((File)inner, "." + fs + "." + fs), new TFile((File)inner, "." + fs + "." + fs + ".")};
        for (i = 0; i < files2.length; ++i) {
            file = files2[i];
            Assert.assertSame((Object)file, (Object)file.getInnerArchive());
            Assert.assertEquals((Object)"", (Object)file.getInnerEntryName());
            Assert.assertSame((Object)this.archive, (Object)file.getEnclArchive());
            Assert.assertEquals((Object)"inner.mok", (Object)file.getEnclEntryName());
        }
        String entryName = "entry";
        TFile entry = new TFile((File)this.archive, "entry");
        files2 = new TFile[]{new TFile((File)entry, ""), new TFile((File)entry, "."), new TFile((File)entry, "." + fs), new TFile((File)entry, "." + fs + "."), new TFile((File)entry, "." + fs + "." + fs), new TFile((File)entry, "." + fs + "." + fs + ".")};
        for (i = 0; i < files2.length; ++i) {
            file = files2[i];
            Assert.assertSame((Object)this.archive, (Object)file.getInnerArchive());
            Assert.assertEquals((Object)"entry", (Object)file.getInnerEntryName());
            Assert.assertSame((Object)this.archive, (Object)file.getEnclArchive());
            Assert.assertEquals((Object)"entry", (Object)file.getEnclEntryName());
        }
        TFile a = new TFile("outer.mok/removed.mok");
        TFile b = new TFile("../removed.dir/removed.dir/../../dir/./inner.mok");
        TFile c = new TFile((File)a, b.getPath());
        Assert.assertTrue((boolean)c.isArchive());
        Assert.assertTrue((boolean)c.isEntry());
        Assert.assertEquals((Object)"outer.mok", (Object)c.getEnclArchive().getPath());
        Assert.assertEquals((Object)"dir/inner.mok", (Object)c.getEnclEntryName());
        b = new TFile("../removed.dir/removed.dir/../../dir/./inner.mok");
        c = new TFile((File)a, b.getPath(), TArchiveDetector.NULL);
        Assert.assertFalse((boolean)c.isArchive());
        Assert.assertTrue((boolean)c.isEntry());
        Assert.assertEquals((Object)"outer.mok", (Object)c.getInnerArchive().getPath());
        Assert.assertEquals((Object)"dir/inner.mok", (Object)c.getInnerEntryName());
        b = new TFile("../removed.dir/removed.dir/../../dir/./inner.mok/removed.dir/removed.dir/../../dir/./test.txt");
        c = new TFile((File)a, b.getPath());
        Assert.assertFalse((boolean)c.isArchive());
        Assert.assertTrue((boolean)c.isEntry());
        Assert.assertEquals((Object)("outer.mok" + fs + "removed.mok" + fs + ".." + fs + "removed.dir" + fs + "removed.dir" + fs + ".." + fs + ".." + fs + "dir" + fs + "." + fs + "inner.mok"), (Object)c.getInnerArchive().getPath());
        Assert.assertEquals((Object)"dir/inner.mok", (Object)c.getInnerArchive().getEnclEntryName());
    }

    @Test
    public void testGetParentFile() {
        TFile abcdefgh = new TFile("a/b.mok/c/d/e.mok/f.mok/g/h.mok");
        TFile abcdefg = abcdefgh.getParentFile();
        TFile abcdef = abcdefg.getParentFile();
        TFile abcde = abcdef.getParentFile();
        TFile abcd = abcde.getParentFile();
        TFile abc = abcd.getParentFile();
        TFile ab = abc.getParentFile();
        TFile a = ab.getParentFile();
        TFile n = a.getParentFile();
        Assert.assertEquals((Object)abcdefgh.getInnerArchive(), (Object)abcdefgh);
        Assert.assertEquals((Object)abcdefgh.getEnclArchive(), (Object)abcdef);
        Assert.assertEquals((Object)abcdefg.getInnerArchive(), (Object)abcdef);
        Assert.assertEquals((Object)abcdefg.getEnclArchive(), (Object)abcdef);
        Assert.assertEquals((Object)abcdef.getInnerArchive(), (Object)abcdef);
        Assert.assertEquals((Object)abcdef.getEnclArchive(), (Object)abcde);
        Assert.assertEquals((Object)abcde.getInnerArchive(), (Object)abcde);
        Assert.assertEquals((Object)abcde.getEnclArchive(), (Object)ab);
        Assert.assertEquals((Object)abcd.getInnerArchive(), (Object)ab);
        Assert.assertEquals((Object)abcd.getEnclArchive(), (Object)ab);
        Assert.assertEquals((Object)abc.getInnerArchive(), (Object)ab);
        Assert.assertEquals((Object)abc.getEnclArchive(), (Object)ab);
        Assert.assertEquals((Object)ab.getInnerArchive(), (Object)ab);
        Assert.assertEquals((Object)ab.getEnclArchive(), null);
        Assert.assertEquals((Object)a.getInnerArchive(), null);
        Assert.assertEquals((Object)a.getEnclArchive(), null);
        Assert.assertNull((Object)n);
    }

    @Test
    public void testNormalizedAbsoluteFile() throws IOException {
        this.testNormalizedAbsoluteFile("", "");
        this.testNormalizedAbsoluteFile(".", ".");
        this.testNormalizedAbsoluteFile("..", "..");
        this.testNormalizedAbsoluteFile("a", "a");
        this.testNormalizedAbsoluteFile("a", "a/.");
        this.testNormalizedAbsoluteFile("a b", "a b");
        this.testNormalizedAbsoluteFile(".", "a/..");
        this.testNormalizedAbsoluteFile("b", "a/../b");
        this.testNormalizedAbsoluteFile("b", "a/../b/.");
        this.testNormalizedAbsoluteFile(".", "a/../b/..");
        this.testNormalizedAbsoluteFile("c", "a/../b/../c");
        this.testNormalizedAbsoluteFile("c", "a/../b/../c/.");
        this.testNormalizedAbsoluteFile(".", "a/../b/../c/..");
        this.testNormalizedAbsoluteFile("../a", "../a");
        this.testNormalizedAbsoluteFile("../a", "../a/.");
        this.testNormalizedAbsoluteFile("..", "../a/..");
        this.testNormalizedAbsoluteFile("../b", "../a/../b");
        this.testNormalizedAbsoluteFile("../b", "../a/../b/.");
        this.testNormalizedAbsoluteFile("..", "../a/../b/..");
        this.testNormalizedAbsoluteFile("../c", "../a/../b/../c");
        this.testNormalizedAbsoluteFile("../c", "../a/../b/../c/.");
        this.testNormalizedAbsoluteFile("..", "../a/../b/../c/..");
        this.testNormalizedAbsoluteFile("../a", "../a");
        this.testNormalizedAbsoluteFile("../a", "../a/.");
        this.testNormalizedAbsoluteFile("../a/b", "../a/b");
        this.testNormalizedAbsoluteFile("../a/b", "../a/b/.");
        this.testNormalizedAbsoluteFile("../a", "../a/b/..");
        this.testNormalizedAbsoluteFile("../a/c", "../a/b/../c");
        this.testNormalizedAbsoluteFile("../a/c", "../a/b/../c/.");
        this.testNormalizedAbsoluteFile("../a", "../a/b/../c/..");
    }

    void testNormalizedAbsoluteFile(String result, String path) throws IOException {
        File resultFile = new File(result).getCanonicalFile();
        File pathFile = new File(new TFile(path).getNormalizedAbsoluteFile().getPath());
        Assert.assertEquals((Object)resultFile, (Object)pathFile);
    }

    @Test
    public void testGetTopLevelArchive() {
        TFile file = new TFile("abc/def.mok/efg.mok/hij.mok/test.txt");
        Assert.assertEquals((Object)new File("abc/def.mok"), (Object)file.getTopLevelArchive());
    }

    @Test
    public void testUriandFsPath() {
        for (String[] params : new String[][]{{"/file", "file:/file"}, {"/archive.mok", "mok:file:/archive.mok!/"}, {"/archive.mok/entry", "mok:file:/archive.mok!/entry"}, {"/foo.mok1/bar.mok2", "mok2:mok1:file:/foo.mok1!/bar.mok2!/"}, {"/dist.mok1/app.mok2/META-INF/MANIFEST.MF", "mok1:mok2:file:/dist.mok1!/app.mok2!/META-INF/MANIFEST.MF"}}) {
            String name = params[0];
            URI uri = URI.create(params[1]);
            FsPath path = FsPath.create((URI)URI.create(params[1]));
            TFile file = new TFile(name);
            Assert.assertThat((Object)new TFile(name), (Matcher)CoreMatchers.equalTo((Object)file));
            Assert.assertThat((Object)new TFile(uri), (Matcher)CoreMatchers.equalTo((Object)file));
            Assert.assertThat((Object)new TFile(path), (Matcher)CoreMatchers.equalTo((Object)file));
            Assert.assertThat((Object)new TFile(name).toURI(), (Matcher)CoreMatchers.equalTo((Object)file.toURI()));
            Assert.assertThat((Object)new TFile(uri).toURI(), (Matcher)CoreMatchers.equalTo((Object)file.toURI()));
            Assert.assertThat((Object)new TFile(path).toURI(), (Matcher)CoreMatchers.equalTo((Object)file.toURI()));
            Assert.assertThat((Object)new TFile(name).toFsPath(), (Matcher)CoreMatchers.equalTo((Object)file.toFsPath()));
            Assert.assertThat((Object)new TFile(uri).toFsPath(), (Matcher)CoreMatchers.equalTo((Object)file.toFsPath()));
            Assert.assertThat((Object)new TFile(path).toFsPath(), (Matcher)CoreMatchers.equalTo((Object)file.toFsPath()));
            Assert.assertThat((Object)new TFile(new TFile(name).toURI()), (Matcher)CoreMatchers.equalTo((Object)file.getAbsoluteFile()));
            Assert.assertThat((Object)new TFile(new TFile(uri).toURI()), (Matcher)CoreMatchers.equalTo((Object)file.getAbsoluteFile()));
            Assert.assertThat((Object)new TFile(new TFile(path).toURI()), (Matcher)CoreMatchers.equalTo((Object)file.getAbsoluteFile()));
            Assert.assertThat((Object)new TFile(new TFile(name).toFsPath()), (Matcher)CoreMatchers.equalTo((Object)file.getAbsoluteFile()));
            Assert.assertThat((Object)new TFile(new TFile(uri).toFsPath()), (Matcher)CoreMatchers.equalTo((Object)file.getAbsoluteFile()));
            Assert.assertThat((Object)new TFile(new TFile(path).toFsPath()), (Matcher)CoreMatchers.equalTo((Object)file.getAbsoluteFile()));
        }
    }

    @Test
    public void testSerialization() throws IOException, ClassNotFoundException {
        ExceptionListener listener = new ExceptionListener(){

            @Override
            public void exceptionThrown(Exception ex) {
                throw new UndeclaredThrowableException(ex);
            }
        };
        for (String[] params : new String[][]{{"file:/file"}, {"mok:file:/archive.mok!/"}, {"mok:file:/archive.mok!/entry"}, {"mok2:mok1:file:/foo.mok1!/bar.mok2!/"}, {"mok2:mok1:file:/foo.mok1!/bar.mok2!/META-INF/MANIFEST.MF"}, {"mok2:mok1:file:/f\u00f6\u00f6%20b\u00e4r.mok1!/f\u00f6\u00f6%20b\u00e4r.mok2!/f\u00f6\u00f6%20b\u00e4r"}, {"mok:file:/f\u00f6\u00f6%20b\u00e4r.mok!/f\u00f6\u00f6%20b\u00e4r"}, {"file:/f\u00f6\u00f6%20b\u00e4r/f\u00f6\u00f6%20b\u00e4r"}, {"mok:file:/foo.mok!/bar"}, {"file:/foo/bar"}, {"file:/foo/bar"}}) {
            TFile original = new TFile(URI.create(params[0]));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(original);
            oos.close();
            logger.log(Level.FINE, "Number of serialized bytes: {0}", bos.size());
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bis);
            TFile clone = (TFile)ois.readObject();
            ois.close();
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)original)));
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.equalTo((Object)original.getAbsoluteFile()));
            bos = new ByteArrayOutputStream();
            XMLEncoder enc = new XMLEncoder(bos);
            enc.setExceptionListener(listener);
            enc.writeObject(original);
            enc.close();
            logger.log(Level.FINE, bos.toString("UTF-8"));
            bis = new ByteArrayInputStream(bos.toByteArray());
            XMLDecoder dec = new XMLDecoder(bis);
            clone = (TFile)dec.readObject();
            dec.close();
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)original)));
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.equalTo((Object)original.getAbsoluteFile()));
        }
    }
}

