/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.file;

import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TConfig;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TFileOutputStream;
import de.schlichtherle.truezip.file.TestBase;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsScheme;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncWarningException;
import de.schlichtherle.truezip.fs.archive.FsArchiveDriver;
import de.schlichtherle.truezip.io.FileBusyException;
import de.schlichtherle.truezip.socket.IOPoolProvider;
import de.schlichtherle.truezip.socket.OutputClosedException;
import de.schlichtherle.truezip.socket.spi.ByteArrayIOPoolService;
import de.schlichtherle.truezip.util.ArrayHelper;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@DefaultAnnotation(value={NonNull.class})
public abstract class TFileTestSuite
extends TestBase {
    private static final Logger logger = Logger.getLogger(TFileTestSuite.class.getName());
    private static final String TEMP_FILE_PREFIX = "tzp";
    private static final Random rnd = new Random();
    private static final byte[] DATA = new byte[1024];
    protected static final IOPoolProvider IO_POOL_PROVIDER;
    private final FsScheme scheme;
    private File temp;
    private TFile archive;
    private byte[] data;
    private static final String[] MEMBERS;

    protected TFileTestSuite(FsScheme scheme, FsArchiveDriver<?> driver) {
        super(new TArchiveDetector(scheme.toString(), driver));
        if (null == driver) {
            throw new NullPointerException();
        }
        this.scheme = scheme;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.temp = this.createTempFile();
        TFile.rm((File)this.temp);
        this.archive = new TFile(this.temp);
        this.data = (byte[])DATA.clone();
    }

    private File createTempFile() throws IOException {
        return File.createTempFile(TEMP_FILE_PREFIX, this.getSuffix()).getCanonicalFile();
    }

    protected final TFile getArchive() {
        return this.archive;
    }

    protected final String getSuffix() {
        return "." + this.scheme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @After
    public void tearDown() throws Exception {
        try {
            this.archive = null;
            try {
                TFile.umount();
            }
            catch (FsSyncException ex) {
                logger.log(Level.WARNING, ex.toString(), ex);
            }
            if (this.temp.exists() && !this.temp.delete()) {
                logger.log(Level.WARNING, "{0} (could not delete)", this.temp);
            }
        }
        finally {
            super.tearDown();
        }
    }

    protected static TFile newNonArchiveFile(TFile file) {
        return new TFile((File)file.getParentFile(), file.getName(), TArchiveDetector.NULL);
    }

    @Test
    public void testArchiveControllerStateWithInputStream() throws IOException, InterruptedException {
        String path = this.archive.getPath() + "/test";
        this.archive = null;
        Assert.assertTrue((boolean)new TFile(path).createNewFile());
        TFile.umount();
        TFileInputStream in = new TFileInputStream(path);
        WeakReference<FsController> ref = new WeakReference<FsController>(new TFile(path).getInnerArchive().getController());
        TFileTestSuite.gc();
        Assert.assertNotNull(ref.get());
        in.close();
        TFileTestSuite.gc();
        Assert.assertNotNull(ref.get());
        Assert.assertSame(ref.get(), (Object)new TFile(path).getInnerArchive().getController());
        in = null;
        TFile.umount();
        TFileTestSuite.gc();
        Assert.assertNull(ref.get());
    }

    @Test
    public void testArchiveControllerStateWithOutputStream() throws IOException, InterruptedException {
        String path = this.archive.getPath() + "/test";
        this.archive = null;
        Assert.assertTrue((boolean)new TFile(path).createNewFile());
        TFile.umount();
        TFileOutputStream out = new TFileOutputStream(path);
        WeakReference<FsController> ref = new WeakReference<FsController>(new TFile(path).getInnerArchive().getController());
        TFileTestSuite.gc();
        Assert.assertNotNull(ref.get());
        out.close();
        out = null;
        TFileTestSuite.gc();
        Assert.assertNotNull(ref.get());
        Assert.assertSame(ref.get(), (Object)new TFile(path).getInnerArchive().getController());
        TFile.umount();
        TFileTestSuite.gc();
        Assert.assertNull(ref.get());
    }

    private static void gc() {
        System.gc();
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(TFileTestSuite.class.getName()).log(Level.WARNING, "Current thread was interrupted while waiting!", ex);
        }
    }

    @Test
    public final void testFalsePositives() throws IOException {
        this.assertFalsePositive(this.archive);
        TFile entry = new TFile((File)this.archive, "entry" + this.getSuffix());
        Assert.assertTrue((boolean)this.archive.mkdir());
        this.assertFalsePositive(entry);
        this.archive.rm();
        Assert.assertTrue((boolean)TFileTestSuite.newNonArchiveFile(this.archive).mkdir());
        this.assertFalsePositive(entry);
        this.archive.rm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertFalsePositive(TFile file) throws IOException {
        block24: {
            block23: {
                assert (file.isArchive());
                TFileOutputStream out = new TFileOutputStream((File)file);
                try {
                    out.write(this.data);
                }
                finally {
                    out.close();
                }
                out = new TFileOutputStream((File)file);
                try {
                    out.write(this.data);
                }
                finally {
                    out.close();
                }
                Assert.assertTrue((boolean)file.exists());
                Assert.assertFalse((boolean)file.isDirectory());
                Assert.assertTrue((boolean)file.isFile());
                Assert.assertEquals((long)this.data.length, (long)file.length());
                Assert.assertTrue((file.lastModified() > 0L ? 1 : 0) != 0);
                TFileInputStream in = new TFileInputStream((File)file);
                try {
                    byte[] buf = new byte[this.data.length];
                    Assert.assertTrue((boolean)ArrayHelper.equals((byte[])this.data, (int)0, (byte[])buf, (int)0, (int)in.read(buf)));
                }
                finally {
                    in.close();
                }
                this.assertRm(file);
                Assert.assertTrue((boolean)TFileTestSuite.newNonArchiveFile(file).mkdir());
                Assert.assertTrue((boolean)file.exists());
                Assert.assertTrue((boolean)file.isDirectory());
                Assert.assertFalse((boolean)file.isFile());
                Assert.assertTrue((file.lastModified() > 0L ? 1 : 0) != 0);
                try {
                    new TFileInputStream((File)this.archive).close();
                    if ('\\' == File.separatorChar) {
                        Assert.fail();
                    }
                }
                catch (FileNotFoundException ex) {
                    if ('\\' == File.separatorChar || this.archive.isArchive() || this.archive.isEntry()) break block23;
                    throw ex;
                }
            }
            try {
                new TFileOutputStream((File)this.archive).close();
                Assert.fail();
            }
            catch (FileNotFoundException expected) {
                // empty catch block
            }
            this.assertRm(file);
            Assert.assertTrue((boolean)file.mkdir());
            Assert.assertTrue((boolean)TFileTestSuite.newNonArchiveFile(file).isFile());
            Assert.assertTrue((boolean)file.exists());
            Assert.assertTrue((boolean)file.isDirectory());
            Assert.assertFalse((boolean)file.isFile());
            Assert.assertTrue((file.lastModified() > 0L ? 1 : 0) != 0);
            try {
                new TFileInputStream((File)this.archive).close();
                if ('\\' == File.separatorChar) {
                    Assert.fail();
                }
            }
            catch (FileNotFoundException ex) {
                if ('\\' == File.separatorChar || this.archive.isArchive()) break block24;
                throw ex;
            }
        }
        try {
            new TFileOutputStream((File)this.archive).close();
            Assert.fail();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.assertRm(file);
    }

    private void assertRm(TFile file) throws IOException {
        file.rm();
        Assert.assertFalse((boolean)file.exists());
        Assert.assertFalse((boolean)file.isDirectory());
        Assert.assertFalse((boolean)file.isFile());
        Assert.assertEquals((long)0L, (long)file.length());
        Assert.assertFalse((file.lastModified() > 0L ? 1 : 0) != 0);
    }

    @Test
    public final void testCreateNewFile() throws IOException {
        this.assertCreateNewPlainFile();
        this.assertCreateNewEnhancedFile();
    }

    @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private void assertCreateNewPlainFile() throws IOException {
        File archive = this.createTempFile();
        TFile.rm((File)archive);
        File file1 = new File(archive, "test.txt");
        File file2 = new File(file1, "test.txt");
        try {
            file1.createNewFile();
            Assert.fail((String)"Creating a file in a non-existent directory should throw an IOException!");
        }
        catch (IOException expected) {
            // empty catch block
        }
        this.assertCreateNewFile(archive, file1, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private void assertCreateNewEnhancedFile() throws IOException {
        TFile file1 = new TFile((File)this.archive, "test.txt");
        TFile file2 = new TFile((File)file1, "test.txt");
        TConfig config = TConfig.push();
        try {
            config.setLenient(false);
            try {
                file1.createNewFile();
                Assert.fail((String)"Creating a file in a non-existent directory should throw an IOException!");
            }
            catch (IOException expected) {
                // empty catch block
            }
            this.assertCreateNewFile((File)this.archive, (File)file1, (File)file2);
        }
        finally {
            config.close();
        }
        this.assertCreateNewFile((File)this.archive, (File)file1, (File)file2);
    }

    @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private void assertCreateNewFile(File dir, File file1, File file2) throws IOException {
        TFile tdir;
        Assert.assertFalse((boolean)dir.exists());
        Assert.assertTrue((boolean)dir.mkdir());
        Assert.assertTrue((boolean)dir.exists());
        Assert.assertTrue((boolean)dir.isDirectory());
        Assert.assertFalse((boolean)dir.isFile());
        if (dir instanceof TFile && ((tdir = (TFile)dir).isArchive() || tdir.isEntry())) {
            Assert.assertEquals((long)0L, (long)dir.length());
        }
        Assert.assertTrue((boolean)file1.createNewFile());
        Assert.assertTrue((boolean)file1.exists());
        Assert.assertFalse((boolean)file1.isDirectory());
        Assert.assertTrue((boolean)file1.isFile());
        Assert.assertEquals((long)0L, (long)file1.length());
        try {
            file2.createNewFile();
            Assert.fail((String)"Creating a file in another file should throw an IOException!");
        }
        catch (IOException expected) {
            // empty catch block
        }
        TFile.rm((File)file1);
        Assert.assertFalse((boolean)file1.exists());
        Assert.assertFalse((boolean)file1.isDirectory());
        Assert.assertFalse((boolean)file1.isFile());
        Assert.assertEquals((long)0L, (long)file1.length());
        TFile.rm((File)dir);
        Assert.assertFalse((boolean)dir.exists());
        Assert.assertFalse((boolean)dir.isDirectory());
        Assert.assertFalse((boolean)dir.isFile());
        Assert.assertEquals((long)0L, (long)dir.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void testIllegalDirectoryOperations() throws IOException {
        try {
            String[] names = new String[]{"inner" + this.getSuffix(), "dir"};
            TFile file = this.archive;
            for (int i = 0; i <= names.length; ++i) {
                TFile file2 = TFileTestSuite.newNonArchiveFile(file);
                Assert.assertTrue((boolean)file2.mkdir());
                this.assertIllegalDirectoryOperations(file2);
                file2.rm();
                Assert.assertTrue((boolean)file.mkdir());
                this.assertIllegalDirectoryOperations(file);
                if (i >= names.length) continue;
                file = new TFile((File)file, names[i]);
            }
        }
        finally {
            this.archive.rm_r();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertIllegalDirectoryOperations(TFile dir) throws IOException {
        block13: {
            assert (dir.isDirectory());
            try {
                new TFileInputStream((File)dir).close();
                if ('\\' == File.separatorChar) {
                    Assert.fail();
                }
            }
            catch (FileNotFoundException ex) {
                if ('\\' == File.separatorChar || dir.isArchive() || dir.isEntry()) break block13;
                throw ex;
            }
        }
        try {
            new TFileOutputStream((File)dir).close();
            Assert.fail();
        }
        catch (FileNotFoundException expected) {
            // empty catch block
        }
        File tmp = TFile.createTempFile((String)TEMP_FILE_PREFIX, null);
        try {
            try {
                TFile.cp((File)tmp, (File)dir);
                Assert.fail();
            }
            catch (IOException expected) {
                // empty catch block
            }
            try {
                TFile.cp((File)dir, (File)tmp);
                Assert.fail();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            TFile.rm((File)tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void testStrictFileOutputStream() throws IOException {
        TFile file = new TFile((File)this.archive, "test.txt");
        TConfig config = TConfig.push();
        try {
            config.setLenient(false);
            try {
                this.assertFileOutputStream(file);
                Assert.fail((String)"Creating ghost directories should not be allowed when File.isLenient() is false!");
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            Assert.assertTrue((boolean)this.archive.mkdir());
            this.assertFileOutputStream(file);
            this.archive.rm();
        }
        finally {
            config.close();
        }
    }

    @Test
    public final void testLenientFileOutputStream() throws IOException {
        TFile file = new TFile((File)this.archive, "dir/inner" + this.getSuffix() + "/dir/test.txt");
        this.assertFileOutputStream(file);
        try {
            this.archive.rm();
            Assert.fail((String)"directory not empty");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        TFile.umount();
        TFile.rm((File)TFileTestSuite.newNonArchiveFile(this.archive));
        Assert.assertFalse((boolean)this.archive.exists());
        Assert.assertFalse((boolean)this.archive.isDirectory());
        Assert.assertFalse((boolean)this.archive.isFile());
        Assert.assertEquals((long)0L, (long)this.archive.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertFileOutputStream(TFile file) throws IOException {
        byte[] message = "Hello World!\r\n".getBytes();
        TFileOutputStream out = new TFileOutputStream((File)file);
        try {
            Assert.assertTrue((boolean)file.exists());
            Assert.assertFalse((boolean)file.isDirectory());
            Assert.assertTrue((boolean)file.isFile());
            Assert.assertEquals((long)0L, (long)file.length());
            out.write(message);
            Assert.assertEquals((long)0L, (long)file.length());
            out.flush();
            Assert.assertEquals((long)0L, (long)file.length());
        }
        finally {
            out.close();
        }
        Assert.assertTrue((boolean)file.exists());
        Assert.assertFalse((boolean)file.isDirectory());
        Assert.assertTrue((boolean)file.isFile());
        Assert.assertEquals((long)message.length, (long)file.length());
        Assert.assertFalse((boolean)file.createNewFile());
        Assert.assertTrue((boolean)file.exists());
        Assert.assertFalse((boolean)file.isDirectory());
        Assert.assertTrue((boolean)file.isFile());
        Assert.assertEquals((long)message.length, (long)file.length());
        file.rm();
        Assert.assertFalse((boolean)file.exists());
        Assert.assertFalse((boolean)file.isDirectory());
        Assert.assertFalse((boolean)file.isFile());
        Assert.assertEquals((long)0L, (long)file.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @SuppressWarnings(value={"OS_OPEN_STREAM"})
    public final void testBusyFileInputStream() throws IOException {
        TFile file1 = new TFile((File)this.archive, "file1");
        TFile file2 = new TFile((File)this.archive, "file2");
        Assert.assertTrue((boolean)file1.createNewFile());
        TFile.umount();
        Assert.assertTrue((boolean)file2.createNewFile());
        TFileInputStream in1 = new TFileInputStream((File)file1);
        try {
            block16: {
                block15: {
                    try {
                        new TFileInputStream((File)file2).close();
                        Assert.fail((String)"Expected exception when reading an unsynchronized entry of a busy archive file!");
                    }
                    catch (FileNotFoundException ex) {
                        if (ex.getCause() instanceof FsSyncException && ex.getCause().getCause() instanceof FileBusyException) break block15;
                        throw ex;
                    }
                }
                file2.input((InputStream)in1);
                try {
                    TFile.umount();
                    Assert.fail((String)"Expected warning exception when synchronizing a busy archive file!");
                }
                catch (FsSyncWarningException ex) {
                    if (ex.getCause() instanceof FileBusyException) break block16;
                    throw ex;
                }
            }
            Assert.assertTrue((boolean)file2.isFile());
            try {
                file2.input((InputStream)in1);
                Assert.fail((String)"Expected exception when reading from entry input stream of an unmounted archive file!");
            }
            catch (IOException expected) {
                Assert.assertFalse((boolean)file2.exists());
            }
            new TFileInputStream((File)file1);
            TFileTestSuite.gc();
            try {
                TFile.umount();
            }
            catch (FsSyncWarningException ex) {
                Assert.fail((String)"The garbage collector hasn't been collecting an open stream. If this is only happening occasionally, you can safely ignore it.");
            }
            TFile.rm((File)TFileTestSuite.newNonArchiveFile(this.archive));
        }
        finally {
            in1.close();
        }
        try {
            file2.rm();
            Assert.fail((String)"already deleted externally");
        }
        catch (IOException expected) {
            // empty catch block
        }
        Assert.assertFalse((boolean)file2.exists());
        try {
            file1.rm();
            Assert.fail((String)"already deleted externally");
        }
        catch (IOException expected) {
            // empty catch block
        }
        Assert.assertFalse((boolean)file1.exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void testBusyFileOutputStream() throws IOException {
        TFileOutputStream out;
        TFile file2;
        TFile file1;
        block20: {
            block19: {
                file1 = new TFile((File)this.archive, "file1");
                file2 = new TFile((File)this.archive, "file2");
                out = new TFileOutputStream((File)file1);
                try {
                    TFile.cat((InputStream)new ByteArrayInputStream(this.data), (OutputStream)out);
                }
                finally {
                    out.close();
                }
                out = new TFileOutputStream((File)file2);
                try {
                    TFile.cat((InputStream)new ByteArrayInputStream(this.data), (OutputStream)out);
                }
                finally {
                    out.close();
                }
                TFile.umount();
                out = new TFileOutputStream((File)file1);
                TFile.cat((InputStream)new ByteArrayInputStream(this.data), (OutputStream)out);
                try {
                    new TFileOutputStream((File)file1).close();
                    Assert.fail((String)"Expected synchronization exception when overwriting an unsynchronized entry of a busy archive file!");
                }
                catch (FileNotFoundException ex) {
                    if (ex.getCause() instanceof FsSyncException && ex.getCause().getCause() instanceof FileBusyException) break block19;
                    throw ex;
                }
            }
            try {
                new TFileOutputStream((File)file2).close();
            }
            catch (FileNotFoundException ex) {
                if (!(ex.getCause() instanceof FsSyncException) || !(ex.getCause().getCause() instanceof FileBusyException)) {
                    throw ex;
                }
                logger.warning("This archive driver does NOT support concurrent writing of different entries in the same archive file.");
            }
            TFile.cat((InputStream)new ByteArrayInputStream(this.data), (OutputStream)out);
            try {
                TFile.umount();
                Assert.fail((String)"Expected warning exception when synchronizing a busy archive file!");
            }
            catch (FsSyncWarningException ex) {
                if (ex.getCause() instanceof FileBusyException) break block20;
                throw ex;
            }
        }
        try {
            TFile.cat((InputStream)new ByteArrayInputStream(this.data), (OutputStream)out);
            Assert.fail((String)"Expected exception when writing to entry output stream of an unmounted archive file!");
        }
        catch (OutputClosedException expected) {
            // empty catch block
        }
        out.close();
        out = new TFileOutputStream((File)file1);
        out = null;
        TFileTestSuite.gc();
        try {
            TFile.umount();
        }
        catch (FsSyncWarningException ex) {
            Assert.fail((String)"The garbage collector hasn't been collecting an open stream. If this is only happening occasionally, you can safely ignore it.");
        }
        file2.rm();
        Assert.assertFalse((boolean)file2.exists());
        file1.rm();
        Assert.assertFalse((boolean)file1.exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void testMkdir() throws IOException {
        TFile dir1 = this.archive;
        TFile dir2 = new TFile((File)dir1, "dir");
        TFile dir3 = new TFile((File)dir2, "inner" + this.getSuffix());
        TFile dir4 = new TFile((File)dir3, "dir");
        TFile dir5 = new TFile((File)dir4, "nuts" + this.getSuffix());
        TFile dir6 = new TFile((File)dir5, "dir");
        assert (TFile.isLenient());
        Assert.assertTrue((boolean)dir6.mkdir());
        Assert.assertFalse((boolean)dir6.mkdir());
        Assert.assertFalse((boolean)dir5.mkdir());
        Assert.assertFalse((boolean)dir4.mkdir());
        Assert.assertFalse((boolean)dir3.mkdir());
        Assert.assertFalse((boolean)dir2.mkdir());
        Assert.assertFalse((boolean)dir1.mkdir());
        dir6.rm();
        dir5.rm();
        dir4.rm();
        dir3.rm();
        dir2.rm();
        dir1.rm();
        TConfig config = TConfig.push();
        try {
            config.setLenient(false);
            Assert.assertFalse((boolean)dir6.mkdir());
            Assert.assertFalse((boolean)dir5.mkdir());
            Assert.assertFalse((boolean)dir4.mkdir());
            Assert.assertFalse((boolean)dir3.mkdir());
            Assert.assertFalse((boolean)dir2.mkdir());
            Assert.assertTrue((boolean)dir1.mkdir());
            Assert.assertTrue((boolean)dir2.mkdir());
            Assert.assertTrue((boolean)dir3.mkdir());
            Assert.assertTrue((boolean)dir4.mkdir());
            Assert.assertTrue((boolean)dir5.mkdir());
            Assert.assertTrue((boolean)dir6.mkdir());
        }
        finally {
            config.close();
        }
        dir6.rm();
        dir5.rm();
        dir4.rm();
        dir3.rm();
        dir2.rm();
        dir1.rm();
    }

    @Test
    public final void testDirectoryTree() throws IOException {
        this.assertDirectoryTree(new TFile(System.getProperty("java.io.tmpdir")), new TFile("dir/inner" + this.getSuffix() + "/dir/outer" + this.getSuffix() + "/" + this.archive.getName()));
    }

    private void assertDirectoryTree(TFile basePath, TFile reversePath) throws IOException {
        if (reversePath == null) {
            TFile test = new TFile((File)basePath, "test.txt");
            this.assertFileOutputStream(test);
            return;
        }
        TFile member = new TFile((File)basePath, reversePath.getName());
        boolean created = member.mkdir();
        TFile children = reversePath.getParentFile();
        this.assertDirectoryTree(member, children);
        this.assertListFiles(basePath, member.getName());
        Assert.assertTrue((boolean)member.exists());
        Assert.assertTrue((boolean)member.isDirectory());
        Assert.assertFalse((boolean)member.isFile());
        if (member.isArchive()) {
            Assert.assertEquals((long)0L, (long)member.length());
        }
        if (created) {
            member.rm();
            Assert.assertFalse((boolean)member.exists());
            Assert.assertFalse((boolean)member.isDirectory());
            Assert.assertFalse((boolean)member.isFile());
            Assert.assertEquals((long)0L, (long)member.length());
        }
    }

    private void assertListFiles(TFile dir, String entry) {
        TFile[] files = dir.listFiles();
        boolean found = false;
        for (TFile file : files) {
            if (!file.getName().equals(entry)) continue;
            found = true;
        }
        if (!found) {
            Assert.fail((String)("No such entry: " + entry));
        }
    }

    @Test
    public final void testInputOutput() throws IOException {
        this.assertInputOutput(this.archive);
        TFile archiveTest = new TFile((File)this.archive, "test");
        this.assertInputOutput(archiveTest);
        TFile archive2 = new TFile((File)this.archive, "inner" + this.getSuffix());
        TFile archive2Test = new TFile((File)archive2, "test");
        this.assertInputOutput(archive2Test);
        archive2.rm();
        this.archive.rm();
    }

    private void assertInputOutput(TFile file) throws IOException {
        this.assertInput(file);
        this.assertOutput(file);
        file.rm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertInput(TFile file) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(this.data);
        try {
            file.input((InputStream)in);
        }
        finally {
            ((InputStream)in).close();
        }
        Assert.assertEquals((long)this.data.length, (long)file.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertOutput(TFile file) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(this.data.length);
        try {
            file.output((OutputStream)out);
        }
        finally {
            out.close();
        }
        Assert.assertTrue((boolean)Arrays.equals(this.data, out.toByteArray()));
    }

    @Test
    public final void testCopyContainingOrSameFiles() throws IOException {
        assert (!this.archive.exists());
        TFile dir = this.archive.getParentFile();
        Assert.assertNotNull((Object)dir);
        TFile entry = new TFile((File)this.archive, "entry");
        this.assertCopyContainingOrSameFiles0(dir, this.archive);
        this.assertCopyContainingOrSameFiles0(this.archive, entry);
        entry.input((InputStream)new ByteArrayInputStream(this.data));
        this.assertCopyContainingOrSameFiles0(dir, this.archive);
        this.assertCopyContainingOrSameFiles0(this.archive, entry);
        TFile.rm_r((File)this.archive);
    }

    private void assertCopyContainingOrSameFiles0(TFile a, TFile b) throws IOException {
        this.assertCopyContainingOrSameFiles1(a, b);
        this.assertCopyContainingOrSameFiles1(a.getCanOrAbsFile(), b);
        this.assertCopyContainingOrSameFiles1(a, b.getCanOrAbsFile());
        this.assertCopyContainingOrSameFiles1(a.getCanOrAbsFile(), b.getCanOrAbsFile());
    }

    private void assertCopyContainingOrSameFiles1(TFile a, TFile b) throws IOException {
        try {
            TFile.cp((File)a, (File)a);
            Assert.fail();
        }
        catch (IOException expected) {
            // empty catch block
        }
        try {
            TFile.cp((File)a, (File)b);
            Assert.fail();
        }
        catch (IOException expected) {
            // empty catch block
        }
        try {
            TFile.cp((File)b, (File)a);
            Assert.fail();
        }
        catch (IOException expected) {
            // empty catch block
        }
        try {
            TFile.cp((File)b, (File)b);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public final void testCopyDelete() throws IOException {
        String[] names = new String[]{"0" + this.getSuffix(), "1" + this.getSuffix()};
        Assert.assertTrue((boolean)this.archive.mkdir());
        this.assertCopyDelete(this.archive, names, 0);
        this.archive.rm();
        Assert.assertTrue((boolean)TFileTestSuite.newNonArchiveFile(this.archive).mkdir());
        this.assertCopyDelete(this.archive, names, 0);
        this.archive.rm();
    }

    private void assertCopyDelete(TFile parent, String[] names, int off) throws IOException {
        if (off >= names.length) {
            return;
        }
        TFile dir = new TFile((File)parent, names[off]);
        Assert.assertTrue((boolean)dir.mkdir());
        this.assertCopyDelete(parent, dir);
        this.assertCopyDelete(dir, names, off + 1);
        dir.rm();
        Assert.assertTrue((boolean)TFileTestSuite.newNonArchiveFile(dir).mkdir());
        this.assertCopyDelete(parent, dir);
        this.assertCopyDelete(dir, names, off + 1);
        dir.rm();
    }

    private void assertCopyDelete(TFile parent, TFile dir) throws IOException {
        TFile parentFile = new TFile((File)parent, "file");
        TFile parentArchive = new TFile((File)parent, "archive" + this.getSuffix());
        TFile dirFile = new TFile((File)dir, "file");
        TFile dirArchive = new TFile((File)dir, "archive" + this.getSuffix());
        this.assertCopyDelete0(dirFile, dirArchive);
        this.assertCopyDelete0(dirFile, parentFile);
        this.assertCopyDelete0(dirFile, parentArchive);
        this.assertCopyDelete0(parentFile, dirFile);
        this.assertCopyDelete0(parentFile, dirArchive);
        this.assertCopyDelete0(parentArchive, dirFile);
        this.assertCopyDelete0(parentArchive, dirArchive);
        this.assertCopyDelete0(dirArchive, dirFile);
        this.assertCopyDelete0(dirArchive, parentFile);
        this.assertCopyDelete0(dirArchive, parentArchive);
    }

    private void assertCopyDelete0(TFile a, TFile b) throws IOException {
        this.assertCopyDelete0(a, b, 4000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertCopyDelete0(TFile a, TFile b, long granularity) throws IOException {
        long time = System.currentTimeMillis();
        TFileOutputStream out = new TFileOutputStream((File)a);
        try {
            out.write(this.data);
        }
        finally {
            out.close();
        }
        Assert.assertTrue((boolean)a.setLastModified(time - granularity));
        TFile.cp((File)a, (File)b);
        Assert.assertThat((Object)b.length(), (Matcher)CoreMatchers.is((Object)a.length()));
        Assert.assertThat((Object)b.lastModified(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.is((Object)a.lastModified())));
        TFile.cp_p((File)a, (File)b);
        Assert.assertThat((Object)b.length(), (Matcher)CoreMatchers.is((Object)a.length()));
        long almd = a.lastModified() / granularity * granularity;
        long blmd = b.lastModified() / granularity * granularity;
        long almu = (a.lastModified() + granularity - 1L) / granularity * granularity;
        long blmu = (b.lastModified() + granularity - 1L) / granularity * granularity;
        Assert.assertTrue((almd == blmd || almu == blmu ? 1 : 0) != 0);
        TFile.cp((File)b, (File)a);
        Assert.assertThat((Object)a.length(), (Matcher)CoreMatchers.is((Object)b.length()));
        Assert.assertThat((Object)a.lastModified(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.is((Object)b.lastModified())));
        TFile.cp_p((File)b, (File)a);
        Assert.assertThat((Object)a.length(), (Matcher)CoreMatchers.is((Object)b.length()));
        almd = a.lastModified() / granularity * granularity;
        blmd = b.lastModified() / granularity * granularity;
        almu = (a.lastModified() + granularity - 1L) / granularity * granularity;
        blmu = (b.lastModified() + granularity - 1L) / granularity * granularity;
        Assert.assertTrue((almd == blmd || almu == blmu ? 1 : 0) != 0);
        ByteArrayOutputStream out2 = new ByteArrayOutputStream(this.data.length);
        TFile.cp((File)a, (OutputStream)out2);
        Assert.assertTrue((boolean)Arrays.equals(this.data, out2.toByteArray()));
        a.rm();
        b.rm();
    }

    @Test
    public final void testListPerformance() throws IOException {
        int j;
        int i;
        Assert.assertTrue((boolean)this.archive.mkdir());
        long time = System.currentTimeMillis();
        for (i = 0; i < 100; ++i) {
            TFile file = new TFile((File)this.archive, "" + i);
            Assert.assertTrue((boolean)file.createNewFile());
        }
        time = System.currentTimeMillis() - time;
        logger.log(Level.FINER, "Time required to create {0} archive file entries: {1}ms", new Object[]{i, time});
        time = System.currentTimeMillis();
        for (j = 0; j < 100; ++j) {
            this.archive.listFiles((FilenameFilter)null);
        }
        time = System.currentTimeMillis() - time;
        logger.log(Level.FINER, "Time required to list these entries {0} times using a nullary FilenameFilter: {1}ms", new Object[]{j, time});
        time = System.currentTimeMillis();
        for (j = 0; j < 100; ++j) {
            this.archive.listFiles((FileFilter)null);
        }
        time = System.currentTimeMillis() - time;
        logger.log(Level.FINER, "Time required to list these entries {0} times using a nullary FileFilter: {1}ms", new Object[]{j, time});
        try {
            this.archive.rm();
            Assert.fail((String)"directory not empty");
        }
        catch (IOException expected) {
            // empty catch block
        }
        TFile.umount();
        TFile.rm((File)new File(this.archive.getPath()));
        Assert.assertFalse((boolean)this.archive.exists());
        Assert.assertFalse((boolean)this.archive.isDirectory());
        Assert.assertFalse((boolean)this.archive.isFile());
        Assert.assertEquals((long)0L, (long)this.archive.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void testIllegalDeleteEntryWithOpenStream() throws IOException {
        TFile entry1 = new TFile((File)this.archive, "entry1");
        TFile entry2 = new TFile((File)this.archive, "entry2");
        TFileOutputStream out1 = new TFileOutputStream((File)entry1);
        try {
            try {
                entry1.rm();
                Assert.fail();
            }
            catch (IOException expected) {
                // empty catch block
            }
            out1.write(this.data);
            try {
                this.archive.rm_r();
                Assert.fail();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        finally {
            out1.close();
        }
        TFileOutputStream out2 = new TFileOutputStream((File)entry2);
        try {
            try {
                entry2.rm();
                Assert.fail();
            }
            catch (IOException expected) {
                // empty catch block
            }
            out2.write(this.data);
            try {
                this.archive.rm_r();
                Assert.fail();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        finally {
            out2.close();
        }
        TFileInputStream in1 = new TFileInputStream((File)entry1);
        try {
            ByteArrayOutputStream out;
            TFileInputStream in2 = new TFileInputStream((File)entry2);
            try {
                entry2.rm();
                out = new ByteArrayOutputStream(this.data.length);
                try {
                    TFile.cat((InputStream)in2, (OutputStream)out);
                }
                finally {
                    out.close();
                }
                Assert.assertTrue((boolean)Arrays.equals(this.data, out.toByteArray()));
                try {
                    this.archive.rm_r();
                    Assert.fail();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            finally {
                in2.close();
            }
            try {
                entry1.rm();
                Assert.fail((String)"deleted within archive.rm_r()");
            }
            catch (IOException expected) {
                // empty catch block
            }
            out = new ByteArrayOutputStream(this.data.length);
            try {
                TFile.cat((InputStream)in1, (OutputStream)out);
            }
            finally {
                out.close();
            }
            Assert.assertTrue((boolean)Arrays.equals(this.data, out.toByteArray()));
            try {
                this.archive.rm_r();
                Assert.fail();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        finally {
            in1.close();
        }
        this.archive.rm_r();
        Assert.assertFalse((boolean)TFileTestSuite.newNonArchiveFile(this.archive).exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void testRenameValidArchive() throws IOException {
        PrintStream out = new PrintStream((OutputStream)new TFileOutputStream((File)new TFile((File)this.archive, "entry")));
        try {
            out.println("Hello World!");
        }
        finally {
            out.close();
        }
        this.assertRenameArchiveToTemp(this.archive);
    }

    @Test
    public final void testRenameFalsePositive() throws IOException {
        TFile tmp = TFileTestSuite.newNonArchiveFile(this.archive);
        ByteArrayInputStream in = new ByteArrayInputStream(this.data);
        TFile.cp((InputStream)in, (File)tmp);
        this.assertRenameArchiveToTemp(this.archive);
    }

    private void assertRenameArchiveToTemp(TFile archive) throws IOException {
        assert (archive.isArchive());
        assert (!archive.isEntry());
        TFile tmp = new TFile(TFile.createTempFile((String)TEMP_FILE_PREFIX, null));
        tmp.rm();
        Assert.assertFalse((boolean)tmp.exists());
        Assert.assertFalse((boolean)TFileTestSuite.newNonArchiveFile(tmp).exists());
        archive.mv((File)tmp);
        Assert.assertFalse((boolean)archive.exists());
        Assert.assertFalse((boolean)TFileTestSuite.newNonArchiveFile(archive).exists());
        tmp.rm_r();
        Assert.assertFalse((boolean)tmp.exists());
        Assert.assertFalse((boolean)TFileTestSuite.newNonArchiveFile(tmp).exists());
    }

    @Test
    public final void testRenameRecursively() throws IOException {
        TFile temp = new TFile(this.createTempFile());
        TFile archive2 = new TFile((File)this.archive, "inner" + this.getSuffix());
        TFile archive3 = new TFile((File)archive2, "nuts" + this.getSuffix());
        TFile archive1a = new TFile((File)this.archive, "a");
        TFile archive1b = new TFile((File)this.archive, "b");
        TFile archive2a = new TFile((File)archive2, "a");
        TFile archive2b = new TFile((File)archive2, "b");
        TFile archive3a = new TFile((File)archive3, "a");
        TFile archive3b = new TFile((File)archive3, "b");
        temp.rm();
        this.assertInput(archive1a);
        for (int i = 2; i >= 1; --i) {
            this.assertRenameTo(archive1a, archive1b);
            this.assertRenameTo(archive1b, archive2a);
            this.assertRenameTo(archive2a, archive2b);
            this.assertRenameTo(archive2b, archive3a);
            this.assertRenameTo(archive3a, archive3b);
            this.assertRenameTo(archive3b, archive3a);
            this.assertRenameTo(archive3a, archive2b);
            this.assertRenameTo(archive2b, archive2a);
            this.assertRenameTo(archive2a, archive1b);
            this.assertRenameTo(archive1b, archive1a);
        }
        this.assertRenameTo(this.archive, temp);
        this.assertRenameTo(temp, this.archive);
        archive3.rm();
        archive2.rm();
        this.assertOutput(archive1a);
        archive1a.rm();
        this.archive.rm();
    }

    private void assertRenameTo(TFile src, TFile dst) throws IOException {
        Assert.assertTrue((boolean)src.exists());
        if (!src.isEntry()) {
            Assert.assertTrue((boolean)TFileTestSuite.newNonArchiveFile(src).exists());
        }
        Assert.assertFalse((boolean)dst.exists());
        if (!dst.isEntry()) {
            Assert.assertFalse((boolean)TFileTestSuite.newNonArchiveFile(dst).exists());
        }
        assert (TFile.isLenient());
        src.mv((File)dst);
        Assert.assertFalse((boolean)src.exists());
        if (!src.isEntry()) {
            Assert.assertFalse((boolean)TFileTestSuite.newNonArchiveFile(src).exists());
        }
        Assert.assertTrue((boolean)dst.exists());
        if (!dst.isEntry()) {
            Assert.assertTrue((boolean)TFileTestSuite.newNonArchiveFile(dst).exists());
        }
    }

    @Test
    public final void testList() throws IOException {
        File dir = this.createTempFile();
        TFile dir2 = new TFile(dir);
        TFile.rm((File)dir);
        Assert.assertTrue((boolean)dir.mkdir());
        int i = MEMBERS.length;
        while (--i >= 0) {
            Assert.assertTrue((boolean)new File(dir, MEMBERS[i]).createNewFile());
        }
        Object[] files = dir.listFiles();
        Arrays.sort(files);
        this.assertList((File[])files, dir2);
        TFile.rm_r((File)dir2);
        Assert.assertTrue((boolean)dir2.mkdir());
        int i2 = MEMBERS.length;
        while (--i2 >= 0) {
            Assert.assertTrue((boolean)new TFile((File)dir2, MEMBERS[i2]).createNewFile());
        }
        this.assertList((File[])files, dir2);
        TFile.rm_r((File)dir2);
    }

    private void assertList(File[] refs, TFile dir) {
        Object[] files = dir.listFiles();
        Arrays.sort(files);
        Assert.assertEquals((long)refs.length, (long)files.length);
        int l = refs.length;
        for (int i = 0; i < l; ++i) {
            File ref = refs[i];
            Object file = files[i];
            Assert.assertTrue((!(ref instanceof TFile) ? 1 : 0) != 0);
            Assert.assertEquals((Object)ref.getPath(), (Object)file.getPath());
            Assert.assertNull((Object)file.list());
            Assert.assertNull((Object)file.list(null));
            Assert.assertNull((Object)file.listFiles());
            Assert.assertNull((Object)file.listFiles(file.getArchiveDetector()));
            Assert.assertNull((Object)file.listFiles((FileFilter)null));
            Assert.assertNull((Object)file.listFiles((FilenameFilter)null));
            Assert.assertNull((Object)file.listFiles((FileFilter)null, file.getArchiveDetector()));
            Assert.assertNull((Object)file.listFiles((FilenameFilter)null, file.getArchiveDetector()));
        }
    }

    @Test
    public final void testMultithreadedSingleArchiveMultipleEntriesReading() throws Exception {
        this.assertMultithreadedSingleArchiveMultipleEntriesReading(20, 20);
    }

    private void assertMultithreadedSingleArchiveMultipleEntriesReading(final int nEntries, int nThreads) throws Exception {
        class CheckAllEntriesThread
        extends IOThread {
            CheckAllEntriesThread() {
            }

            @Override
            public void work() throws IOException {
                TFileTestSuite.this.assertArchiveEntries(TFileTestSuite.this.archive, nEntries);
            }
        }
        CheckAllEntriesThread thread;
        int i;
        this.createTestArchive(nEntries);
        CheckAllEntriesThread[] threads = new CheckAllEntriesThread[nThreads];
        for (i = 0; i < nThreads; ++i) {
            thread = new CheckAllEntriesThread();
            thread.start();
            threads[i] = thread;
        }
        for (i = 0; i < nThreads; ++i) {
            thread = threads[i];
            thread.join();
            if (thread.failure == null) continue;
            throw new IOException(thread.failure);
        }
        TFile.rm_r((File)this.archive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTestArchive(int nEntries) throws IOException {
        for (int i = 0; i < nEntries; ++i) {
            TFile entry = new TFile(this.archive + TFile.separator + i);
            TFileOutputStream out = new TFileOutputStream((File)entry);
            try {
                out.write(this.data);
                continue;
            }
            finally {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertArchiveEntries(TFile archive, int nEntries) throws IOException {
        TFile[] entries = archive.listFiles();
        Assert.assertEquals((long)nEntries, (long)entries.length);
        byte[] buf = new byte[4096];
        for (TFile entry : entries) {
            TFileInputStream in = new TFileInputStream((File)entry);
            try {
                int read;
                int off = 0;
                while ((read = in.read(buf)) >= 0) {
                    Assert.assertTrue((read > 0 ? 1 : 0) != 0);
                    Assert.assertTrue((boolean)ArrayHelper.equals((byte[])this.data, (int)off, (byte[])buf, (int)0, (int)read));
                    off += read;
                }
                Assert.assertEquals((long)-1L, (long)read);
                Assert.assertEquals((long)off, (long)this.data.length);
                Assert.assertTrue((0 >= in.read(new byte[0]) ? 1 : 0) != 0);
            }
            finally {
                in.close();
            }
        }
    }

    @Test
    public final void testMultithreadedSingleArchiveMultipleEntriesWriting() throws Exception {
        this.assertMultithreadedSingleArchiveMultipleEntriesWriting(this.archive, 20, false);
        this.assertMultithreadedSingleArchiveMultipleEntriesWriting(this.archive, 20, true);
    }

    private void assertMultithreadedSingleArchiveMultipleEntriesWriting(final TFile archive, int nThreads, final boolean wait) throws Exception {
        class WritingThread
        extends IOThread {
            final int i;

            WritingThread(int i) {
                this.i = i;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void work() throws IOException {
                block10: {
                    TFileOutputStream out;
                    TFile file = new TFile((File)archive, this.i + "");
                    while (true) {
                        try {
                            out = new TFileOutputStream((File)file);
                        }
                        catch (FileBusyException busy) {
                            continue;
                        }
                        break;
                    }
                    try {
                        out.write(TFileTestSuite.this.data);
                    }
                    finally {
                        out.close();
                    }
                    try {
                        TFile.umount((boolean)wait, (boolean)false, (boolean)wait, (boolean)false);
                    }
                    catch (FsSyncException ex) {
                        if (!(ex.getCause() instanceof FileBusyException)) {
                            throw ex;
                        }
                        if (!wait) break block10;
                        throw new AssertionError((Object)ex);
                    }
                }
            }
        }
        WritingThread thread;
        int i;
        Assert.assertTrue((boolean)TFile.isLenient());
        WritingThread[] threads = new WritingThread[nThreads];
        for (i = 0; i < nThreads; ++i) {
            thread = new WritingThread(i);
            thread.start();
            threads[i] = thread;
        }
        for (i = 0; i < nThreads; ++i) {
            thread = threads[i];
            thread.join();
            if (thread.failure == null) continue;
            throw new Exception(thread.failure);
        }
        this.assertArchiveEntries(archive, nThreads);
        TFile.rm_r((File)archive);
    }

    @Test
    public final void testMultithreadedMultipleArchivesSingleEntryWriting() throws Exception {
        this.assertMultithreadedMultipleArchivesSingleEntryWriting(20, false);
        this.assertMultithreadedMultipleArchivesSingleEntryWriting(20, true);
    }

    private void assertMultithreadedMultipleArchivesSingleEntryWriting(int nThreads, final boolean updateIndividually) throws Exception {
        class WritingThread
        extends IOThread {
            WritingThread() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void work() throws IOException {
                TFile archive = new TFile(TFileTestSuite.this.createTempFile());
                archive.rm();
                TFile file = new TFile((File)archive, "entry");
                try {
                    TFileOutputStream out = new TFileOutputStream((File)file);
                    try {
                        out.write(TFileTestSuite.this.data);
                    }
                    finally {
                        out.close();
                    }
                    try {
                        if (updateIndividually) {
                            TFile.umount((TFile)archive);
                        } else {
                            TFile.umount((boolean)false);
                        }
                    }
                    catch (FsSyncException ex) {
                        if (!(ex.getCause() instanceof FileBusyException)) {
                            throw ex;
                        }
                        if (updateIndividually) {
                            throw new AssertionError((Object)ex);
                        }
                    }
                }
                finally {
                    TFile.rm_r((File)archive);
                }
            }
        }
        WritingThread thread;
        int i;
        Assert.assertTrue((boolean)TFile.isLenient());
        WritingThread[] threads = new WritingThread[nThreads];
        for (i = 0; i < nThreads; ++i) {
            thread = new WritingThread();
            thread.start();
            threads[i] = thread;
        }
        for (i = 0; i < nThreads; ++i) {
            thread = threads[i];
            thread.join();
            if (thread.failure == null) continue;
            throw new Exception(thread.failure);
        }
    }

    static {
        rnd.nextBytes(DATA);
        IO_POOL_PROVIDER = new ByteArrayIOPoolService(4 * DATA.length / 3);
        MEMBERS = new String[]{"A directory member", "Another directory member", "Yet another directory member"};
    }

    private abstract class IOThread
    extends Thread {
        Throwable failure;

        IOThread() {
            this.setDaemon(true);
        }

        @Override
        public final void run() {
            try {
                this.work();
            }
            catch (Throwable exception) {
                this.failure = exception;
            }
        }

        abstract void work() throws IOException;
    }
}

