/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.file;

import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsInputOptions;
import de.schlichtherle.truezip.fs.FsManager;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsOutputOptions;
import de.schlichtherle.truezip.fs.sl.FsManagerLocator;
import de.schlichtherle.truezip.util.BitField;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Closeable;
import java.util.Deque;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
public final class TConfig
implements Closeable {
    public static final BitField<FsInputOption> DEFAULT_INPUT_PREFERENCES = FsInputOptions.NO_INPUT_OPTIONS;
    private static final BitField<FsInputOption> INPUT_PREFERENCES_COMPLEMENT_MASK = FsInputOptions.INPUT_PREFERENCES_MASK.not();
    public static final BitField<FsOutputOption> DEFAULT_OUTPUT_PREFERENCES = BitField.of((Enum)FsOutputOption.CREATE_PARENTS);
    private static final BitField<FsOutputOption> OUTPUT_PREFERENCES_COMPLEMENT_MASK = FsOutputOptions.OUTPUT_PREFERENCES_MASK.not();
    @CheckForNull
    private static volatile InheritableThreadLocalConfigStack configs;
    private TArchiveDetector detector;
    private BitField<FsInputOption> inputPreferences;
    private BitField<FsOutputOption> outputPreferences;

    public static TConfig get() {
        InheritableThreadLocalConfigStack configs = TConfig.configs;
        if (null == configs) {
            return Global.INSTANCE;
        }
        TConfig session = (TConfig)((Deque)configs.get()).peek();
        return null != session ? session : Global.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TConfig push() {
        Class<TConfig> clazz = TConfig.class;
        synchronized (TConfig.class) {
            InheritableThreadLocalConfigStack configs = TConfig.configs;
            if (null == configs) {
                TConfig.configs = configs = new InheritableThreadLocalConfigStack();
            }
            // ** MonitorExit[var1] (shouldn't be in output)
            Deque stack = (Deque)configs.get();
            TConfig template = (TConfig)stack.peek();
            if (null == template) {
                template = Global.INSTANCE;
            }
            TConfig config = new TConfig(template);
            stack.push(config);
            return config;
        }
    }

    public static void pop() {
        TConfig.get().close();
    }

    private static void pop(TConfig config) {
        TConfig found;
        InheritableThreadLocalConfigStack configs = TConfig.configs;
        if (null == configs) {
            throw new IllegalStateException("Inheritable thread local configuration stack is empty.");
        }
        Deque stack = (Deque)configs.get();
        try {
            found = (TConfig)stack.pop();
        }
        catch (NoSuchElementException ex) {
            throw new IllegalStateException("Inheritable thread local configuration stack is empty.", ex);
        }
        if (config != found) {
            stack.push(found);
            throw new IllegalStateException("Not the top element of the inheritable thread local configuration stack.");
        }
        if (stack.isEmpty()) {
            configs.remove();
        }
    }

    private TConfig() {
        this.detector = TArchiveDetector.ALL;
        this.inputPreferences = DEFAULT_INPUT_PREFERENCES;
        this.outputPreferences = DEFAULT_OUTPUT_PREFERENCES;
    }

    private TConfig(TConfig template) {
        this.detector = template.getArchiveDetector();
        this.inputPreferences = template.getInputPreferences();
        this.outputPreferences = template.getOutputPreferences();
    }

    FsManager getManager() {
        return FsManagerLocator.SINGLETON.get();
    }

    public boolean isLenient() {
        return this.outputPreferences.get((Enum)FsOutputOption.CREATE_PARENTS);
    }

    public void setLenient(boolean lenient) {
        this.outputPreferences = this.outputPreferences.set((Enum)FsOutputOption.CREATE_PARENTS, lenient);
    }

    public TArchiveDetector getArchiveDetector() {
        return this.detector;
    }

    public void setArchiveDetector(TArchiveDetector detector) {
        if (null == detector) {
            throw new NullPointerException();
        }
        this.detector = detector;
    }

    public BitField<FsInputOption> getInputPreferences() {
        return this.inputPreferences;
    }

    public void setInputPreferences(BitField<FsInputOption> preferences) {
        BitField illegal = preferences.and(INPUT_PREFERENCES_COMPLEMENT_MASK);
        if (!illegal.isEmpty()) {
            throw new IllegalArgumentException(preferences + " (illegal input preferences)");
        }
        this.inputPreferences = preferences;
    }

    public BitField<FsOutputOption> getOutputPreferences() {
        return this.outputPreferences;
    }

    public void setOutputPreferences(BitField<FsOutputOption> preferences) {
        BitField illegal = preferences.and(OUTPUT_PREFERENCES_COMPLEMENT_MASK);
        if (!illegal.isEmpty()) {
            throw new IllegalArgumentException(preferences + " (illegal output preferences)");
        }
        if (preferences.get((Enum)FsOutputOption.STORE) && preferences.get((Enum)FsOutputOption.COMPRESS)) {
            throw new IllegalArgumentException(preferences + " (either STORE or COMPRESS may be set, but not both)");
        }
        this.outputPreferences = preferences;
    }

    @Override
    public void close() {
        TConfig.pop(this);
    }

    private static final class Global {
        static final TConfig INSTANCE = new TConfig();

        private Global() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class InheritableThreadLocalConfigStack
    extends InheritableThreadLocal<Deque<TConfig>> {
        private InheritableThreadLocalConfigStack() {
        }

        @Override
        protected Deque<TConfig> initialValue() {
            return new LinkedList<TConfig>();
        }

        @Override
        protected Deque<TConfig> childValue(Deque<TConfig> parent) {
            LinkedList<TConfig> child = new LinkedList<TConfig>();
            TConfig element = parent.peek();
            if (null != element) {
                child.push(element);
            }
            return child;
        }
    }
}

