/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.file.swing;

import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.swing.TFileSystemView;
import de.schlichtherle.truezip.file.swing.TFileTree;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

@DefaultAnnotation(value={NonNull.class})
final class TFileTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1045639746091876245L;
    @CheckForNull
    private transient TFileSystemView fileSystemView;
    private final TFileTree fileTree;

    TFileTreeCellRenderer(TFileTree fileTree) {
        if (null == fileTree) {
            throw new NullPointerException();
        }
        this.fileTree = fileTree;
    }

    private TFileSystemView getFileSystemView() {
        TFileSystemView fileSystemView = this.fileSystemView;
        return null != fileSystemView ? fileSystemView : (this.fileSystemView = new TFileSystemView());
    }

    @Nullable
    public Icon getOpenIcon() {
        TFile node;
        Icon icon = super.getOpenIcon();
        return null != icon ? icon : (null != (node = this.fileTree.getEditedNode()) ? this.getFileSystemView().getSystemIcon(node) : null);
    }

    @Nullable
    public Icon getClosedIcon() {
        TFile node;
        Icon icon = super.getClosedIcon();
        return null != icon ? icon : (null != (node = this.fileTree.getEditedNode()) ? this.getFileSystemView().getSystemIcon(node) : null);
    }

    @Nullable
    public Icon getLeafIcon() {
        TFile node;
        Icon icon = super.getLeafIcon();
        return null != icon ? icon : (null != (node = this.fileTree.getEditedNode()) ? this.getFileSystemView().getSystemIcon(node) : null);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        this.setIcon(this.getFileSystemView().getSystemIcon((TFile)value));
        return this;
    }
}

