/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.file;

import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TConfig;
import de.schlichtherle.truezip.fs.FsArchiveDriver;
import de.schlichtherle.truezip.fs.FsArchiveDriverTestBase;
import de.schlichtherle.truezip.fs.FsDefaultManager;
import de.schlichtherle.truezip.fs.FsDriver;
import de.schlichtherle.truezip.fs.FsManager;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsScheme;
import de.schlichtherle.truezip.util.SuffixSet;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ConfiguredClientTestBase<D extends FsArchiveDriver<?>>
extends FsArchiveDriverTestBase<D> {
    protected static final long TIMEOUT_MILLIS = 50L;
    protected static final FsMountPoint ROOT_DIRECTORY = FsMountPoint.create((URI)URI.create("file:/"));
    protected static final FsMountPoint CURRENT_DIRECTORY = FsMountPoint.create((URI)new File("").toURI());
    protected static final String[] NO_STRINGS = new String[0];
    private static final String ARCHIVE_DETECTOR = "archiveDetector";
    private static final boolean ISOLATE_FS_MANAGER = Boolean.getBoolean(ConfiguredClientTestBase.class.getName() + ".isolateFsManager");
    private TArchiveDetector detector;
    private Map<String, ?> environment;

    public void setUp() throws IOException {
        super.setUp();
        this.detector = new TArchiveDetector(this.getSuffixList(), (FsDriver)this.getArchiveDriver());
        this.environment = Collections.singletonMap(ARCHIVE_DETECTOR, this.detector);
        TConfig config = TConfig.push();
        if (ISOLATE_FS_MANAGER) {
            config.setFsManager((FsManager)new FsDefaultManager());
        }
        config.setLenient(true);
        config.setArchiveDetector(this.detector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown() {
        try {
            TConfig.pop();
        }
        finally {
            super.tearDown();
        }
    }

    protected abstract String getSuffixList();

    protected final FsScheme getScheme() {
        return FsScheme.create((String)((String)new SuffixSet(this.getSuffixList()).iterator().next()));
    }

    protected final String getSuffix() {
        return "." + this.getScheme();
    }

    protected final TArchiveDetector getArchiveDetector() {
        return this.detector;
    }

    protected final Map<String, ?> getEnvironment() {
        return this.environment;
    }

    static {
        Logger.getLogger(ConfiguredClientTestBase.class.getName()).log(Level.CONFIG, "Isolate file system manager: {0}", ISOLATE_FS_MANAGER);
    }
}

