/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.file;

import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TConfig;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.fs.FsDriver;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsInputOptions;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.archive.mock.MockArchiveDriver;
import de.schlichtherle.truezip.util.BitField;
import java.util.NoSuchElementException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class TConfigTest {
    @Test
    public void defaults() {
        TConfig c = TConfig.get();
        Assert.assertThat((Object)TConfig.get(), (Matcher)CoreMatchers.sameInstance((Object)c));
        TArchiveDetector detector = c.getArchiveDetector();
        Assert.assertThat((Object)detector, (Matcher)CoreMatchers.sameInstance((Object)TArchiveDetector.ALL));
        Assert.assertThat((Object)c.getArchiveDetector(), (Matcher)CoreMatchers.sameInstance((Object)detector));
        boolean lenient = c.isLenient();
        Assert.assertThat((Object)lenient, (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)c.isLenient(), (Matcher)CoreMatchers.is((Object)lenient));
        Assert.assertTrue((boolean)c.getInputPreferences().isEmpty());
        Assert.assertThat((Object)c.getOutputPreferences(), (Matcher)CoreMatchers.is((Object)BitField.of((Enum)FsOutputOption.CREATE_PARENTS)));
    }

    @Test
    public void pop() {
        TConfig.push();
        TConfig.pop();
        try {
            TConfig.pop();
            Assert.fail();
        }
        catch (IllegalStateException emptyStack) {
            Assert.assertTrue((boolean)(emptyStack.getCause() instanceof NoSuchElementException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void close() {
        TConfig c1 = TConfig.push();
        try {
            TConfig c2 = TConfig.push();
            try {
                c1.close();
                Assert.fail();
            }
            catch (IllegalStateException notTopElement) {
                Assert.assertSame((Object)c2, (Object)TConfig.get());
            }
            finally {
                c2.close();
            }
            c2.close();
            Assert.assertSame((Object)c1, (Object)TConfig.get());
        }
        finally {
            c1.close();
        }
        c1.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void inheritance() throws InterruptedException {
        this.assertInheritance();
        TConfig c1 = TConfig.push();
        try {
            this.assertInheritance();
            TConfig c2 = TConfig.push();
            try {
                this.assertInheritance();
            }
            finally {
                c2.close();
            }
            this.assertInheritance();
        }
        finally {
            c1.close();
        }
    }

    private void assertInheritance() throws InterruptedException {
        class TestThread
        extends Thread {
            TConfig config;

            TestThread() {
            }

            @Override
            public void run() {
                this.config = TConfig.get();
                try {
                    TConfig.pop();
                    TConfig.pop();
                    Assert.fail();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
        TestThread t = new TestThread();
        t.start();
        t.join();
        Assert.assertThat((Object)t.config, (Matcher)CoreMatchers.sameInstance((Object)TConfig.get()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void preferences() {
        TConfig c = TConfig.push();
        try {
            Assert.assertTrue((boolean)c.isLenient());
            Assert.assertTrue((boolean)c.getInputPreferences().isEmpty());
            Assert.assertThat((Object)c.getOutputPreferences(), (Matcher)CoreMatchers.is((Object)BitField.of((Enum)FsOutputOption.CREATE_PARENTS)));
            c.setLenient(false);
            Assert.assertFalse((boolean)c.isLenient());
            Assert.assertTrue((boolean)c.getInputPreferences().isEmpty());
            Assert.assertTrue((boolean)c.getOutputPreferences().isEmpty());
            c.setLenient(true);
            Assert.assertTrue((boolean)c.isLenient());
            Assert.assertTrue((boolean)c.getInputPreferences().isEmpty());
            Assert.assertThat((Object)c.getOutputPreferences(), (Matcher)CoreMatchers.is((Object)BitField.of((Enum)FsOutputOption.CREATE_PARENTS)));
            c.setInputPreferences(BitField.of((Enum)FsInputOption.CACHE));
            Assert.assertTrue((boolean)c.isLenient());
            Assert.assertThat((Object)c.getInputPreferences(), (Matcher)CoreMatchers.is((Object)BitField.of((Enum)FsInputOption.CACHE)));
            Assert.assertThat((Object)c.getOutputPreferences(), (Matcher)CoreMatchers.is((Object)BitField.of((Enum)FsOutputOption.CREATE_PARENTS)));
            c.setInputPreferences(FsInputOptions.NONE);
            Assert.assertTrue((boolean)c.isLenient());
            Assert.assertTrue((boolean)c.getInputPreferences().isEmpty());
            Assert.assertThat((Object)c.getOutputPreferences(), (Matcher)CoreMatchers.is((Object)BitField.of((Enum)FsOutputOption.CREATE_PARENTS)));
            c.setOutputPreferences(BitField.of((Enum)FsOutputOption.CACHE));
            Assert.assertFalse((boolean)c.isLenient());
            Assert.assertTrue((boolean)c.getInputPreferences().isEmpty());
            Assert.assertThat((Object)c.getOutputPreferences(), (Matcher)CoreMatchers.is((Object)BitField.of((Enum)FsOutputOption.CACHE)));
            c.setOutputPreferences(BitField.of((Enum)FsOutputOption.CREATE_PARENTS));
            Assert.assertTrue((boolean)c.isLenient());
            Assert.assertTrue((boolean)c.getInputPreferences().isEmpty());
            Assert.assertThat((Object)c.getOutputPreferences(), (Matcher)CoreMatchers.is((Object)BitField.of((Enum)FsOutputOption.CREATE_PARENTS)));
            try {
                c.setOutputPreferences(BitField.of((Enum)FsOutputOption.APPEND));
                Assert.fail();
            }
            catch (IllegalArgumentException expected) {
                // empty catch block
            }
            Assert.assertTrue((boolean)c.isLenient());
            Assert.assertTrue((boolean)c.getInputPreferences().isEmpty());
            Assert.assertThat((Object)c.getOutputPreferences(), (Matcher)CoreMatchers.is((Object)BitField.of((Enum)FsOutputOption.CREATE_PARENTS)));
            try {
                c.setOutputPreferences(BitField.of((Enum)FsOutputOption.EXCLUSIVE));
                Assert.fail();
            }
            catch (IllegalArgumentException expected) {
                // empty catch block
            }
            Assert.assertTrue((boolean)c.isLenient());
            Assert.assertTrue((boolean)c.getInputPreferences().isEmpty());
            Assert.assertThat((Object)c.getOutputPreferences(), (Matcher)CoreMatchers.is((Object)BitField.of((Enum)FsOutputOption.CREATE_PARENTS)));
            c.setOutputPreferences(BitField.of((Enum)FsOutputOption.STORE));
            Assert.assertFalse((boolean)c.isLenient());
            Assert.assertTrue((boolean)c.getInputPreferences().isEmpty());
            Assert.assertThat((Object)c.getOutputPreferences(), (Matcher)CoreMatchers.is((Object)BitField.of((Enum)FsOutputOption.STORE)));
            c.setOutputPreferences(BitField.of((Enum)FsOutputOption.COMPRESS));
            Assert.assertFalse((boolean)c.isLenient());
            Assert.assertTrue((boolean)c.getInputPreferences().isEmpty());
            Assert.assertThat((Object)c.getOutputPreferences(), (Matcher)CoreMatchers.is((Object)BitField.of((Enum)FsOutputOption.COMPRESS)));
            c.setOutputPreferences(BitField.of((Enum)FsOutputOption.GROW));
            Assert.assertFalse((boolean)c.isLenient());
            Assert.assertTrue((boolean)c.getInputPreferences().isEmpty());
            Assert.assertThat((Object)c.getOutputPreferences(), (Matcher)CoreMatchers.is((Object)BitField.of((Enum)FsOutputOption.GROW)));
            c.setOutputPreferences(BitField.of((Enum)FsOutputOption.CACHE, (Enum[])new FsOutputOption[]{FsOutputOption.CREATE_PARENTS, FsOutputOption.COMPRESS}));
            Assert.assertTrue((boolean)c.isLenient());
            Assert.assertTrue((boolean)c.getInputPreferences().isEmpty());
            Assert.assertThat((Object)c.getOutputPreferences(), (Matcher)CoreMatchers.is((Object)BitField.of((Enum)FsOutputOption.CACHE, (Enum[])new FsOutputOption[]{FsOutputOption.CREATE_PARENTS, FsOutputOption.COMPRESS})));
            c.setOutputPreferences(BitField.of((Enum)FsOutputOption.CREATE_PARENTS));
            try {
                c.setOutputPreferences(BitField.of((Enum)FsOutputOption.STORE, (Enum[])new FsOutputOption[]{FsOutputOption.COMPRESS}));
                Assert.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            Assert.assertTrue((boolean)c.isLenient());
            Assert.assertTrue((boolean)c.getInputPreferences().isEmpty());
            Assert.assertThat((Object)c.getOutputPreferences(), (Matcher)CoreMatchers.is((Object)BitField.of((Enum)FsOutputOption.CREATE_PARENTS)));
        }
        finally {
            c.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void standardUseCase() {
        TFile f1 = new TFile("file.mok");
        Assert.assertFalse((boolean)f1.isArchive());
        TConfig c = TConfig.push();
        try {
            c.setArchiveDetector(new TArchiveDetector("mok", (FsDriver)new MockArchiveDriver()));
            TFile f2 = new TFile("file.mok");
            Assert.assertTrue((boolean)f2.isArchive());
        }
        finally {
            c.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void advancedUseCase() {
        MockArchiveDriver d = new MockArchiveDriver();
        TConfig c1 = TConfig.get();
        Assert.assertThat((Object)TConfig.get(), (Matcher)CoreMatchers.sameInstance((Object)c1));
        TArchiveDetector ad1 = c1.getArchiveDetector();
        Assert.assertThat((Object)c1.getArchiveDetector(), (Matcher)CoreMatchers.sameInstance((Object)ad1));
        TArchiveDetector ad2 = new TArchiveDetector("mok", (FsDriver)d);
        TConfig c2 = TConfig.push();
        try {
            c2.setArchiveDetector(ad2);
            Assert.assertThat((Object)TConfig.get(), (Matcher)CoreMatchers.sameInstance((Object)c2));
            Assert.assertThat((Object)c2.getArchiveDetector(), (Matcher)CoreMatchers.sameInstance((Object)ad2));
            TArchiveDetector ad3 = new TArchiveDetector("mok", (FsDriver)d);
            TConfig c3 = TConfig.push();
            try {
                c3.setArchiveDetector(ad3);
                Assert.assertThat((Object)TConfig.get(), (Matcher)CoreMatchers.sameInstance((Object)c3));
                Assert.assertThat((Object)c3.getArchiveDetector(), (Matcher)CoreMatchers.sameInstance((Object)ad3));
            }
            finally {
                c3.close();
            }
            Assert.assertThat((Object)TConfig.get(), (Matcher)CoreMatchers.sameInstance((Object)c2));
            Assert.assertThat((Object)c2.getArchiveDetector(), (Matcher)CoreMatchers.sameInstance((Object)ad2));
        }
        finally {
            c2.close();
        }
        Assert.assertThat((Object)TConfig.get(), (Matcher)CoreMatchers.sameInstance((Object)c1));
        Assert.assertThat((Object)c1.getArchiveDetector(), (Matcher)CoreMatchers.sameInstance((Object)ad1));
    }
}

