/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.file;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.file.ExpertFeature;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TBIO;
import de.schlichtherle.truezip.file.TConfig;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TFileOutputStream;
import de.schlichtherle.truezip.file.TVFS;
import de.schlichtherle.truezip.fs.FsArchiveDriver;
import de.schlichtherle.truezip.fs.FsCompositeDriver;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDriver;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsPath;
import de.schlichtherle.truezip.fs.FsScheme;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.FsSyncOptions;
import de.schlichtherle.truezip.fs.FsUriModifier;
import de.schlichtherle.truezip.io.Paths;
import de.schlichtherle.truezip.io.Streams;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.JSE7;
import de.schlichtherle.truezip.util.UriBuilder;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;
import javax.swing.Icon;

@Immutable
public final class TFile
extends File {
    private static final long serialVersionUID = 3617072259051821745L;
    private static final String UNC_PREFIX = separator + separator;
    private static final Set<File> ROOTS = Collections.unmodifiableSet(new TreeSet<File>(Arrays.asList(TFile.listRoots())));
    private static final File CURRENT_DIRECTORY = new File(".");
    private transient File file;
    private transient TArchiveDetector detector;
    @CheckForNull
    private transient TFile innerArchive;
    @CheckForNull
    private transient TFile enclArchive;
    @CheckForNull
    private transient FsEntryName enclEntryName;
    @CheckForNull
    @SuppressWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
    private volatile transient FsController<?> controller;

    public TFile(File file) {
        this(file, (TArchiveDetector)null);
    }

    @ExpertFeature(value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public TFile(File file, @CheckForNull TArchiveDetector detector) {
        super(file.getPath());
        if (file instanceof TFile) {
            TFile tfile = (TFile)file;
            this.file = tfile.file;
            this.detector = tfile.detector;
            this.enclArchive = tfile.enclArchive;
            this.enclEntryName = tfile.enclEntryName;
            this.innerArchive = tfile.isArchive() ? this : tfile.innerArchive;
            this.controller = tfile.controller;
        } else {
            this.file = file;
            this.detector = null != detector ? detector : TConfig.get().getArchiveDetector();
            this.scan(null);
        }
        assert (this.invariants());
    }

    public TFile(String path) {
        this(path, (TArchiveDetector)null);
    }

    @ExpertFeature(value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public TFile(String path, @CheckForNull TArchiveDetector detector) {
        super(path);
        this.file = new File(path);
        this.detector = null != detector ? detector : TConfig.get().getArchiveDetector();
        this.scan(null);
        assert (this.invariants());
    }

    public TFile(@CheckForNull String parent, String member) {
        this(parent, member, null);
    }

    @ExpertFeature(value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public TFile(@CheckForNull String parent, String member, @CheckForNull TArchiveDetector detector) {
        super(parent, member);
        this.file = new File(parent, member);
        this.detector = null != detector ? detector : TConfig.get().getArchiveDetector();
        this.scan(null);
        assert (this.invariants());
    }

    public TFile(@CheckForNull File parent, String member) {
        this(parent, member, null);
    }

    @ExpertFeature(value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public TFile(@CheckForNull File parent, String member, @CheckForNull TArchiveDetector detector) {
        super(parent, member);
        this.file = new File(parent, member);
        if (parent instanceof TFile) {
            TFile p = (TFile)parent;
            this.detector = null != detector ? detector : p.detector;
            this.scan(p);
        } else {
            this.detector = null != detector ? detector : TConfig.get().getArchiveDetector();
            this.scan(null);
        }
        assert (this.invariants());
    }

    public TFile(URI uri) {
        this(FsPath.create((URI)uri, (FsUriModifier)FsUriModifier.CANONICALIZE), null);
    }

    public TFile(FsPath path) {
        this(path, null);
    }

    @ExpertFeature(value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public TFile(FsPath path, @CheckForNull TArchiveDetector detector) {
        super(path.toHierarchicalUri());
        this.parse(path, null != detector ? detector : TConfig.get().getArchiveDetector());
    }

    private void parse(FsPath path, TArchiveDetector detector) {
        this.file = new File(super.getPath());
        this.detector = detector;
        FsMountPoint mp = path.getMountPoint();
        FsPath mpp = mp.getPath();
        if (null == mpp) {
            assert (!path.toUri().isOpaque());
            this.enclArchive = null;
            this.enclEntryName = null;
            this.innerArchive = null;
        } else {
            FsEntryName en = path.getEntryName();
            if (en.isRoot()) {
                assert (path.toUri().isOpaque());
                if (mpp.toUri().isOpaque()) {
                    this.enclArchive = new TFile(mpp.getMountPoint(), detector);
                    this.enclEntryName = mpp.getEntryName();
                } else {
                    this.enclArchive = null;
                    this.enclEntryName = null;
                }
                this.innerArchive = this;
                this.controller = this.getController(mp);
            } else {
                assert (path.toUri().isOpaque());
                this.enclArchive = new TFile(mp, detector);
                this.enclEntryName = en;
                this.innerArchive = this.enclArchive;
            }
        }
        assert (this.invariants());
    }

    private TFile(FsMountPoint mountPoint, TArchiveDetector detector) {
        super(mountPoint.toHierarchicalUri());
        this.file = new File(super.getPath());
        this.detector = detector;
        FsPath mpp = mountPoint.getPath();
        if (null == mpp) {
            assert (!mountPoint.toUri().isOpaque());
            this.enclArchive = null;
            this.enclEntryName = null;
            this.innerArchive = null;
        } else {
            assert (mountPoint.toUri().isOpaque());
            if (mpp.toUri().isOpaque()) {
                this.enclArchive = new TFile(mpp.getMountPoint(), detector);
                this.enclEntryName = mpp.getEntryName();
            } else {
                this.enclArchive = null;
                this.enclEntryName = null;
            }
            this.innerArchive = this;
            this.controller = this.getController(mountPoint);
        }
        assert (this.invariants());
    }

    private TFile(File file, @CheckForNull TFile innerArchive, TArchiveDetector detector) {
        super(file.getPath());
        this.file = file;
        String path = file.getPath();
        if (null != innerArchive) {
            int iapl = innerArchive.getPath().length();
            if (path.length() == iapl) {
                this.detector = innerArchive.detector;
                this.enclArchive = innerArchive.enclArchive;
                this.enclEntryName = innerArchive.enclEntryName;
                this.innerArchive = this;
                this.controller = innerArchive.controller;
            } else {
                this.detector = detector;
                this.innerArchive = this.enclArchive = innerArchive;
                try {
                    this.enclEntryName = new FsEntryName(new UriBuilder().path(path.substring(iapl + 1).replace(separatorChar, '/')).getUri(), FsUriModifier.CANONICALIZE);
                }
                catch (URISyntaxException ex) {
                    throw new AssertionError((Object)ex);
                }
            }
        } else {
            this.detector = detector;
        }
        assert (this.invariants());
    }

    private void scan(@CheckForNull TFile ancestor) {
        String path = super.getPath();
        assert (ancestor == null || path.startsWith(ancestor.getPath()));
        assert (this.file.getPath().equals(path));
        assert (null != this.detector);
        StringBuilder enclEntryNameBuf = new StringBuilder(path.length());
        this.scan(ancestor, this.detector, 0, path, enclEntryNameBuf, new Paths.Splitter(separatorChar, false));
        try {
            this.enclEntryName = 0 >= enclEntryNameBuf.length() ? null : new FsEntryName(new UriBuilder().path(enclEntryNameBuf.toString()).getUri(), FsUriModifier.CANONICALIZE);
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private void scan(@CheckForNull TFile ancestor, TArchiveDetector detector, int skip, String path, StringBuilder enclEntryNameBuf, Paths.Splitter splitter) {
        if (path == null) {
            assert (null == this.enclArchive);
            enclEntryNameBuf.setLength(0);
            return;
        }
        splitter.split(path);
        String parent = splitter.getParentPath();
        String member = splitter.getMemberName();
        if (0 != member.length() && !".".equals(member)) {
            if ("..".equals(member)) {
                ++skip;
            } else if (0 < skip) {
                --skip;
            } else {
                boolean isArchive;
                if (null != ancestor) {
                    int ancestorPathLen;
                    int pathLen = path.length();
                    if (pathLen == (ancestorPathLen = ancestor.getPath().length())) {
                        this.enclArchive = ancestor.innerArchive;
                        if (!ancestor.isArchive()) {
                            if (ancestor.isEntry()) {
                                assert (null != ancestor.enclEntryName);
                                if (0 < enclEntryNameBuf.length()) {
                                    enclEntryNameBuf.insert(0, '/');
                                    enclEntryNameBuf.insert(0, ancestor.enclEntryName.getPath());
                                } else {
                                    assert (this.enclArchive == ancestor.enclArchive);
                                    enclEntryNameBuf.append(ancestor.enclEntryName.getPath());
                                }
                            } else {
                                assert (null == this.enclArchive);
                                enclEntryNameBuf.setLength(0);
                            }
                        } else if (0 >= enclEntryNameBuf.length()) {
                            assert (this.enclArchive == ancestor);
                            this.innerArchive = this;
                            this.enclArchive = ancestor.enclArchive;
                            if (ancestor.enclEntryName != null) {
                                enclEntryNameBuf.append(ancestor.enclEntryName.getPath());
                            }
                        }
                        if (this != this.innerArchive) {
                            this.innerArchive = this.enclArchive;
                        }
                        return;
                    }
                    if (pathLen < ancestorPathLen) {
                        detector = ancestor.detector;
                        ancestor = ancestor.enclArchive;
                    }
                }
                boolean bl = isArchive = null != detector.getScheme(path);
                if (0 < enclEntryNameBuf.length()) {
                    if (isArchive) {
                        this.enclArchive = new TFile(path, detector);
                        if (this.innerArchive != this) {
                            this.innerArchive = this.enclArchive;
                        }
                        return;
                    }
                    enclEntryNameBuf.insert(0, '/');
                    enclEntryNameBuf.insert(0, member);
                } else {
                    if (isArchive) {
                        this.innerArchive = this;
                    }
                    enclEntryNameBuf.append(member);
                }
            }
        }
        this.scan(ancestor, detector, skip, parent, enclEntryNameBuf, splitter);
    }

    private Object writeReplace() throws ObjectStreamException {
        return this.getAbsoluteFile();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.toURI());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.parse(FsPath.create((URI)((URI)in.readObject()), (FsUriModifier)FsUriModifier.CANONICALIZE), TConfig.get().getArchiveDetector());
    }

    private boolean invariants() {
        File file = this.file;
        TFile innerArchive = this.innerArchive;
        TFile enclArchive = this.enclArchive;
        FsEntryName enclEntryName = this.enclEntryName;
        assert (null != file);
        assert (!(file instanceof TFile));
        assert (file.getPath().equals(super.getPath()));
        assert (null != this.detector);
        assert (null != innerArchive == (this.getInnerEntryName() != null));
        assert (null != enclArchive == (enclEntryName != null));
        assert (this != enclArchive);
        assert (this == innerArchive ^ (innerArchive == enclArchive && null == this.controller));
        assert (null == enclArchive || Paths.contains((String)enclArchive.getPath(), (String)file.getParentFile().getPath(), (char)separatorChar) && !enclEntryName.toString().isEmpty());
        return true;
    }

    @Deprecated
    public static void sync(BitField<FsSyncOption> options) throws FsSyncException {
        TVFS.sync(options);
    }

    @Deprecated
    public static void sync(TFile archive, BitField<FsSyncOption> options) throws FsSyncException {
        if (!archive.isArchive()) {
            throw new IllegalArgumentException(archive + " (not an archive file)");
        }
        if (null != archive.getEnclArchive()) {
            throw new IllegalArgumentException(archive + " (not a top level archive file)");
        }
        TVFS.sync(archive, options);
    }

    @Deprecated
    public static void umount() throws FsSyncException {
        TVFS.umount();
    }

    @Deprecated
    public static void umount(boolean forceCloseInputAndOutput) throws FsSyncException {
        TVFS.sync((BitField<FsSyncOption>)BitField.of((Enum)FsSyncOption.CLEAR_CACHE).set((Enum)FsSyncOption.FORCE_CLOSE_INPUT, forceCloseInputAndOutput).set((Enum)FsSyncOption.FORCE_CLOSE_OUTPUT, forceCloseInputAndOutput));
    }

    @Deprecated
    public static void umount(boolean waitCloseInput, boolean forceCloseInput, boolean waitCloseOutput, boolean forceCloseOutput) throws FsSyncException {
        TVFS.sync((BitField<FsSyncOption>)BitField.of((Enum)FsSyncOption.CLEAR_CACHE).set((Enum)FsSyncOption.WAIT_CLOSE_INPUT, waitCloseInput).set((Enum)FsSyncOption.FORCE_CLOSE_INPUT, forceCloseInput).set((Enum)FsSyncOption.WAIT_CLOSE_OUTPUT, waitCloseOutput).set((Enum)FsSyncOption.FORCE_CLOSE_OUTPUT, forceCloseOutput));
    }

    @Deprecated
    public static void umount(TFile archive) throws FsSyncException {
        TFile.sync(archive, (BitField<FsSyncOption>)FsSyncOptions.UMOUNT);
    }

    @Deprecated
    public static void umount(TFile archive, boolean forceCloseInputAndOutput) throws FsSyncException {
        TFile.sync(archive, (BitField<FsSyncOption>)BitField.of((Enum)FsSyncOption.CLEAR_CACHE).set((Enum)FsSyncOption.FORCE_CLOSE_INPUT, forceCloseInputAndOutput).set((Enum)FsSyncOption.FORCE_CLOSE_OUTPUT, forceCloseInputAndOutput));
    }

    @Deprecated
    public static void umount(TFile archive, boolean waitCloseInput, boolean forceCloseInput, boolean waitCloseOutput, boolean forceCloseOutput) throws FsSyncException {
        TFile.sync(archive, (BitField<FsSyncOption>)BitField.of((Enum)FsSyncOption.CLEAR_CACHE).set((Enum)FsSyncOption.WAIT_CLOSE_INPUT, waitCloseInput).set((Enum)FsSyncOption.FORCE_CLOSE_INPUT, forceCloseInput).set((Enum)FsSyncOption.WAIT_CLOSE_OUTPUT, waitCloseOutput).set((Enum)FsSyncOption.FORCE_CLOSE_OUTPUT, forceCloseOutput));
    }

    @Deprecated
    public static boolean isLenient() {
        return TConfig.get().isLenient();
    }

    @Deprecated
    public static void setLenient(boolean lenient) {
        TConfig.get().setLenient(lenient);
    }

    @Deprecated
    public static TArchiveDetector getDefaultArchiveDetector() {
        return TConfig.get().getArchiveDetector();
    }

    @Deprecated
    public static void setDefaultArchiveDetector(TArchiveDetector detector) {
        TConfig.get().setArchiveDetector(detector);
    }

    @ExpertFeature(level=ExpertFeature.Level.INTERMEDIATE, value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public TFile toNonArchiveFile() {
        return this.isArchive() ? new TFile((File)this.getParentFile(), this.getName(), TArchiveDetector.NULL) : this;
    }

    @Nullable
    public TFile getNonArchivedParentFile() {
        TFile enclArchive = this.enclArchive;
        return null != enclArchive ? enclArchive.getNonArchivedParentFile() : this.getParentFile();
    }

    @Override
    @Nullable
    public String getParent() {
        return this.file.getParent();
    }

    @Override
    @Nullable
    public TFile getParentFile() {
        File parent = this.file.getParentFile();
        if (parent == null) {
            return null;
        }
        TFile enclArchive = this.enclArchive;
        if (null != enclArchive && enclArchive.getPath().length() == parent.getPath().length()) {
            assert (enclArchive.getPath().equals(parent.getPath()));
            return enclArchive;
        }
        return new TFile(parent, enclArchive, this.detector);
    }

    @Override
    public TFile getAbsoluteFile() {
        String p = this.getAbsolutePath();
        return p.equals(this.getPath()) ? this : new TFile(p, this.detector);
    }

    @Override
    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    public TFile getNormalizedAbsoluteFile() {
        String p = this.getNormalizedAbsolutePath();
        return p.equals(this.getPath()) ? this : new TFile(p, this.detector);
    }

    public String getNormalizedAbsolutePath() {
        return Paths.normalize((String)this.getAbsolutePath(), (char)separatorChar);
    }

    public TFile getNormalizedFile() {
        String p = this.getNormalizedPath();
        return p.equals(this.getPath()) ? this : new TFile(p, this.detector);
    }

    public String getNormalizedPath() {
        return Paths.normalize((String)this.getPath(), (char)separatorChar);
    }

    @Override
    public TFile getCanonicalFile() throws IOException {
        String p = this.getCanonicalPath();
        return p.equals(this.getPath()) ? this : new TFile(p, this.detector);
    }

    @Override
    public String getCanonicalPath() throws IOException {
        return this.file.getCanonicalPath();
    }

    public TFile getCanOrAbsFile() {
        String p = this.getCanOrAbsPath();
        return p.equals(this.getPath()) ? this : new TFile(p, this.detector);
    }

    public String getCanOrAbsPath() {
        try {
            return this.getCanonicalPath();
        }
        catch (IOException ex) {
            return Paths.normalize((String)this.getAbsolutePath(), (char)separatorChar);
        }
    }

    @Override
    public String getPath() {
        return this.file.getPath();
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    public TArchiveDetector getArchiveDetector() {
        return this.detector;
    }

    public boolean isArchive() {
        return this == this.innerArchive;
    }

    public boolean isEntry() {
        return this.enclEntryName != null;
    }

    @CheckForNull
    public TFile getInnerArchive() {
        return this.innerArchive;
    }

    @Nullable
    public String getInnerEntryName() {
        FsEntryName enclEntryName;
        return this == this.innerArchive ? FsEntryName.ROOT.getPath() : (null == (enclEntryName = this.enclEntryName) ? null : enclEntryName.getPath());
    }

    @Nullable
    FsEntryName getInnerFsEntryName() {
        return this == this.innerArchive ? FsEntryName.ROOT : this.enclEntryName;
    }

    @CheckForNull
    public TFile getEnclArchive() {
        return this.enclArchive;
    }

    @Nullable
    public String getEnclEntryName() {
        return null == this.enclEntryName ? null : this.enclEntryName.getPath();
    }

    @Nullable
    FsEntryName getEnclFsEntryName() {
        return this.enclEntryName;
    }

    public boolean isTopLevelArchive() {
        return this.getTopLevelArchive() == this;
    }

    @Nullable
    public TFile getTopLevelArchive() {
        TFile enclArchive = this.enclArchive;
        return null != enclArchive ? enclArchive.getTopLevelArchive() : this.innerArchive;
    }

    @Deprecated
    public File getFile() {
        return this.file;
    }

    @Nullable
    FsController<?> getController() {
        FsMountPoint mountPoint;
        FsController<?> controller = this.controller;
        if (this != this.innerArchive || null != controller) {
            return controller;
        }
        File file = this.file;
        String path = Paths.normalize((String)file.getPath(), (char)separatorChar);
        FsScheme scheme = this.detector.getScheme(path);
        if (null == scheme) {
            throw new ServiceConfigurationError("Unknown file system scheme for path \"" + path + "\"! Check run-time class path configuration.");
        }
        try {
            TFile enclArchive = this.enclArchive;
            FsEntryName enclEntryName = this.enclEntryName;
            assert (null != enclArchive == (null != enclEntryName));
            mountPoint = new FsMountPoint(scheme, null == enclArchive ? new FsPath(file) : new FsPath(enclArchive.getController().getModel().getMountPoint(), enclEntryName));
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
        this.controller = this.getController(mountPoint);
        return this.controller;
    }

    private FsController<?> getController(FsMountPoint mountPoint) {
        return TConfig.get().getFsManager().getController(mountPoint, (FsCompositeDriver)this.detector);
    }

    public boolean isParentOf(File file) {
        String a = this.getAbsolutePath();
        String b = file.getAbsoluteFile().getParent();
        return b != null ? Paths.contains((String)a, (String)b, (char)separatorChar) : false;
    }

    @Override
    public boolean isAbsolute() {
        return this.file.isAbsolute();
    }

    @Override
    public boolean isHidden() {
        return this.file.isHidden();
    }

    public boolean contains(File file) {
        return TFile.contains(this, file);
    }

    public static boolean contains(File a, File b) {
        return Paths.contains((String)a.getAbsolutePath(), (String)b.getAbsolutePath(), (char)separatorChar);
    }

    public boolean isFileSystemRoot() {
        TFile canOrAbsFile = this.getCanOrAbsFile();
        return ROOTS.contains(canOrAbsFile) || TFile.isUNC(canOrAbsFile.getPath());
    }

    public boolean isUNC() {
        return TFile.isUNC(this.getCanOrAbsPath());
    }

    private static boolean isUNC(String path) {
        return path.startsWith(UNC_PREFIX) && path.indexOf(separatorChar, 2) > 2;
    }

    @Override
    public int hashCode() {
        return this.file.hashCode();
    }

    @Override
    public boolean equals(Object that) {
        return this.file.equals(that);
    }

    @Override
    public int compareTo(File that) {
        return this.file.compareTo(that);
    }

    @Override
    public String toString() {
        return this.file.toString();
    }

    @Override
    @Deprecated
    public URL toURL() throws MalformedURLException {
        return null != this.innerArchive ? this.toURI().toURL() : this.file.toURL();
    }

    @Override
    public URI toURI() {
        try {
            if (this == this.innerArchive) {
                FsScheme scheme = this.getScheme();
                if (null != this.enclArchive) {
                    assert (null != this.enclEntryName);
                    return new FsMountPoint(scheme, new FsPath(new FsMountPoint(this.enclArchive.toURI(), FsUriModifier.CANONICALIZE), this.enclEntryName)).toUri();
                }
                return new FsMountPoint(scheme, new FsPath(this.file)).toUri();
            }
            if (null != this.enclArchive) {
                assert (null != this.enclEntryName);
                return new FsPath(new FsMountPoint(this.enclArchive.toURI(), FsUriModifier.CANONICALIZE), this.enclEntryName).toUri();
            }
            return this.file.toURI();
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public FsPath toFsPath() {
        try {
            if (this == this.innerArchive) {
                FsScheme scheme = this.getScheme();
                if (null != this.enclArchive) {
                    assert (null != this.enclEntryName);
                    return new FsPath(new FsMountPoint(scheme, new FsPath(new FsMountPoint(this.enclArchive.toURI(), FsUriModifier.CANONICALIZE), this.enclEntryName)), FsEntryName.ROOT);
                }
                return new FsPath(new FsMountPoint(scheme, new FsPath(this.file)), FsEntryName.ROOT);
            }
            if (null != this.enclArchive) {
                assert (null != this.enclEntryName);
                return new FsPath(new FsMountPoint(this.enclArchive.toURI(), FsUriModifier.CANONICALIZE), this.enclEntryName);
            }
            return new FsPath(this.file);
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    @Nullable
    private FsScheme getScheme() {
        if (this != this.innerArchive) {
            return null;
        }
        FsController<?> controller = this.controller;
        if (null != controller) {
            return controller.getModel().getMountPoint().getScheme();
        }
        return this.detector.getScheme(this.file.getPath());
    }

    @Override
    @Deprecated
    public Path toPath() {
        throw new UnsupportedOperationException("Use a Path constructor or method instead!");
    }

    @Override
    public boolean exists() {
        if (null != this.innerArchive) {
            try {
                FsEntry entry = this.innerArchive.getController().getEntry(this.getInnerFsEntryName());
                return null != entry;
            }
            catch (IOException ex) {
                return false;
            }
        }
        return this.file.exists();
    }

    @Override
    public boolean isFile() {
        if (null != this.innerArchive) {
            try {
                FsEntry entry = this.innerArchive.getController().getEntry(this.getInnerFsEntryName());
                return null != entry && entry.isType(Entry.Type.FILE);
            }
            catch (IOException ex) {
                return false;
            }
        }
        return this.file.isFile();
    }

    @Override
    public boolean isDirectory() {
        if (null != this.innerArchive) {
            try {
                FsEntry entry = this.innerArchive.getController().getEntry(this.getInnerFsEntryName());
                return null != entry && entry.isType(Entry.Type.DIRECTORY);
            }
            catch (IOException ex) {
                return false;
            }
        }
        return this.file.isDirectory();
    }

    @Deprecated
    @CheckForNull
    public Icon getOpenIcon() {
        return this.isArchive() ? ((FsArchiveDriver)this.getDriver(this.getScheme())).getOpenIcon(this.getController().getModel()) : null;
    }

    @Deprecated
    @CheckForNull
    public Icon getClosedIcon() {
        return this.isArchive() ? ((FsArchiveDriver)this.getDriver(this.getScheme())).getClosedIcon(this.getController().getModel()) : null;
    }

    @Nullable
    private FsDriver getDriver(FsScheme scheme) {
        return this.detector.get().get(scheme);
    }

    @Override
    public boolean canRead() {
        if (null != this.innerArchive) {
            try {
                return this.innerArchive.getController().isReadable(this.getInnerFsEntryName());
            }
            catch (IOException ex) {
                return false;
            }
        }
        return this.file.canRead();
    }

    @Override
    public boolean canWrite() {
        if (null != this.innerArchive) {
            try {
                return this.innerArchive.getController().isWritable(this.getInnerFsEntryName());
            }
            catch (IOException ex) {
                return false;
            }
        }
        return this.file.canWrite();
    }

    @Override
    public boolean canExecute() {
        if (null != this.innerArchive) {
            try {
                return this.innerArchive.getController().isExecutable(this.getInnerFsEntryName());
            }
            catch (IOException ex) {
                return false;
            }
        }
        return this.file.canExecute();
    }

    @Override
    public boolean setReadOnly() {
        if (null != this.innerArchive) {
            try {
                this.innerArchive.getController().setReadOnly(this.getInnerFsEntryName());
                return true;
            }
            catch (IOException ex) {
                return false;
            }
        }
        return this.file.setReadOnly();
    }

    @Override
    public long length() {
        if (null != this.innerArchive) {
            FsEntry entry;
            try {
                entry = this.innerArchive.getController().getEntry(this.getInnerFsEntryName());
            }
            catch (IOException ex) {
                return 0L;
            }
            if (null == entry) {
                return 0L;
            }
            long size = entry.getSize(Entry.Size.DATA);
            return -1L != size ? size : 0L;
        }
        return this.file.length();
    }

    @Override
    public long lastModified() {
        if (null != this.innerArchive) {
            FsEntry entry;
            try {
                entry = this.innerArchive.getController().getEntry(this.getInnerFsEntryName());
            }
            catch (IOException ex) {
                return 0L;
            }
            if (null == entry) {
                return 0L;
            }
            long time = entry.getTime(Entry.Access.WRITE);
            return -1L != time ? time : 0L;
        }
        return this.file.lastModified();
    }

    @Override
    public boolean setLastModified(long time) {
        if (null != this.innerArchive) {
            try {
                this.innerArchive.getController().setTime(this.getInnerFsEntryName(), BitField.of((Enum)Entry.Access.WRITE), time, TConfig.get().getOutputPreferences());
                return true;
            }
            catch (IOException ex) {
                return false;
            }
        }
        return this.file.setLastModified(time);
    }

    @Override
    @Nullable
    public String[] list() {
        if (null != this.innerArchive) {
            FsEntry entry;
            try {
                entry = this.innerArchive.getController().getEntry(this.getInnerFsEntryName());
            }
            catch (IOException ex) {
                return null;
            }
            if (null == entry) {
                return null;
            }
            Set members = entry.getMembers();
            return null == members ? null : members.toArray(new String[members.size()]);
        }
        return this.file.list();
    }

    @Override
    @Nullable
    public String[] list(@CheckForNull FilenameFilter filter) {
        if (null != this.innerArchive) {
            FsEntry entry;
            try {
                entry = this.innerArchive.getController().getEntry(this.getInnerFsEntryName());
            }
            catch (IOException ex) {
                return null;
            }
            Set<String> members = TFile.members(entry);
            if (null == members) {
                return null;
            }
            if (null == filter) {
                return members.toArray(new String[members.size()]);
            }
            ArrayList<String> accepted = new ArrayList<String>(members.size());
            for (String member : members) {
                if (!filter.accept(this, member)) continue;
                accepted.add(member);
            }
            return accepted.toArray(new String[accepted.size()]);
        }
        return this.file.list(filter);
    }

    @Nullable
    public TFile[] listFiles() {
        return this.listFiles((FilenameFilter)null, this.detector);
    }

    @Nullable
    @ExpertFeature(value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public TFile[] listFiles(TArchiveDetector detector) {
        return this.listFiles((FilenameFilter)null, detector);
    }

    @Nullable
    public TFile[] listFiles(@CheckForNull FilenameFilter filter) {
        return this.listFiles(filter, this.detector);
    }

    @Nullable
    @ExpertFeature(value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public TFile[] listFiles(@CheckForNull FilenameFilter filter, TArchiveDetector detector) {
        if (null != this.innerArchive) {
            FsEntry entry;
            try {
                entry = this.innerArchive.getController().getEntry(this.getInnerFsEntryName());
            }
            catch (IOException ex) {
                return null;
            }
            return this.filter(TFile.members(entry), filter, detector);
        }
        return this.filter(TFile.list(this.file.list(filter)), (FilenameFilter)null, detector);
    }

    @CheckForNull
    private static Set<String> members(@CheckForNull FsEntry entry) {
        return null == entry ? null : entry.getMembers();
    }

    @CheckForNull
    private static List<String> list(@CheckForNull String[] list) {
        return null == list ? null : Arrays.asList(list);
    }

    @Nullable
    private TFile[] filter(@CheckForNull Collection<String> members, @CheckForNull FilenameFilter filter, TArchiveDetector detector) {
        if (null == members) {
            return null;
        }
        if (null != filter) {
            ArrayList<TFile> accepted = new ArrayList<TFile>(members.size());
            for (String member : members) {
                if (!filter.accept(this, member)) continue;
                accepted.add(new TFile((File)this, member, detector));
            }
            return accepted.toArray(new TFile[accepted.size()]);
        }
        TFile[] accepted = new TFile[members.size()];
        int i = 0;
        for (String member : members) {
            accepted[i++] = new TFile((File)this, member, detector);
        }
        return accepted;
    }

    @Nullable
    public TFile[] listFiles(@CheckForNull FileFilter filter) {
        return this.listFiles(filter, this.detector);
    }

    @Nullable
    @ExpertFeature(value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public TFile[] listFiles(@CheckForNull FileFilter filter, TArchiveDetector detector) {
        if (null != this.innerArchive) {
            FsEntry entry;
            try {
                entry = this.innerArchive.getController().getEntry(this.getInnerFsEntryName());
            }
            catch (IOException ex) {
                return null;
            }
            return this.filter(TFile.members(entry), filter, detector);
        }
        return this.filter(TFile.list(this.file.list()), filter, detector);
    }

    @Nullable
    private TFile[] filter(@CheckForNull Collection<String> members, @CheckForNull FileFilter filter, TArchiveDetector detector) {
        if (null == members) {
            return null;
        }
        if (null != filter) {
            ArrayList<TFile> accepted = new ArrayList<TFile>(members.size());
            for (String member : members) {
                TFile file = new TFile((File)this, member, detector);
                if (!filter.accept(file)) continue;
                accepted.add(file);
            }
            return accepted.toArray(new TFile[accepted.size()]);
        }
        TFile[] accepted = new TFile[members.size()];
        int i = 0;
        for (String member : members) {
            accepted[i++] = new TFile((File)this, member, detector);
        }
        return accepted;
    }

    @Override
    public boolean createNewFile() throws IOException {
        if (null != this.innerArchive) {
            FsEntryName entryName;
            FsController<?> controller = this.innerArchive.getController();
            if (null != controller.getEntry(entryName = this.getInnerFsEntryName())) {
                return false;
            }
            controller.mknod(entryName, Entry.Type.FILE, TConfig.get().getOutputPreferences().set((Enum)FsOutputOption.EXCLUSIVE), null);
            return true;
        }
        return this.file.createNewFile();
    }

    @Override
    public boolean mkdirs() {
        if (null == this.innerArchive) {
            return this.file.mkdirs();
        }
        TFile parent = this.getParentFile();
        if (null != parent && !parent.exists()) {
            parent.mkdirs();
        }
        return this.mkdir();
    }

    @Override
    public boolean mkdir() {
        if (null != this.innerArchive) {
            try {
                this.innerArchive.getController().mknod(this.getInnerFsEntryName(), Entry.Type.DIRECTORY, TConfig.get().getOutputPreferences(), null);
                return true;
            }
            catch (IOException ex) {
                return false;
            }
        }
        return this.file.mkdir();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TFile mkdir(boolean recursive) throws IOException {
        TFile innerArchive = this.innerArchive;
        if (null != innerArchive) {
            TFile parent;
            if (recursive && null != (parent = this.getParentFile()) && !parent.exists()) {
                parent.mkdir(recursive);
            }
            FsController<?> controller = innerArchive.getController();
            FsEntryName innerEntryName = this.getInnerFsEntryName();
            try {
                controller.mknod(innerEntryName, Entry.Type.DIRECTORY, TConfig.get().getOutputPreferences(), null);
                return this;
            }
            catch (IOException ex) {
                FsEntry entry = controller.getEntry(innerEntryName);
                if (null != entry && entry.isType(Entry.Type.DIRECTORY)) return this;
                throw ex;
            }
        } else {
            File dir = this.file;
            if ((!recursive ? dir.mkdir() : dir.mkdirs()) || dir.isDirectory()) return this;
            throw new IOException(dir + " (cannot create directory)");
        }
    }

    @Override
    @Deprecated
    public boolean delete() {
        try {
            TFile.rm(this);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public TFile rm() throws IOException {
        TFile.rm(this);
        return this;
    }

    public static void rm(File node) throws IOException {
        if (node instanceof TFile) {
            TFile file = (TFile)node;
            if (null != file.innerArchive) {
                file.innerArchive.getController().unlink(file.getInnerFsEntryName(), TConfig.get().getOutputPreferences());
                return;
            }
            node = file.file;
        }
        if (!node.delete()) {
            throw new IOException(node + " (cannot delete)");
        }
    }

    public TFile rm_r() throws IOException {
        TBIO.rm_r(this, this.detector);
        return this;
    }

    public static void rm_r(File node) throws IOException {
        TBIO.rm_r(node, node instanceof TFile ? ((TFile)node).detector : TArchiveDetector.NULL);
    }

    @Override
    public void deleteOnExit() {
        if (this.innerArchive != null) {
            throw new UnsupportedOperationException();
        }
        this.file.deleteOnExit();
    }

    @Override
    @Deprecated
    public boolean renameTo(File dst) {
        try {
            TFile.mv(this, dst, this.detector);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public TFile mv(File dst) throws IOException {
        TFile.mv(this, dst, this.detector);
        return this;
    }

    @ExpertFeature(level=ExpertFeature.Level.INTERMEDIATE, value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public static void mv(File src, File dst, TArchiveDetector detector) throws IOException {
        if (detector.toString().isEmpty()) {
            File dstDelegate;
            boolean dstArchived;
            File srcDelegate;
            boolean srcArchived;
            if (src instanceof TFile) {
                TFile srcFile = (TFile)src;
                srcArchived = null != srcFile.innerArchive;
                srcDelegate = srcFile.file;
            } else {
                srcArchived = false;
                srcDelegate = src;
            }
            if (dst instanceof TFile) {
                TFile dstFile = (TFile)dst;
                dstArchived = null != dstFile.innerArchive;
                dstDelegate = dstFile.file;
            } else {
                dstArchived = false;
                dstDelegate = dst;
            }
            if (!srcArchived && !dstArchived) {
                if (srcDelegate.renameTo(dstDelegate)) {
                    return;
                }
                throw new IOException(src + " (cannot move to " + dst + ")");
            }
        }
        TBIO.mv(src, dst, detector);
    }

    public static void cp(@WillClose InputStream in, @WillClose OutputStream out) throws IOException {
        Streams.copy((InputStream)in, (OutputStream)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public static void cp(@WillClose InputStream in, File dst) throws IOException {
        if (null == in) {
            throw new NullPointerException();
        }
        TFileOutputStream out = null;
        try {
            out = new TFileOutputStream(dst);
        }
        finally {
            if (null == out) {
                in.close();
            }
        }
        try {
            TFile.cp(in, (OutputStream)((Object)out));
        }
        catch (IOException ex) {
            TFile.rm(dst);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cp(File src, @WillClose OutputStream out) throws IOException {
        if (null == out) {
            throw new NullPointerException();
        }
        TFileInputStream in = null;
        try {
            in = new TFileInputStream(src);
        }
        finally {
            if (null == in) {
                out.close();
            }
        }
        TFile.cp((InputStream)((Object)in), out);
    }

    public TFile cp(File dst) throws IOException {
        TBIO.cp(false, this, dst);
        return this;
    }

    public static void cp(File src, File dst) throws IOException {
        TBIO.cp(false, src, dst);
    }

    public TFile cp_p(File dst) throws IOException {
        TBIO.cp(true, this, dst);
        return this;
    }

    public static void cp_p(File src, File dst) throws IOException {
        TBIO.cp(true, src, dst);
    }

    public TFile cp_r(File dst) throws IOException {
        TBIO.cp_r(false, this, dst, this.detector, this.detector);
        return this;
    }

    @ExpertFeature(level=ExpertFeature.Level.INTERMEDIATE, value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public static void cp_r(File src, File dst, TArchiveDetector detector) throws IOException {
        TBIO.cp_r(false, src, dst, detector, detector);
    }

    @ExpertFeature(level=ExpertFeature.Level.INTERMEDIATE, value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public static void cp_r(File src, File dst, TArchiveDetector srcDetector, TArchiveDetector dstDetector) throws IOException {
        TBIO.cp_r(false, src, dst, srcDetector, dstDetector);
    }

    public TFile cp_rp(File dst) throws IOException {
        TBIO.cp_r(true, this, dst, this.detector, this.detector);
        return this;
    }

    @ExpertFeature(level=ExpertFeature.Level.INTERMEDIATE, value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public static void cp_rp(File src, File dst, TArchiveDetector detector) throws IOException {
        TBIO.cp_r(true, src, dst, detector, detector);
    }

    @ExpertFeature(level=ExpertFeature.Level.INTERMEDIATE, value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public static void cp_rp(File src, File dst, TArchiveDetector srcDetector, TArchiveDetector dstDetector) throws IOException {
        TBIO.cp_r(true, src, dst, srcDetector, dstDetector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void input(@WillNotClose InputStream in) throws IOException {
        if (null == in) {
            throw new NullPointerException();
        }
        try {
            TFileOutputStream out = new TFileOutputStream(this);
            try {
                Streams.cat((InputStream)in, (OutputStream)((Object)out));
            }
            finally {
                out.close();
            }
        }
        catch (IOException ex) {
            TFile.rm(this);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void output(@WillNotClose OutputStream out) throws IOException {
        if (null == out) {
            throw new NullPointerException();
        }
        TFileInputStream in = new TFileInputStream(this);
        try {
            Streams.cat((InputStream)((Object)in), (OutputStream)out);
        }
        finally {
            in.close();
        }
    }

    public static void cat(@WillNotClose InputStream in, @WillNotClose OutputStream out) throws IOException {
        Streams.cat((InputStream)in, (OutputStream)out);
    }

    public TFile compact() throws IOException {
        if (this.isTopLevelArchive()) {
            TFile.compact(this);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compact(TFile grown) throws IOException {
        assert (grown.isArchive());
        grown = grown.getNormalizedFile();
        assert (grown.isArchive());
        File dir = TFile.getParent(grown);
        String suffix = TFile.getSuffix(grown);
        TConfig config = TConfig.push();
        try {
            config.setOutputPreferences((BitField<FsOutputOption>)config.getOutputPreferences().clear((Enum)FsOutputOption.GROW));
            TFile compact = new TFile(TFile.createTempFile("tzp", suffix, dir));
            compact.rm();
            try {
                grown.cp_rp(compact);
                TVFS.umount(grown);
                TVFS.umount(compact);
                if (!TFile.move(compact.toNonArchiveFile(), grown.toNonArchiveFile())) {
                    throw new IOException(compact + " (cannot move to " + grown + ")");
                }
            }
            catch (IOException ex) {
                block11: {
                    try {
                        compact.rm();
                    }
                    catch (IOException ex2) {
                        if (!JSE7.AVAILABLE) break block11;
                        ex.addSuppressed(ex2);
                    }
                }
                throw ex;
            }
        }
        finally {
            config.close();
        }
    }

    private static File getParent(File file) {
        File parent = file.getParentFile();
        return null != parent ? parent : CURRENT_DIRECTORY;
    }

    @Nullable
    private static String getSuffix(TFile file) {
        FsScheme scheme = file.getScheme();
        return null != scheme ? "." + scheme : null;
    }

    private static boolean move(File src, File dst) {
        return src.exists() && (!dst.exists() || dst.delete()) && src.renameTo(dst);
    }
}

