/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.file.sample;

import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TVFS;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncWarningException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

abstract class Usage {
    private Usage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cat1(String path) throws IOException {
        TFileInputStream in = new TFileInputStream(path);
        try {
            TFile.cat((InputStream)in, (OutputStream)System.out);
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cat2(String path) {
        try {
            TFileInputStream in = new TFileInputStream(path);
            try {
                TFile.cat((InputStream)in, (OutputStream)System.out);
            }
            finally {
                in.close();
            }
        }
        catch (IOException ouch) {
            ouch.printStackTrace();
        }
    }

    void umount1() {
        try {
            TVFS.umount();
        }
        catch (FsSyncException ouch) {
            ouch.sortPriority().printStackTrace();
        }
    }

    void umount2() {
        try {
            TVFS.umount();
        }
        catch (FsSyncException ouch) {
            ouch.sortAppearance().printStackTrace();
        }
    }

    void umount3() {
        try {
            TVFS.umount();
        }
        catch (FsSyncWarningException fsSyncWarningException) {
        }
        catch (FsSyncException ouch) {
            ouch.printStackTrace();
        }
    }

    void performance1() throws IOException {
        String[] names = new String[]{"a", "b", "c"};
        int n = names.length;
        for (int i = 0; i < n; ++i) {
            TFile entry = new TFile("archive.zip", names[i]);
            entry.createNewFile();
            TVFS.umount();
        }
    }

    void performance2() throws IOException {
        String[] names = new String[]{"a", "b", "c"};
        int n = names.length;
        for (int i = 0; i < n; ++i) {
            TFile entry = new TFile("archive.zip", names[i]);
            entry.createNewFile();
        }
        TVFS.umount();
    }

    void performance3() throws IOException {
        String[] names = new String[]{"a", "b", "c"};
        int n = names.length;
        for (int i = 0; i < n; ++i) {
            TFile entry = new TFile("archive.zip", names[i]);
            entry.createNewFile();
            entry.createNewFile();
        }
    }

    void performance4() throws IOException {
        long time = System.currentTimeMillis();
        String[] names = new String[]{"a", "b", "c"};
        int n = names.length;
        for (int i = 0; i < n; ++i) {
            TFile entry = new TFile("archive.zip", names[i]);
            entry.createNewFile();
            entry.setLastModified(time);
        }
    }
}

