/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.file;

import de.schlichtherle.truezip.file.ConfiguredClientTestBase;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileOutputStream;
import de.schlichtherle.truezip.file.TVFS;
import de.schlichtherle.truezip.fs.FsArchiveDriver;
import de.schlichtherle.truezip.fs.FsSyncOptions;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.ConcurrencyUtils;
import de.schlichtherle.truezip.util.JSE7;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Test;

public abstract class ConcurrentSyncITSuite<D extends FsArchiveDriver<?>>
extends ConfiguredClientTestBase<D> {
    private static final String TEMP_FILE_PREFIX = "tzp-sync";
    private static final int NUM_REPEATS = 10;

    @Test
    public void testConcurrentSync() throws Exception {
        Exception ex = null;
        class SyncFactory
        implements ConcurrencyUtils.TaskFactory {
            SyncFactory() {
            }

            public Callable<?> newTask(int threadNum) {
                class Sync
                implements Callable<Void> {
                    Sync() {
                    }

                    @Override
                    public Void call() throws IOException {
                        while (!Thread.interrupted()) {
                            TVFS.sync((BitField)FsSyncOptions.SYNC);
                        }
                        return null;
                    }
                }
                return new Sync();
            }
        }
        ConcurrencyUtils.TaskJoiner sync = ConcurrencyUtils.runConcurrent((int)ConcurrencyUtils.NUM_CPU_THREADS, (ConcurrencyUtils.TaskFactory)new SyncFactory());
        try {
            class RoundTripFactory
            implements ConcurrencyUtils.TaskFactory {
                RoundTripFactory() {
                }

                public Callable<?> newTask(final int threadNum) {
                    class RoundTrip
                    implements Callable<Void> {
                        RoundTrip() {
                        }

                        @Override
                        public Void call() throws Exception {
                            for (int i = 0; i < 10; ++i) {
                                ConcurrentSyncITSuite.this.roundTrip(threadNum);
                            }
                            return null;
                        }
                    }
                    return new RoundTrip();
                }
            }
            ConcurrencyUtils.runConcurrent((int)ConcurrencyUtils.NUM_IO_THREADS, (ConcurrencyUtils.TaskFactory)new RoundTripFactory()).join();
        }
        catch (InterruptedException ex2) {
            ex = ex2;
            throw ex2;
        }
        catch (ExecutionException ex2) {
            ex = ex2;
            throw ex2;
        }
        finally {
            block16: {
                try {
                    sync.cancel();
                    sync.join();
                }
                catch (InterruptedException ex2) {
                    if (null == ex) {
                        throw ex2;
                    }
                    if (JSE7.AVAILABLE) {
                        ex.addSuppressed(ex2);
                    }
                }
                catch (ExecutionException ex2) {
                    if (null == ex) {
                        throw ex2;
                    }
                    if (!JSE7.AVAILABLE) break block16;
                    ex.addSuppressed(ex2);
                }
            }
        }
    }

    void roundTrip(int i) throws IOException {
        TFile archive = this.newTempArchive();
        TFile file = new TFile((File)archive, i + this.getSuffix() + "/" + i);
        this.roundTrip(file);
        archive.rm_r();
    }

    private TFile newTempArchive() throws IOException {
        File temp = File.createTempFile(TEMP_FILE_PREFIX, this.getSuffix()).getCanonicalFile();
        TFile.rm((File)temp);
        return new TFile(temp);
    }

    private void roundTrip(TFile outer) throws IOException {
        TFile inner = new TFile((File)outer.getParentFile(), "inner" + this.getSuffix() + "/" + outer.getName());
        this.create(inner);
        this.check(inner);
        inner.mv((File)outer);
        this.check(outer);
        outer.mv((File)inner);
        this.check(inner);
        inner.rm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void create(TFile file) throws IOException {
        TFileOutputStream out = new TFileOutputStream((File)file);
        try {
            out.write(this.getData());
        }
        finally {
            out.close();
        }
        Assert.assertEquals((long)this.getDataLength(), (long)file.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check(TFile file) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(this.getDataLength());
        try {
            file.output((OutputStream)out);
        }
        finally {
            out.close();
        }
        Assert.assertTrue((boolean)Arrays.equals(this.getData(), out.toByteArray()));
    }
}

