/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.file;

import de.schlichtherle.truezip.file.ConfiguredClientTestBase;
import de.schlichtherle.truezip.file.TConfig;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TFileOutputStream;
import de.schlichtherle.truezip.file.TVFS;
import de.schlichtherle.truezip.fs.FsArchiveDriver;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsResourceOpenException;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.FsSyncOptions;
import de.schlichtherle.truezip.fs.FsSyncWarningException;
import de.schlichtherle.truezip.io.InputClosedException;
import de.schlichtherle.truezip.io.InputException;
import de.schlichtherle.truezip.io.OutputClosedException;
import de.schlichtherle.truezip.util.ArrayHelper;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.ConcurrencyUtils;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public abstract class TFileITSuite<D extends FsArchiveDriver<?>>
extends ConfiguredClientTestBase<D> {
    private static final Logger logger = Logger.getLogger(TFileITSuite.class.getName());
    private static final String TEMP_FILE_PREFIX = "tzp-file";
    private File temp;
    private TFile archive;
    private static final String[] MEMBERS = new String[]{"A directory member", "Another directory member", "Yet another directory member"};

    @Override
    public void setUp() throws IOException {
        super.setUp();
        this.temp = this.createTempFile();
        TFile.rm((File)this.temp);
        this.archive = new TFile(this.temp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() {
        try {
            try {
                this.umount();
            }
            finally {
                this.archive = null;
                File temp = this.temp;
                this.temp = null;
                if (null != temp && temp.exists() && !temp.delete()) {
                    throw new IOException(temp + " (could not delete)");
                }
            }
        }
        catch (IOException ex) {
            logger.log(Level.FINEST, "Failed to clean up test file (this may be just an aftermath):", ex);
        }
        finally {
            super.tearDown();
        }
    }

    protected final TFile getArchive() {
        return this.archive;
    }

    protected final void umount() throws FsSyncException {
        if (null != this.archive) {
            TVFS.umount((TFile)this.archive);
        }
    }

    private File createTempFile() throws IOException {
        return File.createTempFile(TEMP_FILE_PREFIX, this.getSuffix()).getCanonicalFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void createTestFile(TFile file) throws IOException {
        TFileOutputStream out = new TFileOutputStream((File)file);
        try {
            out.write(this.getData());
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void verifyTestFile(TFile file) throws IOException {
        Assert.assertEquals((long)this.getDataLength(), (long)file.length());
        byte[] array = new byte[this.getDataLength()];
        TFileInputStream in = new TFileInputStream((File)file);
        try {
            new DataInputStream((InputStream)in).readFully(array);
        }
        finally {
            in.close();
        }
        Assert.assertArrayEquals((byte[])this.getData(), (byte[])array);
    }

    @Test
    public void testArchiveControllerStateWithInputStream() throws IOException, InterruptedException {
        this.assertArchiveControllerStateWithResource((Factory<Closeable, String, IOException>)new Factory<InputStream, String, IOException>(){

            @Override
            public InputStream create(String entry) throws IOException {
                return new TFileInputStream(entry);
            }
        });
    }

    @Test
    public void testArchiveControllerStateWithOutputStream() throws IOException, InterruptedException {
        this.assertArchiveControllerStateWithResource((Factory<Closeable, String, IOException>)new Factory<OutputStream, String, IOException>(){

            @Override
            public OutputStream create(String entry) throws IOException {
                return new TFileOutputStream(entry);
            }
        });
    }

    private void assertArchiveControllerStateWithResource(Factory<? extends Closeable, ? super String, ? extends IOException> factory) throws IOException, InterruptedException {
        Reference got;
        String entry = this.archive.getPath() + "/entry";
        this.archive = null;
        Assert.assertTrue((boolean)new TFile(entry).createNewFile());
        TVFS.umount((TFile)new TFile(entry).getTopLevelArchive());
        Closeable resource = factory.create(entry);
        ReferenceQueue queue = new ReferenceQueue();
        WeakReference<FsController> expected = new WeakReference<FsController>(new TFile(entry).getInnerArchive().getController(), queue);
        System.gc();
        System.runFinalization();
        Assert.assertNull(queue.remove(50L));
        Assert.assertSame(expected.get(), (Object)new TFile(entry).getInnerArchive().getController());
        resource.close();
        resource = null;
        System.gc();
        System.runFinalization();
        Assert.assertNull(queue.remove(50L));
        Assert.assertSame(expected.get(), (Object)new TFile(entry).getInnerArchive().getController());
        TVFS.umount((TFile)new TFile(entry).getTopLevelArchive());
        do {
            System.gc();
            System.runFinalization();
        } while (null == (got = queue.remove(50L)));
        assert (expected == got);
        assert (null == expected.get());
    }

    @Test
    public final void testFalsePositives() throws IOException {
        this.assertFalsePositive(this.archive);
        TFile entry = new TFile((File)this.archive, "entry" + this.getSuffix());
        Assert.assertTrue((boolean)this.archive.toNonArchiveFile().mkdir());
        this.assertFalsePositive(entry);
        this.archive.rm();
        Assert.assertTrue((boolean)this.archive.mkdir());
        this.assertFalsePositive(entry);
        this.archive.rm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertFalsePositive(TFile file) throws IOException {
        block16: {
            block15: {
                assert (file.isArchive());
                this.createTestFile(file);
                this.createTestFile(file);
                Assert.assertTrue((boolean)file.exists());
                Assert.assertFalse((boolean)file.isDirectory());
                Assert.assertTrue((boolean)file.isFile());
                Assert.assertEquals((long)this.getDataLength(), (long)file.length());
                Assert.assertTrue((file.lastModified() > 0L ? 1 : 0) != 0);
                TFileInputStream in = new TFileInputStream((File)file);
                try {
                    byte[] buf = new byte[this.getDataLength()];
                    Assert.assertTrue((boolean)ArrayHelper.equals((byte[])this.getData(), (int)0, (byte[])buf, (int)0, (int)in.read(buf)));
                }
                finally {
                    in.close();
                }
                this.assertRm(file);
                Assert.assertTrue((boolean)file.toNonArchiveFile().mkdir());
                Assert.assertTrue((boolean)file.exists());
                Assert.assertTrue((boolean)file.isDirectory());
                Assert.assertFalse((boolean)file.isFile());
                Assert.assertTrue((file.lastModified() > 0L ? 1 : 0) != 0);
                try {
                    new TFileInputStream((File)this.archive).close();
                    if ('\\' == File.separatorChar) {
                        Assert.fail();
                    }
                }
                catch (FileNotFoundException ex) {
                    if ('\\' == File.separatorChar || this.archive.isArchive() || this.archive.isEntry()) break block15;
                    throw ex;
                }
            }
            try {
                new TFileOutputStream((File)this.archive).close();
                Assert.fail();
            }
            catch (FileNotFoundException ex) {
                // empty catch block
            }
            this.assertRm(file);
            Assert.assertTrue((boolean)file.mkdir());
            Assert.assertTrue((boolean)file.exists());
            Assert.assertTrue((boolean)file.isDirectory());
            Assert.assertFalse((boolean)file.isFile());
            Assert.assertTrue((file.lastModified() > 0L ? 1 : 0) != 0);
            try {
                new TFileInputStream((File)this.archive).close();
                if ('\\' == File.separatorChar) {
                    Assert.fail();
                }
            }
            catch (FileNotFoundException ex) {
                if ('\\' == File.separatorChar || this.archive.isArchive()) break block16;
                throw ex;
            }
        }
        try {
            new TFileOutputStream((File)this.archive).close();
            Assert.fail();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.assertRm(file);
    }

    private void assertRm(TFile file) throws IOException {
        file.rm();
        Assert.assertFalse((boolean)file.exists());
        Assert.assertFalse((boolean)file.isDirectory());
        Assert.assertFalse((boolean)file.isFile());
        Assert.assertEquals((long)0L, (long)file.length());
        Assert.assertFalse((file.lastModified() > 0L ? 1 : 0) != 0);
    }

    @Test
    public final void testCreateNewFile() throws IOException {
        this.assertCreateNewPlainFile();
        this.assertCreateNewEnhancedFile();
    }

    @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private void assertCreateNewPlainFile() throws IOException {
        File archive = this.createTempFile();
        TFile.rm((File)archive);
        File file1 = new File(archive, "test.txt");
        File file2 = new File(file1, "test.txt");
        try {
            file1.createNewFile();
            Assert.fail((String)"Creating a file in a non-existent directory should throw an IOException!");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.assertCreateNewFile(archive, file1, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private void assertCreateNewEnhancedFile() throws IOException {
        TFile file1 = new TFile((File)this.archive, "test.txt");
        TFile file2 = new TFile((File)file1, "test.txt");
        TConfig config = TConfig.push();
        try {
            config.setLenient(false);
            try {
                file1.createNewFile();
                Assert.fail((String)"Creating a file in a non-existent directory should throw an IOException!");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.assertCreateNewFile((File)this.archive, (File)file1, (File)file2);
        }
        finally {
            config.close();
        }
        this.assertCreateNewFile((File)this.archive, (File)file1, (File)file2);
    }

    @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private void assertCreateNewFile(File dir, File file1, File file2) throws IOException {
        TFile tdir;
        Assert.assertFalse((boolean)dir.exists());
        Assert.assertTrue((boolean)dir.mkdir());
        Assert.assertTrue((boolean)dir.exists());
        Assert.assertTrue((boolean)dir.isDirectory());
        Assert.assertFalse((boolean)dir.isFile());
        if (dir instanceof TFile && ((tdir = (TFile)dir).isArchive() || tdir.isEntry())) {
            Assert.assertEquals((long)0L, (long)dir.length());
        }
        Assert.assertTrue((boolean)file1.createNewFile());
        Assert.assertTrue((boolean)file1.exists());
        Assert.assertFalse((boolean)file1.isDirectory());
        Assert.assertTrue((boolean)file1.isFile());
        Assert.assertEquals((long)0L, (long)file1.length());
        try {
            file2.createNewFile();
            Assert.fail((String)"Creating a file in another file should throw an IOException!");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        TFile.rm((File)file1);
        Assert.assertFalse((boolean)file1.exists());
        Assert.assertFalse((boolean)file1.isDirectory());
        Assert.assertFalse((boolean)file1.isFile());
        Assert.assertEquals((long)0L, (long)file1.length());
        TFile.rm((File)dir);
        Assert.assertFalse((boolean)dir.exists());
        Assert.assertFalse((boolean)dir.isDirectory());
        Assert.assertFalse((boolean)dir.isFile());
        Assert.assertEquals((long)0L, (long)dir.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void testIllegalDirectoryOperations() throws IOException {
        try {
            String[] names = new String[]{"inner" + this.getSuffix(), "dir"};
            TFile file = this.archive;
            for (int i = 0; i <= names.length; ++i) {
                TFile file2 = file.toNonArchiveFile();
                Assert.assertTrue((boolean)file2.mkdir());
                this.assertIllegalDirectoryOperations(file2);
                file2.rm();
                Assert.assertTrue((boolean)file.mkdir());
                this.assertIllegalDirectoryOperations(file);
                if (i >= names.length) continue;
                file = new TFile((File)file, names[i]);
            }
        }
        finally {
            this.archive.rm_r();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertIllegalDirectoryOperations(TFile dir) throws IOException {
        block13: {
            assert (dir.isDirectory());
            try {
                new TFileInputStream((File)dir).close();
                if ('\\' == File.separatorChar) {
                    Assert.fail();
                }
            }
            catch (FileNotFoundException ex) {
                if ('\\' == File.separatorChar || dir.isArchive() || dir.isEntry()) break block13;
                throw ex;
            }
        }
        try {
            new TFileOutputStream((File)dir).close();
            Assert.fail();
        }
        catch (FileNotFoundException ex) {
            // empty catch block
        }
        File tmp = TFile.createTempFile((String)TEMP_FILE_PREFIX, null);
        try {
            try {
                TFile.cp((File)tmp, (File)dir);
                Assert.fail();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                TFile.cp((File)dir, (File)tmp);
                Assert.fail();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            TFile.rm((File)tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void testStrictFileOutputStream() throws IOException {
        TFile file = new TFile((File)this.archive, "test.txt");
        TConfig config = TConfig.push();
        try {
            config.setLenient(false);
            try {
                this.assertFileOutputStream(file);
                Assert.fail((String)"Creating ghost directories should not be allowed when File.isLenient() is false!");
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            Assert.assertTrue((boolean)this.archive.mkdir());
            this.assertFileOutputStream(file);
            this.archive.rm();
        }
        finally {
            config.close();
        }
    }

    @Test
    public final void testLenientFileOutputStream() throws IOException {
        TFile file = new TFile((File)this.archive, "dir/inner" + this.getSuffix() + "/dir/test.txt");
        this.assertFileOutputStream(file);
        try {
            this.archive.rm();
            Assert.fail((String)"directory not empty");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.umount();
        TFile.rm((File)this.archive.toNonArchiveFile());
        Assert.assertFalse((boolean)this.archive.exists());
        Assert.assertFalse((boolean)this.archive.isDirectory());
        Assert.assertFalse((boolean)this.archive.isFile());
        Assert.assertEquals((long)0L, (long)this.archive.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertFileOutputStream(TFile file) throws IOException {
        byte[] message = "Hello World!\r\n".getBytes();
        TFileOutputStream out = new TFileOutputStream((File)file);
        try {
            Assert.assertTrue((boolean)file.exists());
            Assert.assertFalse((boolean)file.isDirectory());
            Assert.assertTrue((boolean)file.isFile());
            Assert.assertEquals((long)0L, (long)file.length());
            out.write(message);
            Assert.assertEquals((long)0L, (long)file.length());
            out.flush();
            Assert.assertEquals((long)0L, (long)file.length());
        }
        finally {
            out.close();
        }
        Assert.assertTrue((boolean)file.exists());
        Assert.assertFalse((boolean)file.isDirectory());
        Assert.assertTrue((boolean)file.isFile());
        Assert.assertEquals((long)message.length, (long)file.length());
        Assert.assertFalse((boolean)file.createNewFile());
        Assert.assertTrue((boolean)file.exists());
        Assert.assertFalse((boolean)file.isDirectory());
        Assert.assertTrue((boolean)file.isFile());
        Assert.assertEquals((long)message.length, (long)file.length());
        file.rm();
        Assert.assertFalse((boolean)file.exists());
        Assert.assertFalse((boolean)file.isDirectory());
        Assert.assertFalse((boolean)file.isFile());
        Assert.assertEquals((long)0L, (long)file.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @SuppressWarnings(value={"OS_OPEN_STREAM"})
    public final void testBusyFileInputStream() throws IOException, InterruptedException {
        TFile file1 = new TFile((File)this.archive, "file1");
        TFile file2 = new TFile((File)this.archive, "file2");
        Assert.assertTrue((boolean)file1.createNewFile());
        this.umount();
        TFileInputStream in1 = new TFileInputStream((File)file1);
        Assert.assertTrue((boolean)file2.createNewFile());
        try {
            block18: {
                block17: {
                    block16: {
                        try {
                            new TFileInputStream((File)file2).close();
                            Assert.fail();
                        }
                        catch (FileNotFoundException ex) {
                            if (ex.getCause() instanceof FsSyncException && ex.getCause().getCause() instanceof FsResourceOpenException) break block16;
                            throw ex;
                        }
                    }
                    file2.input((InputStream)in1);
                    try {
                        this.umount();
                        Assert.fail();
                    }
                    catch (FsSyncWarningException ex) {
                        if (ex.getCause() instanceof FsResourceOpenException) break block17;
                        throw ex;
                    }
                }
                Assert.assertTrue((boolean)file2.isFile());
                try {
                    file2.input((InputStream)in1);
                    Assert.fail();
                }
                catch (InputException ex) {
                    if (!(ex.getCause() instanceof InputClosedException)) {
                        throw ex;
                    }
                    Assert.assertFalse((boolean)file2.exists());
                }
                new TFileInputStream((File)file1);
                try {
                    this.umount();
                }
                catch (FsSyncWarningException ex) {
                    if (ex.getCause() instanceof FsResourceOpenException) break block18;
                    throw ex;
                }
            }
            this.umount();
            TFile.rm((File)this.archive.toNonArchiveFile());
        }
        finally {
            in1.close();
        }
        try {
            file2.rm();
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)file2.exists());
        try {
            file1.rm();
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)file1.exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @SuppressWarnings(value={"OS_OPEN_STREAM"})
    public final void testBusyFileOutputStream() throws IOException, InterruptedException {
        TFile file2;
        TFile file1;
        block21: {
            TFileOutputStream out;
            block20: {
                block19: {
                    file1 = new TFile((File)this.archive, "file1");
                    file2 = new TFile((File)this.archive, "file2");
                    out = new TFileOutputStream((File)file1);
                    try {
                        TFile.cat((InputStream)new ByteArrayInputStream(this.getData()), (OutputStream)out);
                    }
                    finally {
                        out.close();
                    }
                    out = new TFileOutputStream((File)file2);
                    try {
                        TFile.cat((InputStream)new ByteArrayInputStream(this.getData()), (OutputStream)out);
                    }
                    finally {
                        out.close();
                    }
                    this.umount();
                    out = new TFileOutputStream((File)file1);
                    TFile.cat((InputStream)new ByteArrayInputStream(this.getData()), (OutputStream)out);
                    try {
                        new TFileOutputStream((File)file1).close();
                        Assert.fail();
                    }
                    catch (FileNotFoundException ex) {
                        if (ex.getCause() instanceof FsSyncException && ex.getCause().getCause() instanceof FsResourceOpenException) break block19;
                        throw ex;
                    }
                }
                try {
                    new TFileOutputStream((File)file2).close();
                }
                catch (FileNotFoundException ex) {
                    if (!(ex.getCause() instanceof FsSyncException) || !(ex.getCause().getCause() instanceof FsResourceOpenException)) {
                        throw ex;
                    }
                    logger.log(Level.INFO, this.getArchiveDriver().getClass() + " does not support concurrent writing of different entries in the same archive file.", ex);
                }
                TFile.cat((InputStream)new ByteArrayInputStream(this.getData()), (OutputStream)out);
                try {
                    this.umount();
                    Assert.fail();
                }
                catch (FsSyncWarningException ex) {
                    if (ex.getCause() instanceof FsResourceOpenException) break block20;
                    throw ex;
                }
            }
            try {
                TFile.cat((InputStream)new ByteArrayInputStream(this.getData()), (OutputStream)out);
                Assert.fail();
            }
            catch (OutputClosedException ex) {
                // empty catch block
            }
            out.close();
            new TFileOutputStream((File)file1);
            out = null;
            try {
                this.umount();
            }
            catch (FsSyncWarningException ex) {
                if (ex.getCause() instanceof FsResourceOpenException) break block21;
                throw ex;
            }
        }
        this.umount();
        file2.rm();
        Assert.assertFalse((boolean)file2.exists());
        file1.rm();
        Assert.assertFalse((boolean)file1.exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void testMkdir() throws IOException {
        TFile dir1 = this.archive;
        TFile dir2 = new TFile((File)dir1, "dir");
        TFile dir3 = new TFile((File)dir2, "inner" + this.getSuffix());
        TFile dir4 = new TFile((File)dir3, "dir");
        TFile dir5 = new TFile((File)dir4, "nuts" + this.getSuffix());
        TFile dir6 = new TFile((File)dir5, "dir");
        assert (TConfig.get().isLenient());
        Assert.assertTrue((boolean)dir6.mkdir());
        Assert.assertFalse((boolean)dir6.mkdir());
        Assert.assertFalse((boolean)dir5.mkdir());
        Assert.assertFalse((boolean)dir4.mkdir());
        Assert.assertFalse((boolean)dir3.mkdir());
        Assert.assertFalse((boolean)dir2.mkdir());
        Assert.assertFalse((boolean)dir1.mkdir());
        dir6.rm();
        dir5.rm();
        dir4.rm();
        dir3.rm();
        dir2.rm();
        dir1.rm();
        TConfig config = TConfig.push();
        try {
            config.setLenient(false);
            Assert.assertFalse((boolean)dir6.mkdir());
            Assert.assertFalse((boolean)dir5.mkdir());
            Assert.assertFalse((boolean)dir4.mkdir());
            Assert.assertFalse((boolean)dir3.mkdir());
            Assert.assertFalse((boolean)dir2.mkdir());
            Assert.assertTrue((boolean)dir1.mkdir());
            Assert.assertTrue((boolean)dir2.mkdir());
            Assert.assertTrue((boolean)dir3.mkdir());
            Assert.assertTrue((boolean)dir4.mkdir());
            Assert.assertTrue((boolean)dir5.mkdir());
            Assert.assertTrue((boolean)dir6.mkdir());
        }
        finally {
            config.close();
        }
        dir6.rm();
        dir5.rm();
        dir4.rm();
        dir3.rm();
        dir2.rm();
        dir1.rm();
    }

    @Test
    public final void testDirectoryTree() throws IOException {
        this.assertDirectoryTree(new TFile(System.getProperty("java.io.tmpdir")), new TFile("dir/inner" + this.getSuffix() + "/dir/outer" + this.getSuffix() + "/" + this.archive.getName()));
    }

    private void assertDirectoryTree(TFile basePath, TFile reversePath) throws IOException {
        if (reversePath == null) {
            TFile test = new TFile((File)basePath, "test.txt");
            this.assertFileOutputStream(test);
            return;
        }
        TFile member = new TFile((File)basePath, reversePath.getName());
        boolean created = member.mkdir();
        TFile children = reversePath.getParentFile();
        this.assertDirectoryTree(member, children);
        this.assertListFiles(basePath, member.getName());
        Assert.assertTrue((boolean)member.exists());
        Assert.assertTrue((boolean)member.isDirectory());
        Assert.assertFalse((boolean)member.isFile());
        if (member.isArchive()) {
            Assert.assertEquals((long)0L, (long)member.length());
        }
        if (created) {
            member.rm();
            Assert.assertFalse((boolean)member.exists());
            Assert.assertFalse((boolean)member.isDirectory());
            Assert.assertFalse((boolean)member.isFile());
            Assert.assertEquals((long)0L, (long)member.length());
        }
    }

    private void assertListFiles(TFile dir, String entry) {
        TFile[] files = dir.listFiles();
        boolean found = false;
        for (TFile file : files) {
            if (!file.getName().equals(entry)) continue;
            found = true;
        }
        if (!found) {
            Assert.fail((String)("No such entry: " + entry));
        }
    }

    @Test
    public final void testInputOutput() throws IOException {
        this.assertInputOutput(this.archive);
        TFile archiveTest = new TFile((File)this.archive, "test");
        this.assertInputOutput(archiveTest);
        TFile archiveInner = new TFile((File)this.archive, "inner" + this.getSuffix());
        TFile archiveInnerTest = new TFile((File)archiveInner, "test");
        this.assertInputOutput(archiveInnerTest);
        archiveInner.rm();
        this.archive.rm();
    }

    private void assertInputOutput(TFile file) throws IOException {
        this.assertInput(file);
        this.assertOutput(file);
        file.rm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertInput(TFile file) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(this.getData());
        try {
            file.input((InputStream)in);
        }
        finally {
            ((InputStream)in).close();
        }
        Assert.assertEquals((long)this.getDataLength(), (long)file.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertOutput(TFile file) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(this.getDataLength());
        try {
            file.output((OutputStream)out);
        }
        finally {
            out.close();
        }
        Assert.assertArrayEquals((byte[])this.getData(), (byte[])out.toByteArray());
    }

    @Test
    public final void testCopyContainingOrSameFiles() throws IOException {
        assert (!this.archive.exists());
        TFile dir = this.archive.getParentFile();
        Assert.assertNotNull((Object)dir);
        TFile entry = new TFile((File)this.archive, "entry");
        this.assertCopyContainingOrSameFiles0(dir, this.archive);
        this.assertCopyContainingOrSameFiles0(this.archive, entry);
        entry.input((InputStream)new ByteArrayInputStream(this.getData()));
        this.assertCopyContainingOrSameFiles0(dir, this.archive);
        this.assertCopyContainingOrSameFiles0(this.archive, entry);
        TFile.rm_r((File)this.archive);
    }

    private void assertCopyContainingOrSameFiles0(TFile a, TFile b) throws IOException {
        this.assertCopyContainingOrSameFiles1(a, b);
        this.assertCopyContainingOrSameFiles1(a.getCanOrAbsFile(), b);
        this.assertCopyContainingOrSameFiles1(a, b.getCanOrAbsFile());
        this.assertCopyContainingOrSameFiles1(a.getCanOrAbsFile(), b.getCanOrAbsFile());
    }

    private void assertCopyContainingOrSameFiles1(TFile a, TFile b) throws IOException {
        try {
            TFile.cp((File)a, (File)a);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            TFile.cp((File)a, (File)b);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            TFile.cp((File)b, (File)a);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            TFile.cp((File)b, (File)b);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public final void testCopyDelete() throws IOException {
        String[] names = new String[]{"0" + this.getSuffix(), "1" + this.getSuffix()};
        Assert.assertTrue((boolean)this.archive.mkdir());
        this.assertCopyDelete(this.archive, names, 0);
        this.archive.rm();
        Assert.assertTrue((boolean)this.archive.toNonArchiveFile().mkdir());
        this.assertCopyDelete(this.archive, names, 0);
        this.archive.rm();
    }

    private void assertCopyDelete(TFile parent, String[] names, int off) throws IOException {
        if (off >= names.length) {
            return;
        }
        TFile dir = new TFile((File)parent, names[off]);
        Assert.assertTrue((boolean)dir.mkdir());
        this.assertCopyDelete(parent, dir);
        this.assertCopyDelete(dir, names, off + 1);
        dir.rm();
        Assert.assertTrue((boolean)dir.toNonArchiveFile().mkdir());
        this.assertCopyDelete(parent, dir);
        this.assertCopyDelete(dir, names, off + 1);
        dir.rm();
    }

    private void assertCopyDelete(TFile parent, TFile dir) throws IOException {
        TFile parentFile = new TFile((File)parent, "file");
        TFile parentArchive = new TFile((File)parent, "archive" + this.getSuffix());
        TFile dirFile = new TFile((File)dir, "file");
        TFile dirArchive = new TFile((File)dir, "archive" + this.getSuffix());
        this.assertCopyDelete0(dirFile, dirArchive);
        this.assertCopyDelete0(dirFile, parentFile);
        this.assertCopyDelete0(dirFile, parentArchive);
        this.assertCopyDelete0(parentFile, dirFile);
        this.assertCopyDelete0(parentFile, dirArchive);
        this.assertCopyDelete0(parentArchive, dirFile);
        this.assertCopyDelete0(parentArchive, dirArchive);
        this.assertCopyDelete0(dirArchive, dirFile);
        this.assertCopyDelete0(dirArchive, parentFile);
        this.assertCopyDelete0(dirArchive, parentArchive);
    }

    private void assertCopyDelete0(TFile a, TFile b) throws IOException {
        this.assertCopyDelete0(a, b, 4000L);
    }

    private void assertCopyDelete0(TFile a, TFile b, long granularity) throws IOException {
        long time = System.currentTimeMillis();
        this.createTestFile(a);
        Assert.assertTrue((boolean)a.setLastModified(time - granularity));
        TFile.cp((File)a, (File)b);
        Assert.assertThat((Object)b.length(), (Matcher)CoreMatchers.is((Object)a.length()));
        Assert.assertThat((Object)b.lastModified(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.is((Object)a.lastModified())));
        TFile.cp_p((File)a, (File)b);
        Assert.assertThat((Object)b.length(), (Matcher)CoreMatchers.is((Object)a.length()));
        long almd = a.lastModified() / granularity * granularity;
        long blmd = b.lastModified() / granularity * granularity;
        long almu = (a.lastModified() + granularity - 1L) / granularity * granularity;
        long blmu = (b.lastModified() + granularity - 1L) / granularity * granularity;
        Assert.assertTrue((String)("almd (" + almd + ") != blmd (" + blmd + ") && almu (" + almu + ") != blmu (" + blmu + ")"), (almd == blmd || almu == blmu ? 1 : 0) != 0);
        TFile.cp((File)b, (File)a);
        Assert.assertThat((Object)a.length(), (Matcher)CoreMatchers.is((Object)b.length()));
        Assert.assertThat((Object)a.lastModified(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.is((Object)b.lastModified())));
        TFile.cp_p((File)b, (File)a);
        Assert.assertThat((Object)a.length(), (Matcher)CoreMatchers.is((Object)b.length()));
        almd = a.lastModified() / granularity * granularity;
        blmd = b.lastModified() / granularity * granularity;
        almu = (a.lastModified() + granularity - 1L) / granularity * granularity;
        blmu = (b.lastModified() + granularity - 1L) / granularity * granularity;
        Assert.assertTrue((String)("almd (" + almd + ") != blmd (" + blmd + ") && almu (" + almu + ") != blmu (" + blmu + ")"), (almd == blmd || almu == blmu ? 1 : 0) != 0);
        this.verifyTestFile(a);
        a.rm();
        b.rm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void testIllegalDeleteOfEntryWithOpenStream() throws IOException {
        TFile entry1 = new TFile((File)this.archive, "entry1");
        TFile entry2 = new TFile((File)this.archive, "entry2");
        TFileOutputStream out1 = new TFileOutputStream((File)entry1);
        try {
            try {
                entry1.rm();
                Assert.fail();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            out1.write(this.getData());
            TFileOutputStream out2 = new TFileOutputStream((File)entry2);
            try {
                try {
                    entry2.rm();
                    Assert.fail();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                out2.write(this.getData());
                try {
                    this.archive.rm_r();
                    Assert.fail();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            finally {
                out2.close();
            }
        }
        finally {
            out1.close();
        }
        TFileInputStream in1 = new TFileInputStream((File)entry1);
        try {
            TFileInputStream in32 = new TFileInputStream((File)entry2);
            try {
                entry2.rm();
                ByteArrayOutputStream out = new ByteArrayOutputStream(this.getDataLength());
                try {
                    TFile.cat((InputStream)in32, (OutputStream)out);
                }
                finally {
                    out.close();
                }
                Assert.assertTrue((boolean)Arrays.equals(this.getData(), out.toByteArray()));
                try {
                    this.archive.rm_r();
                    Assert.fail();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            finally {
                in32.close();
            }
            try {
                entry1.rm();
                Assert.fail((String)"deleted within archive.rm_r()");
            }
            catch (IOException in32) {
                // empty catch block
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream(this.getDataLength());
            try {
                TFile.cat((InputStream)in1, (OutputStream)out);
            }
            finally {
                out.close();
            }
            Assert.assertTrue((boolean)Arrays.equals(this.getData(), out.toByteArray()));
            try {
                this.archive.rm_r();
                Assert.fail();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            in1.close();
        }
        this.archive.rm_r();
        Assert.assertFalse((boolean)this.archive.toNonArchiveFile().exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void testRenameValidArchive() throws IOException {
        PrintStream out = new PrintStream((OutputStream)new TFileOutputStream((File)new TFile((File)this.archive, "entry")));
        try {
            out.println("Hello World!");
        }
        finally {
            out.close();
        }
        this.assertRenameArchiveToTemp(this.archive);
    }

    @Test
    public final void testRenameFalsePositive() throws IOException {
        TFile tmp = this.archive.toNonArchiveFile();
        ByteArrayInputStream in = new ByteArrayInputStream(this.getData());
        TFile.cp((InputStream)in, (File)tmp);
        this.assertRenameArchiveToTemp(this.archive);
    }

    private void assertRenameArchiveToTemp(TFile archive) throws IOException {
        assert (archive.isArchive());
        assert (!archive.isEntry());
        TFile tmp = new TFile(TFile.createTempFile((String)TEMP_FILE_PREFIX, null));
        tmp.rm();
        Assert.assertFalse((boolean)tmp.exists());
        Assert.assertFalse((boolean)tmp.toNonArchiveFile().exists());
        archive.mv((File)tmp);
        Assert.assertFalse((boolean)archive.exists());
        Assert.assertFalse((boolean)archive.toNonArchiveFile().exists());
        tmp.rm_r();
        Assert.assertFalse((boolean)tmp.exists());
        Assert.assertFalse((boolean)tmp.toNonArchiveFile().exists());
    }

    @Test
    public final void testRenameRecursively() throws IOException {
        TFile temp = new TFile(this.createTempFile());
        TFile archive2 = new TFile((File)this.archive, "inner" + this.getSuffix());
        TFile archive3 = new TFile((File)archive2, "nuts" + this.getSuffix());
        TFile archive1a = new TFile((File)this.archive, "a");
        TFile archive1b = new TFile((File)this.archive, "b");
        TFile archive2a = new TFile((File)archive2, "a");
        TFile archive2b = new TFile((File)archive2, "b");
        TFile archive3a = new TFile((File)archive3, "a");
        TFile archive3b = new TFile((File)archive3, "b");
        temp.rm();
        this.assertInput(archive1a);
        for (int i = 2; i >= 1; --i) {
            this.assertRenameTo(archive1a, archive1b);
            this.assertRenameTo(archive1b, archive2a);
            this.assertRenameTo(archive2a, archive2b);
            this.assertRenameTo(archive2b, archive3a);
            this.assertRenameTo(archive3a, archive3b);
            this.assertRenameTo(archive3b, archive3a);
            this.assertRenameTo(archive3a, archive2b);
            this.assertRenameTo(archive2b, archive2a);
            this.assertRenameTo(archive2a, archive1b);
            this.assertRenameTo(archive1b, archive1a);
        }
        this.assertRenameTo(this.archive, temp);
        this.assertRenameTo(temp, this.archive);
        archive3.rm();
        archive2.rm();
        this.verifyTestFile(archive1a);
        archive1a.rm();
        this.archive.rm();
    }

    private void assertRenameTo(TFile src, TFile dst) throws IOException {
        Assert.assertTrue((boolean)src.exists());
        Assert.assertFalse((boolean)dst.exists());
        Assert.assertFalse((boolean)dst.toNonArchiveFile().exists());
        assert (TConfig.get().isLenient());
        src.mv((File)dst);
        Assert.assertFalse((boolean)src.exists());
        Assert.assertFalse((boolean)src.toNonArchiveFile().exists());
        Assert.assertTrue((boolean)dst.exists());
    }

    @Test
    public final void testList() throws IOException {
        File dir = this.createTempFile();
        TFile tdir = new TFile(dir);
        Assert.assertNull((Object)dir.listFiles());
        Assert.assertNull((Object)tdir.listFiles());
        Assert.assertNull((Object)tdir.toNonArchiveFile().listFiles());
        TFile.rm((File)dir);
        Assert.assertTrue((boolean)dir.mkdir());
        int i = MEMBERS.length;
        while (--i >= 0) {
            Assert.assertTrue((boolean)new File(dir, MEMBERS[i]).createNewFile());
        }
        Object[] files = dir.listFiles();
        Arrays.sort(files);
        this.assertList((File[])files, tdir);
        TFile.rm_r((File)tdir);
        Assert.assertTrue((boolean)tdir.mkdir());
        int i2 = MEMBERS.length;
        while (--i2 >= 0) {
            Assert.assertTrue((boolean)new TFile((File)tdir, MEMBERS[i2]).createNewFile());
        }
        this.assertList((File[])files, tdir);
        TFile.rm_r((File)tdir);
    }

    private void assertList(File[] expected, TFile dir) {
        Object[] got = dir.listFiles();
        Arrays.sort(got);
        Assert.assertEquals((long)expected.length, (long)got.length);
        int l = expected.length;
        for (int i = 0; i < l; ++i) {
            File ref = expected[i];
            Object file = got[i];
            Assert.assertTrue((!(ref instanceof TFile) ? 1 : 0) != 0);
            Assert.assertEquals((Object)ref.getPath(), (Object)file.getPath());
            Assert.assertNull((Object)file.list());
            Assert.assertNull((Object)file.list(null));
            Assert.assertNull((Object)file.listFiles());
            Assert.assertNull((Object)file.listFiles(file.getArchiveDetector()));
            Assert.assertNull((Object)file.listFiles((FileFilter)null));
            Assert.assertNull((Object)file.listFiles((FilenameFilter)null));
            Assert.assertNull((Object)file.listFiles((FileFilter)null, file.getArchiveDetector()));
            Assert.assertNull((Object)file.listFiles((FilenameFilter)null, file.getArchiveDetector()));
        }
    }

    @Test
    public final void testMultithreadedSingleArchiveMultipleEntriesReading() throws Exception {
        this.assertMultithreadedSingleArchiveMultipleEntriesReading(ConcurrencyUtils.NUM_IO_THREADS, ConcurrencyUtils.NUM_IO_THREADS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertMultithreadedSingleArchiveMultipleEntriesReading(final int nEntries, int nThreads) throws Exception {
        this.createTestArchive(nEntries);
        try {
            class CheckAllEntriesFactory
            implements ConcurrencyUtils.TaskFactory {
                CheckAllEntriesFactory() {
                }

                public Callable<?> newTask(int threadNum) {
                    class CheckAllEntries
                    implements Callable<Void> {
                        final /* synthetic */ int val$nEntries;

                        CheckAllEntries() {
                            this.val$nEntries = n;
                        }

                        @Override
                        public Void call() throws IOException {
                            TFileITSuite.this.assertArchiveEntries(TFileITSuite.this.archive, this.val$nEntries);
                            return null;
                        }
                    }
                    return new CheckAllEntries(TFileITSuite.this, nEntries);
                }
            }
            ConcurrencyUtils.runConcurrent((int)nThreads, (ConcurrencyUtils.TaskFactory)new CheckAllEntriesFactory()).join();
        }
        finally {
            TFile.rm_r((File)this.archive);
        }
    }

    private void createTestArchive(int nEntries) throws IOException {
        for (int i = 0; i < nEntries; ++i) {
            this.createTestFile(new TFile((File)this.archive, i + ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertArchiveEntries(TFile archive, int nEntries) throws IOException {
        List<TFile> entries = Arrays.asList(archive.listFiles());
        assert (entries.size() == nEntries);
        Collections.shuffle(entries, new Random());
        byte[] buf = new byte[this.getDataLength()];
        for (TFile entry : entries) {
            TFileInputStream in = new TFileInputStream((File)entry);
            try {
                int read;
                int off = 0;
                while (0 <= (read = in.read(buf))) {
                    Assert.assertTrue((read > 0 ? 1 : 0) != 0);
                    Assert.assertTrue((boolean)ArrayHelper.equals((byte[])this.getData(), (int)off, (byte[])buf, (int)0, (int)read));
                    off += read;
                }
                Assert.assertEquals((long)-1L, (long)read);
                Assert.assertEquals((long)off, (long)this.getDataLength());
                Assert.assertTrue((0 >= in.read(new byte[0]) ? 1 : 0) != 0);
            }
            finally {
                in.close();
            }
        }
    }

    @Test
    public final void testMultithreadedSingleArchiveMultipleEntriesWriting() throws Exception {
        this.assertMultithreadedSingleArchiveMultipleEntriesWriting(false);
        this.assertMultithreadedSingleArchiveMultipleEntriesWriting(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertMultithreadedSingleArchiveMultipleEntriesWriting(final boolean wait) throws Exception {
        assert (TConfig.get().isLenient());
        try {
            class WriteFactory
            implements ConcurrencyUtils.TaskFactory {
                WriteFactory() {
                }

                public Callable<?> newTask(final int threadNum) {
                    class Write
                    implements Callable<Void> {
                        Write() {
                        }

                        @Override
                        public Void call() throws IOException {
                            block3: {
                                TFile entry = new TFile((File)TFileITSuite.this.archive, "" + threadNum);
                                TFileITSuite.this.createTestFile(entry);
                                try {
                                    TVFS.sync((TFile)TFileITSuite.this.archive, (BitField)BitField.of((Enum)FsSyncOption.CLEAR_CACHE).set((Enum)FsSyncOption.WAIT_CLOSE_INPUT, wait).set((Enum)FsSyncOption.WAIT_CLOSE_OUTPUT, wait));
                                }
                                catch (FsSyncException ex) {
                                    if (!(ex.getCause() instanceof FsResourceOpenException)) {
                                        throw ex;
                                    }
                                    if (!wait) break block3;
                                    throw new AssertionError((Object)ex);
                                }
                            }
                            return null;
                        }
                    }
                    return new Write();
                }
            }
            ConcurrencyUtils.runConcurrent((int)ConcurrencyUtils.NUM_IO_THREADS, (ConcurrencyUtils.TaskFactory)new WriteFactory()).join();
        }
        finally {
            this.assertArchiveEntries(this.archive, ConcurrencyUtils.NUM_IO_THREADS);
            TFile.rm_r((File)this.archive);
        }
    }

    @Test
    public final void testMultithreadedMultipleArchivesSingleEntryWriting() throws Exception {
        this.assertMultithreadedMultipleArchivesSingleEntryWriting(false);
        this.assertMultithreadedMultipleArchivesSingleEntryWriting(true);
    }

    private void assertMultithreadedMultipleArchivesSingleEntryWriting(final boolean syncIndividually) throws Exception {
        assert (TConfig.get().isLenient());
        class WriteFactory
        implements ConcurrencyUtils.TaskFactory {
            WriteFactory() {
            }

            public Callable<?> newTask(int threadNum) {
                class Write
                implements Callable<Void> {
                    final /* synthetic */ boolean val$syncIndividually;

                    Write() {
                        this.val$syncIndividually = bl;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void call() throws IOException {
                        TFile archive = new TFile(TFileITSuite.this.createTempFile());
                        archive.rm();
                        TFile entry = new TFile((File)archive, "entry");
                        try {
                            TFileITSuite.this.createTestFile(entry);
                            try {
                                if (this.val$syncIndividually) {
                                    TVFS.umount((TFile)archive);
                                } else {
                                    TVFS.sync((BitField)FsSyncOptions.SYNC);
                                }
                            }
                            catch (FsSyncWarningException ex) {
                                if (!(ex.getCause() instanceof FsResourceOpenException)) {
                                    throw ex;
                                }
                                if (this.val$syncIndividually) {
                                    throw new AssertionError((Object)ex);
                                }
                            }
                        }
                        finally {
                            TFile.rm_r((File)archive);
                        }
                        return null;
                    }
                }
                return new Write(TFileITSuite.this, syncIndividually);
            }
        }
        ConcurrencyUtils.runConcurrent((int)ConcurrencyUtils.NUM_IO_THREADS, (ConcurrencyUtils.TaskFactory)new WriteFactory()).join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultithreadedMutualArchiveCopying() throws Exception {
        assert (TConfig.get().isLenient());
        TFile src = this.archive;
        try {
            TFile dst = new TFile(this.createTempFile());
            dst.rm();
            try {
                try {
                    class CopyFactory
                    implements ConcurrencyUtils.TaskFactory {
                        final TFile src;
                        final TFile dst;

                        CopyFactory(TFile src, TFile dst) {
                            this.src = src;
                            this.dst = dst;
                        }

                        public Callable<?> newTask(final int threadNum) {
                            class Copy
                            implements Callable<Void> {
                                Copy() {
                                }

                                @Override
                                public Void call() throws IOException {
                                    TFile srcNo = new TFile((File)src, "src/" + threadNum);
                                    TFile dstNo = new TFile((File)dst, "dst/" + threadNum);
                                    TFileITSuite.this.createTestFile(srcNo);
                                    srcNo.cp((File)dstNo);
                                    return null;
                                }
                            }
                            return new Copy();
                        }
                    }
                    ConcurrencyUtils.TaskJoiner join = ConcurrencyUtils.runConcurrent((int)ConcurrencyUtils.NUM_IO_THREADS, (ConcurrencyUtils.TaskFactory)new CopyFactory(src, dst));
                    try {
                        ConcurrencyUtils.runConcurrent((int)ConcurrencyUtils.NUM_IO_THREADS, (ConcurrencyUtils.TaskFactory)new CopyFactory(dst, src)).join();
                    }
                    finally {
                        join.join();
                    }
                }
                finally {
                    TVFS.umount((TFile)dst);
                }
            }
            finally {
                dst.toNonArchiveFile().rm();
            }
        }
        finally {
            TVFS.umount((TFile)src);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGrowing() throws IOException {
        TFile file = this.archive.toNonArchiveFile();
        TFile entry1 = new TFile((File)this.archive, "entry1");
        TFile entry2 = new TFile((File)this.archive, "entry2");
        TConfig config = TConfig.push();
        try {
            config.setOutputPreferences(config.getOutputPreferences().set((Enum)FsOutputOption.GROW));
            this.createTestFile(entry1);
            this.createTestFile(entry2);
            this.umount();
            Assert.assertTrue((file.length() > (long)(2 * this.getDataLength()) ? 1 : 0) != 0);
            this.createTestFile(entry1);
            this.createTestFile(entry2);
            this.createTestFile(entry1);
            this.createTestFile(entry2);
            Assert.assertTrue((boolean)entry1.setLastModified(System.currentTimeMillis()));
            Assert.assertTrue((boolean)entry2.setLastModified(System.currentTimeMillis()));
            entry1.rm();
            entry2.rm();
            this.umount();
            Assert.assertTrue((file.length() > (long)(6 * this.getDataLength()) ? 1 : 0) != 0);
        }
        finally {
            config.close();
        }
        Assert.assertThat((Object)this.archive.list().length, (Matcher)CoreMatchers.is((Object)0));
        config = TConfig.push();
        try {
            config.setOutputPreferences(config.getOutputPreferences().set((Enum)FsOutputOption.GROW));
            this.archive.rm();
            this.umount();
        }
        finally {
            config.close();
        }
        Assert.assertNull((Object)this.archive.list());
    }

    private static interface Factory<O, P, E extends Exception> {
        public O create(P var1) throws E;
    }
}

