/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.entry.EntryName;
import de.schlichtherle.truezip.fs.FsUriModifier;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import net.jcip.annotations.Immutable;

@Immutable
@DefaultAnnotation(value={NonNull.class})
public final class FsEntryName
extends EntryName {
    private static final long serialVersionUID = 2212342253466752478L;
    public static final FsEntryName ROOT = FsEntryName.create(URI.create(""));

    public static FsEntryName create(String uri) {
        return FsEntryName.create(uri, FsUriModifier.NULL);
    }

    public static FsEntryName create(String uri, FsUriModifier modifier) {
        try {
            return new FsEntryName(uri, modifier);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static FsEntryName create(URI uri) {
        return FsEntryName.create(uri, FsUriModifier.NULL);
    }

    public static FsEntryName create(URI uri, FsUriModifier modifier) {
        try {
            return new FsEntryName(uri, modifier);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public FsEntryName(String uri) throws URISyntaxException {
        this(uri, FsUriModifier.NULL);
    }

    public FsEntryName(String uri, FsUriModifier modifier) throws URISyntaxException {
        this(new URI(uri), modifier);
    }

    public FsEntryName(URI uri) throws URISyntaxException {
        this(uri, FsUriModifier.NULL);
    }

    public FsEntryName(URI uri, FsUriModifier modifier) throws URISyntaxException {
        uri = modifier.modify(uri, FsUriModifier.PostFix.ENTRY_NAME);
        super(uri);
        this.parse(uri);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.parse(this.getUri());
        }
        catch (URISyntaxException ex) {
            throw (InvalidObjectException)new InvalidObjectException(ex.toString()).initCause(ex);
        }
    }

    private void parse(URI uri) throws URISyntaxException {
        String p = uri.getRawPath();
        if ("..".equals(p) || p.startsWith("/") || p.startsWith("./") || p.startsWith("../")) {
            throw new URISyntaxException(FsEntryName.quote(uri), "Illegal start of URI path");
        }
        if (p.endsWith("/")) {
            throw new URISyntaxException(FsEntryName.quote(uri), "Illegal separator \"/\" at end of URI path");
        }
        assert (this.invariants());
    }

    private static String quote(Object s) {
        return "\"" + s + "\"";
    }

    FsEntryName(FsEntryName parent, FsEntryName member) {
        super(parent, member);
        assert (this.invariants());
    }

    private boolean invariants() {
        assert (null != this.getUri());
        assert (this.getUri().normalize() == this.getUri());
        String p = this.getUri().getRawPath();
        assert (!"..".equals(p));
        assert (!p.startsWith("/"));
        assert (!p.startsWith("./"));
        assert (!p.startsWith("../"));
        assert (!p.endsWith("/"));
        return true;
    }

    public boolean isRoot() {
        URI uri = this.getUri();
        String path = uri.getRawPath();
        if (null != path && !path.isEmpty()) {
            return false;
        }
        String query = uri.getRawQuery();
        return null == query || query.isEmpty();
    }
}

