/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsConcurrentModel;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsException;
import de.schlichtherle.truezip.fs.FsFalsePositiveException;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.FsSyncWarningException;
import de.schlichtherle.truezip.fs.archive.FsArchiveDriver;
import de.schlichtherle.truezip.fs.archive.FsArchiveEntry;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystem;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystemEvent;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystemTouchListener;
import de.schlichtherle.truezip.fs.archive.FsCacheableFalsePositiveException;
import de.schlichtherle.truezip.fs.archive.FsCovariantEntry;
import de.schlichtherle.truezip.fs.archive.FsFileSystemArchiveController;
import de.schlichtherle.truezip.io.InputBusyException;
import de.schlichtherle.truezip.io.InputException;
import de.schlichtherle.truezip.io.OutputBusyException;
import de.schlichtherle.truezip.io.Paths;
import de.schlichtherle.truezip.socket.ConcurrentInputShop;
import de.schlichtherle.truezip.socket.ConcurrentOutputShop;
import de.schlichtherle.truezip.socket.IOSocket;
import de.schlichtherle.truezip.socket.InputService;
import de.schlichtherle.truezip.socket.InputShop;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputService;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.ExceptionHandler;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.Icon;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
public final class FsDefaultArchiveController<E extends FsArchiveEntry>
extends FsFileSystemArchiveController<E> {
    private static final BitField<FsOutputOption> MOUNT_MASK = BitField.of(FsOutputOption.CREATE_PARENTS);
    private static final BitField<FsInputOption> MOUNT_INPUT_OPTIONS = BitField.of(FsInputOption.CACHE);
    private static final BitField<FsOutputOption> MAKE_OUTPUT_OPTIONS = BitField.noneOf(FsOutputOption.class);
    private static final BitField<FsSyncOption> SYNC_OPTIONS = BitField.of((Enum)FsSyncOption.WAIT_CLOSE_INPUT, (Enum[])new FsSyncOption[]{FsSyncOption.WAIT_CLOSE_OUTPUT, FsSyncOption.CLEAR_CACHE});
    private final FsArchiveDriver<E> driver;
    private final FsController<?> parent;
    private final FsEntryName parentName;
    @Nullable
    private Input input;
    @Nullable
    private Output output;
    private final FsArchiveFileSystemTouchListener<E> touchListener = new TouchListener();

    public FsDefaultArchiveController(FsConcurrentModel model, FsArchiveDriver<E> driver, FsController<?> parent) {
        super(model);
        if (null == driver) {
            throw new NullPointerException();
        }
        if (model.getParent() != parent.getModel()) {
            throw new IllegalArgumentException("Parent/member mismatch!");
        }
        this.driver = driver;
        this.parent = parent;
        this.parentName = this.getModel().getMountPoint().getPath().resolve(FsEntryName.ROOT).getEntryName();
        assert (this.invariants());
    }

    private boolean invariants() {
        assert (null != this.driver);
        assert (null != this.parent);
        assert (null != this.parentName);
        return true;
    }

    @Override
    public FsController<?> getParent() {
        return this.parent;
    }

    @Override
    public Icon getOpenIcon() throws IOException {
        this.autoMount();
        return this.driver.getOpenIcon(this.getModel());
    }

    @Override
    public Icon getClosedIcon() throws IOException {
        this.autoMount();
        return this.driver.getClosedIcon(this.getModel());
    }

    @Override
    void mount(boolean autoCreate, BitField<FsOutputOption> options) throws IOException {
        options = options.and(MOUNT_MASK);
        try {
            boolean readOnly = !this.parent.isWritable(this.parentName);
            InputSocket<?> socket = this.driver.getInputSocket(this.parent, this.parentName, MOUNT_INPUT_OPTIONS);
            this.input = new Input(this.driver.newInputShop(this.getModel(), socket));
            this.setFileSystem(FsArchiveFileSystem.newArchiveFileSystem(this.driver, this.input.getDelegate(), (Entry)socket.getLocalTarget(), readOnly));
        }
        catch (FsException ex) {
            throw ex;
        }
        catch (IOException ex) {
            if (!autoCreate) {
                throw ex instanceof FileNotFoundException ? new FsFalsePositiveException((FsModel)this.getModel(), ex) : new FsCacheableFalsePositiveException(this.getModel(), ex);
            }
            if (null != this.parent.getEntry(this.parentName)) {
                throw new FsCacheableFalsePositiveException(this.getModel(), ex);
            }
            FsArchiveFileSystem<E> fileSystem = FsArchiveFileSystem.newArchiveFileSystem(this.driver);
            this.makeOutput(options);
            this.setFileSystem(fileSystem);
            this.getModel().setTouched(true);
        }
        this.getFileSystem().addFsArchiveFileSystemTouchListener(this.touchListener);
    }

    void makeOutput(BitField<FsOutputOption> options) throws IOException {
        if (null != this.output) {
            return;
        }
        OutputSocket<?> socket = this.driver.getOutputSocket(this.parent, this.parentName, options.set(FsOutputOption.CACHE), null);
        Input input = this.input;
        this.output = new Output(this.driver.newOutputShop(this.getModel(), socket, null != input ? input.getDelegate() : null));
    }

    @Override
    InputSocket<?> getInputSocket(String name) throws IOException {
        return this.input.getInputSocket(name);
    }

    @Override
    OutputSocket<?> getOutputSocket(E entry) throws IOException {
        if (null == this.output) {
            this.makeOutput(MAKE_OUTPUT_OPTIONS);
        }
        return this.output.getOutputSocket(entry);
    }

    @Override
    public void unlink(FsEntryName name) throws IOException {
        super.unlink(name);
        if (name.isRoot()) {
            this.getParent().unlink(this.getModel().getMountPoint().getPath().resolve(name).getEntryName());
        }
    }

    @Override
    boolean autoSync(FsEntryName name, @CheckForNull Entry.Access intention) throws FsSyncException, FsException {
        FsCovariantEntry entry;
        FsArchiveFileSystem fileSystem = this.getFileSystem();
        if (null == fileSystem || null == (entry = fileSystem.getEntry(name))) {
            return false;
        }
        String n = null;
        if (null != this.output && null != this.output.getEntry(n = entry.getEntry().getName())) {
            return this.sync();
        }
        if (null != this.input && null != this.input.getEntry(null != n ? n : (n = entry.getEntry().getName()))) {
            return false;
        }
        if (Entry.Access.READ == intention) {
            return this.sync();
        }
        return false;
    }

    private boolean sync() throws FsSyncException, FsException {
        this.getModel().assertWriteLockedByCurrentThread();
        this.sync(SYNC_OPTIONS);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <X extends IOException> void sync(BitField<FsSyncOption> options, ExceptionHandler<? super FsSyncException, X> handler) throws X {
        assert (!this.isTouched() || null != this.output);
        assert (this.getModel().isWriteLockedByCurrentThread());
        if (options.get(FsSyncOption.FORCE_CLOSE_OUTPUT) && !options.get(FsSyncOption.FORCE_CLOSE_INPUT)) {
            throw new IllegalArgumentException();
        }
        this.awaitSync(options, handler);
        this.commenceSync(handler);
        try {
            if (!options.get(FsSyncOption.ABORT_CHANGES) && this.isTouched()) {
                this.performSync(handler);
            }
        }
        finally {
            try {
                this.commitSync(handler);
            }
            finally {
                assert (null == this.getFileSystem());
                assert (null == this.input);
                assert (null == this.output);
                this.getModel().setTouched(false);
            }
        }
    }

    private <X extends IOException> void awaitSync(BitField<FsSyncOption> options, ExceptionHandler<? super FsSyncException, X> handler) throws X {
        int inStreams;
        String message;
        int outStreams;
        if (this.output != null && (outStreams = this.output.waitCloseOthers(options.get(FsSyncOption.WAIT_CLOSE_OUTPUT) ? 0L : 50L)) > 0) {
            message = "Number of open output streams: " + outStreams;
            if (!options.get(FsSyncOption.FORCE_CLOSE_OUTPUT)) {
                throw (IOException)handler.fail(new FsSyncException(this.getModel(), new OutputBusyException(message)));
            }
            handler.warn(new FsSyncWarningException(this.getModel(), new OutputBusyException(message)));
        }
        if (this.input != null && (inStreams = this.input.waitCloseOthers(options.get(FsSyncOption.WAIT_CLOSE_INPUT) ? 0L : 50L)) > 0) {
            message = "Number of open input streams: " + inStreams;
            if (!options.get(FsSyncOption.FORCE_CLOSE_INPUT)) {
                throw (IOException)handler.fail(new FsSyncException(this.getModel(), new InputBusyException(message)));
            }
            handler.warn(new FsSyncWarningException(this.getModel(), new InputBusyException(message)));
        }
    }

    private <X extends IOException> void commenceSync(final ExceptionHandler<? super FsSyncException, X> handler) throws X {
        class FilterExceptionHandler
        implements ExceptionHandler<IOException, X> {
            FilterExceptionHandler() {
            }

            @Override
            public X fail(IOException cannotHappen) {
                throw new AssertionError((Object)cannotHappen);
            }

            @Override
            public void warn(IOException cause) throws IOException {
                if (null == cause) {
                    throw new NullPointerException();
                }
                handler.warn(new FsSyncWarningException(FsDefaultArchiveController.this.getModel(), cause));
            }
        }
        FilterExceptionHandler decoratorHandler = new FilterExceptionHandler();
        if (this.output != null) {
            this.output.closeAll(decoratorHandler);
        }
        if (this.input != null) {
            this.input.closeAll(decoratorHandler);
        }
    }

    private <X extends IOException> void performSync(final ExceptionHandler<? super FsSyncException, X> handler) throws X {
        assert (this.isTouched());
        assert (null != this.output);
        class FilterExceptionHandler
        implements ExceptionHandler<IOException, X> {
            IOException last;

            FilterExceptionHandler() {
            }

            @Override
            public X fail(IOException cause) {
                this.last = cause;
                return (IOException)handler.fail(new FsSyncException(FsDefaultArchiveController.this.getModel(), cause));
            }

            @Override
            public void warn(IOException cause) throws IOException {
                assert (null != cause);
                IOException old = this.last;
                this.last = cause;
                if (null != old || !(cause instanceof InputException)) {
                    throw (IOException)handler.fail(new FsSyncException(FsDefaultArchiveController.this.getModel(), cause));
                }
                handler.warn(new FsSyncWarningException(FsDefaultArchiveController.this.getModel(), cause));
            }
        }
        FsDefaultArchiveController.copy(this.getFileSystem(), null != this.input ? this.input.getDelegate() : new DummyInputService(), this.output.getDelegate(), new FilterExceptionHandler());
    }

    private static <E extends FsArchiveEntry, X extends IOException> void copy(FsArchiveFileSystem<E> fileSystem, InputService<E> input, OutputService<E> output, ExceptionHandler<IOException, X> handler) throws X {
        for (FsCovariantEntry<E> ce : fileSystem) {
            for (FsArchiveEntry ae : ce.getEntries()) {
                String aen = ae.getName();
                if (null != output.getEntry(aen)) continue;
                try {
                    if (Entry.Type.DIRECTORY == ae.getType()) {
                        if (Paths.isRoot(ce.getName()) || -1L == ae.getTime(Entry.Access.WRITE)) continue;
                        output.getOutputSocket(ae).newOutputStream().close();
                        continue;
                    }
                    if (null != input.getEntry(aen)) {
                        IOSocket.copy(input.getInputSocket(aen), output.getOutputSocket(ae));
                        continue;
                    }
                    output.getOutputSocket(ae).newOutputStream().close();
                }
                catch (IOException ex) {
                    handler.warn(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X extends IOException> void commitSync(ExceptionHandler<? super FsSyncException, X> handler) throws X {
        this.setFileSystem(null);
        try {
            Input input = this.input;
            this.input = null;
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ex) {
                    handler.warn(new FsSyncWarningException(this.getModel(), ex));
                }
            }
        }
        finally {
            Output output = this.output;
            this.output = null;
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException ex) {
                    throw (IOException)handler.fail(new FsSyncException(this.getModel(), ex));
                }
            }
        }
    }

    private boolean isTouched() {
        FsArchiveFileSystem fileSystem = this.getFileSystem();
        return null != fileSystem && fileSystem.isTouched();
    }

    private final class TouchListener
    implements FsArchiveFileSystemTouchListener<E> {
        private TouchListener() {
        }

        @Override
        public void beforeTouch(FsArchiveFileSystemEvent<? extends E> event) throws IOException {
            assert (event.getSource() == FsDefaultArchiveController.this.getFileSystem());
            FsDefaultArchiveController.this.makeOutput(MAKE_OUTPUT_OPTIONS);
        }

        @Override
        public void afterTouch(FsArchiveFileSystemEvent<? extends E> event) {
            assert (event.getSource() == FsDefaultArchiveController.this.getFileSystem());
            FsDefaultArchiveController.this.getModel().setTouched(true);
        }
    }

    private final class Output
    extends ConcurrentOutputShop<E> {
        Output(OutputShop<E> output) {
            super(output);
        }

        OutputShop<E> getDelegate() {
            return (OutputShop)this.delegate;
        }
    }

    private final class Input
    extends ConcurrentInputShop<E> {
        Input(InputShop<E> input) {
            super(input);
        }

        InputShop<E> getDelegate() {
            return (InputShop)this.delegate;
        }
    }

    private static final class DummyInputService<E extends Entry>
    implements InputShop<E> {
        private DummyInputService() {
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public int getSize() {
            return 0;
        }

        @Override
        public Iterator<E> iterator() {
            return Collections.emptyList().iterator();
        }

        @Override
        public E getEntry(String name) {
            return null;
        }

        @Override
        public InputSocket<? extends E> getInputSocket(String name) {
            if (null == name) {
                throw new NullPointerException();
            }
            throw new UnsupportedOperationException();
        }
    }
}

