/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.io;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Locale;
import net.jcip.annotations.NotThreadSafe;
import net.jcip.annotations.ThreadSafe;

@DefaultAnnotation(value={NonNull.class})
@ThreadSafe
public final class Paths {
    private Paths() {
    }

    public static String normalize(String path, char separatorChar) {
        return new Normalizer(separatorChar).normalize(path);
    }

    public static String cutTrailingSeparators(String path, char separatorChar) {
        int i = path.length();
        if (0 >= i || separatorChar != path.charAt(--i)) {
            return path;
        }
        while (0 < i && separatorChar == path.charAt(--i)) {
        }
        return path.substring(0, ++i);
    }

    public static Splitter split(String path, char separatorChar, boolean keepTrailingSeparator) {
        return new Splitter(separatorChar, keepTrailingSeparator).split(path);
    }

    public static boolean isRoot(String path) {
        return path.isEmpty();
    }

    public static boolean isAbsolute(String path, char separatorChar) {
        int prefixLen = Paths.prefixLength(path, separatorChar);
        return prefixLen > 0 && path.charAt(prefixLen - 1) == separatorChar;
    }

    private static int prefixLength(String path, char separatorChar) {
        char drive;
        int pathLength = path.length();
        int len = 0;
        if (pathLength > 0 && path.charAt(0) == separatorChar) {
            ++len;
        } else if (pathLength > 1 && path.charAt(1) == ':' && ('A' <= (drive = path.charAt(0)) && drive <= 'Z' || 'a' <= drive && drive <= 'z')) {
            len = 2;
        }
        if (pathLength > len && path.charAt(len) == separatorChar) {
            ++len;
        }
        return len;
    }

    public static boolean contains(String a, String b, char separatorChar) {
        int lengthB;
        if (separatorChar == '\\') {
            a = a.toLowerCase(Locale.ENGLISH);
            b = b.toLowerCase(Locale.ENGLISH);
        }
        if (!b.startsWith(a)) {
            return false;
        }
        int lengthA = a.length();
        if (lengthA == (lengthB = b.length())) {
            return true;
        }
        if (lengthA < lengthB) {
            return b.charAt(lengthA) == separatorChar;
        }
        return false;
    }

    @NotThreadSafe
    public static class Splitter {
        private final char separatorChar;
        private final int fixum;
        @CheckForNull
        private String parentPath;
        private String memberName;

        public Splitter(char separatorChar, boolean keepTrailingSeparator) {
            this.separatorChar = separatorChar;
            this.fixum = keepTrailingSeparator ? 2 : 1;
        }

        public Splitter split(String path) {
            int prefixLength = Paths.prefixLength(path, this.separatorChar);
            int memberEnd = path.length() - 1;
            if (memberEnd < prefixLength) {
                this.parentPath = null;
                this.memberName = "";
                return this;
            }
            memberEnd = Splitter.lastIndexNot(path, this.separatorChar, memberEnd);
            int memberBegin = path.lastIndexOf(this.separatorChar, memberEnd);
            ++memberEnd;
            if (prefixLength <= memberBegin) {
                int parentEnd = Splitter.lastIndexNot(path, this.separatorChar, memberBegin);
                this.parentPath = path.substring(0, prefixLength <= parentEnd ? parentEnd + this.fixum : prefixLength);
                this.memberName = path.substring(memberBegin + 1, memberEnd);
            } else if (0 < prefixLength && prefixLength <= memberEnd) {
                this.parentPath = path.substring(0, prefixLength);
                this.memberName = path.substring(prefixLength, memberEnd);
            } else if (prefixLength <= memberEnd) {
                this.parentPath = null;
                this.memberName = path.substring(memberBegin + 1, memberEnd);
            } else {
                this.parentPath = null;
                this.memberName = "";
            }
            return this;
        }

        private static int lastIndexNot(String path, char separatorChar, int last) {
            while (path.charAt(last) == separatorChar && --last >= 0) {
            }
            return last;
        }

        @Nullable
        public String getParentPath() {
            return this.parentPath;
        }

        public String getMemberName() {
            return this.memberName;
        }
    }

    @NotThreadSafe
    public static class Normalizer {
        private final char separatorChar;
        private String path;
        private final StringBuilder buffer;

        public Normalizer(char separatorChar) {
            this.separatorChar = separatorChar;
            this.buffer = new StringBuilder();
        }

        public String normalize(String path) {
            String result;
            int prefixLen = Paths.prefixLength(path, this.separatorChar);
            int pathLen = path.length();
            this.path = path.substring(prefixLen, pathLen);
            this.buffer.setLength(0);
            this.buffer.ensureCapacity(pathLen);
            this.normalize(0, pathLen - prefixLen);
            this.buffer.insert(0, path.substring(0, prefixLen));
            int bufferLen = this.buffer.length();
            if (pathLen > 0 && path.charAt(pathLen - 1) == this.separatorChar || pathLen > 1 && path.charAt(pathLen - 2) == this.separatorChar && path.charAt(pathLen - 1) == '.') {
                this.slashify();
                bufferLen = this.buffer.length();
            }
            if (bufferLen == path.length()) {
                assert (path.equals(this.buffer.toString()));
                result = path;
            } else {
                result = this.buffer.toString();
                if (path.startsWith(result)) {
                    result = path.substring(0, bufferLen);
                }
            }
            assert (!result.equals(path) || result == path);
            return result;
        }

        private int normalize(int collapse, int end) {
            int notCollapsed;
            assert (collapse >= 0);
            if (0 >= end) {
                return collapse;
            }
            int next = this.path.lastIndexOf(this.separatorChar, end - 1);
            String base = this.path.substring(next + 1, end);
            if (0 >= base.length() || ".".equals(base)) {
                return this.normalize(collapse, next);
            }
            if ("..".equals(base)) {
                notCollapsed = this.normalize(collapse + 1, next) - 1;
                if (0 > notCollapsed) {
                    return 0;
                }
            } else {
                if (0 < collapse) {
                    int notCollapsed2 = this.normalize(collapse - 1, next);
                    this.slashify();
                    return notCollapsed2;
                }
                assert (0 == collapse);
                notCollapsed = this.normalize(0, next);
                assert (0 == notCollapsed);
            }
            this.slashify();
            this.buffer.append(base);
            return notCollapsed;
        }

        private void slashify() {
            int bufferLen = this.buffer.length();
            if (bufferLen > 0 && this.buffer.charAt(bufferLen - 1) != this.separatorChar) {
                this.buffer.append(this.separatorChar);
            }
        }
    }
}

