/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.util;

import de.schlichtherle.truezip.util.UriEncoder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.CharBuffer;
import net.jcip.annotations.NotThreadSafe;

@DefaultAnnotation(value={NonNull.class})
@NotThreadSafe
public final class UriBuilder {
    private final UriEncoder encoder = new UriEncoder(null);
    @CheckForNull
    private StringBuilder builder;
    @CheckForNull
    private String scheme;
    @CheckForNull
    private String authority;
    @CheckForNull
    private String path;
    @CheckForNull
    private String query;
    @CheckForNull
    private String fragment;

    public UriBuilder() {
    }

    public UriBuilder(URI uri) {
        this();
        this.setUri(uri);
    }

    public UriBuilder clear() {
        this.scheme = null;
        this.authority = null;
        this.path = null;
        this.query = null;
        this.fragment = null;
        return this;
    }

    public String toString() {
        try {
            return this.getString();
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public String getString() throws URISyntaxException {
        boolean hasAuth;
        boolean absUri;
        StringBuilder b = this.builder;
        if (null == b) {
            b = this.builder = new StringBuilder();
        } else {
            b.setLength(0);
        }
        int errIdx = -1;
        String errMsg = null;
        String s = this.scheme;
        String a = this.authority;
        String p = this.path;
        String q = this.query;
        String f = this.fragment;
        boolean bl = absUri = null != s;
        if (absUri) {
            b.append(s).append(':');
        }
        int ssp = b.length();
        boolean bl2 = hasAuth = null != a;
        if (hasAuth) {
            this.encoder.encode(a, UriEncoder.Encoding.AUTHORITY, b.append("//"));
        }
        boolean absPath = false;
        if (null != p && !p.isEmpty()) {
            if (p.startsWith("/")) {
                absPath = true;
                this.encoder.encode(p, UriEncoder.Encoding.ABSOLUTE_PATH, b);
            } else if (hasAuth) {
                absPath = true;
                errIdx = b.length();
                errMsg = "Relative path with " + (a.isEmpty() ? "" : "non-") + "empty authority";
                this.encoder.encode(p, UriEncoder.Encoding.ABSOLUTE_PATH, b);
            } else if (absUri) {
                this.encoder.encode(p, UriEncoder.Encoding.QUERY, b);
            } else {
                this.encoder.encode(p, UriEncoder.Encoding.PATH, b);
            }
        }
        if (null != q) {
            b.append('?');
            if (absUri && !absPath) {
                errIdx = b.length();
                errMsg = "Query in opaque URI";
            }
            this.encoder.encode(q, UriEncoder.Encoding.QUERY, b);
        }
        assert (absUri == 0 < ssp);
        if (absUri && ssp >= b.length()) {
            errIdx = b.length();
            errMsg = "Empty scheme specific part in absolute URI";
        }
        if (null != f) {
            this.encoder.encode(f, UriEncoder.Encoding.FRAGMENT, b.append('#'));
        }
        if (absUri) {
            UriBuilder.validateScheme((CharBuffer)CharBuffer.wrap(b).limit(s.length()));
        }
        String u = b.toString();
        if (0 <= errIdx) {
            throw new URISyntaxException(UriBuilder.quote(u), errMsg, errIdx);
        }
        return u;
    }

    public static void validateScheme(String scheme) throws URISyntaxException {
        UriBuilder.validateScheme(CharBuffer.wrap(scheme));
    }

    private static void validateScheme(CharBuffer input) throws URISyntaxException {
        if (!input.hasRemaining()) {
            throw UriBuilder.newURISyntaxException(input, "Empty URI scheme");
        }
        char c = input.get();
        if (!(c >= 'a' && 'z' >= c || c >= 'A' && 'Z' >= c)) {
            throw UriBuilder.newURISyntaxException(input, "Illegal character in URI scheme");
        }
        while (input.hasRemaining()) {
            c = input.get();
            if (c >= 'a' && 'z' >= c || c >= 'A' && 'Z' >= c || c >= '0' && '9' >= c || c == '+' || c == '-' || c == '.') continue;
            throw UriBuilder.newURISyntaxException(input, "Illegal character in URI scheme");
        }
    }

    private static URISyntaxException newURISyntaxException(CharBuffer input, String reason) {
        int p = input.position() - 1;
        return new URISyntaxException(UriBuilder.quote(input.rewind().limit(input.capacity())), reason, p);
    }

    private static String quote(Object s) {
        return "\"" + s + "\"";
    }

    public void setString(String uri) {
        this.setUri(URI.create(uri));
    }

    public UriBuilder string(String uri) {
        this.setString(uri);
        return this;
    }

    public URI toUri() {
        try {
            return this.getUri();
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public URI getUri() throws URISyntaxException {
        String u = this.getString();
        try {
            return new URI(u);
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public void setUri(URI uri) {
        this.setScheme(uri.getScheme());
        this.setAuthority(uri.getAuthority());
        this.setPath(uri.isOpaque() ? uri.getSchemeSpecificPart() : uri.getPath());
        this.setQuery(uri.getQuery());
        this.setFragment(uri.getFragment());
    }

    public UriBuilder uri(URI uri) {
        this.setUri(uri);
        return this;
    }

    @CheckForNull
    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(@CheckForNull String scheme) {
        this.scheme = scheme;
    }

    public UriBuilder scheme(@CheckForNull String scheme) {
        this.setScheme(scheme);
        return this;
    }

    @CheckForNull
    public String getAuthority() {
        return this.authority;
    }

    public void setAuthority(@CheckForNull String authority) {
        this.authority = authority;
    }

    public UriBuilder authority(@CheckForNull String authority) {
        this.setAuthority(authority);
        return this;
    }

    @CheckForNull
    public String getPath() {
        return this.path;
    }

    public void setPath(@CheckForNull String path) {
        this.path = path;
    }

    public UriBuilder path(@CheckForNull String path) {
        this.setPath(path);
        return this;
    }

    @CheckForNull
    public String getQuery() {
        return this.query;
    }

    public void setQuery(@CheckForNull String query) {
        this.query = query;
    }

    public UriBuilder query(@CheckForNull String query) {
        this.setQuery(query);
        return this;
    }

    @CheckForNull
    public String getFragment() {
        return this.fragment;
    }

    public void setFragment(@CheckForNull String fragment) {
        this.fragment = fragment;
    }

    public UriBuilder fragment(@CheckForNull String fragment) {
        this.setFragment(fragment);
        return this;
    }
}

