/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.fs.FsCompositeDriver;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDecoratingManager;
import de.schlichtherle.truezip.fs.FsManager;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.FsSyncOptions;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.ExceptionHandler;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class FsFailSafeManager
extends FsDecoratingManager<FsManager> {
    private static final Runtime RUNTIME = Runtime.getRuntime();
    @CheckForNull
    private volatile ShutdownHook shutdownHook;

    public FsFailSafeManager(FsManager manager) {
        super(manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FsController<?> getController(FsMountPoint mountPoint, FsCompositeDriver driver) {
        FsController<?> controller = this.delegate.getController(mountPoint, driver);
        if (null == this.shutdownHook) {
            FsFailSafeManager fsFailSafeManager = this;
            synchronized (fsFailSafeManager) {
                ShutdownHook shutdown = this.shutdownHook;
                if (null == shutdown) {
                    shutdown = new ShutdownHook(this.delegate);
                    RUNTIME.addShutdownHook(shutdown);
                    this.shutdownHook = shutdown;
                }
            }
        }
        return controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <X extends IOException> void sync(BitField<FsSyncOption> options, ExceptionHandler<? super IOException, X> handler) throws X {
        if (null != this.shutdownHook) {
            FsFailSafeManager fsFailSafeManager = this;
            synchronized (fsFailSafeManager) {
                ShutdownHook shutdownHook = this.shutdownHook;
                if (null != shutdownHook) {
                    this.shutdownHook = null;
                    RUNTIME.removeShutdownHook(shutdownHook);
                }
            }
        }
        this.delegate.sync(options, handler);
    }

    private static class ShutdownHook
    extends Thread {
        private final FsManager manager;

        ShutdownHook(FsManager manager) {
            super(ShutdownHook.class.getName());
            super.setPriority(10);
            this.manager = manager;
        }

        @Override
        public void run() {
            try {
                this.manager.sync(FsSyncOptions.UMOUNT);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

