/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsLockModel;
import de.schlichtherle.truezip.fs.FsLockModelDecoratingController;
import de.schlichtherle.truezip.fs.FsNeedsLockRetryException;
import de.schlichtherle.truezip.fs.FsNeedsWriteLockException;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsResourceOpenException;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.FsSyncWarningException;
import de.schlichtherle.truezip.io.DecoratingInputStream;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.io.DecoratingSeekableByteChannel;
import de.schlichtherle.truezip.rof.DecoratingReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.DecoratingInputSocket;
import de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.ExceptionHandler;
import de.schlichtherle.truezip.util.JSE7;
import de.schlichtherle.truezip.util.Threads;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.swing.Icon;

@Immutable
public final class FsLockController
extends FsLockModelDecoratingController<FsController<? extends FsLockModel>> {
    private static final SocketFactory SOCKET_FACTORY = JSE7.AVAILABLE ? SocketFactory.NIO2 : SocketFactory.OIO;
    private static final ThreadLocal<ThreadUtil> threadUtil = (JSE7.AVAILABLE ? ThreadLocalUtilFactory.NEW : ThreadLocalUtilFactory.OLD).newThreadLocalUtil();
    private static final BitField<FsSyncOption> NOT_WAIT_CLOSE_IO = BitField.of((Enum)FsSyncOption.WAIT_CLOSE_INPUT, (Enum[])new FsSyncOption[]{FsSyncOption.WAIT_CLOSE_OUTPUT}).not();
    private final ReentrantReadWriteLock.ReadLock readLock = ((FsLockModel)this.getModel()).readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = ((FsLockModel)this.getModel()).writeLock();

    public FsLockController(FsController<? extends FsLockModel> controller) {
        super(controller);
    }

    @Override
    protected ReentrantReadWriteLock.ReadLock readLock() {
        return this.readLock;
    }

    @Override
    protected ReentrantReadWriteLock.WriteLock writeLock() {
        return this.writeLock;
    }

    <T> T readOrWriteLocked(IOOperation<T> operation) throws IOException {
        try {
            return this.readLocked(operation);
        }
        catch (FsNeedsWriteLockException ex) {
            return this.writeLocked(operation);
        }
    }

    <T> T readLocked(IOOperation<T> operation) throws IOException {
        return this.locked(operation, this.readLock());
    }

    <T> T writeLocked(IOOperation<T> operation) throws IOException {
        assert (!((FsLockModel)this.getModel()).isReadLockedByCurrentThread()) : "Trying to upgrade a read lock to a write lock would only result in a dead lock - see Javadoc for ReentrantReadWriteLock!";
        return this.locked(operation, this.writeLock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private <T> T locked(IOOperation<T> operation, Lock lock) throws IOException {
        ThreadUtil thread = threadUtil.get();
        if (thread.locking) {
            if (!lock.tryLock()) {
                throw FsNeedsLockRetryException.get(this.getModel());
            }
            try {
                T t = operation.call();
                return t;
            }
            finally {
                lock.unlock();
            }
        }
        while (true) {
            lock.lock();
            thread.locking = true;
            T t = operation.call();
            thread.locking = false;
            lock.unlock();
            threadUtil.remove();
            return t;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            thread.locking = false;
                            lock.unlock();
                            throw throwable;
                        }
                        catch (FsNeedsLockRetryException ex) {
                            thread.pause();
                        }
                    }
                    catch (Throwable throwable2) {
                        threadUtil.remove();
                        throw throwable2;
                    }
                }
            }
        }
    }

    @Override
    @Deprecated
    public Icon getOpenIcon() throws IOException {
        return this.readOrWriteLocked(new GetOpenIcon());
    }

    @Override
    @Deprecated
    public Icon getClosedIcon() throws IOException {
        return this.readOrWriteLocked(new GetClosedIcon());
    }

    @Override
    public boolean isReadOnly() throws IOException {
        return this.readOrWriteLocked(new IsReadOnly());
    }

    @Override
    public FsEntry getEntry(final FsEntryName name) throws IOException {
        final class GetEntry
        implements IOOperation<FsEntry> {
            GetEntry() {
            }

            @Override
            public FsEntry call() throws IOException {
                return FsLockController.this.delegate.getEntry(name);
            }
        }
        return this.readOrWriteLocked(new GetEntry());
    }

    @Override
    public boolean isReadable(final FsEntryName name) throws IOException {
        final class IsReadable
        implements IOOperation<Boolean> {
            IsReadable() {
            }

            @Override
            public Boolean call() throws IOException {
                return FsLockController.this.delegate.isReadable(name);
            }
        }
        return this.readOrWriteLocked(new IsReadable());
    }

    @Override
    public boolean isWritable(final FsEntryName name) throws IOException {
        final class IsWritable
        implements IOOperation<Boolean> {
            IsWritable() {
            }

            @Override
            public Boolean call() throws IOException {
                return FsLockController.this.delegate.isWritable(name);
            }
        }
        return this.readOrWriteLocked(new IsWritable());
    }

    @Override
    public boolean isExecutable(final FsEntryName name) throws IOException {
        final class IsExecutable
        implements IOOperation<Boolean> {
            IsExecutable() {
            }

            @Override
            public Boolean call() throws IOException {
                return FsLockController.this.delegate.isExecutable(name);
            }
        }
        return this.readOrWriteLocked(new IsExecutable());
    }

    @Override
    public void setReadOnly(final FsEntryName name) throws IOException {
        final class SetReadOnly
        implements IOOperation<Void> {
            SetReadOnly() {
            }

            @Override
            public Void call() throws IOException {
                FsLockController.this.delegate.setReadOnly(name);
                return null;
            }
        }
        this.writeLocked(new SetReadOnly());
    }

    @Override
    public boolean setTime(final FsEntryName name, final Map<Entry.Access, Long> times, final BitField<FsOutputOption> options) throws IOException {
        final class SetTime
        implements IOOperation<Boolean> {
            SetTime() {
            }

            @Override
            public Boolean call() throws IOException {
                return FsLockController.this.delegate.setTime(name, times, options);
            }
        }
        return this.writeLocked(new SetTime());
    }

    @Override
    public boolean setTime(final FsEntryName name, final BitField<Entry.Access> types, final long value, final BitField<FsOutputOption> options) throws IOException {
        final class SetTime
        implements IOOperation<Boolean> {
            SetTime() {
            }

            @Override
            public Boolean call() throws IOException {
                return FsLockController.this.delegate.setTime(name, types, value, options);
            }
        }
        return this.writeLocked(new SetTime());
    }

    @Override
    public InputSocket<?> getInputSocket(FsEntryName name, BitField<FsInputOption> options) {
        return SOCKET_FACTORY.newInputSocket(this, name, options);
    }

    @Override
    public OutputSocket<?> getOutputSocket(FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        return SOCKET_FACTORY.newOutputSocket(this, name, options, template);
    }

    @Override
    @SuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
    public void mknod(final FsEntryName name, final Entry.Type type, final BitField<FsOutputOption> options, final Entry template) throws IOException {
        final class Mknod
        implements IOOperation<Void> {
            Mknod() {
            }

            @Override
            public Void call() throws IOException {
                FsLockController.this.delegate.mknod(name, type, options, template);
                return null;
            }
        }
        this.writeLocked(new Mknod());
    }

    @Override
    public void unlink(final FsEntryName name, final BitField<FsOutputOption> options) throws IOException {
        final class Unlink
        implements IOOperation<Void> {
            Unlink() {
            }

            @Override
            public Void call() throws IOException {
                FsLockController.this.delegate.unlink(name, options);
                return null;
            }
        }
        this.writeLocked(new Unlink());
    }

    @Override
    public <X extends IOException> void sync(final BitField<FsSyncOption> options, final ExceptionHandler<? super FsSyncException, X> handler) throws IOException {
        final boolean locking = FsLockController.threadUtil.get().locking;
        final BitField<FsSyncOption> sync = locking ? options.and(NOT_WAIT_CLOSE_IO) : options;
        final class Sync
        implements IOOperation<Void> {
            Sync() {
            }

            @Override
            public Void call() throws IOException {
                try {
                    FsLockController.this.delegate.sync(sync, handler);
                }
                catch (FsSyncWarningException ex) {
                    throw ex;
                }
                catch (FsSyncException ex) {
                    if (sync != options) {
                        assert (locking);
                        if (ex.getCause() instanceof FsResourceOpenException) {
                            throw FsNeedsLockRetryException.get(FsLockController.this.getModel());
                        }
                    }
                    throw ex;
                }
                return null;
            }
        }
        this.writeLocked(new Sync());
    }

    void close(final Closeable closeable) throws IOException {
        final class Close
        implements IOOperation<Void> {
            Close() {
            }

            @Override
            public Void call() throws IOException {
                closeable.close();
                return null;
            }
        }
        this.writeLocked(new Close());
    }

    @Immutable
    private static enum ThreadLocalUtilFactory {
        NEW{

            @Override
            ThreadLocal<ThreadUtil> newThreadLocalUtil() {
                return new ThreadLocal<ThreadUtil>(){

                    @Override
                    public ThreadUtil initialValue() {
                        return new ThreadUtil(ThreadLocalRandom.current());
                    }
                };
            }
        }
        ,
        OLD{

            @Override
            ThreadLocal<ThreadUtil> newThreadLocalUtil() {
                return new ThreadLocal<ThreadUtil>(){

                    @Override
                    public ThreadUtil initialValue() {
                        return new ThreadUtil(new Random());
                    }
                };
            }
        };


        abstract ThreadLocal<ThreadUtil> newThreadLocalUtil();
    }

    @NotThreadSafe
    private static final class ThreadUtil {
        boolean locking;
        final Random rnd;

        ThreadUtil(Random rnd) {
            this.rnd = rnd;
        }

        void pause() {
            Threads.pause(1 + this.rnd.nextInt(100));
        }
    }

    private final class LockOutputStream
    extends DecoratingOutputStream {
        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        LockOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void close() throws IOException {
            FsLockController.this.close(this.delegate);
        }
    }

    private final class LockInputStream
    extends DecoratingInputStream {
        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        LockInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() throws IOException {
            FsLockController.this.close(this.delegate);
        }
    }

    private final class LockSeekableByteChannel
    extends DecoratingSeekableByteChannel {
        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        LockSeekableByteChannel(SeekableByteChannel sbc) {
            super(sbc);
        }

        @Override
        public void close() throws IOException {
            FsLockController.this.close(this.delegate);
        }
    }

    private final class LockReadOnlyFile
    extends DecoratingReadOnlyFile {
        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        LockReadOnlyFile(ReadOnlyFile rof) {
            super(rof);
        }

        @Override
        public void close() throws IOException {
            FsLockController.this.close(this.delegate);
        }
    }

    @Immutable
    private class Output
    extends DecoratingOutputSocket<Entry> {
        Output(FsEntryName name, @CheckForNull BitField<FsOutputOption> options, Entry template) {
            super(FsLockController.this.delegate.getOutputSocket(name, options, template));
        }

        @Override
        public Entry getLocalTarget() throws IOException {
            class GetLocalTarget
            implements IOOperation<Entry> {
                GetLocalTarget() {
                }

                @Override
                public Entry call() throws IOException {
                    return (Entry)Output.this.getBoundSocket().getLocalTarget();
                }
            }
            return FsLockController.this.writeLocked(new GetLocalTarget());
        }

        @Override
        public OutputStream newOutputStream() throws IOException {
            class NewOutputStream
            implements IOOperation<OutputStream> {
                NewOutputStream() {
                }

                @Override
                public OutputStream call() throws IOException {
                    return new LockOutputStream(Output.this.getBoundSocket().newOutputStream());
                }
            }
            return FsLockController.this.writeLocked(new NewOutputStream());
        }
    }

    @Immutable
    private final class Nio2Output
    extends Output {
        Nio2Output(FsEntryName name, @CheckForNull BitField<FsOutputOption> options, Entry template) {
            super(name, options, template);
        }

        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            class NewSeekableByteChannel
            implements IOOperation<SeekableByteChannel> {
                NewSeekableByteChannel() {
                }

                @Override
                public SeekableByteChannel call() throws IOException {
                    return new LockSeekableByteChannel(Nio2Output.this.getBoundSocket().newSeekableByteChannel());
                }
            }
            return FsLockController.this.writeLocked(new NewSeekableByteChannel());
        }
    }

    @Immutable
    private class Input
    extends DecoratingInputSocket<Entry> {
        Input(FsEntryName name, BitField<FsInputOption> options) {
            super(FsLockController.this.delegate.getInputSocket(name, options));
        }

        @Override
        public Entry getLocalTarget() throws IOException {
            class GetLocalTarget
            implements IOOperation<Entry> {
                GetLocalTarget() {
                }

                @Override
                public Entry call() throws IOException {
                    return (Entry)Input.this.getBoundSocket().getLocalTarget();
                }
            }
            return FsLockController.this.writeLocked(new GetLocalTarget());
        }

        @Override
        public ReadOnlyFile newReadOnlyFile() throws IOException {
            class NewReadOnlyFile
            implements IOOperation<ReadOnlyFile> {
                NewReadOnlyFile() {
                }

                @Override
                public ReadOnlyFile call() throws IOException {
                    return new LockReadOnlyFile(Input.this.getBoundSocket().newReadOnlyFile());
                }
            }
            return FsLockController.this.writeLocked(new NewReadOnlyFile());
        }

        @Override
        public InputStream newInputStream() throws IOException {
            class NewInputStream
            implements IOOperation<InputStream> {
                NewInputStream() {
                }

                @Override
                public InputStream call() throws IOException {
                    return new LockInputStream(Input.this.getBoundSocket().newInputStream());
                }
            }
            return FsLockController.this.writeLocked(new NewInputStream());
        }
    }

    @Immutable
    private final class Nio2Input
    extends Input {
        Nio2Input(FsEntryName name, BitField<FsInputOption> options) {
            super(name, options);
        }

        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            class NewSeekableByteChannel
            implements IOOperation<SeekableByteChannel> {
                NewSeekableByteChannel() {
                }

                @Override
                public SeekableByteChannel call() throws IOException {
                    return new LockSeekableByteChannel(Nio2Input.this.getBoundSocket().newSeekableByteChannel());
                }
            }
            return FsLockController.this.writeLocked(new NewSeekableByteChannel());
        }
    }

    @Immutable
    private static enum SocketFactory {
        NIO2{

            @Override
            InputSocket<?> newInputSocket(FsLockController controller, FsEntryName name, BitField<FsInputOption> options) {
                FsLockController fsLockController = controller;
                fsLockController.getClass();
                return fsLockController.new Nio2Input(name, options);
            }

            @Override
            OutputSocket<?> newOutputSocket(FsLockController controller, FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
                FsLockController fsLockController = controller;
                fsLockController.getClass();
                return fsLockController.new Nio2Output(name, options, template);
            }
        }
        ,
        OIO{

            @Override
            InputSocket<?> newInputSocket(FsLockController controller, FsEntryName name, BitField<FsInputOption> options) {
                FsLockController fsLockController = controller;
                fsLockController.getClass();
                return fsLockController.new Input(name, options);
            }

            @Override
            OutputSocket<?> newOutputSocket(FsLockController controller, FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
                FsLockController fsLockController = controller;
                fsLockController.getClass();
                return fsLockController.new Output(name, options, template);
            }
        };


        abstract InputSocket<?> newInputSocket(FsLockController var1, FsEntryName var2, BitField<FsInputOption> var3);

        abstract OutputSocket<?> newOutputSocket(FsLockController var1, FsEntryName var2, BitField<FsOutputOption> var3, @CheckForNull Entry var4);
    }

    private static interface IOOperation<T> {
        @Nullable
        public T call() throws IOException;
    }

    private final class IsReadOnly
    implements IOOperation<Boolean> {
        private IsReadOnly() {
        }

        @Override
        public Boolean call() throws IOException {
            return FsLockController.this.delegate.isReadOnly();
        }
    }

    private final class GetClosedIcon
    implements IOOperation<Icon> {
        private GetClosedIcon() {
        }

        @Override
        public Icon call() throws IOException {
            return FsLockController.this.delegate.getClosedIcon();
        }
    }

    private final class GetOpenIcon
    implements IOOperation<Icon> {
        private GetOpenIcon() {
        }

        @Override
        public Icon call() throws IOException {
            return FsLockController.this.delegate.getOpenIcon();
        }
    }
}

