/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.archive.FsArchiveEntry;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.io.InputException;
import de.schlichtherle.truezip.io.SequentialIOException;
import de.schlichtherle.truezip.io.SequentialIOExceptionBuilder;
import de.schlichtherle.truezip.socket.DecoratingInputSocket;
import de.schlichtherle.truezip.socket.DecoratingOutputShop;
import de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.IOSocket;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.JSE7;
import de.schlichtherle.truezip.util.JointIterator;
import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class FsMultiplexedOutputShop<E extends FsArchiveEntry>
extends DecoratingOutputShop<E, OutputShop<E>> {
    private final IOPool<?> pool;
    private final Map<String, BufferedEntryOutputStream> buffers = new LinkedHashMap<String, BufferedEntryOutputStream>();
    private boolean busy;

    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public FsMultiplexedOutputShop(@WillCloseWhenClosed OutputShop<E> output, IOPool<?> pool) {
        super(output);
        this.pool = pool;
        if (null == this.pool) {
            throw new NullPointerException();
        }
    }

    @Override
    public int getSize() {
        return ((OutputShop)this.delegate).getSize() + this.buffers.size();
    }

    @Override
    public Iterator<E> iterator() {
        return new JointIterator(((OutputShop)this.delegate).iterator(), new BufferedEntriesIterator());
    }

    @Override
    @CheckForNull
    public E getEntry(String name) {
        FsArchiveEntry entry = (FsArchiveEntry)((OutputShop)this.delegate).getEntry(name);
        if (null != entry) {
            return (E)entry;
        }
        BufferedEntryOutputStream out = this.buffers.get(name);
        return null == out ? null : (E)out.getLocalTarget();
    }

    @Override
    public OutputSocket<? extends E> getOutputSocket(E local) {
        if (null == local) {
            throw new NullPointerException();
        }
        final class Output
        extends DecoratingOutputSocket<E> {
            final /* synthetic */ FsArchiveEntry val$local;

            Output() {
                this.val$local = fsArchiveEntry;
                super(FsMultiplexedOutputShop.super.getOutputSocket(fsArchiveEntry));
            }

            @Override
            public E getLocalTarget() throws IOException {
                return this.val$local;
            }

            @Override
            public OutputStream newOutputStream() throws IOException {
                OutputSocket output = this.getBoundSocket();
                return FsMultiplexedOutputShop.this.isBusy() ? new BufferedEntryOutputStream(output) : new EntryOutputStream(output);
            }
        }
        return new Output();
    }

    public boolean isBusy() {
        return this.busy;
    }

    @Override
    @DischargesObligation
    public void close() throws IOException {
        if (this.isBusy()) {
            throw new IOException("This multiplexed output shop is still busy with writing a stream!");
        }
        this.storeBuffers();
        assert (this.buffers.isEmpty());
        ((OutputShop)this.delegate).close();
    }

    final void storeBuffers() throws IOException {
        if (this.isBusy()) {
            return;
        }
        SequentialIOExceptionBuilder<IOException, SequentialIOException> builder = SequentialIOExceptionBuilder.create(IOException.class, SequentialIOException.class);
        Iterator<BufferedEntryOutputStream> i = this.buffers.values().iterator();
        while (i.hasNext()) {
            BufferedEntryOutputStream out = i.next();
            try {
                if (!out.storeBuffer()) continue;
                i.remove();
            }
            catch (InputException ex) {
                builder.warn(ex);
            }
            catch (IOException ex) {
                throw (SequentialIOException)builder.fail(ex);
            }
        }
        builder.check();
    }

    @CleanupObligation
    private final class BufferedEntryOutputStream
    extends DecoratingOutputStream {
        final InputSocket<Entry> input;
        final OutputSocket<? extends E> output;
        final IOPool.Entry<?> buffer;
        boolean closed;

        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        BufferedEntryOutputStream(OutputSocket<? extends E> output) throws IOException {
            super(null);
            this.output = output;
            FsArchiveEntry local = (FsArchiveEntry)this.output.getLocalTarget();
            Entry _peer = output.getPeerTarget();
            final IOPool.Entry buffer = this.buffer = (IOPool.Entry)FsMultiplexedOutputShop.this.pool.allocate();
            final Entry peer = null != _peer ? _peer : buffer;
            try {
                final class InputProxy
                extends DecoratingInputSocket<Entry> {
                    InputProxy() {
                        super(entry.getInputSocket());
                    }

                    @Override
                    public Entry getLocalTarget() {
                        return peer;
                    }
                }
                this.input = new InputProxy();
                this.delegate = buffer.getOutputSocket().newOutputStream();
            }
            catch (IOException ex) {
                block4: {
                    try {
                        buffer.release();
                    }
                    catch (IOException ex2) {
                        if (!JSE7.AVAILABLE) break block4;
                        ex.addSuppressed(ex2);
                    }
                }
                throw ex;
            }
            FsMultiplexedOutputShop.this.buffers.put(local.getName(), this);
        }

        E getLocalTarget() {
            try {
                return (FsArchiveEntry)this.output.getLocalTarget();
            }
            catch (IOException ex) {
                throw new AssertionError((Object)ex);
            }
        }

        @Override
        @DischargesObligation
        public void close() throws IOException {
            SequentialIOExceptionBuilder<IOException, SequentialIOException> builder = SequentialIOExceptionBuilder.create(IOException.class, SequentialIOException.class);
            if (!this.closed) {
                try {
                    this.delegate.close();
                    this.closed = true;
                    FsArchiveEntry local = (FsArchiveEntry)this.output.getLocalTarget();
                    if (this == FsMultiplexedOutputShop.this.buffers.get(local.getName())) {
                        this.updateProperties(local, (Entry)this.input.getLocalTarget());
                    } else {
                        this.discardBuffer();
                    }
                }
                catch (IOException ex) {
                    builder.warn(ex);
                }
            }
            try {
                FsMultiplexedOutputShop.this.storeBuffers();
            }
            catch (IOException ex) {
                builder.warn(ex);
            }
            builder.check();
        }

        void updateProperties(E local, Entry peer) {
            for (Entry.Access type : Entry.ALL_ACCESS_SET) {
                if (-1L != local.getTime(type)) continue;
                local.setTime(type, peer.getTime(type));
            }
            if (-1L == local.getSize(Entry.Size.DATA)) {
                local.setSize(Entry.Size.DATA, peer.getSize(Entry.Size.DATA));
            }
        }

        void discardBuffer() throws IOException {
            assert (this.closed);
            this.buffer.release();
        }

        boolean storeBuffer() throws InputException, IOException {
            if (!this.closed || FsMultiplexedOutputShop.this.isBusy()) {
                return false;
            }
            IOSocket.copy(this.input, this.output);
            this.buffer.release();
            return true;
        }
    }

    @CleanupObligation
    private final class EntryOutputStream
    extends DecoratingOutputStream {
        boolean closed;

        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        EntryOutputStream(OutputSocket<? extends E> output) throws IOException {
            super(output.newOutputStream());
            FsMultiplexedOutputShop.this.busy = true;
        }

        @Override
        @DischargesObligation
        public void close() throws IOException {
            if (!this.closed) {
                this.delegate.close();
                this.closed = true;
                FsMultiplexedOutputShop.this.busy = false;
            }
            FsMultiplexedOutputShop.this.storeBuffers();
        }
    }

    private class BufferedEntriesIterator
    implements Iterator<E> {
        final Iterator<BufferedEntryOutputStream> i;

        private BufferedEntriesIterator() {
            this.i = FsMultiplexedOutputShop.this.buffers.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public E next() {
            return this.i.next().getLocalTarget();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

