/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsControllerException;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsEntryNotFoundException;
import de.schlichtherle.truezip.fs.FsFalsePositiveException;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsLockModel;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsNeedsLockRetryException;
import de.schlichtherle.truezip.fs.FsNeedsSyncException;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsOutputOptions;
import de.schlichtherle.truezip.fs.FsPersistentFalsePositiveException;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.FsSyncWarningException;
import de.schlichtherle.truezip.fs.archive.FsArchiveDriver;
import de.schlichtherle.truezip.fs.archive.FsArchiveEntry;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystem;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystemEvent;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystemTouchListener;
import de.schlichtherle.truezip.fs.archive.FsCovariantEntry;
import de.schlichtherle.truezip.fs.archive.FsFileSystemArchiveController;
import de.schlichtherle.truezip.io.InputClosedException;
import de.schlichtherle.truezip.io.InputException;
import de.schlichtherle.truezip.io.OutputClosedException;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.ClutchInputSocket;
import de.schlichtherle.truezip.socket.ClutchOutputSocket;
import de.schlichtherle.truezip.socket.DisconnectingInputShop;
import de.schlichtherle.truezip.socket.DisconnectingOutputShop;
import de.schlichtherle.truezip.socket.IOSocket;
import de.schlichtherle.truezip.socket.InputService;
import de.schlichtherle.truezip.socket.InputShop;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.LockInputShop;
import de.schlichtherle.truezip.socket.LockOutputShop;
import de.schlichtherle.truezip.socket.OutputService;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.ExceptionHandler;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.Collections;
import java.util.Iterator;
import java.util.TooManyListenersException;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import javax.swing.Icon;

@NotThreadSafe
final class FsTargetArchiveController<E extends FsArchiveEntry>
extends FsFileSystemArchiveController<E> {
    private static final BitField<FsInputOption> MOUNT_INPUT_OPTIONS = BitField.of(FsInputOption.CACHE);
    private final FsArchiveDriver<E> driver;
    private final FsController<?> parent;
    private final FsEntryName name;
    @CheckForNull
    private InputArchive<E> inputArchive;
    @CheckForNull
    private OutputArchive<E> outputArchive;
    private final FsArchiveFileSystemTouchListener<E> touchListener = new TouchListener();

    FsTargetArchiveController(FsLockModel model, FsController<?> parent, FsArchiveDriver<E> driver) {
        super(model);
        if (null == driver) {
            throw new NullPointerException();
        }
        if (model.getParent() != parent.getModel()) {
            throw new IllegalArgumentException("Parent/member mismatch!");
        }
        this.driver = driver;
        this.parent = parent;
        this.name = this.getMountPoint().getPath().getEntryName();
        assert (this.invariants());
    }

    private boolean invariants() {
        assert (null != this.driver);
        assert (null != this.parent);
        assert (null != this.name);
        FsArchiveFileSystem fs = this.getFileSystem();
        InputArchive<E> ia = this.inputArchive;
        OutputArchive<E> oa = this.outputArchive;
        assert (null == ia || null != fs) : "null != ia => null != fs";
        assert (null == oa || null != fs) : "null != oa => null != fs";
        assert (null == fs || null != ia || null != oa) : "null != fs => null != ia || null != oa";
        return true;
    }

    @Nullable
    InputArchive<E> getInputArchive() throws FsNeedsSyncException {
        InputArchive<E> ia = this.inputArchive;
        if (null != ia && ia.isClosed()) {
            throw FsNeedsSyncException.get(this.getModel(), FsEntryName.ROOT, Entry.Access.READ);
        }
        return ia;
    }

    private void setInputArchive(@CheckForNull InputArchive<E> ia) {
        assert (null == ia || null == this.inputArchive);
        this.inputArchive = ia;
        if (null != ia) {
            this.setTouched(true);
        }
    }

    @Nullable
    OutputArchive<E> getOutputArchive() throws FsNeedsSyncException {
        OutputArchive<E> oa = this.outputArchive;
        if (null != oa && oa.isClosed()) {
            throw FsNeedsSyncException.get(this.getModel(), FsEntryName.ROOT, Entry.Access.WRITE);
        }
        return oa;
    }

    private void setOutputArchive(@CheckForNull OutputArchive<E> oa) {
        assert (null == oa || null == this.outputArchive);
        this.outputArchive = oa;
        if (null != oa) {
            this.setTouched(true);
        }
    }

    @Override
    public FsController<?> getParent() {
        return this.parent;
    }

    @Override
    @Deprecated
    public Icon getOpenIcon() throws IOException {
        this.autoMount();
        return this.driver.getOpenIcon((FsModel)this.getModel());
    }

    @Override
    @Deprecated
    public Icon getClosedIcon() throws IOException {
        this.autoMount();
        return this.driver.getClosedIcon((FsModel)this.getModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void mount(boolean autoCreate) throws IOException {
        try {
            this.mount0(autoCreate);
        }
        finally {
            assert (this.invariants());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    private void mount0(boolean autoCreate) throws IOException {
        FsArchiveFileSystem<E> fs;
        FsEntry pe;
        try {
            pe = this.parent.getEntry(this.name);
        }
        catch (FsControllerException ex) {
            if ($assertionsDisabled || ex instanceof FsNeedsLockRetryException) throw ex;
            throw new AssertionError();
        }
        catch (IOException inaccessibleEntry) {
            throw autoCreate ? inaccessibleEntry : new FsFalsePositiveException((FsModel)this.getModel(), inaccessibleEntry);
        }
        if (null == pe) {
            if (!autoCreate) throw new FsFalsePositiveException((FsModel)this.getModel(), new FsEntryNotFoundException((FsModel)this.parent.getModel(), this.name, "no such entry"));
            this.makeOutputArchive();
            fs = FsArchiveFileSystem.newEmptyFileSystem(this.driver);
        } else {
            try {
                boolean ro = !this.parent.isWritable(this.name);
                InputSocket<?> is = this.driver.getInputSocket(this.parent, this.name, MOUNT_INPUT_OPTIONS);
                InputArchive<E> ia = new InputArchive<E>(this.driver.newInputShop((FsModel)this.getModel(), is));
                try {
                    fs = FsArchiveFileSystem.newPopulatedFileSystem(this.driver, ia.getArchive(), pe, ro);
                }
                catch (IOException ex) {
                    ia.close();
                    throw ex;
                }
                this.setInputArchive(ia);
            }
            catch (FsControllerException ex) {
                if ($assertionsDisabled || ex instanceof FsNeedsLockRetryException) throw ex;
                throw new AssertionError();
            }
            catch (IOException ex) {
                throw pe.isType(Entry.Type.SPECIAL) ? new FsFalsePositiveException((FsModel)this.getModel(), ex) : new FsPersistentFalsePositiveException((FsModel)this.getModel(), ex);
            }
        }
        try {
            fs.addFsArchiveFileSystemTouchListener(this.touchListener);
        }
        catch (TooManyListenersException ex) {
            throw new AssertionError((Object)ex);
        }
        this.setFileSystem(fs);
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    OutputArchive<E> makeOutputArchive() throws IOException {
        OutputArchive<E> oa = this.getOutputArchive();
        if (null != oa) {
            return oa;
        }
        BitField<FsOutputOption> options = this.getContext().getOutputOptions().and(FsOutputOptions.OUTPUT_PREFERENCES_MASK).set(FsOutputOption.CACHE);
        OutputSocket<?> os = this.driver.getOutputSocket(this.parent, this.name, options, null);
        InputArchive<E> ia = this.getInputArchive();
        try {
            oa = new OutputArchive<E>(this.driver.newOutputShop((FsModel)this.getModel(), os, null == ia ? null : ia.getArchive()));
        }
        catch (FsControllerException ex) {
            assert (ex instanceof FsNeedsLockRetryException);
            throw ex;
        }
        this.setOutputArchive(oa);
        return oa;
    }

    @Override
    InputSocket<? extends E> getInputSocket(final String name) {
        class Input
        extends ClutchInputSocket<E> {
            Input() {
            }

            @Override
            protected InputSocket<? extends E> getLazyDelegate() throws IOException {
                return FsTargetArchiveController.this.getInputArchive().getInputSocket(name);
            }

            @Override
            public E getLocalTarget() throws IOException {
                try {
                    return (FsArchiveEntry)super.getLocalTarget();
                }
                catch (InputClosedException ex) {
                    throw this.map(ex);
                }
            }

            @Override
            public ReadOnlyFile newReadOnlyFile() throws IOException {
                try {
                    return super.newReadOnlyFile();
                }
                catch (InputClosedException ex) {
                    throw this.map(ex);
                }
            }

            @Override
            public SeekableByteChannel newSeekableByteChannel() throws IOException {
                try {
                    return super.newSeekableByteChannel();
                }
                catch (InputClosedException ex) {
                    throw this.map(ex);
                }
            }

            @Override
            public InputStream newInputStream() throws IOException {
                try {
                    return super.newInputStream();
                }
                catch (InputClosedException ex) {
                    throw this.map(ex);
                }
            }

            IOException map(IOException ex) {
                return FsNeedsSyncException.get(FsTargetArchiveController.this.getModel(), name, ex);
            }
        }
        return new Input();
    }

    @Override
    OutputSocket<? extends E> getOutputSocket(E entry) {
        class Output
        extends ClutchOutputSocket<E> {
            final /* synthetic */ FsArchiveEntry val$entry;

            Output() {
                this.val$entry = fsArchiveEntry;
            }

            @Override
            protected OutputSocket<? extends E> getLazyDelegate() throws IOException {
                return FsTargetArchiveController.this.makeOutputArchive().getOutputSocket(this.val$entry);
            }

            @Override
            public E getLocalTarget() throws IOException {
                try {
                    return (FsArchiveEntry)super.getLocalTarget();
                }
                catch (OutputClosedException ex) {
                    throw this.map(ex);
                }
            }

            @Override
            public SeekableByteChannel newSeekableByteChannel() throws IOException {
                try {
                    return super.newSeekableByteChannel();
                }
                catch (OutputClosedException ex) {
                    throw this.map(ex);
                }
            }

            @Override
            public OutputStream newOutputStream() throws IOException {
                try {
                    return super.newOutputStream();
                }
                catch (OutputClosedException ex) {
                    throw this.map(ex);
                }
            }

            IOException map(IOException ex) {
                return FsNeedsSyncException.get(FsTargetArchiveController.this.getModel(), this.val$entry.getName(), ex);
            }
        }
        return new Output();
    }

    @Override
    void checkSync(FsEntryName name, @CheckForNull Entry.Access intention) throws FsNeedsSyncException {
        FsArchiveEntry iae;
        String aen;
        FsCovariantEntry fse;
        FsArchiveFileSystem fs;
        if (this.getContext().get(FsOutputOption.GROW)) {
            if (null == intention) {
                if (this.driver.getRedundantMetaDataSupport()) {
                    return;
                }
            } else if (Entry.Access.WRITE == intention && this.driver.getRedundantContentSupport()) {
                this.getOutputArchive();
                return;
            }
        }
        if (null == (fs = this.getFileSystem()) || null == (fse = fs.getEntry(name))) {
            return;
        }
        if (name.isRoot()) {
            return;
        }
        OutputArchive<E> oa = this.getOutputArchive();
        if (null != oa) {
            aen = fse.getEntry().getName();
            if (null != oa.getEntry(aen)) {
                throw FsNeedsSyncException.get(this.getModel(), name, intention);
            }
        } else {
            aen = null;
        }
        if (Entry.Access.READ != intention) {
            return;
        }
        InputArchive<E> ia = this.getInputArchive();
        if (null != ia) {
            if (null == aen) {
                aen = fse.getEntry().getName();
            }
            iae = (FsArchiveEntry)ia.getEntry(aen);
        } else {
            iae = null;
        }
        if (null == iae) {
            throw FsNeedsSyncException.get(this.getModel(), name, Entry.Access.READ);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <X extends IOException> void sync(BitField<FsSyncOption> options, ExceptionHandler<? super FsSyncException, X> handler) throws FsControllerException, X {
        assert (this.isWriteLockedByCurrentThread());
        try {
            if (!options.get(FsSyncOption.ABORT_CHANGES)) {
                this.copy(handler);
            }
            this.close(options, handler);
        }
        finally {
            assert (this.invariants());
        }
    }

    private <X extends IOException> void copy(final ExceptionHandler<? super FsSyncException, X> handler) throws X {
        OutputArchive<E> oa = this.outputArchive;
        if (null == oa || oa.isClosed()) {
            return;
        }
        assert (!oa.isClosed());
        DisconnectingOutputShop<E> os = oa.getClutch();
        InputArchive<E> ia = this.inputArchive;
        if (null != ia && ia.isClosed()) {
            return;
        }
        assert (null == ia || !ia.isClosed());
        InputService<E> is = null != ia ? ia.getClutch() : new DummyInputService();
        class Filter
        implements ExceptionHandler<IOException, X> {
            IOException warning;

            Filter() {
            }

            @Override
            public X fail(IOException cause) {
                assert (false) : "should not get used by copy()";
                assert (null != cause);
                assert (!(cause instanceof FsControllerException));
                return (IOException)handler.fail(new FsSyncException((FsModel)FsTargetArchiveController.this.getModel(), cause));
            }

            @Override
            public void warn(IOException cause) throws IOException {
                assert (null != cause);
                assert (!(cause instanceof FsControllerException));
                if (null != this.warning || !(cause instanceof InputException)) {
                    throw (IOException)handler.fail(new FsSyncException((FsModel)FsTargetArchiveController.this.getModel(), cause));
                }
                this.warning = cause;
                handler.warn(new FsSyncWarningException((FsModel)FsTargetArchiveController.this.getModel(), cause));
            }
        }
        FsTargetArchiveController.copy(this.getFileSystem(), is, os, new Filter());
    }

    private static <E extends FsArchiveEntry, X extends IOException> void copy(FsArchiveFileSystem<E> fs, InputService<E> is, OutputService<E> os, ExceptionHandler<? super IOException, X> handler) throws X {
        for (FsCovariantEntry<E> fse : fs) {
            for (FsArchiveEntry ae : fse.getEntries()) {
                String aen = ae.getName();
                if (null != os.getEntry(aen)) continue;
                try {
                    if (Entry.Type.DIRECTORY == ae.getType()) {
                        if (fse.isRoot() || -1L == ae.getTime(Entry.Access.WRITE)) continue;
                        os.getOutputSocket(ae).newOutputStream().close();
                        continue;
                    }
                    if (null != is.getEntry(aen)) {
                        IOSocket.copy(is.getInputSocket(aen), os.getOutputSocket(ae));
                        continue;
                    }
                    for (Entry.Size size : Entry.ALL_SIZE_SET) {
                        ae.setSize(size, -1L);
                    }
                    ae.setSize(Entry.Size.DATA, 0L);
                    os.getOutputSocket(ae).newOutputStream().close();
                }
                catch (IOException ex) {
                    handler.warn(ex);
                }
            }
        }
    }

    private <X extends IOException> void close(BitField<FsSyncOption> options, ExceptionHandler<? super FsSyncException, X> handler) throws FsControllerException, X {
        InputArchive<E> ia = this.inputArchive;
        if (null != ia) {
            try {
                ia.close();
            }
            catch (FsControllerException nonLocalControlFlow) {
                assert (nonLocalControlFlow instanceof FsNeedsLockRetryException);
                throw nonLocalControlFlow;
            }
            catch (IOException ex) {
                handler.warn(new FsSyncWarningException((FsModel)this.getModel(), ex));
            }
            this.setInputArchive(null);
        }
        FsSyncException ex = null;
        OutputArchive<E> oa = this.outputArchive;
        if (null != oa) {
            try {
                oa.close();
            }
            catch (FsControllerException nonLocalControlFlow) {
                assert (nonLocalControlFlow instanceof FsNeedsLockRetryException);
                throw nonLocalControlFlow;
            }
            catch (IOException ex2) {
                ex = new FsSyncException((FsModel)this.getModel(), ex2);
            }
            this.setOutputArchive(null);
        }
        this.setFileSystem(null);
        if (options.get(FsSyncOption.ABORT_CHANGES) || options.get(FsSyncOption.CLEAR_CACHE)) {
            this.setTouched(false);
        }
        if (null != ex) {
            throw (IOException)handler.fail(ex);
        }
    }

    private final class TouchListener
    implements FsArchiveFileSystemTouchListener<E> {
        private TouchListener() {
        }

        @Override
        public void beforeTouch(FsArchiveFileSystemEvent<? extends E> event) throws IOException {
            assert (event.getSource() == FsTargetArchiveController.this.getFileSystem());
            FsTargetArchiveController.this.makeOutputArchive();
            assert (FsTargetArchiveController.this.isTouched());
        }

        @Override
        public void afterTouch(FsArchiveFileSystemEvent<? extends E> event) {
            assert (event.getSource() == FsTargetArchiveController.this.getFileSystem());
            assert (FsTargetArchiveController.this.isTouched());
        }
    }

    private static final class OutputArchive<E extends FsArchiveEntry>
    extends LockOutputShop<E> {
        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        OutputArchive(@WillCloseWhenClosed OutputShop<E> output) {
            super(new DisconnectingOutputShop<E>(output));
        }

        boolean isClosed() {
            return this.getClutch().isClosed();
        }

        DisconnectingOutputShop<E> getClutch() {
            return (DisconnectingOutputShop)this.delegate;
        }
    }

    private static final class InputArchive<E extends FsArchiveEntry>
    extends LockInputShop<E> {
        final InputShop<E> archive;

        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        InputArchive(@WillCloseWhenClosed InputShop<E> input) {
            super(new DisconnectingInputShop<E>(input));
            this.archive = input;
        }

        boolean isClosed() {
            return this.getClutch().isClosed();
        }

        DisconnectingInputShop<E> getClutch() {
            return (DisconnectingInputShop)this.delegate;
        }

        InputShop<E> getArchive() {
            assert (!this.isClosed());
            return this.archive;
        }
    }

    private static final class DummyInputService<E extends Entry>
    implements InputService<E> {
        private DummyInputService() {
        }

        @Override
        public int getSize() {
            return 0;
        }

        @Override
        public Iterator<E> iterator() {
            return Collections.emptyList().iterator();
        }

        @Override
        @CheckForNull
        public E getEntry(String name) {
            return null;
        }

        @Override
        public InputSocket<? extends E> getInputSocket(String name) {
            throw new UnsupportedOperationException();
        }
    }
}

