/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.io;

import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.test.TestConfig;
import de.schlichtherle.truezip.test.ThrowControl;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.CheckForNull;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class ThrowingOutputStream
extends DecoratingOutputStream {
    private final ThrowControl control;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public ThrowingOutputStream(@WillCloseWhenClosed OutputStream out) {
        this(out, null);
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public ThrowingOutputStream(@WillCloseWhenClosed OutputStream out, @CheckForNull ThrowControl control) {
        super(out);
        if (null == out) {
            throw new NullPointerException();
        }
        this.control = null != control ? control : TestConfig.get().getThrowControl();
    }

    private void checkAllExceptions() throws IOException {
        this.control.check((Object)this, IOException.class);
        this.checkUndeclaredExceptions();
    }

    private void checkUndeclaredExceptions() {
        this.control.check((Object)this, RuntimeException.class);
        this.control.check((Object)this, Error.class);
    }

    public void write(int b) throws IOException {
        this.checkAllExceptions();
        this.delegate.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.checkAllExceptions();
        this.delegate.write(b, off, len);
    }

    public void flush() throws IOException {
        this.checkAllExceptions();
        this.delegate.flush();
    }

    public void close() throws IOException {
        this.checkAllExceptions();
        this.delegate.close();
    }
}

