/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.rof;

import de.schlichtherle.truezip.rof.AbstractReadOnlyFile;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class MemoryMappedReadOnlyFile
extends AbstractReadOnlyFile {
    private static final int WINDOW_LEN = Integer.MAX_VALUE;
    private FileChannel channel;
    private long windowOff = -1L;
    private ByteBuffer window;

    public MemoryMappedReadOnlyFile(File file) throws FileNotFoundException {
        this.channel = new FileInputStream(file).getChannel();
        try {
            try {
                this.window(0L);
            }
            catch (IOException ex) {
                this.channel.close();
                throw ex;
            }
        }
        catch (IOException ex) {
            throw (FileNotFoundException)new FileNotFoundException(ex.toString()).initCause(ex);
        }
        assert (this.window != null);
        assert (this.windowOff == 0L);
    }

    private int available() throws IOException {
        this.assertOpen();
        if (0 >= this.window.remaining()) {
            this.window(this.windowOff + Integer.MAX_VALUE);
        }
        return this.window.remaining();
    }

    private void window(long newWindowOff) throws IOException {
        if (this.windowOff == newWindowOff) {
            return;
        }
        long size = this.channel.size();
        if (newWindowOff > size) {
            newWindowOff = size;
        }
        this.window = this.channel.map(FileChannel.MapMode.READ_ONLY, newWindowOff, Math.min(size - newWindowOff, Integer.MAX_VALUE));
        assert (this.window != null);
        this.windowOff = newWindowOff;
    }

    public long length() throws IOException {
        this.assertOpen();
        return this.channel.size();
    }

    public long getFilePointer() throws IOException {
        this.assertOpen();
        return this.windowOff + (long)this.window.position();
    }

    public void seek(long fp) throws IOException {
        this.assertOpen();
        if (0L > fp) {
            throw new IOException("file pointer must not be negative");
        }
        long length = this.length();
        if (fp > length) {
            throw new IOException("file pointer (" + fp + ") is larger than file length (" + length + ")");
        }
        this.window(fp / Integer.MAX_VALUE * Integer.MAX_VALUE);
        this.window.position((int)(fp % Integer.MAX_VALUE));
    }

    public int read() throws IOException {
        return this.available() > 0 ? this.window.get() & 0xFF : -1;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        if (0 == len) {
            return 0;
        }
        int avail = this.available();
        if (avail <= 0) {
            return -1;
        }
        if (null == buf) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > buf.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len > avail) {
            len = avail;
        }
        this.window.get(buf, off, len);
        return len;
    }

    @SuppressWarnings(value={"DM_GC"})
    public void close() throws IOException {
        FileChannel channel = this.channel;
        if (null == channel) {
            return;
        }
        channel.close();
        this.channel = null;
        this.window = null;
        System.gc();
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void assertOpen() throws IOException {
        if (null == this.channel) {
            throw new IOException("file is closed");
        }
    }
}

