/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.socket;

import de.schlichtherle.truezip.socket.ByteArrayIOBuffer;
import de.schlichtherle.truezip.socket.IOPool;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ByteArrayIOPool
implements IOPool<ByteArrayIOBuffer> {
    private static final String BUFFER_NAME = "buffer-";
    private final int initialCapacity;
    private final AtomicInteger total = new AtomicInteger();
    private final AtomicInteger active = new AtomicInteger();

    public ByteArrayIOPool(int initialCapacity) {
        if (0 > initialCapacity) {
            throw new IllegalArgumentException("Negative initial capacity: " + initialCapacity);
        }
        this.initialCapacity = initialCapacity;
    }

    public IOPool.Entry<ByteArrayIOBuffer> allocate() {
        Buffer entry = new Buffer(this.total.getAndIncrement());
        this.active.getAndIncrement();
        return entry;
    }

    public void release(IOPool.Entry<ByteArrayIOBuffer> entry) throws IOException {
        entry.release();
    }

    public int getSize() {
        return this.active.get();
    }

    @NotThreadSafe
    private final class Buffer
    extends ByteArrayIOBuffer
    implements IOPool.Entry<ByteArrayIOBuffer> {
        private boolean released;

        Buffer(int i) {
            super(ByteArrayIOPool.BUFFER_NAME + i, ByteArrayIOPool.this.initialCapacity);
        }

        public void release() throws IOException {
            if (this.released) {
                return;
            }
            ByteArrayIOPool.this.active.getAndDecrement();
            this.setData(null);
            this.released = true;
        }
    }
}

