/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.test;

import de.schlichtherle.truezip.util.Throwables;
import edu.umd.cs.findbugs.annotations.CleanupObligation;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;

@CleanupObligation
@NotThreadSafe
public final class ThrowControl {
    private final Map<Class<?>, Throwable> throwables;

    public ThrowControl() {
        this.throwables = new HashMap();
    }

    public ThrowControl(ThrowControl template) {
        this.throwables = new HashMap(template.throwables);
    }

    public Throwable trigger(Throwable toThrow) {
        return this.trigger(Object.class, toThrow);
    }

    public Throwable trigger(Class<?> from, Throwable toThrow) {
        if (null == from) {
            throw new NullPointerException();
        }
        Throwables.wrap((Throwable)toThrow);
        return this.throwables.put(from, toThrow);
    }

    public Throwable clear(Class<?> from) {
        return this.throwables.remove(from);
    }

    public <X extends Throwable> void check(Object thiz, Class<X> throwz) throws X {
        this.check(thiz.getClass(), throwz);
    }

    private <X extends Throwable> void check(Class<?> thiz, Class<X> throwz) throws X {
        Throwable toThrow = this.throwables.remove(thiz);
        if (null != toThrow) {
            if (throwz.isInstance(toThrow)) {
                throw (Throwable)throwz.cast(Throwables.wrap((Throwable)toThrow));
            }
            this.throwables.put(thiz, toThrow);
        }
        for (Class<?> ic : thiz.getInterfaces()) {
            this.check(ic, throwz);
        }
        Class<?> sc = thiz.getSuperclass();
        if (null != sc) {
            this.check(sc, throwz);
        }
    }
}

