/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.util;

import de.schlichtherle.truezip.util.BitField;
import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class BitFieldTest {
    private static final Logger logger = Logger.getLogger(BitFieldTest.class.getName());

    @Test
    public void testSetOne() {
        BitField bits = BitField.noneOf(Dummy.class).set((Enum)Dummy.ONE);
        Assert.assertFalse((boolean)bits.isEmpty());
        Assert.assertThat((Object)bits.cardinality(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)bits.get((Enum)Dummy.ONE));
        Assert.assertTrue((boolean)bits.is((Enum)Dummy.ONE));
        Assert.assertThat((Object)BitField.copyOf((Collection)bits.toEnumSet()), (Matcher)CoreMatchers.equalTo((Object)bits));
    }

    @Test
    public void testClearOne() {
        BitField bits = BitField.of((Enum)Dummy.ONE).clear((Enum)Dummy.ONE);
        Assert.assertTrue((boolean)bits.isEmpty());
        Assert.assertThat((Object)bits.cardinality(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertFalse((boolean)bits.get((Enum)Dummy.ONE));
        Assert.assertFalse((boolean)bits.is((Enum)Dummy.ONE));
        Assert.assertThat((Object)BitField.copyOf((Collection)bits.toEnumSet()), (Matcher)CoreMatchers.equalTo((Object)bits));
    }

    @Test
    public void testSetTwo() {
        BitField bits = BitField.of((Enum)Dummy.ONE, (Enum[])new Dummy[]{Dummy.TWO});
        Assert.assertFalse((boolean)bits.isEmpty());
        Assert.assertThat((Object)bits.cardinality(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)bits.get((Enum)Dummy.ONE));
        Assert.assertTrue((boolean)bits.is((Enum)Dummy.ONE));
        Assert.assertTrue((boolean)bits.get((Enum)Dummy.TWO));
        Assert.assertTrue((boolean)bits.is((Enum)Dummy.TWO));
        Assert.assertThat((Object)BitField.copyOf((Collection)bits.toEnumSet()), (Matcher)CoreMatchers.equalTo((Object)bits));
    }

    @Test
    public void testClearTwo() {
        BitField bits = BitField.of((Enum)Dummy.ONE, (Enum[])new Dummy[]{Dummy.TWO}).clear((Enum)Dummy.ONE).clear((Enum)Dummy.TWO);
        Assert.assertTrue((boolean)bits.isEmpty());
        Assert.assertThat((Object)bits.cardinality(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertFalse((boolean)bits.get((Enum)Dummy.ONE));
        Assert.assertFalse((boolean)bits.is((Enum)Dummy.ONE));
        Assert.assertFalse((boolean)bits.get((Enum)Dummy.TWO));
        Assert.assertFalse((boolean)bits.is((Enum)Dummy.TWO));
        Assert.assertThat((Object)BitField.copyOf((Collection)bits.toEnumSet()), (Matcher)CoreMatchers.equalTo((Object)bits));
    }

    @Test
    public void testAllOf() {
        BitField bits = BitField.allOf(Dummy.class);
        Assert.assertThat((Object)bits.cardinality(), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void testNot() {
        BitField bits = BitField.allOf(Dummy.class);
        Assert.assertThat((Object)bits.cardinality(), (Matcher)CoreMatchers.is((Object)3));
        bits = bits.not();
        Assert.assertThat((Object)bits.cardinality(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testAnd() {
        BitField bits = BitField.allOf(Dummy.class);
        Assert.assertThat((Object)bits.cardinality(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)bits.and(BitField.allOf(Dummy.class)), (Matcher)CoreMatchers.sameInstance((Object)bits));
        bits = bits.and(BitField.noneOf(Dummy.class));
        Assert.assertThat((Object)bits.cardinality(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testOr() {
        BitField bits = BitField.noneOf(Dummy.class);
        Assert.assertThat((Object)bits.cardinality(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)bits.and(BitField.noneOf(Dummy.class)), (Matcher)CoreMatchers.sameInstance((Object)bits));
        bits = bits.or(BitField.allOf(Dummy.class));
        Assert.assertThat((Object)bits.cardinality(), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void testIterator() {
        BitField bits = BitField.allOf(Dummy.class);
        Iterator it = bits.iterator();
        Dummy[] dummies = Dummy.values();
        for (int i = 0; i < dummies.length; ++i) {
            assert (it.hasNext());
            Assert.assertThat(it.next(), (Matcher)CoreMatchers.sameInstance((Object)((Object)dummies[i])));
            try {
                it.remove();
                Assert.fail();
                continue;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testSerialization() throws IOException, ClassNotFoundException {
        ExceptionListener listener = new ExceptionListener(){

            @Override
            public void exceptionThrown(Exception ex) {
                throw new UndeclaredThrowableException(ex);
            }
        };
        for (Dummy[] params : new Dummy[][]{{Dummy.ONE}, {Dummy.ONE, Dummy.TWO}, {Dummy.ONE, Dummy.TWO, Dummy.THREE}}) {
            BitField original = BitField.copyOf(Arrays.asList(params));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(original);
            oos.close();
            logger.log(Level.FINEST, "Number of serialized bytes: {0}", bos.size());
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bis);
            Object clone = ois.readObject();
            ois.close();
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)original)));
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.equalTo((Object)original));
            bos = new ByteArrayOutputStream();
            XMLEncoder enc = new XMLEncoder(bos);
            enc.setExceptionListener(listener);
            enc.writeObject(original);
            enc.close();
            logger.log(Level.FINEST, bos.toString("UTF-8"));
            bis = new ByteArrayInputStream(bos.toByteArray());
            XMLDecoder dec = new XMLDecoder(bis);
            clone = dec.readObject();
            dec.close();
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)original)));
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.equalTo((Object)original));
        }
    }

    static enum Dummy {
        ONE,
        TWO,
        THREE;

    }
}

