/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.util;

import de.schlichtherle.truezip.util.ExceptionBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class ExceptionBuilderTestSuite<B extends ExceptionBuilder<C, X>, C extends Exception, X extends Exception> {
    protected final Class<X> clazz;
    protected B builder;

    protected ExceptionBuilderTestSuite(Class<X> clazz) {
        this.clazz = clazz;
        if (null == this.clazz) {
            throw new NullPointerException();
        }
    }

    protected abstract B newBuilder();

    protected abstract C newCause();

    @Before
    public void setUp() {
        this.builder = this.newBuilder();
        if (null == this.builder) {
            throw new NullPointerException();
        }
    }

    @Test
    public void testCheck() throws X {
        this.builder.check();
    }

    @Test
    public void testFailThenCheck() throws X {
        try {
            this.builder.fail(null);
            Assert.fail();
        }
        catch (RuntimeException expected) {
            this.builder.check();
        }
        Assert.assertNotNull((Object)this.builder.fail(this.newCause()));
        this.builder.check();
    }

    @Test
    public void testWarnThenCheck() throws X {
        try {
            this.builder.warn(null);
            Assert.fail();
        }
        catch (RuntimeException expected) {
            this.builder.check();
        }
        try {
            this.builder.warn(this.newCause());
            this.builder.check();
            Assert.fail();
        }
        catch (Exception expected) {
            Assert.assertTrue((boolean)this.clazz.isInstance(expected));
            this.builder.check();
        }
    }
}

