/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.util;

import de.schlichtherle.truezip.util.CanonicalStringSet;
import de.schlichtherle.truezip.util.SuffixSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class SuffixSetTest {
    private SuffixSet empty;
    private SuffixSet[] sets;

    @Before
    public void setUp() {
        this.empty = new SuffixSet("");
        this.sets = new SuffixSet[]{new SuffixSet("suffix1|suffix2"), new SuffixSet("suffix2|suffix1"), new SuffixSet(".suffix1|.suffix2"), new SuffixSet(".suffix2|.suffix1"), new SuffixSet("SUFFIX1|SUFFIX2"), new SuffixSet("SUFFIX2|SUFFIX1"), new SuffixSet(".SUFFIX1|.SUFFIX2"), new SuffixSet(".SUFFIX2|.SUFFIX1"), new SuffixSet("SuFfIx1|SuFfIx2"), new SuffixSet("SuFfIx2|SuFfIx1"), new SuffixSet(".sUfFiX1|.sUfFiX2"), new SuffixSet(".sUfFiX2|.sUfFiX1"), new SuffixSet("suffix1|.suffix2|suffix2|.suffix1"), new SuffixSet("suffix2|.suffix1|suffix1|.suffix2"), new SuffixSet("SUFFIX1|.SUFFIX2|SUFFIX2|.SUFFIX1"), new SuffixSet("SUFFIX2|.SUFFIX1|SUFFIX1|.SUFFIX2"), new SuffixSet("SuFfIx1|.sUfFiX2|SuFfIx2|.sUfFiX1"), new SuffixSet("SuFfIx2|.sUfFiX1|SuFfIx1|.sUfFiX2"), new SuffixSet("suffix1|.suffix1|SUFFIX1|.SUFFIX1|suffix2|.suffix2|SUFFIX2|.SUFFIX2"), new SuffixSet("suffix2|.suffix2|SUFFIX2|.SUFFIX2|suffix1|.suffix1|SUFFIX1|.SUFFIX1"), new SuffixSet("suffix1|.suffix1|SUFFIX1|.SUFFIX1|SuFfIx1|.sUfFiX1|suffix2|.suffix2|SUFFIX2|.SUFFIX2|SuFfIx2|.sUfFiX2"), new SuffixSet("suffix2|.suffix2|SUFFIX2|.SUFFIX2|SuFfIx2|.sUfFiX2|suffix1|.suffix1|SUFFIX1|.SUFFIX1|SuFfIx1|.sUfFiX1"), new SuffixSet("suffix1||.suffix1||SUFFIX1||.SUFFIX1||SuFfIx1||.sUfFiX1||suffix2||.suffix2||SUFFIX2||.SUFFIX2||SuFfIx2||.sUfFiX2"), new SuffixSet("suffix2||.suffix2||SUFFIX2||.SUFFIX2||SuFfIx2||.sUfFiX2||suffix1||.suffix1||SUFFIX1||.SUFFIX1||SuFfIx1||.sUfFiX1")};
    }

    @Test
    public void testEqualsAndHashCode() {
        for (int i = 0; i < this.sets.length; ++i) {
            for (int j = 0; j < this.sets.length; ++j) {
                Assert.assertTrue((boolean)this.sets[i].equals((Object)this.sets[j]));
                Assert.assertEquals((long)this.sets[i].hashCode(), (long)this.sets[j].hashCode());
            }
        }
    }

    @Test
    public void testIsEmpty() {
        Assert.assertTrue((boolean)this.empty.isEmpty());
        for (SuffixSet set : this.sets) {
            Assert.assertFalse((boolean)set.isEmpty());
        }
    }

    @Test
    public void testIteratorAndContains() {
        Assert.assertFalse((boolean)this.empty.iterator().hasNext());
        for (int i = 0; i < this.sets.length; ++i) {
            for (int j = 0; j < this.sets.length; ++j) {
                for (String s : this.sets[i]) {
                    Assert.assertTrue((boolean)this.sets[j].contains((Object)s));
                }
            }
        }
    }

    @Test
    public void testAddAll() {
        for (int i = 0; i < this.sets.length; ++i) {
            for (int j = 0; j < this.sets.length; ++j) {
                Assert.assertFalse((boolean)this.sets[i].addAll((CanonicalStringSet)this.sets[j]));
            }
        }
    }

    @Test
    public void testRetainAll() {
        for (int i = 0; i < this.sets.length; ++i) {
            for (int j = 0; j < this.sets.length; ++j) {
                Assert.assertFalse((boolean)this.sets[i].retainAll((CanonicalStringSet)this.sets[j]));
            }
        }
    }

    @Test
    public void testRemoveAll() {
        for (int i = 0; i < this.sets.length - 1; ++i) {
            SuffixSet set = this.sets[i];
            Assert.assertFalse((boolean)set.removeAll((CanonicalStringSet)this.empty));
            Assert.assertFalse((boolean)set.isEmpty());
            Assert.assertTrue((boolean)set.removeAll((CanonicalStringSet)this.sets[i + 1]));
            Assert.assertTrue((boolean)set.isEmpty());
        }
    }

    @Test
    public void testClear() {
        for (SuffixSet set : this.sets) {
            Assert.assertFalse((boolean)set.isEmpty());
            set.clear();
            Assert.assertTrue((boolean)set.isEmpty());
        }
    }

    @Test
    public void testToString() {
        for (SuffixSet set : this.sets) {
            Assert.assertTrue((boolean)"suffix1|suffix2".equals(set.toString()));
        }
    }

    @Test
    public void testToPattern() {
        for (int i = 0; i < this.sets.length; ++i) {
            SuffixSet set = this.sets[i];
            Assert.assertTrue((boolean)set.toPattern().matcher(".suffix1").matches());
            Assert.assertTrue((boolean)set.toPattern().matcher(".suffix2").matches());
            Assert.assertTrue((boolean)set.toPattern().matcher("a.SUFFIX1").matches());
            Assert.assertTrue((boolean)set.toPattern().matcher("a.SUFFIX2").matches());
            Assert.assertTrue((boolean)set.toPattern().matcher("a.b.suffix1").matches());
            Assert.assertTrue((boolean)set.toPattern().matcher("a.b.suffix2").matches());
            Assert.assertTrue((boolean)set.toPattern().matcher("a.b.c.SUFFIX1").matches());
            Assert.assertTrue((boolean)set.toPattern().matcher("a.b.c.SUFFIX2").matches());
        }
    }
}

