/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.zip.raes;

import de.schlichtherle.truezip.crypto.raes.RaesOutputStream;
import de.schlichtherle.truezip.crypto.raes.RaesParameters;
import de.schlichtherle.truezip.crypto.raes.RaesReadOnlyFile;
import de.schlichtherle.truezip.crypto.raes.param.AesCipherParameters;
import de.schlichtherle.truezip.crypto.raes.param.KeyManagerRaesParameters;
import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsArchiveEntry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.archive.zip.JarDriver;
import de.schlichtherle.truezip.fs.archive.zip.OptionOutputSocket;
import de.schlichtherle.truezip.fs.archive.zip.ZipDriverEntry;
import de.schlichtherle.truezip.fs.archive.zip.ZipInputShop;
import de.schlichtherle.truezip.fs.archive.zip.raes.ZipRaesKeyController;
import de.schlichtherle.truezip.key.KeyManagerProvider;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.IOPoolProvider;
import de.schlichtherle.truezip.socket.InputShop;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.LazyOutputSocket;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.zip.ZipEntry;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class ZipRaesDriver
extends JarDriver {
    private final KeyManagerProvider keyManagerProvider;

    public ZipRaesDriver(IOPoolProvider ioPoolProvider, KeyManagerProvider keyManagerProvider) {
        super(ioPoolProvider);
        this.keyManagerProvider = keyManagerProvider;
        if (null == this.keyManagerProvider) {
            throw new NullPointerException();
        }
    }

    @Override
    public final boolean getPreambled() {
        return true;
    }

    @Override
    protected final KeyManagerProvider getKeyManagerProvider() {
        return this.keyManagerProvider;
    }

    protected RaesParameters raesParameters(FsModel model) {
        return new KeyManagerRaesParameters(this.getKeyManagerProvider().get(AesCipherParameters.class), this.mountPointUri(model));
    }

    protected abstract long getAuthenticationTrigger();

    @Override
    protected final boolean check(ZipInputShop input, ZipDriverEntry entry) {
        return input.length() > this.getAuthenticationTrigger();
    }

    @Override
    public <M extends FsModel> FsController<M> decorate(FsController<M> controller) {
        return new ZipRaesKeyController<M>(controller, this);
    }

    @Override
    public ZipDriverEntry newEntry(String path, Entry.Type type, @CheckForNull Entry template, BitField<FsOutputOption> mknod) throws CharConversionException {
        FsArchiveEntry entry = super.newEntry(path, type, template, (BitField)mknod.set(FsOutputOption.COMPRESS));
        ((ZipEntry)((Object)entry)).clearEncryption();
        return entry;
    }

    @Override
    public final InputShop<ZipDriverEntry> newInputShop(FsModel model, InputSocket<?> input) throws IOException {
        if (null == model) {
            throw new NullPointerException();
        }
        ReadOnlyFile rof = input.newReadOnlyFile();
        try {
            RaesReadOnlyFile rrof = RaesReadOnlyFile.getInstance(rof, this.raesParameters(model));
            if (rrof.length() <= this.getAuthenticationTrigger()) {
                rrof.authenticate();
            }
            return this.newInputShop(model, rrof);
        }
        catch (IOException ex) {
            rof.close();
            throw ex;
        }
    }

    @Override
    public final OptionOutputSocket getOutputSocket(FsController<?> controller, FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        options = options.set(FsOutputOption.STORE);
        options = options.clear(FsOutputOption.GROW);
        return new OptionOutputSocket(controller.getOutputSocket(name, options, template), options);
    }

    @Override
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    protected OutputShop<ZipDriverEntry> newOutputShop(FsModel model, OptionOutputSocket output, ZipInputShop source) throws IOException {
        if (null == model) {
            throw new NullPointerException();
        }
        OutputStream out = new LazyOutputSocket<Entry>(output).newOutputStream();
        try {
            RaesOutputStream ros = RaesOutputStream.getInstance(out, this.raesParameters(model));
            return this.newOutputShop(model, ros, source);
        }
        catch (IOException ex) {
            out.close();
            throw ex;
        }
    }
}

