/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.nio.file;

import de.schlichtherle.truezip.fs.nio.file.FileEntry;
import de.schlichtherle.truezip.socket.IOPool;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class TempFilePool
implements IOPool<FileEntry> {
    private static final Path TEMP_DIR = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    private static final boolean IS_POSIX = FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
    private static final FileAttribute<Set<PosixFilePermission>> POSIX_PERMISSIONS = PosixFilePermissions.asFileAttribute(EnumSet.of(PosixFilePermission.OWNER_READ, new PosixFilePermission[]{PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_WRITE}));
    private static final FileAttribute<?>[] POSIX_ATTRIBUTES = new FileAttribute[]{POSIX_PERMISSIONS};
    private static final FileAttribute<?>[] NO_ATTRIBUTES = new FileAttribute[0];
    static final TempFilePool INSTANCE = new TempFilePool(null, null);
    @Nullable
    private final Path dir;
    private final String name;

    private static FileAttribute<?>[] attributes() {
        return IS_POSIX ? (FileAttribute[])POSIX_ATTRIBUTES.clone() : NO_ATTRIBUTES;
    }

    TempFilePool(@CheckForNull Path dir, @CheckForNull String name) {
        this.dir = null != dir ? dir : TEMP_DIR;
        this.name = null != name ? name + "." : "tzp";
    }

    @Override
    public Buffer allocate() throws IOException {
        return new Buffer(Files.createTempFile(this.dir, this.name, null, TempFilePool.attributes()), this);
    }

    @Override
    public void release(IOPool.Entry<FileEntry> resource) throws IOException {
        resource.release();
    }

    @NotThreadSafe
    private static final class Buffer
    extends FileEntry
    implements IOPool.Entry<FileEntry> {
        Buffer(Path file, TempFilePool pool) {
            super(file);
            assert (null != file);
            assert (null != pool);
            this.pool = pool;
        }

        @Override
        public void release() throws IOException {
            if (null == this.pool) {
                throw new IllegalStateException(this.getPath() + " (already released)");
            }
            this.pool(null);
        }

        private void pool(@CheckForNull TempFilePool newPool) throws IOException {
            TempFilePool oldPool = this.pool;
            this.pool = newPool;
            if (oldPool != newPool) {
                Files.deleteIfExists(this.getPath());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.pool(null);
            }
            finally {
                super.finalize();
            }
        }
    }
}

