/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.swing;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

@DefaultAnnotation(value={NonNull.class})
public abstract class AbstractComboBoxBrowser
implements Serializable {
    private static final long serialVersionUID = 1065103960246722893L;
    private final Listener listener = new Listener();
    @CheckForNull
    private JComboBox comboBox;
    private transient boolean recursion;

    protected AbstractComboBoxBrowser() {
    }

    protected AbstractComboBoxBrowser(@CheckForNull JComboBox comboBox) {
        this.changeComboBox(null, comboBox, false);
    }

    @Nullable
    public JComboBox getComboBox() {
        return this.comboBox;
    }

    public void setComboBox(@CheckForNull JComboBox comboBox) {
        this.changeComboBox(this.getComboBox(), comboBox, true);
    }

    private void changeComboBox(@CheckForNull JComboBox oldCB, @CheckForNull JComboBox newCB, boolean update) {
        if (newCB == oldCB) {
            return;
        }
        ComboBoxEditor oldCBE = null;
        if (null != oldCB) {
            oldCB.removePropertyChangeListener("editor", this.listener);
            oldCBE = oldCB.getEditor();
            oldCB.setEditor(((DecoratingComboBoxEditor)oldCBE).getEditor());
        }
        this.comboBox = newCB;
        DecoratingComboBoxEditor newCBE = null;
        if (null != newCB) {
            newCB.updateUI();
            newCBE = new DecoratingComboBoxEditor(newCB.getEditor());
            newCB.setEditor(newCBE);
            newCB.addPropertyChangeListener("editor", this.listener);
        }
        this.changeEditor(oldCBE, newCBE, update);
    }

    private void changeEditor(@CheckForNull ComboBoxEditor oldCBE, @CheckForNull ComboBoxEditor newCBE, boolean update) {
        Component component;
        Component component2;
        if (newCBE == oldCBE) {
            return;
        }
        JTextComponent oldText = null;
        if (null != oldCBE && (component2 = oldCBE.getEditorComponent()) instanceof JTextComponent) {
            oldText = (JTextComponent)component2;
        }
        JTextComponent newText = null;
        if (null != newCBE && (component = newCBE.getEditorComponent()) instanceof JTextComponent) {
            newText = (JTextComponent)component;
        }
        this.changeText(oldText, newText, update);
    }

    private void changeText(@CheckForNull JTextComponent oldTC, @CheckForNull JTextComponent newTC, boolean update) {
        if (newTC == oldTC) {
            return;
        }
        Document oldDocument = null;
        if (null != oldTC) {
            oldTC.removePropertyChangeListener("document", this.listener);
            oldDocument = oldTC.getDocument();
        }
        Document newDocument = null;
        if (null != newTC) {
            newDocument = newTC.getDocument();
            newTC.addPropertyChangeListener("document", this.listener);
        }
        this.changeDocument(oldDocument, newDocument, update);
    }

    private void changeDocument(@CheckForNull Document oldDoc, @CheckForNull Document newDoc, boolean update) {
        if (newDoc == oldDoc) {
            return;
        }
        if (null != oldDoc) {
            oldDoc.removeDocumentListener(this.listener);
        }
        if (null != newDoc) {
            if (update) {
                String txt;
                try {
                    txt = newDoc.getText(0, newDoc.getLength());
                }
                catch (BadLocationException e) {
                    txt = null;
                }
                this.update(txt);
            }
            newDoc.addDocumentListener(this.listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void documentUpdated() {
        if (this.lock()) {
            return;
        }
        try {
            JComboBox cb = this.getComboBox();
            ComboBoxEditor cbe = cb.getEditor();
            JTextComponent tc = (JTextComponent)cbe.getEditorComponent();
            assert (cb.isShowing() || !tc.isFocusOwner());
            if (!tc.isFocusOwner()) {
                return;
            }
            cb.setPopupVisible(false);
            if (this.update(tc.getText())) {
                cb.setPopupVisible(true);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEditor(ComboBoxEditor cbe, @CheckForNull Object item) {
        if (this.lock()) {
            return;
        }
        try {
            cbe.setItem(item);
            if (!(item instanceof String)) {
                return;
            }
            JComboBox cb = this.getComboBox();
            JTextComponent tc = (JTextComponent)cbe.getEditorComponent();
            assert (cb.isShowing() || !tc.isFocusOwner());
            if (!tc.isFocusOwner()) {
                return;
            }
            Caret caret = tc.getCaret();
            caret.setDot(((String)item).length());
        }
        finally {
            this.unlock();
        }
    }

    protected abstract boolean update(@CheckForNull String var1);

    private boolean lock() {
        if (this.recursion) {
            return true;
        }
        this.recursion = true;
        return false;
    }

    private void unlock() {
        this.recursion = false;
    }

    private final class DecoratingComboBoxEditor
    implements ComboBoxEditor {
        private final ComboBoxEditor delegate;

        DecoratingComboBoxEditor(ComboBoxEditor comboBoxEditor) {
            assert (null != comboBoxEditor);
            this.delegate = comboBoxEditor;
        }

        ComboBoxEditor getEditor() {
            return this.delegate;
        }

        @Override
        public Component getEditorComponent() {
            return this.delegate.getEditorComponent();
        }

        @Override
        public void setItem(@CheckForNull Object item) {
            AbstractComboBoxBrowser.this.updateEditor(this.delegate, item);
        }

        @Override
        @CheckForNull
        public Object getItem() {
            return this.delegate.getItem();
        }

        @Override
        public void selectAll() {
            this.delegate.selectAll();
        }

        @Override
        public void addActionListener(ActionListener actionListener) {
            this.delegate.addActionListener(actionListener);
        }

        @Override
        public void removeActionListener(ActionListener actionListener) {
            this.delegate.removeActionListener(actionListener);
        }
    }

    private class Listener
    implements DocumentListener,
    PropertyChangeListener {
        private Listener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            AbstractComboBoxBrowser.this.documentUpdated();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            AbstractComboBoxBrowser.this.documentUpdated();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            AbstractComboBoxBrowser.this.documentUpdated();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String property = e.getPropertyName();
            if ("editor".equals(property)) {
                AbstractComboBoxBrowser.this.changeEditor((ComboBoxEditor)e.getOldValue(), (ComboBoxEditor)e.getNewValue(), true);
            } else if ("document".equals(property)) {
                AbstractComboBoxBrowser.this.changeDocument((Document)e.getOldValue(), (Document)e.getNewValue(), true);
            } else {
                throw new AssertionError((Object)("Received change event for unknown property: " + property));
            }
        }
    }
}

