/*
 * Decompiled with CFR 0.152.
 */
package de.schmizzolin.yogi;

import de.schmizzolin.yogi.IntSet;
import de.schmizzolin.yogi.Protocol;
import de.schmizzolin.yogi.Statistics;
import de.schmizzolin.yogi.UserFiles;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.oneandone.sushi.fs.Node;
import net.oneandone.sushi.util.Strings;

public class Book
implements Comparable<Book> {
    public static final String EXT = ".yogi";
    public final String name;
    public final byte[] jpg;
    public final LinkedHashMap<String, IntSet> sections;
    private final List<String> lefts;
    private final List<String> rights;

    public static Book load(Node<?> file, byte[] jpg) throws IOException {
        Book book = new Book(Strings.removeRight((String)file.getName(), (String)EXT), jpg);
        IntSet current = null;
        for (String line : file.readLines()) {
            if (line.startsWith("# ")) {
                current = new IntSet();
                book.sections.put(line.substring(2), current);
                continue;
            }
            if ((line = line.trim()).isEmpty()) continue;
            if (current == null) {
                throw new IOException("missing section header");
            }
            try {
                current.add(book.addInvLine(line));
            }
            catch (IllegalArgumentException e) {
                System.out.println("TODO: " + e.getMessage());
            }
        }
        return book;
    }

    public Book(String name, byte[] jpg) {
        this.name = name;
        this.jpg = jpg;
        this.sections = new LinkedHashMap();
        this.lefts = new ArrayList<String>();
        this.rights = new ArrayList<String>();
    }

    public byte[] jpg() {
        return this.jpg;
    }

    public Statistics statistics(UserFiles context) throws IOException {
        return Statistics.collect(context, this);
    }

    public List<Section> sections() {
        ArrayList<Section> result = new ArrayList<Section>(this.sections.size());
        int id = 0;
        for (Map.Entry<String, IntSet> entry : this.sections.entrySet()) {
            result.add(new Section(++id, entry.getKey(), entry.getValue()));
        }
        return result;
    }

    public int currentSection(IntSet userSelection) {
        int id = 0;
        Integer lastMixed = null;
        Integer firstEmpty = null;
        for (Map.Entry<String, IntSet> entry : this.sections.entrySet()) {
            IntSet sectionSelection = entry.getValue();
            ++id;
            if (firstEmpty == null && Book.empty(userSelection, sectionSelection)) {
                firstEmpty = id;
            }
            if (!Book.mixed(userSelection, sectionSelection)) continue;
            lastMixed = id;
        }
        if (lastMixed != null) {
            return lastMixed;
        }
        if (firstEmpty != null) {
            return firstEmpty;
        }
        return -1;
    }

    private static boolean empty(IntSet userSelection, IntSet sectionSelection) {
        for (int idx : userSelection) {
            if (!sectionSelection.contains(idx)) continue;
            return false;
        }
        return true;
    }

    private static boolean mixed(IntSet userSelection, IntSet sectionSelection) {
        boolean foundMissing = false;
        boolean foundContaining = false;
        for (int idx : sectionSelection) {
            if (userSelection.contains(idx)) {
                foundContaining = true;
                continue;
            }
            foundMissing = true;
        }
        return foundMissing && foundContaining;
    }

    public Map<String, String> selection(IntSet selection) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(this.sections.size());
        for (Integer integer : selection) {
            result.put(this.lefts.get(integer), this.rights.get(integer));
        }
        return result;
    }

    public IntSet selection(Protocol protocol) {
        IntSet result = new IntSet();
        for (String question : protocol.questionCount().keySet()) {
            int idx = this.lefts.indexOf(question);
            if (idx < 0) {
                System.out.println("not found: " + question);
                continue;
            }
            result.add(idx);
        }
        return result;
    }

    public void saveSelection(UserFiles context, String selectionName, IntSet selection) throws IOException {
        ArrayList<String> lst = new ArrayList<String>();
        for (int idx : selection) {
            lst.add(this.lefts.get(idx));
        }
        context.saveSelection(this.name, selectionName, lst);
    }

    public IntSet loadSelection(UserFiles context, String selectionName) throws IOException {
        List<String> enabled = context.loadSelectionOpt(this.name, selectionName);
        IntSet result = new IntSet();
        if (enabled != null) {
            for (String active : enabled) {
                int idx = this.lefts.indexOf(active);
                if (idx < 0) {
                    System.out.println("unknown question - ignored: " + active);
                    continue;
                }
                result.add(idx);
            }
        } else {
            throw new IOException("selection not found: " + selectionName);
        }
        return result;
    }

    public int size() {
        return this.lefts.size();
    }

    public int addInvLine(String line) throws IOException {
        if ((line = line.trim()).isEmpty() || line.startsWith("#")) {
            throw new IllegalArgumentException(line);
        }
        int idx = line.indexOf(61);
        if (idx == -1) {
            throw new IOException("syntax error: " + line);
        }
        return this.add(line.substring(idx + 1).trim(), line.substring(0, idx).trim());
    }

    public int add(String left, String right) {
        if (this.lookupLeft(left) >= 0) {
            throw new IllegalArgumentException("duplicate word: " + left);
        }
        this.lefts.add(left);
        this.rights.add(right);
        return this.lefts.size() - 1;
    }

    public String left(int idx) {
        return this.lefts.get(idx);
    }

    public String right(int idx) {
        return this.rights.get(idx);
    }

    public int lookupLeft(String left) {
        return this.lefts.indexOf(left);
    }

    public IntSet all() {
        IntSet result = new IntSet();
        for (int i = 0; i < this.lefts.size(); ++i) {
            result.add(i);
        }
        return result;
    }

    @Override
    public int compareTo(Book right) {
        return this.name.compareTo(right.name);
    }

    public record Section(int id, String title, IntSet selection) {
        public int first() {
            return this.selection.iterator().next();
        }
    }
}

