/*
 * Decompiled with CFR 0.152.
 */
package de.schmizzolin.yogi;

import de.schmizzolin.yogi.Book;
import de.schmizzolin.yogi.IntSet;
import de.schmizzolin.yogi.Protocol;
import de.schmizzolin.yogi.UserFiles;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.oneandone.sushi.fs.NodeWriter;
import net.oneandone.sushi.util.Separator;

public class Exercise {
    private static final Separator COLON = Separator.on((char)':');
    public final int id;
    public final Book book;
    public final String title;
    private final IntSet selection;
    public int round;
    public int ofs;
    public final IntSet ok;
    public final IntSet wrong;

    public static Exercise forParam(Book book, String param) {
        List args = COLON.split((CharSequence)param);
        int id = Integer.parseInt(Exercise.eat(args, "-1"));
        if (id == -1) {
            throw new IllegalStateException();
        }
        String title = Exercise.eat(args, "");
        String selection = Exercise.eat(args, null);
        if (selection == null) {
            throw new IllegalStateException();
        }
        int round = Integer.parseInt(Exercise.eat(args, "1"));
        int ofs = Integer.parseInt(Exercise.eat(args, "0"));
        String ok = Exercise.eat(args, null);
        String wrong = Exercise.eat(args, null);
        return Exercise.create(id, book, title, selection, round, ofs, ok, wrong);
    }

    private static String eat(List<String> lst, String dflt) {
        if (lst.isEmpty()) {
            return dflt;
        }
        return lst.remove(0);
    }

    public static Exercise create(int id, Book book, String title, IntSet selection) {
        return new Exercise(id, book, title, selection, 1, 0, new IntSet(), new IntSet());
    }

    public static Exercise create(int id, Book book, String title, String selectionParam, int round, int ofs, String okParam, String wrongParam) {
        IntSet selection = IntSet.parseArg(selectionParam);
        IntSet ok = IntSet.parse(okParam == null ? new ArrayList() : Separator.COMMA.split((CharSequence)okParam));
        IntSet wrong = IntSet.parse(wrongParam == null ? new ArrayList() : Separator.COMMA.split((CharSequence)wrongParam));
        return new Exercise(id, book, title, selection, round, ofs, ok, wrong);
    }

    public Exercise(int id, Book book, String title, IntSet selection, int round, int ofs, IntSet ok, IntSet wrong) {
        this.id = id;
        this.book = book;
        this.title = title;
        this.selection = selection;
        this.round = round;
        this.ofs = ofs;
        this.ok = ok;
        this.wrong = wrong;
    }

    public void logTitle(UserFiles userFiles, String withTitle) throws IOException {
        this.doLog(userFiles, "! " + withTitle);
    }

    public void logComment(UserFiles userFiles, String comment) throws IOException {
        this.doLog(userFiles, "# " + comment);
    }

    public void logAnswer(UserFiles userFiles, String question, String answer, String correct) throws IOException {
        this.doLog(userFiles, question + " -> " + answer + " -> " + correct);
    }

    private void doLog(UserFiles userFiles, String line) throws IOException {
        try (NodeWriter writer = userFiles.protocolFile(this.book.name, this.id).newAppender();){
            writer.append(Protocol.FMT.format(new Date()));
            writer.append(' ');
            writer.append(line.replace("\n", " // "));
            writer.append('\n');
        }
    }

    public int roundSize() {
        return this.selection.size() - this.ofs;
    }

    public int number(String question) {
        int idx = this.book.lookupLeft(question);
        return this.ok.size() + this.wrong.size() + (this.wrong.contains(idx) ? 0 : 1) - this.ofs;
    }

    public String question() {
        int next;
        if (this.ok.size() + this.wrong.size() == this.selection.size()) {
            ++this.round;
            if (this.wrong.isEmpty()) {
                this.ofs = 0;
                this.ok.clear();
            } else {
                this.ofs = this.ok.size();
                this.wrong.clear();
            }
        }
        if (this.ok.contains(next = this.selection.next(IntSet.union(this.ok, this.wrong)))) {
            throw new IllegalStateException(this.ok.toString() + " vs " + next);
        }
        if (this.wrong.contains(next)) {
            throw new IllegalStateException(this.wrong.toString() + " vs " + next);
        }
        return this.book.left(next);
    }

    public String answer(String question, String answer) {
        int idx = this.book.lookupLeft(question);
        if (idx == -1) {
            throw new IllegalArgumentException(question);
        }
        if (!this.selection.contains(idx)) {
            throw new IllegalArgumentException(this.selection + " " + idx);
        }
        if (answer.equals(this.book.right(idx))) {
            if (!this.wrong.contains(idx)) {
                this.ok.add(idx);
            }
            return null;
        }
        if (!this.wrong.contains(idx)) {
            this.wrong.add(idx);
        }
        return this.book.right(idx);
    }

    public String lookup(String question) {
        int idx = this.book.lookupLeft(question);
        if (idx == -1) {
            return null;
        }
        return this.book.right(idx);
    }

    public String toParam() {
        return this.id + ":" + this.title + ":" + this.selection.toString() + ":" + this.round + ":" + this.ofs + ":" + this.ok.toString() + ":" + this.wrong.toString();
    }

    public boolean allDone() {
        return this.ok.size() == this.selection.size();
    }
}

