/*
 * Decompiled with CFR 0.152.
 */
package de.schmizzolin.yogi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.oneandone.sushi.util.Separator;

public class IntSet
implements Iterable<Integer> {
    private final List<Integer> data;
    private static final Random RANDOM = new Random();

    public static IntSet parseArg(String arg) {
        return IntSet.parse(Separator.COMMA.split((CharSequence)arg));
    }

    public static IntSet parse(List<String> strings) {
        IntSet result = new IntSet();
        for (String str : strings) {
            result.add(Integer.parseInt(str));
        }
        return result;
    }

    public IntSet() {
        this.data = new ArrayList<Integer>();
    }

    public IntSet(IntSet orig) {
        this.data = new ArrayList<Integer>(orig.data);
    }

    public IntSet(Collection<Integer> collection) {
        this();
        this.addAll(collection);
    }

    public void addAll(Collection<Integer> collection) {
        for (Integer i : collection) {
            this.add(i);
        }
    }

    public void add(int i) {
        this.data.add(i);
    }

    public void clear() {
        this.data.clear();
    }

    public boolean contains(int i) {
        return this.data.contains(i);
    }

    public int size() {
        return this.data.size();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Integer i : this.data) {
            if (result.length() > 0) {
                result.append(',');
            }
            result.append(i);
        }
        return result.toString();
    }

    public static IntSet union(IntSet left, IntSet right) {
        IntSet result = new IntSet();
        result.data.addAll(left.data);
        result.data.addAll(right.data);
        return result;
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.data.iterator();
    }

    public int next(IntSet done) {
        int selectionSize = this.size();
        int doneSize = done.size();
        if (doneSize >= selectionSize) {
            throw new IllegalStateException("all done");
        }
        int rnd = RANDOM.nextInt(selectionSize - doneSize);
        for (Integer i : this) {
            if (done.contains(i)) continue;
            if (rnd == 0) {
                return i;
            }
            --rnd;
        }
        throw new IllegalStateException();
    }

    public void retain(int count) {
        while (this.data.size() > count) {
            this.data.remove(this.data.size() - 1);
        }
    }

    public void retain(IntSet set) {
        for (int i = this.data.size() - 1; i >= 0; --i) {
            int value = this.data.get(i);
            if (set.contains(value)) continue;
            this.data.remove(i);
        }
    }

    public IntSet createRetained(IntSet set) {
        IntSet result = new IntSet(this);
        result.retain(set);
        return result;
    }

    public void removeAll(IntSet set) {
        for (int i = this.data.size() - 1; i >= 0; --i) {
            int value = this.data.get(i);
            if (!set.contains(value)) continue;
            this.data.remove(i);
        }
    }

    public boolean remove(int remove) {
        for (int i = this.data.size() - 1; i >= 0; --i) {
            if (this.data.get(i) != remove) continue;
            this.data.remove(i);
            return true;
        }
        return false;
    }
}

