/*
 * Decompiled with CFR 0.152.
 */
package de.schmizzolin.yogi;

import de.schmizzolin.yogi.Book;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.oneandone.sushi.fs.Node;

public class Library
implements Iterable<Book> {
    private final List<Book> books = new ArrayList<Book>();

    public static Library load(Node<?> base) throws IOException {
        Library result = new Library();
        for (Node book : base.find(new String[]{"*.yogi"})) {
            byte[] jpg = base.join(new String[]{book.getBasename() + ".jpg"}).readBytes();
            result.books.add(Book.load(book, jpg));
        }
        Collections.sort(result.books);
        return result;
    }

    public Book get(String name) throws IOException {
        for (Book book : this.books) {
            if (!book.name.equals(name)) continue;
            return book;
        }
        throw new IOException("book not found: " + name);
    }

    @Override
    public Iterator<Book> iterator() {
        return this.books.iterator();
    }
}

