/*
 * Decompiled with CFR 0.152.
 */
package de.schmizzolin.yogi;

import de.schmizzolin.yogi.Achievement;
import de.schmizzolin.yogi.Book;
import de.schmizzolin.yogi.Statistics;
import de.schmizzolin.yogi.UserFiles;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.oneandone.sushi.fs.file.FileNode;
import net.oneandone.sushi.util.Strings;

public class Protocol {
    public static final SimpleDateFormat FMT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final FileNode file;
    private final List<Entry> entries;
    public static final int NOT_ANSWERED = 999;

    public static Protocol load(FileNode src) throws IOException {
        Protocol result = new Protocol(src);
        for (String line : src.readLines()) {
            result.addRaw(line);
        }
        return result;
    }

    public Protocol(FileNode file) {
        this.file = file;
        this.entries = new ArrayList<Entry>();
    }

    public void addRaw(String raw) throws IOException {
        Date date;
        int idx = raw.indexOf(32);
        if (idx == -1) {
            throw new IOException("invalid line: " + raw);
        }
        if ((idx = raw.indexOf(32, idx + 1)) == -1) {
            throw new IOException("invalid line: " + raw);
        }
        try {
            date = FMT.parse(raw.substring(0, idx));
        }
        catch (ParseException e) {
            throw new IOException("invalid line: " + raw, e);
        }
        this.entries.add(new Entry(date, raw.substring(idx + 1)));
    }

    public int words() {
        Map<Integer, List<String>> raw = this.histogramRaw();
        int result = 0;
        for (List<String> lst : raw.values()) {
            result += lst.size();
        }
        return result;
    }

    public String date() {
        return FMT.format(this.entries.get((int)0).date);
    }

    public String duration() {
        long millis = this.entries.get((int)(this.entries.size() - 1)).date.getTime() - this.entries.get((int)0).date.getTime();
        return Protocol.durationString(millis);
    }

    private static String durationString(long millis) {
        int seconds = (int)(millis / 1000L);
        int minutes = seconds / 60;
        return minutes + ":" + Strings.padLeft((String)Integer.toString(seconds %= 60), (int)2, (char)'0');
    }

    public Map<Integer, String> histogram() {
        int words = this.words();
        Map<Integer, List<String>> raw = this.histogramRaw();
        TreeMap<Integer, String> result = new TreeMap<Integer, String>();
        for (Map.Entry<Integer, List<String>> entry : raw.entrySet()) {
            result.put(entry.getKey(), Integer.toString(entry.getValue().size() * 100 / words));
        }
        return result;
    }

    public Map<Integer, List<String>> histogramRaw() {
        HashMap<Integer, List<String>> result = new HashMap<Integer, List<String>>();
        for (Map.Entry<String, Integer> entry : this.questionCount().entrySet()) {
            ArrayList<String> questions;
            int count = entry.getValue();
            String question = entry.getKey();
            if (count < 0) {
                count = 999;
            }
            if ((questions = (ArrayList<String>)result.get(count)) == null) {
                questions = new ArrayList<String>();
                result.put(count, questions);
            }
            questions.add(question);
        }
        return result;
    }

    public Map<String, Integer> questionCount() {
        String again = null;
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Entry entry : this.entries) {
            String text = entry.text;
            if (text.startsWith("# ") || text.startsWith("! ")) continue;
            int idx = text.indexOf(" -> ");
            if (idx == -1) {
                throw new IllegalStateException(text);
            }
            String question = text.substring(0, idx);
            String answer = text.substring(idx + 4);
            if ((idx = answer.indexOf(" -> ")) == -1) {
                throw new IllegalStateException(text);
            }
            String correct = answer.substring(idx + 4);
            answer = answer.substring(0, idx);
            if (again == null) {
                Integer count = (Integer)result.get(question);
                if (count == null) {
                    count = -1;
                } else {
                    Integer n = count;
                    count = count - 1;
                }
                result.put(question, count);
                if (answer.equals(correct)) {
                    result.put(question, -((Integer)result.get(question)).intValue());
                }
            }
            if (answer.equals(correct)) {
                again = null;
                continue;
            }
            again = question;
        }
        return result;
    }

    public String title() {
        Object result = "";
        for (Entry entry : this.entries) {
            String text = entry.text;
            if (!text.startsWith("! ")) continue;
            text = text.substring(2);
            if (((String)result).isEmpty()) {
                result = text;
                continue;
            }
            result = (String)result + "\n" + text;
        }
        return result;
    }

    public List<String> comments() {
        ArrayList<String> result = new ArrayList<String>();
        for (Entry entry : this.entries) {
            String text = entry.text;
            if (!text.startsWith("# ")) continue;
            result.add(text.substring(2));
        }
        return result;
    }

    public Achievement achievement(UserFiles context, Book book) throws IOException {
        long max = -1L;
        long min = Long.MAX_VALUE;
        long avg = 0L;
        Entry prev = null;
        int count = 0;
        for (Entry entry : this.entries) {
            if (prev != null) {
                ++count;
                long diff = entry.date.getTime() - prev.date.getTime();
                avg += diff;
                max = Math.max(max, diff);
                min = Math.min(min, diff);
            }
            prev = entry;
        }
        int[] beforeAfter = Statistics.beforeAfter(context, book, this.file, book.selection(this));
        return count == 0 ? new Achievement(beforeAfter[0], beforeAfter[1], "-", "-", "-") : new Achievement(beforeAfter[0], beforeAfter[1], Protocol.durationString(min), Protocol.durationString(max), Protocol.durationString(avg / (long)count));
    }

    private static class Entry {
        public final Date date;
        public final String text;

        private Entry(Date date, String text) {
            this.date = date;
            this.text = text;
        }
    }
}

