/*
 * Decompiled with CFR 0.152.
 */
package de.schmizzolin.yogi;

import de.schmizzolin.yogi.Book;
import de.schmizzolin.yogi.IntSet;
import de.schmizzolin.yogi.Protocol;
import de.schmizzolin.yogi.UserFiles;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.oneandone.sushi.fs.file.FileNode;

public class Statistics {
    private final Map<String, List<Integer>> map = new HashMap<String, List<Integer>>();

    public static Statistics collect(UserFiles context, Book book) throws IOException {
        Statistics result = new Statistics();
        List<FileNode> logs = context.listProtocols(book.name);
        for (FileNode node : logs) {
            Protocol protocol = Protocol.load(node);
            for (Map.Entry<Integer, List<String>> entry : protocol.histogramRaw().entrySet()) {
                int count = entry.getKey();
                for (String question : entry.getValue()) {
                    result.add(question, count);
                }
            }
        }
        return result;
    }

    public static int[] beforeAfter(UserFiles context, Book book, FileNode theProtocol, IntSet selection) throws IOException {
        Statistics result = new Statistics();
        List<FileNode> logs = context.listProtocols(book.name);
        int before = 0;
        for (FileNode node : logs) {
            if (node.equals((Object)theProtocol)) {
                before = result.quality(book, selection);
            }
            Protocol protocol = Protocol.load(node);
            for (Map.Entry<Integer, List<String>> entry : protocol.histogramRaw().entrySet()) {
                int count = entry.getKey();
                for (String question : entry.getValue()) {
                    result.add(question, count);
                }
            }
            if (!node.equals((Object)theProtocol)) continue;
            return new int[]{before, result.quality(book, selection)};
        }
        throw new IllegalStateException(theProtocol.getAbsolute());
    }

    public void add(String question, int count) {
        List<Integer> tries = this.map.get(question);
        if (tries == null) {
            tries = new ArrayList<Integer>();
            this.map.put(question, tries);
        }
        tries.add(count);
    }

    public int quality(Book book, IntSet selection) {
        int sum = 0;
        int count = 0;
        for (Integer question : selection) {
            sum += this.quality(book.left(question));
            ++count;
        }
        return count == 0 ? 0 : sum / count;
    }

    public int quality(String question) {
        List<Integer> tries = this.map.get(question);
        if (tries == null) {
            return 0;
        }
        return this.previousCountQuality(tries, 1) * 100 / 200 + this.previousCountQuality(tries, 2) * 100 / 400 + this.previousCountQuality(tries, 3) * 100 / 400;
    }

    private int previousCountQuality(List<Integer> tries, int back) {
        int idx = tries.size() - back;
        return this.countQuality(idx < 0 ? 999 : tries.get(idx));
    }

    private int countQuality(int count) {
        if (count == 999) {
            return 0;
        }
        return Math.max(1, 100 - (count - 1) * 33);
    }

    public String tries(String question) {
        List<Integer> tries = this.map.get(question);
        if (tries == null) {
            return "(new)";
        }
        StringBuilder builder = new StringBuilder();
        for (int count : tries) {
            if (builder.length() > 0) {
                builder.append(' ');
            }
            if (count == 999) {
                builder.append('-');
                continue;
            }
            builder.append(count);
        }
        return builder.toString();
    }

    public List<Integer> sort(IntSet selection, Book book) {
        ArrayList<Integer> result = new ArrayList<Integer>(selection.size());
        for (Integer i : selection) {
            result.add(i);
        }
        Collections.sort(result, (left, right) -> Integer.compare(this.quality(book.left((int)left)), this.quality(book.left((int)right))));
        return result;
    }

    public static String style(int quality) {
        if (quality < 30) {
            return "color: red;";
        }
        if (quality < 60) {
            return "color: orange;";
        }
        if (quality < 80) {
            return "color: yellow;";
        }
        if (quality < 95) {
            return "color: yellowgreen;";
        }
        return "color: green;";
    }
}

