/*
 * Decompiled with CFR 0.152.
 */
package de.schmizzolin.yogi;

import de.schmizzolin.yogi.YogiSecurity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.oneandone.sushi.fs.MkdirException;
import net.oneandone.sushi.fs.Node;
import net.oneandone.sushi.fs.file.FileNode;

public class UserFiles {
    private final FileNode root;
    private static final String PROTOCOL_EXT = ".protocol";

    public UserFiles(FileNode lib) throws IOException {
        this.root = (FileNode)((FileNode)lib.join(new String[]{YogiSecurity.username()})).mkdirsOpt();
        this.migrationBefore14();
    }

    private void migrationBefore14() throws IOException {
        for (FileNode book : this.root.list()) {
            if (!book.isDirectory()) continue;
            this.migrateBefore14selection(book);
            this.migrateBefore14protocols(book);
        }
    }

    private void migrateBefore14protocols(FileNode book) throws IOException {
        FileNode oldSelection = (FileNode)book.join(new String[]{".enabled"});
        if (oldSelection.exists()) {
            FileNode newSelection = (FileNode)book.join(new String[]{"freigeschaltet.selection"});
            System.out.println("selection migration " + oldSelection + " -> " + newSelection);
            oldSelection.move((Node)newSelection);
        }
    }

    private void migrateBefore14selection(FileNode book) throws IOException {
        for (FileNode oldProtocol : book.find(new String[]{"*.log"})) {
            FileNode newProtocol = (FileNode)book.join(new String[]{oldProtocol.getBasename() + PROTOCOL_EXT});
            System.out.println("protocol migration " + oldProtocol + " -> " + newProtocol);
            oldProtocol.move((Node)newProtocol);
        }
    }

    public FileNode protocolFile(String book, long id) {
        return (FileNode)this.root.join(new String[]{book, id + PROTOCOL_EXT});
    }

    public int nextProtocol(String book) throws IOException {
        Node dir = this.root.join(new String[]{book});
        int max = 0;
        if (dir.exists()) {
            for (Node file : dir.find(new String[]{"*.protocol"})) {
                int id;
                try {
                    id = Integer.parseInt(file.getBasename());
                }
                catch (NumberFormatException e) {
                    throw new IOException("unexpected name: " + file.getName());
                }
                max = Math.max(id, max);
            }
        }
        return max + 1;
    }

    public List<FileNode> listProtocols(String book) throws IOException {
        FileNode dir = (FileNode)this.root.join(new String[]{book});
        if (!dir.exists()) {
            return new ArrayList<FileNode>();
        }
        List lst = dir.find(new String[]{"*.protocol"});
        Collections.sort(lst, (o1, o2) -> {
            Integer left = UserFiles.numberOpt(o1);
            Integer right = UserFiles.numberOpt(o2);
            if (left != null && right != null) {
                return left.compareTo(right);
            }
            return o1.getName().compareTo(o2.getName());
        });
        return lst;
    }

    private static Integer numberOpt(FileNode log) {
        try {
            return Integer.parseInt(log.getBasename());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public List<String> loadSelectionOpt(String book, String name) throws IOException {
        FileNode file = this.selectionFile(book, name);
        return file.exists() ? file.readLines() : null;
    }

    public void saveSelection(String book, String name, List<String> lst) throws IOException {
        this.selectionFile(book, name).writeLines(lst);
    }

    private FileNode selectionFile(String book, String name) throws MkdirException {
        FileNode dir = (FileNode)((FileNode)this.root.join(new String[]{book})).mkdirOpt();
        return (FileNode)dir.join(new String[]{name + ".selection"});
    }

    public List<String> listSelections(String book) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        FileNode dir = (FileNode)this.root.join(new String[]{book});
        if (dir.isDirectory()) {
            for (FileNode file : dir.find(new String[]{"*.selection"})) {
                result.add(file.getBasename());
            }
        }
        return result;
    }

    public String newSelection(String book, String orig) throws IOException {
        int i = 1;
        while (true) {
            String name;
            FileNode file;
            if (!(file = this.selectionFile(book, name = "auswahl-" + i)).exists()) {
                this.selectionFile(book, orig).copyFile((Node)file);
                return name;
            }
            ++i;
        }
    }

    public void deleteSelection(String book, String name) throws IOException {
        this.selectionFile(book, name).deleteFile();
    }
}

