/*
 * Decompiled with CFR 0.152.
 */
package de.schmizzolin.yogi;

import de.schmizzolin.yogi.Achievement;
import de.schmizzolin.yogi.Book;
import de.schmizzolin.yogi.Exercise;
import de.schmizzolin.yogi.IntSet;
import de.schmizzolin.yogi.Library;
import de.schmizzolin.yogi.Protocol;
import de.schmizzolin.yogi.UserFiles;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.oneandone.sushi.fs.World;
import net.oneandone.sushi.fs.file.FileNode;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.util.UriUtils;

@Controller
public class YogiController {
    private final UserFiles userFiles;
    private final Library library;
    private final String version;

    public YogiController(World world, UserFiles userFiles, @Value(value="${yogi.etc}") String etc) throws IOException {
        this.userFiles = userFiles;
        this.library = Library.load(((FileNode)world.file(etc).join(new String[]{"books"})).checkDirectory());
        this.version = world.resource("yogi.version").readString().trim();
        System.out.println("started YogiController " + this.version);
    }

    @ModelAttribute(value="yogiVersion")
    protected String getVersion() {
        return this.version;
    }

    @RequestMapping(value={"/"})
    public String index(Model model) {
        model.addAttribute("login", (Object)true);
        return "index";
    }

    @RequestMapping(value={"/books"})
    public String books() {
        return "redirect:/books/" + YogiController.urlEncodeSegement(this.library.iterator().next().name);
    }

    @RequestMapping(value={"/books/{book}"})
    public String bookRaw(@PathVariable(value="book") String book) throws IOException {
        String selection;
        List<String> lst = this.userFiles.listSelections(book);
        if (lst.isEmpty()) {
            selection = "freigeschaltet";
            this.userFiles.saveSelection(book, selection, Collections.emptyList());
        } else {
            selection = lst.get(0);
        }
        return "redirect:/books/" + YogiController.urlEncodeSegement(book) + "/" + YogiController.urlEncodeSegement(selection);
    }

    @ResponseBody
    @GetMapping(value={"/books/{book}/jpg"}, produces={"image/jpeg"})
    public byte[] bookJpg(@PathVariable(value="book") String book) throws IOException {
        return this.library.get(book).jpg();
    }

    @GetMapping(value={"/books/{book}/{selection}"})
    public String book(Model model, @PathVariable(value="book") String book, @PathVariable(value="selection") String selection) throws IOException {
        model.addAttribute("library", (Object)this.library);
        model.addAttribute("book", (Object)this.library.get(book));
        model.addAttribute("selection", (Object)selection);
        return "book";
    }

    @GetMapping(value={"/books/{book}/{selection}/selection"})
    public String selection(Model model, @PathVariable(value="book") String bookName, @PathVariable(value="selection") String selectionName) throws IOException {
        Book book = this.library.get(bookName);
        model.addAttribute("library", (Object)this.library);
        model.addAttribute("book", (Object)book);
        model.addAttribute("selectionName", (Object)selectionName);
        model.addAttribute("selection", (Object)book.loadSelection(this.userFiles, selectionName));
        return "selection";
    }

    @PostMapping(value={"/books/{book}/{selection}/selection"})
    public String updateSelection(@PathVariable(value="book") String book, @PathVariable(value="selection") String oldName, @RequestParam(value="newName") String newName, HttpServletRequest request) throws IOException {
        if (newName.isEmpty()) {
            throw new IllegalStateException();
        }
        IntSet enable = YogiController.getChecked(request, "select_");
        this.userFiles.deleteSelection(book, oldName);
        this.library.get(book).saveSelection(this.userFiles, newName, enable);
        return "redirect:/books/" + YogiController.urlEncodeSegement(book) + "/" + YogiController.urlEncodeSegement(newName);
    }

    @GetMapping(value={"/books/{book}/{selection}/new-selection"})
    public String newSelection(@PathVariable(value="book") String book, @PathVariable(value="selection") String selection) throws IOException {
        String newSelection = this.userFiles.newSelection(book, selection);
        return "redirect:/books/" + YogiController.urlEncodeSegement(book) + "/" + YogiController.urlEncodeSegement(newSelection) + "/selection";
    }

    @PostMapping(value={"/books/{book}/{selection}/delete-selection"})
    public String deleteSelection(@PathVariable(value="book") String book, @PathVariable(value="selection") String selection) throws IOException {
        this.userFiles.deleteSelection(book, selection);
        return "redirect:/books/" + YogiController.urlEncodeSegement(book);
    }

    private static IntSet getChecked(HttpServletRequest request, String prefix) {
        IntSet result = new IntSet();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith(prefix)) continue;
            result.add(Integer.parseInt(request.getParameter(name)));
        }
        return result;
    }

    @RequestMapping(value={"/books/{book}/{selection}/start"})
    public String start(@PathVariable(value="book") String bookName, @PathVariable(value="selection") String selectionName, @RequestParam(value="count") String countOrAll) throws IOException {
        Book book = this.library.get(bookName);
        IntSet selection = book.loadSelection(this.userFiles, selectionName);
        if (!countOrAll.equals("all")) {
            List<Integer> sorted = book.statistics(this.userFiles).sort(selection, book);
            int count = Integer.parseInt(countOrAll);
            while (sorted.size() > count) {
                sorted.remove(sorted.size() - 1);
            }
            selection = new IntSet(sorted);
        }
        return this.doStart(book, bookName + "-" + selectionName, selection);
    }

    private String doStart(Book book, String title, IntSet selection) throws IOException {
        Exercise exercise = Exercise.create(this.userFiles.nextProtocol(book.name), book, title, selection);
        exercise.logTitle(this.userFiles, title);
        return "redirect:question?e=" + YogiController.urlEncodeQuery(exercise.toParam());
    }

    private static String urlEncodeSegement(String segment) {
        return UriUtils.encodePathSegment((String)segment, (Charset)StandardCharsets.UTF_8);
    }

    public static String urlEncodeQuery(String str) {
        return URLEncoder.encode(str, StandardCharsets.UTF_8);
    }

    @RequestMapping(value={"/books/{book}/{selection}/protocols/"})
    public String protocols(Model model, @PathVariable(value="book") String book, @PathVariable(value="selection") String selection) throws IOException {
        List<FileNode> protocols = this.userFiles.listProtocols(book);
        Collections.reverse(protocols);
        LinkedHashMap<String, CallSite> map = new LinkedHashMap<String, CallSite>();
        Book b = this.library.get(book);
        for (FileNode log : protocols) {
            String basename = log.getBasename();
            Protocol p = Protocol.load(log);
            Achievement a = p.achievement(this.userFiles, b);
            map.put(basename, (CallSite)((Object)(p.date() + " " + p.words() + " " + a.before + " -> " + a.after)));
        }
        model.addAttribute("map", map);
        model.addAttribute("book", (Object)b);
        model.addAttribute("selection", (Object)selection);
        model.addAttribute("library", (Object)this.library);
        return "protocols";
    }

    @RequestMapping(value={"/books/{book}/{selection}/protocols/{id}"})
    public String protocol(Model model, @PathVariable(value="book") String book, @PathVariable(value="selection") String selection, @PathVariable(value="id") long id) throws IOException {
        Protocol protocol = Protocol.load(this.userFiles.protocolFile(book, id));
        model.addAttribute("protocol", (Object)protocol);
        model.addAttribute("book", (Object)this.library.get(book));
        model.addAttribute("library", (Object)this.library);
        return "protocol";
    }

    @PostMapping(value={"/books/{book}/{selection}/comment"})
    @ResponseStatus(value=HttpStatus.OK)
    public void comment(@PathVariable(value="book") String book, @PathVariable(value="selection") String selection, @RequestParam Map<String, String> body) throws IOException {
        Exercise exercise = Exercise.forParam(this.library.get(book), body.get("e"));
        exercise.logComment(this.userFiles, body.get("comment"));
    }

    @GetMapping(value={"/books/{book}/{selection}/question"})
    public String question(Model model, @PathVariable(value="book") String book, @PathVariable(value="selection") String selection, @RequestParam(value="e") String e, @RequestParam(value="question", required=false) String question) throws IOException {
        Exercise exercise = Exercise.forParam(this.library.get(book), e);
        if (question == null) {
            question = exercise.question();
        }
        model.addAttribute("selection", (Object)selection);
        model.addAttribute("exercise", (Object)exercise);
        model.addAttribute("question", (Object)question);
        return "question";
    }

    @PostMapping(value={"/books/{book}/{selection}/answer"})
    public String answer(Model model, @PathVariable(value="book") String book, @PathVariable(value="selection") String selection, @RequestParam(value="e") String e, @RequestParam(value="question") String question, @RequestParam(value="answer") String answer) throws IOException {
        answer = answer.trim();
        Exercise exercise = Exercise.forParam(this.library.get(book), e);
        String correction = exercise.answer(question, answer);
        model.addAttribute("selection", (Object)selection);
        model.addAttribute("exercise", (Object)exercise);
        model.addAttribute("question", (Object)question);
        model.addAttribute("answer", (Object)answer);
        model.addAttribute("correction", (Object)correction);
        exercise.logAnswer(this.userFiles, question, answer, exercise.lookup(question));
        return "answer";
    }
}

